#ifndef SPM_TRAP_H
#define SPM_TRAP_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) spm_trap.h: version 25.1 created on 11/27/91 at 15:36:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)spm_trap.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* spm_trap.h */

/* function numbers */

#define	CONOUT		0x00
#define	CONIN		0x01
#define	DEVREQ		0x02
#define	CHGINT		0x04
#define	PUTCHAR		0x05
#define	GETCHAR		0x06
#define	USRABORT 	0x07
#define OPEN		0x08
#define CLOSE  		0x09
#define WRITE		0x0a
#define READ		0x0b
#define IOCTL		0x0c
#define LSEEK		0x0d
#define RUNTIME		0x0e
#define EXIT		0x0f
#define CHKDRV		0x10
#define NINETRK		0x11
#define CHKSCSI		0x12
#define SHOW_CONT	0x13
#define FSTAT		0x14

struct	trap	{
	ulong	s_d1;
	ulong	s_a0, s_a1;
	ushort	s_ps;		/* psw */
	uint	s_pc;		/* instruction counter */

	uint	s_format : 4;	/* describes format of any additional info */
	uint	s_crunch : 1;	/* reduce this stack frame to format 0 */
	uint	s_expand : 1;	/* expand this stack frame */
	uint	s_vector : 8;	/* vector number */
	uint	s_unused : 2;	/* unused bits */

	uint	function;
	uint	r_pc;
	uint	param1;
	uint	param2;
	uint	param3;
	uint	param4;
};

#endif /* SPM_TRAP_H */
