#ifndef SENSOR_H
#define SENSOR_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sensor.h: version 25.1 created on 11/27/91 at 15:35:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sensor.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* sensor.h */

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif

#ifndef LIMIT_H
#include "limit.h"
#endif

#define READ_NUM_MAX	12		/* number of readings to average */

typedef struct sensor {
	uchar 		reading[READ_NUM_MAX];	/* A/D converter readings */
	struct sensor	*next;			/* next sensor		*/
	struct limit	*warn;			/* warning (shutdown follows) */
	uint		time;			/* clock tick of last message */
	char		*name;			/* sensor's name	*/
	uchar		mux;			/* mux channel number	*/
	uchar 		channel;		/* A/D channel number	*/
	uchar 		state;			/* NORMAL, WARNING, etc	*/
	uchar		type;			/* MAIN_FIVE_VOLT, etc.	*/
} sensor_t;

/* structure for converting readings to [-]NNN.TH format */
typedef struct frac {
	short	number;
	uchar	tenths;
	uchar	hundredths;
} frac_t;
#endif /* SENSOR_H */
