#ifndef SBUS_IOM_H
#define SBUS_IOM_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sbus_iom.h: version 25.1 created on 11/27/91 at 15:35:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sbus_iom.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*******************************************************************************
*
*	sbus_iom.h	 defines for and description of the I/O MODULE  (IOM)
*
*******************************************************************************/


#define NUM_IOM_PER_SYS	4	/* number of IOM's per system supported */


/**************************************
*
*	The I/O Module
*
*	The I/O Module (IOM), in conjunction with a LINK and an I/O Adapter
*	(IOA), is used to connect an I/O bus to the SBUS.  The IOM connects
*	to the SBUS, the IOA connects to the I/O bus and the LINK connects
*	the IOM and IOA (or IOSBA).
*
*	The IOM is designed to support the requirements of the SBUS.  The
*	IOA and is designed to support the  requirements of the I/O bus.  
*	The commands, command sizes and responses transmitted on the LINK
*	closely match the those transmitted on the SBUS.
*
*	The primary tasks of the IOM are to provide flow control and buffering
*	for transmissions between the SBUS and the LINK and to arbitrate the
*	use of the LINK.  A secondary task is to issue INTERRUPT REQUESTs at
*	the request of the attached IOA.  This secondary task was allocated to
*	the IOM to ease a space problem on the first IOA and is not a necessary
*	part of the IOM or need be used by future IOAs.
*
*	Internally, the IOM has four major sections.  The largest sections
*	are the DONWLINK and the UPLINK.    The DOWNLINK carries transmissions
*	from the SBUS to the LINK, and the UPLINK carries transmissions from the
*	LINK to the SBUS.  The other major sections are the control and status
*	section and the IOA interrupt request relay section.  The LINK arbiter
*	is implemented with a single part.
*
*	The DOWNLINK and UPLINK each have two FIFOs, one for COMMANDS and one
*	RESPONSES.  Each FIFO holds eight entries.  Unloading the RESPONSE
*	FIFOs is assinged priority over unloading the COMMAND FIFOs.
*
****************************************/

/****************************************
*
*	IOM Hardware Resets
*
*	There are 3 hardware resets.
*
*		POWER_UP_RESET
*		SBUS_RESET
*		SBUS_CONTROL_WRITE_RESET
*	
*	POWER_UP_RESET holds the IOM and the attached adapter in reset
*	when Vcc of the IOM is less than about 4.5 V.
*
*	SBUS_RESET resets the IOM (with the exception of the ERROR
*	registers) and the attached adapter.  The ERROR registers are
*	reset with the software reset IOM_ERROR_RESET.
*
*	SBUS_CONTROL_WRITE_RESET holds the IOM and the attached adapter
*	in reset.
*
*****************************************/

/******************************************
*
*	IOM Software RESETs
*
*	The IOM provides 4 software resets.
*
*		IOM_RESET
*		IOM_IOA_RESET
*		IOM_PATH_RESET
*		IOM_ERROR_RESET
*
*	A software reset is issued by a WRITE of any size to
*	the reset address.  The write data is not used.
*
****************************************/


#define IOM_RESET	((unsigned)0xffffff00)


	/*	Resets all of the IOM and the attached adapter.	*/


#define IOM_IOA_RESET	((unsigned)0xffffff08)


	/*	Resets the IOA attached to the IOM.	*/


#define IOM_PATH_RESET	((unsigned)0xffffff10)


	/*	Resets the IOM ARB_READY counter, DOWNLINK,
		LINK interface, UPLINK and SBUS interface.
		It does not reset the IOM control (configuration)
		registers and the IOM error registers.	*/


#define IOM_ERROR_RESET	((unsigned)0xffffff18)


	/*	Resets the IOM_BUS_GRANT_TIMEOUT, IOM_BUS_ERROR,
		IOM_LINK_ERROR and IOM_DOWNLINK_ERROR bits in the
		IOM_ERROR_REG and enables the error registers to
		capture the next error of each type.  */

/****************************************
*
*	IOM Control Registers
*
*	The IOM has 7 control registers.  The contents of these	registers
*	control the operation of the module.
*
*		Name				Type
*		----				----
*
*		IOM_CONTROL_REG			READ/WRITE
*
*		IOM_IOSLOT_TEST_REG		READ/WRITE
*
*		IOM_LINK_CONTROL_REG		READ/WRITE
*
*		IOM_DLBUF_CONTROL_REG		READ/WRITE
*
*		IOM_DLBUF_READ_ONCE		WRITE only
*
*		IOM_ULBUF_CONTROL_REG		READ/WRITE
*
*		IOM_ULBUF_READ_ONCE		WRITE only
*
*
*	All control registers are cleared by any of the hardware resets
*	and the IOM_RESET software reset.
*
*	Only two of the registers, IOM_CONTROL_REG and IOM_LINK_CONTROL_REG,
*	contain bits that require setting for normal operation.  The other
*	registers are used only for testing.
*	
****************************************/	

/********
*
*	IOM_CONTROL_REG
*
*		Bit			Name
*		---			----
*
*		31		IOM_MAX_OFFSET_ADDR_EN
*		30		IOM_FORCE_SBUS_READY
*		29		IOM_ERROR_INTR_EN
*		28		IOM_BUS_DATA_PARITY_ERROR_INHIBIT
*
*		27:24		IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR[3:0]
*
*	IOM_MAX_OFFSET_ADDR_EN and IOM_ERROR_INTR_EN are the only bits
*	in this register that are set for normal operation.
*
********/


#define IOM_CONTROL_REG		((unsigned)0xffffff40)


#define IOM_MAX_OFFSET_ADDR_EN	((unsigned)0x80000000)


	/*	Maximum Offset Address Enable

		The state of this bit determines the size of the
		offset address space and the effective addresses
		of the control and status registers and the IOA
		interrupt request relay function of the IOM.
		These addresses are in the top 4 KB of the offset
		address space of the IOM.

		When asserted, the offset address space of the IOM
		is 4 GB.
	
		When deasserted, the offset address space of the IOM
		is 256 MB.  Larger offset addresses are interpreted
		modulo 256 MB.  */


#define IOM_FORCE_SBUS_READY	((unsigned)0x40000000)


	/*	Force SBUS READY

		This bit is used only for testing.

		The state of this bit determines whether commands
		sent to the IOM on the SBUS are flow controlled.
		The bit is provided to support debugging of the
		IOM with scope loops.

		When asserted, ARB_READY1 and/or ARB_READY3 is
		always asserted to the arbiter and does not reflect
		the number of free command buffers in the IOM.

		When deasserted, SBUS flow control functions normally.
		
		After this bit has been asserted and then dearrested,
		SBUS_RESET, IOM_RESET or IOM_PATH_RESET must be
		issued to insure that the ARB_READY count is
		initialized correctly.  */


#define IOM_ERROR_INTR_EN	((unsigned)0x20000000)


	/*	IOM Error Interrupt Enable

		The state of this bit determines whether the IOM can
		issue an interrupt to report detected error conditions.

		When asserted, the IOM will issue the IOM_ERROR
		interrupt when one or more of the bits
		IOM_BUS_GRANT_TIMEOUT, IOM_BUS_ERROR_LATCHED,
		IOM_LINK_ERROR_LATCHED or IOM_DOWNLINK_ERROR_LATCHED
		in the IOM_ERROR_REG is asserted.  Only one interrupt
		will be issued.

		After processing the information saved in the "ERROR"
		registers about the reported error(s), issue
		IOM_ERROR_RESET to reenable error recording and
		rearm the IOM_ERROR interrupt.

		When deasserted, the IOM cannot issue an interrupt to
		report detected errors.  */
	

#define IOM_BUS_DATA_PARITY_ERROR_INHIBIT	((unsigned)0x10000000)


	/*	Bus Data Parity Error Inhibit
	
		This bit is used only for testing.

		This bit MUST be set if any of bits
		IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR[3:0] are set.

		The state of this bit determines whether the IOM
		checks for data field parity errors in transmissions
		received from or sent to the SBUS.

		When asserted, the IOM ignors data field parity
		errors.

		When deasserted, the IOM checks for data field
		parity errors. */


#define IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR3	((unsigned)0x08000000)


#define IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR2	((unsigned)0x04000000)


#define IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR1	((unsigned)0x02000000)


#define IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR0	((unsigned)0x01000000)


	/*	Force Down Link Data Parity Error [3:0]

		These bits are used only for testing.
		
		The bits are used to test data field error
		detection of the IOM LINK receiver when DOWNLINK
		transmissions are looped back to the UPLINK at
		the LINK.

		IOM_BUS_DATA_PARITY_ERROR_INHIBIT must be set if any
		of these bits are set.  If any of these bits are
		set and IOM_BUS_DATA_PARITY_ERROR_INHIBIT is not set,
		all transmissions sent to the IOM will be NACKed
		and all commands except a CONTROL WRITE (type 6)
		will be ignorred.

		The state of IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR[n]
		determines whether the sense of data field parity
		bit n is inverted when received from the SBUS.
		If the sense is inverted, byte n of the received
		data field will appear to have a parity error and
		will be sent to the DOWNLINK with a parity error.

		When IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR[n] is asserted,
		the sense of data field parity bit n is inverted
		when it is received from the SBUS and sent to the
		DOWNLINK.

		When IOM_FORCE_DOWNLINK_DATA_PARITY_ERROR[n] is deasserted,
		data field parity bit of n is received from the SBUS
		without inversion.  */

/***********
*
*	IOM_IOSLOT_TEST_REG
*
*	All bits in this register are used only for testing.
*
*		Bit			Name
*		---			----
*
*		31		IOM_IOSLOT_TEST_EN
*		30		IOM_FORCE_IOSLOT_PARITY_ERROR
*		29		IOM_IOSLOT_TEST_PARITY
*		28:24		IOM_IOSLOT_TEST_DATA[4:0]
*
*	While this is a READ/WRITE register, the READ function is
*	unconventional.  Bits [31:30] (IOM_IOSLOT_TEST_EN and
*	IOM_FORCE_IOSLOT_PARITY_ERROR) read normally.  Bits [29:24]
*	read the IOSLOT value and parity being sent to the DOWNLINK.
*	The source of the IOSLOT value and parity being sent to the
*	DOWNLINK is controlled by the value of IOM_IOSLOT_TEST_EN.
*	When IOM_IOSLOT_TEST_EN is asserted, IOM_IOSLOT_TEST_PARITY
*	and IOM_IOSLOT_TEST_DATA[4:0] are sent to the DOWNLINK.
*
************/


#define IOM_IOSLOT_TEST_REG	((unsigned)0xffffff48)


#define IOM_IOSLOT_TEST_EN	((unsigned)0x80000000)


	/*	I/O Slot Test Enable

		The state of this bit determines the source of the
		IOSLOT value and parity supplied to the DOWNLINK
		and what is read in the IOM_IOSLOT_TEST_REG.  This
		permits a test value of IOSLOT and parity to be sent
		to the DOWNLINK and the value of IOSLOT and parity
		returned by the UPLINK to be checked when the IOM
		is in loopback.

		When asserted, the values of IOM_IOSLOT_TEST_DATA[4:0]
		and IOM_IOSLOT_TEST_PARITY are supplied to the DOWNLINK
		as the IOSLOT value and parity and are readable as those
		fields in IOM_IOSLOT_TEST_REG.

		When deasserted, the IOSLOT value and parity from the
		UPLINK BUS_READ_COMMAND_REG are supplied to the DOWNLINK
		as the IOSLOT value and parity and are readable in the
		IOM_IOSLOT_TEST_DATA[4:0] and IOM_IOSLOT_TEST_PARITY
		fields respectively in the IOM_IOSLOT_TEST_REG.  */


#define IOM_BUS_READ_CMD_IOSLOT_PARITY	((unsigned)0x20000000)


#define IOM_BUS_READ_CMD_IOSLOT		((unsigned)0x1f000000)

#define IOM_BUS_READ_CMD_IOSLOT_SHIFT	24


#define IOM_FORCE_IOSLOT_PARITY_ERROR	((unsigned)0x40000000)


	/*	Force I/O Slot Number Parity Error

		The state of this bit determines the sense of the parity
		computed over the bits BUS_READ_CMD_IOSLOT[parity,4:0].
		This allows forcing IOM_BUS_IOSLOT_ERROR in
		IOM_BUS_ERROR_REG0 when the IOM sends a READ command 
		on the SBUS.  When an IOM_BUS_IOSLOT_ERROR is detected
		and IOM_IOSLOT_TEST_EN is not asserted, the IOSLOT value
		sent to the DOWNLINK is forced to 31 (0x1f) with bad parity.

		When asserted, the sense of the parity and
		BUS_READ_CMD_IOSLOT_ERROR signals are inverted.

		When deasserted, the sense of the parity and
		BUS_READ_CMD_IOSLOT_ERROR signals are normal.  */
	

#define IOM_IOSLOT_TEST_PARITY	((unsigned)0x20000000)

	
	/*	Test I/O Slot Parity

		When IOM_IOSLOT_TEST_EN is asserted, this bit is
		the IOSLOT parity bit supplied to the DOWNLINK.  */


#define IOM_IOSLOT_TEST_DATA	((unsigned)0x1f000000)

#define IOM_IOSLOT_TEST_DATA_SHIFT	24

	
	/*	Test I/O Slot Number [4:0]

		When IOM_IOSLOT_TEST_EN is asserted, these bits
		are the IOSLOT supplied to the DOWNLINK.  */

/*************
*
*	IOM_LINK_CONTROL_REG
*
*		Bit			Name
*		---			----
*
*		31		IOM_LINK_LOOPBACK
*		30		IOM_IOA_LINK_GRANT_INHIBIT
*		29		IOM_LINK_RMSEQ_ERROR_INHIBIT
*		28		IOM_IOA_INTERRUPT_EN
*
*		27		IOM_FORCE_LINK_TYPE_ERROR
*		26		IOM_FORCE_RMSEQ
*		25		---
*		24		IOM_NORMAL_LED
*
*	IOM_IOA_INTERRUPT_EN and IOM_NORMAL_LED are the only bits in this
*	register that are set for normal operation.
*
***************/


#define IOM_LINK_CONTROL_REG	((unsigned)0xffffff50)


#define IOM_LINK_LOOPBACK	((unsigned)0x80000000)


	/*	Link Loopback Enable

		This bit is used only for testing.

		The state of this bit determines whether IOM
		DOWNLINK traffic to the LINK is directed to the
		IOA or the IOM UPLINK.

		When asserted, DOWNLINK traffic to the LINK is
		directed to the IOM (loopback), passes through the
		UPLINK to the SBUS and returns to the originating
		SBUS slot.

		When deasserted, DOWNLINK traffic is directed to
		the IOA.  */
	

#define IOM_IOA_LINK_GRANT_INHIBIT	((unsigned)0x40000000)

	
	/*	I/O Adapter (IOA) LINK Grant Inhibit

		This bit is used only for testing.

		The state of this bit determines whether the LINK
		arbiter responds to a request from the IOA for use
		of the LINK by issuing a grant.

		When asserted, the LINK arbiter ignors requests
		from the IOA for use of the LINK and issues no
		grants to the IOA.

		When deasserted, the LINK arbiter responds to a
		request from the IOA for use of the LINK by issuing
		a grant.  */


#define IOM_LINK_RMSEQ_ERROR_INHIBIT ((unsigned)0x20000000)

	
	/*	LINK RMSEQ Error Inhibit

		This bit is used only for testing.

		The state of this bit determines whether the
		IOM LINK receiver will detect a LINK RMSEQ error.
		When the LINK cable is not connected,  LINK RMSEQ
		error is always asserted.  This bit allows the IOM
		LINK interface to be loopback tested without
		LINK RMSEQ error interferring.

		When asserted, the LINK receiver will not detect
		a LINK RMSEQ error.

		When deasserted, the LINK receiver will detect a
		LINK RMSEQ error.  */


#define IOM_IOA_INTERRUPT_EN	((unsigned)0x10000000)

	
	/*	IOA Interrupt Enable

		The state of this bit determines whether the IOM
		will relay interrupt requests from the IOA.
	
		When asserted, the IOM will relay interrupt requests
		from the IOA.

		When deasserted, the IOM will not relay interrupt
		requests from the IOA.  */


#define IOM_FORCE_LINK_TYPE_ERROR	((unsigned)0x08000000)


	/*	Force LINK Type Error
	
		This bit is used only for testing.

		The state of this bit determines whether the LINK
		type field bit is inverted on reception.  This
		permits forcing IOM_LINK_TYPE_ERROR.
		
		When asserted, the LINK type field parity bit
		is inverted on reception.
		
		When deasserted, the LINK type field parity bit
		is not inverted on reception.	*/


#define IOM_FORCE_RMSEQ		((unsigned)0x04000000)


	/*	Force RMSEQ
	
		This bit is used only for testing.
		
		When asserted, ARB_MODIFY is always asserted to the
		SBUS arbiter.
		
		When deasserted, ARB_MODIFY is asserted to the SBUS
		arbiter according to the values of RMSEQ supplied
		to the SBUS interface by the LINK and the UPLINK
		and the state of the SBUS interface.	*/


#define IOM_NORMAL_LED	((unsigned)0x01000000)

	
	/*	IOM NORMAL led

		When asserted, the NORMAL led is ON and the FAULT
		led is OFF.

		When deasserted, the NORMAL led if OFF and the FAULT
		led is ON.  */

/**********************
*
*	IOM_DLBUF_CONTROL_REG
*
*	All bits in this register are used only for testing.
*
*		Bit			Name
*		---			----
*
*		31		IOM_DLBUF_COUNTER_READ_ENABLE
*		30		IOM_DLBUF_POINTER_TEST_EN
*		29		IOM_DLBUF_READ_INHIBIT
*		28		IOM_DLBUF_POINTER_LOCK
*
*		27:24		IOM_DLBUF_POINTER_RESET_VALUE[3:0]
*		25:24		IOM_DLBUF_POINTER_SEL[1:0]
*
*
*	The DOWNLINK command and response buffers are FIFOs, each
*	holding up to eight entries.  The buffers are implemented with
*	circular buffers in a common static RAM.  Only one buffer can
*	be read or written at time.
*
*	The pointers and entry count for each buffer are maintained in
*	4 bit counters, one for each pointer and one for the count.
*	The low order 3 bits of each pointer counter are used for
*	addressing the static RAM.  A fourth address bit selects the
*	command or response buffer.  For each static RAM access, a
*	multiplexer selects the low order 3 bits from the appropriate
*	pointer counter and supplies the bit specifing the buffer.
*
*	The static RAM address multiplexer output is readable in the
*	IOM_DLBUF_POINTER field of IOM_DLBUF_STATE_REG.  However, the
*	multiplexer output must be static when its output is read.
*	The bits in IOM_DLBUF_CONTROL_REG provide the control necessary to
*	test the pointer counters and address multiplexer.
*
**********************/


#define IOM_DLBUF_CONTROL_REG	((unsigned)0xffffff60)


#define IOM_DLBUF_COUNTER_READ_ENABLE	((unsigned)0x80000000)

		
	/*	DOWNLINK Buffer Counter Read Enable

		This state of this bit has no effect unless
		IOM_DLBUF_POINTER_TEST_EN is asserted.

		When IOM_DLBUF_POINTER_TEST_EN is asserted, this
		bit selects the source for the most significant
		buffer address bit.

		When asserted and IOM_DLBUF_POINTER_TEST_EN is
		asserted, IOM_DLBUF_POINTER[3] contains bit 3
		of the pointer counter selected by the
		IOM_DLBUF_POINTER_SEL field.

		When deasserted and IOM_DLBUF_POINTER_TEST_EN is
		asserted, IOM_DLBUF_POINTER[3] specifies which
		buffer is selected by the IOM_DLBUF_POINTER_SEL
		field.  IOM_DLBUF_POINTER[3] = 0 selects the command
		buffer; IOM_DLBUF_POINTER[3] = 1 selects the response
		buffer.  */
		

#define IOM_DLBUF_POINTER_TEST_EN	((unsigned)0x40000000)

		
	/*	DOWNLINK Buffer Pointer Test Enable

		When asserted, the IOM_DLBUF_POINTER_SEL field
		specifies which pointer is selected by the address
		multiplexer and is readable in IOM_DLBUF_POINTER.


#define IOM_DLBUF_READ_INHIBIT	((unsigned)0x20000000)


	/*	DOWNLINK Buffer Read Inhibit

		When asserted, reading (unloading) of the DOWNLINK
		buffers is inhibited.  The inhibit can be overriden
		for one read by setting IOM_DLBUF_READ_ONCE.

		When deasserted, reading of the DOWNLINK buffers
		is regulated by normal flow control.	*/

#define IOM_DLBUF_POINTER_LOCK	((unsigned)0x10000000)


	/*	DOWNLINK Buffer Pointer Lock

		When asserted, the read and write pointers
		into the DOWNLINK command and response buffers
		do not increment as the buffers are written
		and read.  This allows each buffer location to
		be tested, one location at a time.

		When deasserted, the pointers into the DOWNLINK
		buffers increment normally on buffer read and
		write.
		
#define IOM_DLBUF_POINTER_RESET_VALUE	((unsigned)0x0f000000)

#define IOM_DLBUF_POINTER_RESET_VALUE_SHIFT	24


	/*	DOWNLINK Buffer Pointer Reset Value

		This value is loaded into all of the DOWNLINK
		buffer pointer counters when an IOM_PATH_RESET
		is issued.	*/

		
#define IOM_DLBUF_POINTER_SEL	((unsigned)0x03000000)

#define IOM_DLBUF_POINTER_SEL_SHIFT	24


	/*	DOWNLINK Buffer Pointer Select[1:0]

		When IOM_DLBUF_POINTER_TEST_EN is asserted, these
		bits select which DOWNLINK buffer pointer is selected
		by the address multiplexer.  */


#define IOM_SELECT_DL_RESPONSE_BUFFER_WRITE_POINTER	0

#define IOM_SELECT_DL_RESPONSE_BUFFER_READ_POINTER	1

#define IOM_SELECT_DL_COMMAND_BUFFER_WRITE_POINTER	2

#define IOM_SELECT_DL_COMMAND_BUFFER_READ_POINTER	3

/**************************
*
*	IOM_DLBUF_READ_ONCE
*
*	This register is used only for testing.
*
*	IOM_DLBUF_READ_ONCE is for use in conjunction with
*	IOM_DLBUF_READ_INHIBIT.
*
*	IOM_DLBUF_READ_ONCE is a single bit register that is WRITE only.
*	The register is set by a write of any size to its address.
*	The WRITE data is not used.   IOM_DLBUF_READ_ONCE is reset
*	by any of the hardware resets, the IOM_RESET or IOM_PATH_RESET
*	software resets or by unloading (reading) one entry from the 
*	DOWNLINK buffer.
*
*	When IOM_DLBUF_READ_INHIBIT is asserted, setting IOM_DLBUF_READ_ONCE
*	allows one DOWNLINK buffer entry to be unloaded.  Each read
*	of the DOWNLINK buffer resets IOM_DLBUF_READ_ONCE.
*
*	When IOM_DLBUF_READ_INHIBIT is deasserted, the state of
*	IOM_DLBUF_READ_ONCE has no effect on DOWNLNIK buffer operation.
*
*****************************/


#define IOM_DLBUF_READ_ONCE	((unsigned)0xffffff68)

/**************************
*
*
*	IOM_ULBUF_CONTROL_REG
*
*	All bits in this register are used only for testing.
*
*		Bit			Name
*		---			----
*
*		31		IOM_ULBUF_COUNTER_READ_ENABLE
*		30		IOM_ULBUF_POINTER_TEST_EN
*		29		IOM_ULBUF_READ_INHIBIT
*		28		IOM_ULBUF_POINTER_LOCK
*
*		27:24		IOM_ULBUF_POINTER_RESET_VALUE[3:0]
*		25:24		IOM_ULBUF_POINTER_SEL[1:0]
*
*
*	The UPLINK command and response buffers are FIFOs, each
*	holding up to eight entries.  The buffers are implemented with
*	circular buffers in a common static RAM.  Only one buffer can
*	be read or written at time.
*
*	The pointers and entry count for each buffer are maintained in
*	4 bit counters, one for each pointer and one for the count.
*	The low order 3 bits of each pointer counter are used for
*	addressing the static RAM.  A fourth address bit selects the
*	command or response buffer.  For each static RAM access, a
*	multiplexer selects the low order 3 bits from the appropriate
*	pointer counter and supplies the bit specifing the buffer.
*
*	The static RAM address multiplexer output is readable in the
*	IOM_ULBUF_POINTER field of IOM_ULBUF_STATE_REG.  However, the
*	multiplexer output must be static when its output is read.
*	The bits in IOM_ULBUF_CONTROL_REG provide the control necessary to
*	test the pointer counters and address multiplexer.
*
**********************/


#define IOM_ULBUF_CONTROL_REG	((unsigned)0xffffff70)


#define IOM_ULBUF_COUNTER_READ_ENABLE	((unsigned)0x80000000)

		
	/*	UPLINK Buffer Counter Read Enable

		This state of this bit has no effect unless
		IOM_ULBUF_POINTER_TEST_EN is asserted.

		When IOM_ULBUF_POINTER_TEST_EN is asserted, this
		bit selects the source for the most significant
		buffer address bit.

		When asserted and IOM_ULBUF_POINTER_TEST_EN is
		asserted, IOM_ULBUF_POINTER[3] contains bit 3
		of the pointer counter selected by the
		IOM_ULBUF_POINTER_SEL field.

		When deasserted and IOM_ULBUF_POINTER_TEST_EN is
		asserted, IOM_ULBUF_POINTER[3] specifies which
		buffer is selected by the IOM_ULBUF_POINTER_SEL
		field.  IOM_ULBUF_POINTER[3] = 0 selects the command
		buffer; IOM_ULBUF_POINTER[3] = 1 selects the response
		buffer.  */
		

#define IOM_ULBUF_POINTER_TEST_EN	((unsigned)0x40000000)

		
	/*	UPLINK Buffer Pointer Test Enable

		When asserted, the IOM_ULBUF_POINTER_SEL field
		specifies which pointer is selected by the address
		multiplexer and is readable in IOM_ULBUF_POINTER.


#define IOM_ULBUF_READ_INHIBIT	((unsigned)0x20000000)


	/*	UPLINK Buffer Read Inhibit

		When asserted, reading (unloading) of the UPLINK
		buffers is inhibited.  The inhibit can be overriden
		for one read by setting IOM_ULBUF_READ_ONCE.

		When deasserted, reading of the UPLINK buffers
		is regulated by normal flow control.	*/

#define IOM_ULBUF_POINTER_LOCK	((unsigned)0x10000000)


	/*	UPLINK Buffer Pointer Lock

		When asserted, the read and write pointers
		into the UPLINK command and response buffers
		do not increment as the buffers are written
		and read.  This allows each buffer location to
		be tested, one location at a time.

		When deasserted, the pointers into the UPLINK
		buffers increment normally on buffer read and
		write.
		
#define IOM_ULBUF_POINTER_RESET_VALUE	((unsigned)0x0f000000)

#define IOM_ULBUF_POINTER_RESET_VALUE_SHIFT	24


	/*	UPLINK Buffer Pointer Reset Value

		This value is loaded into all of the UPLINK
		buffer pointer counters when an IOM_PATH_RESET
		is issued.	*/

		
#define IOM_ULBUF_POINTER_SEL	((unsigned)0x03000000)

#define IOM_ULBUF_POINTER_SEL_SHIFT	24


	/*	UPLINK Buffer Pointer Select[1:0]

		When IOM_ULBUF_POINTER_TEST_EN is asserted, these
		bits select which UPLINK buffer pointer is selected
		by the address multiplexer.  */


#define IOM_SELECT_UL_RESPONSE_BUFFER_WRITE_POINTER	0

#define IOM_SELECT_UL_RESPONSE_BUFFER_READ_POINTER	1

#define IOM_SELECT_UL_COMMAND_BUFFER_WRITE_POINTER	2

#define IOM_SELECT_UL_COMMAND_BUFFER_READ_POINTER	3

/**************************
*
*	IOM_ULBUF_READ_ONCE
*
*	This register is used only for testing.
*
*	IOM_ULBUF_READ_ONCE is for use in conjunction with
*	IOM_ULBUF_READ_INHIBIT.
*
*	IOM_ULBUF_READ_ONCE is a single bit register that is WRITE only.
*	The register is set by a write of any size to its address.
*	The WRITE data is not used.   IOM_ULBUF_READ_ONCE is reset
*	by any of the hardware resets, the IOM_RESET or IOM_PATH_RESET
*	software resets or by unloading (reading) one entry from the 
*	DOWNLINK buffer.
*
*	When IOM_ULBUF_READ_INHIBIT is asserted, setting IOM_ULBUF_READ_ONCE
*	allows one DOWNLINK buffer entry to be unloaded.  Each read
*	of the DOWNLINK buffer resets IOM_ULBUF_READ_ONCE.
*
*	When IOM_ULBUF_READ_INHIBIT is deasserted, the state of
*	IOM_ULBUF_READ_ONCE has no effect on UPLINK buffer operation.
*
*****************************/


#define IOM_ULBUF_READ_ONCE	((unsigned)0xffffff78)

/*************************************
*
*	IOM Status Registers
*
*	The IOM has 11 status registers.  Each register is READ only and
*	unchanged by the act of READing.
*
*		IOM_BUS_GRANT_TIMEOUT_REG
*		IOM_ERROR_REG
*		IOM_BUS_ERROR_REG0
*		IOM_BUS_ERROR_REG1
*		IOM_BUS_ERROR_REG2
*		IOM_DLBUF_STATE_REG	
*		IOM_LINK_ERROR_REG0
*		IOM_LINK_ERROR_REG1
*		IOM_LINK_ERROR_REG2
*		IOM_ULBUF_STATE_REG	
*		IOM_ID
*
*	The information saved in the "ERROR" registers is NOT released
*	by the SBUS_RESET hardware reset or the IOM_PATH_RESET software
*	reset.  This allows the use of SBUS_RESET or IOM_PATH_RESET to
*	gain control of the system before the information in the "ERORR"
*	registers is processed.
*
***************************************/



/**************************************
*
*
*	IOM_BUS_GRANT_TIMEOUT_REG
*
*	The bits in this register have meaning only when
*	IOM_BUS_GRANT_TIMEOUT is set in the IOM_ERROR_REG.
*
*		Bit			Name
*		---			----
*
*		31:29		IOM_BUS_GRANT_TIMEOUT_TYPE[5:3]
*
*		28:24		IOM_BUS_GRANT_TIMEOUT_IOSLOT[4:0]
*
*		23:20		IOM_BUS_GRANT_TIMEOUT_SBSLOT[3:0]
*
*		19:16		IOM_BUS_GRANT_TIMEOUT_SBSLOT_NOT[3:0]
*
*	IOM_BUS_GRANT_TIMEOUT is declared if ARB_GRANT is not received
*	in about 50 usec after ARB_REQUEST is asserted.
*
***************************************/


#define IOM_BUS_GRANT_TIMEOUT_REG	((unsigned)0xffffffb0)


#define IOM_BUS_GRANT_TIMEOUT_TYPE	((unsigned)0xe0000000)

#define IOM_BUS_GRANT_TIMEOUT_TYPE_SHIFT	29


	/*	SBUS TYPE[5:3] of the SBUS request that timed out.  */


#define IOM_BUS_GRANT_TIMEOUT_IOSLOT	((unsigned)0x1f000000)

#define IOM_BUS_GRANT_TIMEOUT_IOSLOT_SHIFT	24


	/*	IOSLOT[4:0] of the SBUS request that timed out.  */


#define IOM_BUS_GRANT_TIMEOUT_SBSLOT	((unsigned)0x00f00000)

#define IOM_BUS_GRANT_TIMEOUT_SBSLOT_SHIFT	20


	/*	SBUS DEST[3:0] of the SBUS request that timed out.  */


#define IOM_BUS_GRANT_TIMEOUT_SBSLOT_NOT	((unsigned)0x000f0000)

#define IOM_BUS_GRANT_TIMEOUT_SBSLOT_NOT_SHIFT	16


	/*	SBUS DEST[3:0]* of the SBUS request that timed out.  */

/*******************************
*
*	IOM_ERROR_REG
*
*		Bit(s)			Name
*		------			----
*
*		31		--
*		30		IOM_DL_RESP80
*		29		IOM_DL_RESP44
*		28		IOM_DL_RESP40
*
*		27		--
*		26:24		IOM_DL_TYPE[5:3]
*
*		23		IOM_BUS_GRANT_TIMEOUT
*		22		--
*		21		IOM_LOCAL_TIMEOUT
*		20		IOM_INTR_REQ_TIMEOUT
*
*		19		IOM_IOA_5V_OK
*		18		IOM_BUS_ERROR_LATCHED
*		17		IOM_LINK_ERROR_LATCHED
*		16		IOM_DOWNLINK_ERROR_LATCHED
*
*	IOM_ERROR_REG contains several distinct group of bits.
*
*	IOM_ERROR_REG[31:24] contains information about an
*	IOM_DOWNLINK_ERROR and is valid only when
*	IOM_DOWNLINK_ERROR_LATCHED is asserted.
*
*	IOM_ERROR_REG[23:20] indicates whether IOM_BUS_GRANT_TIMEOUT
*	has occurred and the source of the BUS request that was not
*	granted.  IOM_LOCAL_TIMEOUT and IOM_INTR_REQ_TIMEOUT are
*	valid only when IOM_BUS_GRANT_TIMEOUT is asserted.
*
*	IOM_ERROR_REG[19:16] indicates the state of the IOA's +5 V
*	supply and whether a BUS_ERROR, LINK_ERROR or DOWNLINK_ERROR
*	has been detected.  
*
*	The first step in processing an IOM_ERROR_INTERRUPT is to
*	test IOM_BUS_GRANT_TIMEOUT, IOM_BUS_ERROR_LATCHED,
*	IOM_LINK_ERROR_LATCHED and IOM_DOWNLINK_ERROR_LATCHED to
*	determine which error(s) has (have) occurred and which error
*	registers contain valid information.
*
*********************************/


#define IOM_ERROR_REG	((unsigned)0xffffffb8)


/**************************************
*
*	IOM_DOWNLINK_ERROR
*
*	An IOM_DOWNLINK_ERROR is declared if an error is detected in the
*	bits IOM_DL_RESP80, IOM_DL_RESP44 and IOM_DL_RESP40 or the
*	TYPE CONTROL_WRITE is detected when an ertry is read form the
*	DOWNLINK buffer.  IOM_DL_RESP80, IOM_DL_RESP44 and IOM_DL_RESP80
*	form a one-out-of-three code.  The presence of none or more than
*	one of them is an error.  The presence of a CONTROL_WRITE in the
*	DOWNLINK buffer is also an error.
*
***************************************/


#define IOM_DL_RESP80	((unsigned)0x40000000)


#define IOM_DL_RESP44	((unsigned)0x20000000)


#define IOM_DL_RESP40	((unsigned)0x10000000)


#define IOM_DL_TYPE	((unsigned)0x07000000)

#define IOM_DL_TYPE_SHIFT	24


#define IOM_BUS_GRANT_TIMEOUT	((unsigned)0x00800000)


	/*	Bus Grant Timeout

		When asserted, this bit indicates that a SBUS
		grant timeout has occurred.  Information about
		the request that timed out is held in
		IOM_LOCAL_TIMEOUT, IOM_INTR_REQ_TIMEOUT and
		IOM_BUS_GRANT_TIMEOUT_REG.	*/


#define IOM_LOCAL_TIMEOUT	((unsigned)0x00200000)


	/*	Local Timeout
	
		This bit is valid only when IOM_BUS_GRANT_TIMEOUT
		is asserted.

		The state of this bit indicates whether the source
		of the SBUS request that timed out was the UPLINK
		or the local control, status and interrupt request
		sections of the IOM.

		When asserted, this bit indicates that the source
		of the SBUS request that timed out was local to the
		IOM and not the UPLINK.  */


#define IOM_INTR_REQ_TIMEOUT	((unsigned)0x00100000)


	/*	Interrupt Request Timeout
	
		This bit is valid only when IOM_BUS_GRANT_TIMEOUT
		is asserted.

		The state of this bit indicates whether the source
		of the SBUS request that timed out was the response
		to a read of a control register, status register or
		interrupt vector table entry or a write command from
		the interrupt request section.

		When asserted, this bit indicates that the SBUS
		request that timed out was a write command from the
		interrupt request section of the IOM.

		When deasserted, this bit indicates that the SBUS
		request that timed out was the response to a read
		of a control register, status register or interrupt
		vector table entry.  */


#define IOM_IOA_5V_OK	((unsigned)0x00080000)


	/*	IOA +5V Okay

		When asserted, this bit indicates that Vcc of the
		attached IOA is above about 4.5 V.

		When deasserted, this bit indicates that Vcc of the
		attached IOA is below about 4.5 V.	*/


#define IOM_BUS_ERROR_LATCHED	((unsigned)0x00040000)


	/*	SBUS Error Latched

		When asserted, this bit indicates that 
		IOM_BUS_ERROR_REG0, IOM_BUS_ERROR_REG1 and
		IOM_BUS_ERROR_REG2 contain information about a
		error detected at the SBUS end of the IOM.  */


#define IOM_LINK_ERROR_LATCHED	((unsigned)0x00020000)


	/*	LINK Error Latched

		When asserted, this bit indicates that 
		IOM_LINK_ERROR_REG0, IOM_LINK_ERROR_REG1 and
		IOM_LINK_ERROR_REG2 contain information about a
		error detected at the LINK end of the IOM.  */


#define IOM_DOWNLINK_ERROR_LATCHED	((unsigned)0x00010000)


	/*	DOWNLINK Error Latched

		When asserted, this bit indicates that the IOM
		has detected an error in the DOWNLINK response
		size field and latched information about the error
		in IOM_ERROR_REG[31:24].	*/

/**********************************
*
*	IOM_BUS_ERROR_REG0
*
*	The bits in this register are not valid unless IOM_BUS_ERROR_LATCHED
*	is asserted in IOM_ERROR_REG.
*
*		Bit(s)			Name
*		------			----
*
*		31:30		--
*		29		IOM_BUS_READ_TIMEOUT
*		28		IOM_BUS_RMSEQ_ERROR
*
*		27		IOM_BUS_IOSLOT_ERROR
*		26		IOM_DL_CMD_BUF_OVFL
*		25		IOM_DL_RESP_BUF_OVFL
*		24		IOM_BUS_ERROR
*
*		23		IOM_BUS_ACTIVE_NOT
*		22		IOM_BUS_SOURCE_ERROR
*		21		IOM_BUS_DEST_ERROR
*		20		IOM_BUS_RESP_SOURCE_MISMATCH
*
*		19		IOM_BUS_TYPE_ERROR
*		18		IOM_BUS_DATA_ERROR
*		17		IOM_BUS_ACK_NOT
*		16		IOM_BUS_NACK
*
*	IOM_BUS_ERROR_REG0 contains two distinct group of bits.
*
*	IOM_BUS_ERROR_REG0[29:25] indicates which if any
*	non-transmission error was detected.  THESE BITS MUST BE
*	CHECKED FIRST WHEN PROCESSING A BUS ERROR.
*
*	If IOM_BUS_ERROR_REG0[29:25] is 0, then a transmission error
*	was detected and IOM_BUS_ERROR_REG0[23:16] indicates the
*	specific error(s) that was (were) detected.
*
*	IOM_BUS_ERROR_REG1 and IOM_BUS_ERROR_REG2 contain supporting
*	information.
*
************************************/


#define IOM_BUS_ERROR_REG0	((unsigned)0xffffffc0)


#define IOM_BUS_READ_TIMEOUT	((unsigned)0x20000000)

	/*	When asserted, an SBUS READ operation has failed to
		complete with in the allowed time.	*/

#define IOM_BUS_RMSEQ_ERROR	((unsigned)0x10000000)

	/*	When asserted, an error was detected in the RMSEQ
		field of an entry unloaded from the UPLINK buffer.	*/

#define IOM_BUS_IOSLOT_ERROR	((unsigned)0x08000000)

	/*	When asserted, an error was detected in the IOSLOT
		field of a READ command unloaded from the UPLINK
		command buffer.	*/

#define IOM_DL_CMD_BUF_OVFL	((unsigned)0x04000000)


#define IOM_DL_RESP_BUF_OVFL	((unsigned)0x02000000)


#define IOM_BUS_ERROR		((unsigned)0x01000000)


#define IOM_BUS_ERRORS		((unsigned)0x00ff0000)


#define IOM_BUS_ACTIVE_NOT	((unsigned)0x00800000)


#define IOM_BUS_SOURCE_ERROR	((unsigned)0x00400000)


#define IOM_BUS_DEST_ERROR	((unsigned)0x00200000)


#define IOM_BUS_RESP_SOURCE_MISMATCH	((unsigned)0x00100000)


#define IOM_BUS_TYPE_ERROR	((unsigned)0x00080000)


#define IOM_BUS_DATA_ERROR	((unsigned)0x00040000)


#define IOM_BUS_ACK_NOT		((unsigned)0x00020000)


#define IOM_BUS_NACK		((unsigned)0x00010000)

/**********************************
*
*	IOM_BUS_ERROR_REG1
*
*	The bits in this register are not valid unless IOM_BUS_ERROR_LATCHED
*	is asserted in IOM_ERROR_REG.
*
*		Bit(s)			Name
*		------			----
*
*		31:28		IOM_BUS_SOURCE[3:0]
*
*		27:24		IOM_BUS_DEST[3:0]
*
*		23:22		--
*
*		21:16		IOM_BUS_TYPE[5:0]
*
************************************/


#define IOM_BUS_ERROR_REG1	((unsigned)0xffffffc8)


#define IOM_BUS_SOURCE	((unsigned)0xf0000000)

#define IOM_BUS_SOURCE_SHIFT	28


#define IOM_BUS_DEST	((unsigned)0x0f000000)

#define IOM_BUS_DEST_SHIFT	24


#define IOM_BUS_TYPE	((unsigned)0x003f0000)

#define IOM_BUS_TYPE_SHIFT	16

/**********************************
*
*	IOM_BUS_ERROR_REG2
*
*	The bits in this register are not valid unless IOM_BUS_ERROR_LATCHED
*	is asserted in IOM_ERROR_REG.
*
*		Bit(s)			Name
*		------			----
*
*		31		IOM_BUS_XMIT
*		30		IOM_BUS_LOCAL_GRANT
*		29		IOM_BUS_DEST_IOM
*		28		IOM_BUS_DATA_PARITY_VALID
*
*		27:24		IOM_BUS_READ_DEST[3:0]
*
*		23:21		IOM_BUS_READ_RESP_PENDING_CNT[2:0]*
*
*		20:16		IOM_BUS_IOSLOT
*
************************************/


#define IOM_BUS_ERROR_REG2	((unsigned)0xffffffd0)


#define IOM_BUS_XMIT		((unsigned)0x80000000)


#define IOM_BUS_LOCAL_GRANT	((unsigned)0x40000000)


#define IOM_BUS_DEST_IOM	((unsigned)0x20000000)


#define IOM_BUS_DATA_PARITY_VALID	((unsigned)0x10000000)


#define IOM_BUS_READ_DEST	((unsigned)0x0f000000)

#define IOM_BUS_READ_DEST_SHIFT	24


#define IOM_BUS_READ_RESP_PENDING_CNT_NOT	((unsigned)0x00e00000)

#define IOM_BUS_READ_RESP_PENDING_CNT_NOT_SHIFT 21

	/*	The logical complement of the number of RESPONSE
		transmissions from the SBUS to complete the current
		READ command.	*/


#define IOM_BUS_IOSLOT		((unsigned)0x001f0000)

#define IOM_BUS_IOSLOT_SHIFT	16

/**********************************
*
*	IOM_DLBUF_STATE_REG
*
*		Bit(s)			Name
*		------			----
*
*		31:28		IOM_DL_CMD_BUF_COUNT[3:0]
*
*		27:24		IOM_DL_RESP_BUF_COUNT[3:0]		
*
*		23		IOM_DL_OUTPUT_REG_READY		
*		22		IOM_DL_READ_REG_READY
*		21		IOM_DLBUF_READ_REQUEST_PENDING
*		20		IOM_IOA_READY
*
*		19		IOM_DLBUF_POINTER[3:0]
*
************************************/


#define IOM_DLBUF_STATE_REG		((unsigned)0xffffffd8)


#define IOM_DL_CMD_BUF_COUNT	((unsigned)0xf0000000)

#define IOM_DL_CMD_BUF_COUNT_SHIFT	28


	/*	The number of commands in the DOWNLINK command buffer	*/


#define IOM_DL_RESP_BUF_COUNT	((unsigned)0x0f000000)

#define IOM_DL_RESP_BUF_COUNT_SHIFT	24


	/*	The number of responses in the DOWNLINK response buffer	*/


#define IOM_DL_OUTPUT_REG_READY			((unsigned)0x00800000)


	/*	*/


#define IOM_DL_READ_REG_READY	((unsigned)0x00400000)


	/*	*/


#define IOM_DLBUF_READ_REQUEST_PENDING	((unsigned)0x00200000)


	/*	*/


#define IOM_IOA_READY	((unsigned)0x00100000)


	/*	*/


#define IOM_DLBUF_POINTER	((unsigned)0x000f0000)

#define IOM_DLBUF_POINTER_SHIFT	16


	/*	The address selected by the DLBUF address multiplexer	*/

/**********************************
*
*	IOM_LINK_ERROR_REG0
*
*	Bits [27:16] in this register are not valid unless
*	IOM_LINK_ERROR_LATCHED is asserted in IOM_ERROR_REG.
*
*		Bit(s)			Name
*		------			----
*
*		31		IOM_LINK_CONN1_PIN1_OPEN
*		30		IOM_LINK_CONN1_PIN64_OPEN
*		29		IOM_LINK_CONN2_PIN1_OPEN
*		28		IOM_LINK_CONN2_PIN64_OPEN
*
*		27		IOM_LINK_RMSEQ_ERROR
*		26		IOM_UL_CMD_BUF_OVFL
*		25		IOM_UL_RESP_BUF_OVFL
*		24		IOM_LINK_ERROR
*
*		23		IOM_LINK_STROBE_NOT
*		22		IOM_LINK_DEST_ERROR
*		21		IOM_LINK_IOSLOT_ERROR
*		20		IOM_LINK_SBSLOT_ERROR
*
*		19		IOM_LINK_TYPE_ERROR
*		18		IOM_LINK_DATA_ERROR
*		17		IOM_LINK_ACK_NOT
*		16		IOM_LINK_NACK
*
*	IOM_LINK_ERROR_REG0 contains three distinct groups of bits.
*
*	IOM_LINK_ERROR_REG0[31:28] indicate whether the IOM is connected
*	to an IOA.  If one of these bits is asserted, the named LINK pin
*	is not connected to an IOA.
*
*	IOM_LINK_ERROR_REG0[27:25] indicates which if any non-transmission
*	error was detected.  THESE BITS MUST BE CHECKED FIRST WHEN
*	PROCESSING A LINK ERROR.
*
*	If IOM_LINK_ERROR_REG0[27:25] is 0, then a transmission error
*	was detected and IOM_LINK_ERROR_REG0[23:16] indicates the
*	specific error that was detected.
*
*	IOM_LINK_ERROR_REG1 and IOM_LINK_ERROR_REG2 contain supporting
*	information.
*
************************************/


#define IOM_LINK_ERROR_REG0	((unsigned)0xffffffe0)


#define IOM_LINK_CONN1_PIN1_OPEN	((unsigned)0x80000000)


#define IOM_LINK_CONN1_PIN64_OPEN	((unsigned)0x40000000)


#define IOM_LINK_CONN2_PIN1_OPEN	((unsigned)0x20000000)


#define IOM_LINK_CONN2_PIN64_OPEN	((unsigned)0x10000000)


#define IOM_LINK_RMSEQ_ERROR		((unsigned)0x08000000)


#define IOM_UL_CMD_BUF_OVFL		((unsigned)0x04000000)


#define IOM_UL_RESP_BUF_OVFL		((unsigned)0x02000000)


#define IOM_LINK_ERROR		((unsigned)0x01000000)


#define IOM_LINK_STROBE_NOT	((unsigned)0x00800000)


#define IOM_LINK_DEST_ERROR	((unsigned)0x00400000)


#define IOM_LINK_IOSLOT_ERROR	((unsigned)0x00200000)


#define IOM_LINK_SBSLOT_ERROR	((unsigned)0x00100000)


#define IOM_LINK_TYPE_ERROR	((unsigned)0x00080000)


#define IOM_LINK_DATA_ERROR	((unsigned)0x00040000)


#define IOM_LINK_ACK_NOT	((unsigned)0x00020000)


#define IOM_LINK_NACK		((unsigned)0x00010000)

/**********************************
*
*	IOM_LINK_ERROR_REG1
*
*	The bits in this register are not valid unless IOM_LINK_ERROR_LATCHED
*	is asserted in IOM_ERROR_REG.
*
*		Bit(s)			Name
*		------			----
*
*		31		IOM_LINK_SOURCE
*		30		IOM_LINK_DESTINATION
*		29		IOM_LINK_RMSEQ
*
*		28:24		IOM_LINK_IOSLOT[4:0]		
*
*		23		IOM_LINK_CMD_DATA_READY_NOT
*		22		IOM_LINK_RESP2OR6_READY
*
*		21:16		IOM_LINK_TYPE[5:0]
*
*
************************************/


#define IOM_LINK_ERROR_REG1	((unsigned)0xffffffe8)


#define IOM_LINK_SOURCE		((unsigned)0x80000000)


#define IOM_LINK_DESTINATION	((unsigned)0x40000000)


#define IOM_LINK_RMSEQ		((unsigned)0x20000000)


#define IOM_LINK_IOSLOT		((unsigned)0x1f000000)

#define IOM_LINK_IOSLOT_SHIFT	24


#define IOM_LINK_CMD_DATA_READY_NOT	((unsigned)0x00800000)


#define IOM_LINK_RESP2OR6_READY	((unsigned)0x00400000)


#define IOM_LINK_TYPE		((unsigned)0x003f0000)

#define IOM_LINK_TYPE_SHIFT	16

/**********************************
*
*	IOM_LINK_ERROR_REG2
*
*	The bits in this register are not valid unless IOM_LINK_ERROR_LATCHED
*	is asserted in IOM_ERROR_REG.
*
*		Bit(s)			Name
*		------			----
*
*		31:28		IOM_LINK_SBSLOT[3:0]
*
*		27		IOM_LINK_DATA_ERROR_BYTE3
*		26		IOM_LINK_DATA_ERROR_BYTE2
*		25		IOM_LINK_DATA_ERROR_BYTE1
*		24		IOM_LINK_DATA_ERROR_BYTE0
*
*
************************************/


#define IOM_LINK_ERROR_REG2	((unsigned)0xfffffff0)


#define IOM_LINK_SBSLOT	((unsigned)0xf0000000)

#define IOM_LINK_SBSLOT_SHIFT	28


#define IOM_LINK_DATA_ERROR_BYTE3	((unsigned)0x08000000)

#define IOM_LINK_DATA_ERROR_BYTE2	((unsigned)0x04000000)

#define IOM_LINK_DATA_ERROR_BYTE1	((unsigned)0x02000000)

#define IOM_LINK_DATA_ERROR_BYTE0	((unsigned)0x01000000)


	/*	IOM_LINK_DATA_ERROR_BYTE[n] indicates whether a
		parity error was detected in data byte n on a
		LINK transmission.

		When asserted, a parity error was detected in
		data byte n.

		When deasserted, a parity error was not detected
		in data byte n.	*/

/**********************************
*
*	IOM_ULBUF_STATE_REG
*
*		Bit(s)			Name
*		------			----
*
*		31:28		IOM_UL_CMD_BUF_CNT[3:0]
*
*		27:24		IOM_UL_RESP_BUF_CNT[3:0]		
*
*		23:22		---
*
*		21:20		IOM_DLD_READ_CNT[1:0]
*
*		19:16		IOM_UL_BUF_POINTER[3:0]
*
*
************************************/


#define IOM_ULBUF_STATE_REG		((unsigned)0xfffffff8)


#define IOM_UL_CMD_BUF_COUNT	((unsigned)0xf0000000)

#define IOM_UL_CMD_BUF_COUNT_SHIFT	28


	/*	The number of commands in the UPLINK command buffer	*/


#define IOM_UL_RESP_BUF_COUNT	((unsigned)0x0f000000)

#define IOM_UL_RESP_BUF_COUNT_SHIFT	24


	/*	The number of responses in the UPLINK response buffer	*/


#define IOM_DLD_READ_CNT	((unsigned)0x00300000)

#define IOM_DLD_READ_CNT_SHIFT	20


	/*	The number on entries in the Delayed Read FIFO	*/


#define IOM_ULBUF_POINTER	((unsigned)0x000f0000)

#define IOM_ULBUF_POINTER_SHIFT	16


	/*	The address selected by the DLBUF address multiplexer	*/

/**********************************
*
*	IOM_ID_REG
*
*		Bit(s)		Name
*		------		----
*
*		31:8		--
*
*		7:0		IOM_ID[7:0]
*
*
************************************/


#define IOM_ID_REG			((unsigned)0xfffffffc)


#define IOM_ID	((unsigned)0x000000ff)

/******************************************
*
*	A1000 I/O controllers and the IOA are unable to issue the INTERRUPT
*	REQUEST messages used in the S90 system.  The INTERRUPT REQUEST
*	signal from an A1000 controller is detected by the I/O Adapter.
*	The I/O Adapter writes one byte containing the IOSLOT number of
*	the requesting controller to offset address 0xfffffc00 of the
*	I/O Module to which the IOA is connected by the LINK.  The
*	I/O Module uses the IOSLOT number to index into a table of
*	INTERRUPT VECTORs and issues the specified INTERRUPT REQUEST message.
* 
*	INTERRUPT VECTORs are stored in the IOM for 32 IOSLOTs and for
*	the IOM itself.  INTERRUPT VECTORs are defined as 32 bit long words.
*	INTERRUPT VECTOR storage is READ/WRITE.  Since byte 3 of the
*	INTERRUPT VECTOR is undefined, the INTERRUPT VECTOR storage implements
*	only bytes 0:2 (bits 31:8).  The INTERRUPT VECTORs must be written as
*	long words.
*
*	The INTERRUPT VECTOR has the following format:
*
*		Bit(s)		Use
*		------		---
*
*		31:24		Type of Interrupt (software defined)
*
*		23:16		Interrupt priority
*
*					Priority levels 0:127 are non-directed;
*					priority levels 128:255 are directed.
*
*		15:12		Sbus module address to be interrupted by a
*					directed interrupt
*
*					0x0 if interrupt in non-directed
*
*		11:8		Sbus module address to which interrupt requests
*					are sent
*
*					This is usually the Sbus module
*					address of interrupt dispatcher.
*
*		7:0		undefined and unimplemented
*
*
*
*	The INTERRUPT REQUEST has the following format:
*
*		Bit(s)		Use
*		------		---
*
*		31:24		Type of Interrupt (software defined)
*
*		23:16		Interrupt priority
*
*					Priority levels 0:127 are non-directed;
*					priority levels 128:255 are directed.
*
*		15:12		Sbus module address to be interrupted by a
*					directed interrupt
*
*					0x0 if interrupt in non-directed
*
*		11:8		Sbus module address of interrupt requester
*
*					Sbus source of the interrupt request
*
*		7		Attached I/O bus flag
*
*					When asserted, the interrupt request
*					is from a device on an I/O bus that
*					is attached to the Sbus thru an IOM.
*					Bits 11:8 indicate the slot of the
*					attaching IOM.
*					
*					When not asserted, the interrupt is
*					from the module in the specified
*					Sbus slot.
*
*		6:0		I/O bus slot number of interrupt requester
*
*					This field is 0x0 if bit 7 = 0
*
*
*******************************************/


/* address to program up info associated with IOM generated interrupts */

#define IOM_ERROR_INTR_VECTOR	((unsigned)0xfffffd00)


/*
 * base of INTERRUPT VECTOR table.  The table contains interrupt information
 * associated with each i/o slot behind the IOM/IOA.
 */

#define IOM_IOSLOT_INTR_VECTOR_BASE	((unsigned)0xfffffe00)

/*
 * the IOM fills in its SBUS slot in an interrupt request in bits 11:8 
 */

#define GET_IOM_SLOT(x)		((x & 0x00000f00) >> 8)


/*  The spacing in 32 bit long words of IOM_IOSLOT_INTR_VECTORs	*/

#define IOM_IOSLOT_INTR_VECTOR_SIZE	2


/********************************************
*
*	Through the IOM/IOA a 64K window is provided to each slot on
*	the ICB hooked to the IOA.
*
********************************************/


#define IOM_ICB_BASE	((unsigned)0x00000000)

#endif /* SBUS_IOM_H */
