#ifndef SBUS_CONF_H
#define SBUS_CONF_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sbus_conf.h: version 25.1 created on 11/27/91 at 15:35:09	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sbus_conf.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* sbus_conf.h */

#ifndef SYS_SBUS_H
#include "sys/sbus.h"
#endif

#ifndef SYS_IUNIT_H
#include "sys/iunit.h"
#endif

#define BOARD_DECONFIG(slot)	(sbus_config.slot_id[slot] = SBUS_NO_BOARD)
#define BOARD_CONFIG(slot)	(get_slot_config(slot))

typedef struct sbus_config {
	uchar	slot_id[SBUS_NUM_SLOT];		/* id of each slot */
	uchar	dev_board_id[SBUS_NUM_SLOT];	/* IOPM device board ID */
	uint	slot_size[SBUS_NUM_SLOT];	/* size of any memory boards */
	uint	pfn_adjust[SBUS_NUM_SLOT];	/* spfn minus lpfn */
	uint	lpfn_end[SBUS_NUM_SLOT];	/* one more than last lpfn */
	uint	pm_own[SBUS_MAX_NUM_PM];	/* address in kernel's memory */
	uint	pm_qtbl[SBUS_MAX_NUM_PM];	/* address in kernel's memory */
	uint	pm_stbl[SBUS_MAX_NUM_PM];	/* address in kernel's memory */

	uint	invalid_rde;
	uint	invalid_qde;
	uint	invalid_sde;
	uint	invalid_pde;
	uint	*kv_iomap;
	uint	mem_ptbl;
	uint	iopm_stbl;
	uint	*lpfn_tbl;
	uint	cache_off;
	iunit_t	rootdev;
	iunit_t	swapdev;
	uint	cpu_type;
} sbus_config_t;

extern sbus_config_t	sbus_config;

#endif /* SBUS_CONF_H */
