#ifndef SAIO_H
#define SAIO_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) saio.h: version 25.1 created on 11/27/91 at 15:35:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)saio.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * header file for standalone package
 */

#include "sainode.h"

#ifndef SYS_IUNIT_H
#include "sys/iunit.h"
#endif

#ifndef SA_DIR_H
#include "sa_dir.h"
#endif

/*
 * io block: includes an
 * inode, cells for the use of seek, etc,
 * and a buffer.
 */
#define BUFFSIZE 1024
typedef struct iob {
	sainode_t	i_ino;
	ushort		i_flgs;
	ushort		inodesize;	
	iunit_t		i_unit;
	off_t		i_offset;
	daddr_t		i_bn;
	char		*i_ma;
	int		i_cc;
} iob_t;

#define F_READ		0x01	/* open for reading		*/
#define F_WRITE		0x02	/* open for writing		*/
#define F_ALLOC		0x08	/* struct is in use		*/
#define F_FILE		0x10	/* is a file in a file system	*/
#define F_BOOT		0x20	/* is a file in a bootimage	*/
#define F_PERMMASK	0x03	/* open permission mask		*/
#define F_TYPEMASK	0xf0	/* file type mask		*/

/*
 * request codes. Must be the same as F_XXX above
 */
#define CNTRL	0
#define	READ	1
#define	WRITE	2

/*
 * dev switch
 */
typedef struct devsw {
	uint	dv_id;
	int	(*dv_strategy)();
	int	(*dv_open)();
	int	(*dv_close)();
	int	(*dv_ioctl)();
} devsw_t;

extern devsw_t	devsw[];


#define	NBUFS		3	/* number of indirect buffers to maintain */
#define NFILES		6	/* number of file descriptors	*/
#define XTRA_NFILES	2	/* extras for use by drivers	*/

#define iob		((iob_t *)iob_array)

#endif /* SAIO_H */
