#ifndef SA_DIR_H
#define SA_DIR_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sa_dir.h: version 25.1 created on 11/27/91 at 15:34:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sa_dir.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* sa_dir.h */

#define MAX_DIR_ENTRY	31
#define MAX_DIR_NAME	15
#define BLK_SIZE	0x400				/* size of block */
#define sa_load_point	0x90001000			/* standalone addr */
#define iob_offset	0				/* iob board offset */
#define iob_array	0x90000000			/* iob mapped addr */
#define dir_load_point	(iob_array + BLK_SIZE)		/* directory block */
#define xtra_block	(dir_load_point + BLK_SIZE)	/* superblock buff */
#define getc_block	(xtra_block + BLK_SIZE)		/* getc's block */
#define sa_mem_requirement 0x200000			/* MM must be >= this */
#define MAGIC_NUM	'SA'				/* sa_dir.magic_num */

typedef struct sa_dir_entry {
	unsigned char	name[MAX_DIR_NAME];/* program name */
	unsigned char	major_version;	/* program major version # */
	unsigned char	minor_version;	/* program minor version # */
	unsigned int	start_block_num;/* program start block */
	unsigned int	byte_count;	/* program byte count */
	unsigned char	spm_exec;	/* set if spm local execution */
	unsigned char	pad[5];		/* byte pad */
} sa_dir_entry_t;

typedef struct sa_dir {
	unsigned short	magic_num;		/* magic number for ldsa */
	unsigned char	major_version;		/* bootimage major version # */
	unsigned char	minor_version;		/* bootimage minor version # */
	unsigned int	next_dir_block;		/* next directory block
					   	   0 means this is the last */
	unsigned int	block_size;		/* block size of data */
	unsigned int	bootimage_size;		/* entire bootimage size */
	unsigned char	pad[16];		/* byte pad */
	sa_dir_entry_t	entry[MAX_DIR_ENTRY];
} sa_dir_t;	

#endif /* SA_DIR_H */
