#ifndef RWI_H
#define RWI_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) rwi.h: version 25.1 created on 11/27/91 at 15:34:52	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)rwi.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * sensor.h
 */

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif

#include "sensor.h"

/*
	CIO 0 port A bit definition
	---------------------------

  I/O	I  I  I  I  I  I  I  I

	7  6  5  4  3  2  1  0
	|  |  |  |  |  |  |  |
	|  |  |  |  |  |  |  +--------	power supply 0 power fail, active low
	|  |  |  |  |  |  +-----------  power supply 1 power fail, active low
	|  |  |  |  |  +--------------  power supply 2 power fail, active low 
	|  |  |  |  +-----------------  power supply 3 power fail, active low
	|  |  |  +--------------------  power supply 4 power fail, active low
	|  |  +-----------------------  UPS a.c. fail, active low
	|  +--------------------------	UPS low battery, active low
	+-----------------------------  off switch, active low 

	
	CIO 0 port B bit definition
	---------------------------

  I/O	O  O  O  O  O  O  O  O

	7  6  5  4  3  2  1  0
	|  |  |  |  |  |  |  |
	|  |  |  |  |  |  |  +-------- 	solid state relay 0, active low 
	|  |  |  |  |  |  +----------- 	solid state relay 1, active low 
	|  |  |  |  |  +-------------- 	solid state relay 2, active low 
	|  |  |  |  +----------------- 	solid state relay 3, active low 
	|  |  |  +--------------------	solid state relay 4, active low  
	|  |  +-----------------------	solid state relay 5, active low	
	|  +--------------------------	solid state relay 6, active low	
	+-----------------------------	UPS off, active low
	

	CIO 0 port C bit definition
	---------------------------

  I/O	I  I  I  I

	3  2  1  0
	|  |  |  |
	|  |  |  +-------------------- 	on switch, active low
	|  |  +-----------------------  off switch, active low 
	|  +--------------------------	spare  
	+-----------------------------	spare 	



	CIO 1 port A bit definition
	---------------------------

  I/O	I  I  I  I  I  I  I  I

	7  6  5  4  3  2  1  0
	|  |  |  |  |  |  |  |
	|  |  |  |  |  |  |  +--------	RWI type 0
	|  |  |  |  |  |  +-----------  RWI type 1 
	|  |  |  |  |  +--------------  RWI type 2 (ACRW)
	|  |  |  |  +-----------------  spare 
	|  |  |  +-------------------- 	spare 
	|  |  +----------------------- 	spare
	|  +--------------------------  spare	
	+-----------------------------  spare

	CIO 1 port B bit definition
	---------------------------

  I/O	O  O  O  O  O  O  O  O	

	7  6  5  4  3  2  1  0
	|  |  |  |  |  |  |  |
	|  |  |  |  |  |  |  +--------	power supply 0 margin +, active low
	|  |  |  |  |  |  +-----------	power supply 1 margin +, active low
	|  |  |  |  |  +--------------	power supply 2 margin +, active low
	|  |  |  |  +-----------------	power supply 3 margin +, active low
	|  |  |  +--------------------	power supply 4 margin +, active low
	|  |  +-----------------------	power supply 0 margin -, active low
	|  +--------------------------	power supply 1 margin -, active low
	+-----------------------------	power supply 2 margin -, active low


	CIO 1 port C bit definition
	---------------------------

  I/O	O  O  O  O

	3  2  1  0
	|  |  |  |
	|  |  |  +--------------------	power supply 3 margin -, active low
	|  |  +-----------------------	power supply 4 margin -, active low
	|  +-------------------------- 	warning light, active low
        +-----------------------------  system on light, active low

(Bits 7-4 are read as 1s.  When writing, each set bit in the MS nybble disables
 the write to the cooresponding bit to the LS nybble.  For example, to modify
 only the warning light bit:  *RWI_CIO1_PORTC = val | 0xd0;

*/
#define RWI_CIO0 ((struct cio *)(0x02800a00))
#define RWI_CIO1 ((struct cio *)(0x02800c00))
#define	RWI_CIO0_PORTA	((unchar *)(0x02800a1a))
#define	RWI_CIO0_PORTB	((unchar *)(0x02800a1c))
#define	RWI_CIO0_PORTC	((unchar *)(0x02800a1e))
#define	RWI_CIO1_PORTA	((unchar *)(0x02800c1a))
#define	RWI_CIO1_PORTB	((unchar *)(0x02800c1c))
#define	RWI_CIO1_PORTC	((unchar *)(0x02800c1e))

/* CIO 0 port a bit positions */

#define PS_0_FAIL	0x01
#define PS_1_FAIL	0x02
#define PS_2_FAIL	0x04
#define PS_3_FAIL	0x08
#define PS_4_FAIL	0x10
#define UPS_AC_FAIL	0x20
#define UPS_LOW_BATTERY	0x40
#define	OFF_SW		0x80

#define PS_ANY_FAIL    (PS_0_FAIL|PS_1_FAIL|PS_2_FAIL|PS_3_FAIL|PS_4_FAIL)

/* CIO 0 port b bit positions */

#define CAB_0_RELAY_ON	0x01
#define CAB_1_RELAY_ON	0x02
#define	CAB_2_RELAY_ON	0x04
#define	CAB_3_RELAY_ON	0x08
#define	CAB_4_RELAY_ON	0x10
#define	CAB_5_RELAY_ON	0x20
#define	CAB_6_RELAY_ON	0x40
#define UPS_OFF		0x80
#define ALL_CAB_OFF	0x7f

/* CIO 0 port c bit positions */

#define ON_SWITCH	0x01
#define OFF_SWITCH	0x02

/* CIO 1 port a bit positions */

#define RWI_TYPE_0	0x01
#define RWI_TYPE_1	0x02
#define RWI_TYPE_2	0x04
#define RWI_TYPE_ACRW	0x04
#define RWI_TYPE_MASK	0x07

#define RWI_REV_1A	0x00
#define	RWI_REV_2B	0x01

#define ACRW_FAN_OK	0x80

/* CIO 1 port b bit positions */

#define	PS_0_POS_MARGIN	0x01
#define	PS_1_POS_MARGIN	0x02
#define	PS_2_POS_MARGIN	0x04
#define	PS_3_POS_MARGIN	0x08
#define	PS_4_POS_MARGIN	0x10
#define	PS_0_NEG_MARGIN	0x20
#define	PS_1_NEG_MARGIN	0x40
#define	PS_2_NEG_MARGIN	0x80

/* CIO 1 port c bit positions */

#define	PS_3_NEG_MARGIN	0x01
#define	PS_4_NEG_MARGIN	0x02
#define	WARNING_LIGHT	0x04
#define	ON_LIGHT	0x08

#define LIGHT_ON(p, bit)  (*(p) = (bit) | (~(bit) << 4))
#define LIGHT_OFF(p, bit) (*(p) = ~(bit) << 4)
#define ON_LIGHT_ON	  LIGHT_ON(RWI_CIO1_PORTC,  ON_LIGHT)
#define ON_LIGHT_OFF	  LIGHT_OFF(RWI_CIO1_PORTC, ON_LIGHT)
#define WARNING_LIGHT_ON  LIGHT_ON(RWI_CIO1_PORTC,  WARNING_LIGHT)
#define WARNING_LIGHT_OFF LIGHT_OFF(RWI_CIO1_PORTC, WARNING_LIGHT)

/*******************************************************************************
 *
 *	SCC	
 *
 ******************************************************************************/

/* SCC 0 */
#define CONSOLE_PORT	((struct scc *)(0x02800820))
#define MODEM_PORT	((struct scc *)(0x02800800))

/* SCC 1 */
#define PRINTER_PORT	((struct scc *)(0x02800920))
#define UPS_PORT	((struct scc *)(0x02800900))

/* RWI interrupt vectors */
#define SCC0_VECT 0x80
#define SCC1_VECT 0x90

/* RWI A/D converter channel 0*/

#define CAB_0_INLET_AIR_CHAN		0x00
#define CAB_0_INLET_AIR_MUX		0x00
#define CAB_0_EXHAUST_AIR_CHAN		0x00
#define CAB_0_EXHAUST_AIR_MUX		0x10
#define CAB_1_INLET_AIR_CHAN		0x00
#define CAB_1_INLET_AIR_MUX		0x20
#define CAB_1_EXHAUST_AIR_CHAN		0x00
#define CAB_1_EXHAUST_AIR_MUX		0x30
#define CAB_2_INLET_AIR_CHAN		0x00
#define CAB_2_INLET_AIR_MUX		0x40
#define CAB_2_EXHAUST_AIR_CHAN		0x00
#define CAB_2_EXHAUST_AIR_MUX		0x50
#define CAB_3_INLET_AIR_CHAN		0x00
#define CAB_3_INLET_AIR_MUX		0x60
#define CAB_3_EXHAUST_AIR_CHAN		0x00
#define CAB_3_EXHAUST_AIR_MUX		0x70

/* RWI A/D converter channel 2*/

#define CAB_4_INLET_AIR_CHAN		0x02
#define CAB_4_INLET_AIR_MUX		0x00
#define CAB_4_EXHAUST_AIR_CHAN		0x02
#define CAB_4_EXHAUST_AIR_MUX		0x10
#define CAB_5_INLET_AIR_CHAN		0x02
#define CAB_5_INLET_AIR_MUX		0x20
#define CAB_5_EXHAUST_AIR_CHAN		0x02
#define CAB_5_EXHAUST_AIR_MUX		0x30
#define CAB_6_INLET_AIR_CHAN		0x02
#define CAB_6_INLET_AIR_MUX		0x40
#define CAB_6_EXHAUST_AIR_CHAN		0x02
#define CAB_6_EXHAUST_AIR_MUX		0x50

/* RWI A/D converter channel 3 */

#define PS_0_TEMP_CHAN			0x03
#define PS_0_TEMP_MUX			0x00
#define PS_1_TEMP_CHAN			0x03
#define PS_1_TEMP_MUX			0x10
#define PS_2_TEMP_CHAN			0x03
#define PS_2_TEMP_MUX			0x20
#define PS_3_TEMP_CHAN			0x03
#define PS_3_TEMP_MUX			0x30
#define PS_4_TEMP_CHAN			0x03
#define PS_4_TEMP_MUX			0x40


/* RWI A/D converter channel 4 */

#define PS_0_5_VOLT_CHAN		0x04
#define PS_0_5_VOLT_MUX			0x00
#define PS_0_12_VOLT_CHAN		0x04
#define PS_0_12_VOLT_MUX		0x10
#define PS_0_NEG_12_VOLT_CHAN		0x04
#define PS_0_NEG_12_VOLT_MUX		0x20
#define PS_0_I_MON_CHAN			0x04
#define PS_0_I_MON_MUX			0x30
#define PS_1_5_VOLT_CHAN		0x04
#define PS_1_5_VOLT_MUX			0x40
#define PS_1_12_VOLT_CHAN		0x04
#define PS_1_12_VOLT_MUX		0x50
#define PS_1_NEG_12_VOLT_CHAN		0x04
#define PS_1_NEG_12_VOLT_MUX		0x60
#define PS_1_I_MON_CHAN			0x04
#define PS_1_I_MON_MUX			0x70

/* RWI A/D converter channel 5 */

#define PS_2_5_VOLT_CHAN		0x05
#define PS_2_5_VOLT_MUX			0x00
#define PS_2_12_VOLT_CHAN		0x05
#define PS_2_12_VOLT_MUX		0x10
#define PS_2_NEG_12_VOLT_CHAN		0x05
#define PS_2_NEG_12_VOLT_MUX		0x20
#define PS_2_I_MON_CHAN			0x05
#define PS_2_I_MON_MUX			0x30
#define PS_3_5_VOLT_CHAN		0x05
#define PS_3_5_VOLT_MUX			0x40
#define PS_3_12_VOLT_CHAN		0x05
#define PS_3_12_VOLT_MUX		0x50
#define PS_3_NEG_12_VOLT_CHAN		0x05
#define PS_3_NEG_12_VOLT_MUX		0x60
#define PS_3_I_MON_CHAN			0x05
#define PS_3_I_MON_MUX			0x70

/* RWI A/D converter channel 6 */

#define PS_4_5_VOLT_CHAN		0x0e
#define PS_4_5_VOLT_MUX			0x00
#define PS_4_12_VOLT_CHAN		0x0e
#define PS_4_12_VOLT_MUX		0x10
#define PS_4_NEG_12_VOLT_CHAN		0x0e
#define PS_4_NEG_12_VOLT_MUX		0x20
#define PS_4_I_MON_CHAN			0x0e
#define PS_4_I_MON_MUX			0x30

#define RWI_AD_MUX ((ushort *)(0x02800d00))
#define RWI_AD_CNTL ((ushort *)(0x02800b02))
#define RWI_AD_DATA ((ushort *)(0x02800b00))
#define RWI_AD_RESULT_MASK	0x00ff
#define RWI_AD_START_CONV	0x0100
#define RWI_AD_END_CONV		0x8000

/* RWI A/D converter state variable */ 
#define INLET_AIR		0x10
#define	EXHAUST_AIR		0x11
#define MAIN_FIVE_VOLT		0x12
#define MAIN_TWELVE_VOLT	0x13
#define	MAIN_NEG_TWELVE_VOLT	0x14
#define	MAIN_FIVE_VOLT_CURRENT	0x15	
#define	PS_TEMP			0x16

#define	MAIN_5V_HC_AMPS		0x20	/* more descriptive IDs for 5V current*/
#define	MAIN_5V_SWITCH_AMPS	0x21

#define	EXHAUST_DELTA		0x99	/* phony for change_err_state */

/* conversion numbers */

#define	VOLTS_PER_BIT			176
#define	VOLTAGE_OFFSET			290
#define	VOLTS_PER_DEGREE		703
#define	FIVE_VOLTS_PER_BIT		352
#define	TWELVE_VOLTS_PER_BIT		850
#define	NEG_TWELVE_VOLTS_PER_BIT	1188	
#define HC_VOLTS_PER_AMP		33
#define SW_VOLTS_PER_AMP		160	
#define	NEG_TWELVE_ZERO			0xda
#define NEG_TWELVE_MAX			259200
#define	TEN_THOUSAND			10000
#define	ONE_THOUSAND			1000
#define	ONE_HUNDRED			100


/* main and expansion cabinets */

#define CAB_INLET_AIR		0
#define CAB_EXHAUST_AIR		1
#define CAB_EXHAUST_DELTA	2
#define NUM_SENSORS_PER_CABINET	3
/* psuedo-structure members */
#define c_inlet_air		cab[CAB_INLET_AIR]
#define c_exhaust_air		cab[CAB_EXHAUST_AIR]
#define c_exhaust_delta		cab[CAB_EXHAUST_DELTA]

#define POW_FIVE_VOLT		0
#define POW_TWELVE_VOLT		1
#define POW_NEG_TWELVE_VOLT	2
#define POW_FIVE_VOLT_CURRENT	3
#define POW_TEMP		4
#define NUM_SENSORS_PER_PS	5
/* psuedo-structure members */
#define p_five_volt		pow[POW_FIVE_VOLT]
#define p_twelve_volt		pow[POW_TWELVE_VOLT]
#define p_neg_twelve_volt	pow[POW_NEG_TWELVE_VOLT]
#define p_five_volt_current	pow[POW_FIVE_VOLT_CURRENT]
#define p_ps_temp		pow[POW_TEMP]

typedef struct cabinet {
	sensor_t	cab[NUM_SENSORS_PER_CABINET];
} cabinet_t;

typedef struct main_ps {
	sensor_t	pow[NUM_SENSORS_PER_PS];
} main_ps_t;

/* power supply types */
#define SWITCHING_POWER 	0
#define HC_POWER		1
#define NO_POWER_SUPPLY		0xff

/* cabinet types */
#define	CSS_CABINET		0
#define IO_CABINET		1
#define NO_CABINET		0xff

/* sensor states */
#define NORMAL			0
#define	WARNING			1
#define	SHUTDOWN		2
#define DECONFIGURED		0xff

#define	PS_0_MARGIN_HIGH	0x01
#define	PS_1_MARGIN_HIGH	0x02
#define	PS_2_MARGIN_HIGH	0x04
#define	PS_3_MARGIN_HIGH	0x08
#define	PS_4_MARGIN_HIGH	0x10
#define	PS_0_MARGIN_LOW		0x20
#define	PS_1_MARGIN_LOW		0x40
#define	PS_2_MARGIN_LOW		0x80
#define	PS_3_MARGIN_LOW		0x01
#define	PS_4_MARGIN_LOW		0x02

#define	MARGIN_OFF		0x00
#define	MARGIN_HIGH		0x01
#define	MARGIN_LOW		0x02

/* misc. */

#ifndef NEL
#define NEL(x)			(sizeof(x) / sizeof(*x))
#endif

#ifndef BAD_UINT
#define BAD_UINT		(~(uint)0)	/* unsigned error value	*/
#endif

#endif /* RWI_H */
