#ifndef RTC_H
#define RTC_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) rtc.h: version 25.1 created on 11/27/91 at 15:34:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)rtc.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*******************************************************************
 *
 *			R   T   C
 *
 *******************************************************************/

struct rtc {
	unsigned char control;			/* control register */
	unsigned char sec;			/* seconds */
	unsigned char min;			/* minutes */
	unsigned char hour;			/* hour */
	unsigned char day;			/* day */
	unsigned char date;			/* date */
	unsigned char month;			/* month */
	unsigned char year;			/* year */
};

/******************************************************************************
 *
 * control --- rtc control register
 *
 ******************************************************************************/
#define RTC_WRITE_BIT	0x80	/* write bit (set to change clock's time) */
				/* When write is cleared the values in the
				 * registers will be transferred into the clock
				 */
#define RTC_READ_BIT	0x40	/* read bit -- stops updates while reading */
#define RTC_SIGN_BIT	0x20	/* sign bit (for cal bits) */
#define RTC_CAL_BITS	0x1f	/* time calibration (5 bit signed binary) */
				/* Each increment changes time 5.35 sec/month.
				 * Positive numbers make the clock run faster;
				 * negative make it run slower.
				 */
#define RTC_SCALE	535	/* each increment in the calibration field */
				/* changes the clock by 535 hundredths of a
				 * second per month
				 */

/******************************************************************************
 *
 * seconds --- seconds register
 *
 ******************************************************************************/
#define RTC_STOP_BIT	0x80	/* stop bit -- stops the oscillator when true */

/******************************************************************************
 *
 * hour --- hour register
 *
 ******************************************************************************/
#define RTC_KICK_START	0x80	/* kick start bit -- the oscillator is not */
				/* guaranteed to be self-starting unless this
				 * bit is used.  Procedure:
				 *	1) set write to 1
				 *	2) set kick start to 1 (stop must be 0)
				 *	3) set write to 0
				 *	4) wait 2 seconds
				 *	5) set write to 1
				 *	6) set kick start to 0
				 *	7) set time and date
				 *	8) set write to 0
				 * Don't leave kick start on -- it increases
				 * power consumption.
				 */

/******************************************************************************
 *
 * day --- day register
 *
 ******************************************************************************/
#define RTC_FREQ_TEST	0x40	/* frequency test -- when true, the chip's */
				/* LSB (DQ0) outputs the oscillator's idea of
				 * 512 Hz.  Don't use this feature in a SPM.
				 */

/******************************************************************************
 *
 * mask defines
 *
 ******************************************************************************/
#define RTC_DAY_MASK	0x07
#define RTC_MONTH_MASK	0x1f
#define RTC_DATE_MASK	0x3f
#define RTC_HOUR_MASK	0x3f
#define RTC_MIN_MASK	0x7f
#define RTC_SEC_MASK	0x7f
#define RTC_YEAR_MASK	0xff

#endif /* RTC_H */
