#ifndef NOVRAM_H
#define NOVRAM_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) novram.h: version 25.1 created on 11/27/91 at 15:34:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)novram.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif

#ifndef LIMIT_H
#include "limit.h"
#endif

#include "param.h"
#include "sa_dir.h"
#include "sys/sbus.h"


#define SPM_NOVRAM_VERSION_A	2
#define SPM_NOVRAM_VERSION_B	3
#define PATHNAME_LENGTH 	80	
#define PATH_LENGTH 		32	
#define PASSWORD_LENGTH		16

/* system type defines */
/* BEWARE : this information is supplied by the PROMs
 * They distinguish between models 25 and 15 by using the fact that 15s 
 * always have the SPM/ACRW in slot 3.
 * Model 25s with the SPM/ACRW in slot 3 will therefore be incorrectly
 * identified.
 * Currently this information isn't used anywhere. That should probably remain
 * the case.
 */

#define SYS_UNKNOWN		0		/* unknown system type */
#define SYS_45			1		/* model 45/85 */
#define SYS_25			2		/* model 25 */
#define SYS_15			4		/* model 15 */

/* fan checking status set by PROMs */
#define	FAN_ALRM_DISABLE	0x00		/* fan alarm disabled */
#define	FAN_ALRM_ENABLE		0x01		/* fan alarm enabled */

#define NUM_ICB_DEVS_PER_IOA	20	/* still supported by the PROMs */

struct local_sensor {
	unchar	five_volt   	   : 1;	
	unchar	aux_five_volt  	   : 1;	
	unchar	twelve_volt 	   : 1;	
	unchar	aux_twelve_volt	   : 1;	
	unchar	neg_twelve_volt	   : 1;	
	unchar	aux_neg_twelve_volt : 1;	
	unchar	cage_air	   : 1;
	unchar  unused		   : 1;	
} ;
	
struct pwr_sensor {
	unchar	ps_id;
	unchar	scale_factor;
	unchar	five_volt   	   : 1;	
	unchar	twelve_volt 	   : 1;	
	unchar	neg_twelve_volt    : 1;	
	unchar	five_volt_current  : 1;	
	unchar	temp		   : 1;
	unchar  unused		   : 1;	
	unchar  unused1		   : 1;	
	unchar  unused2		   : 1;	
};

struct cab_sensor {
	unchar	present		   : 1;
	unchar	inlet_air	   : 1;
	unchar	exhaust_air	   : 1;
	unchar  unused		   : 1;	
	unchar  unused1		   : 1;	
	unchar  unused2		   : 1;	
	unchar  unused3		   : 1;	
	unchar  unused4		   : 1;	
};

struct new_iom_slot {
	unchar	iom_slot;			/* the mutha of the IOA */
	unchar  ext_bd_type;
	union {
		unchar	icb_slot[NUM_ICB_DEVS_PER_IOA];
		unchar	ios_slot[SBUS_NUM_SLOT];
	} io_bds;
};

struct old_iom_slot {
	unchar	iom_slot;			/* the mutha of the IOA */
	unchar	icb_slot[NUM_ICB_DEVS_PER_IOA];
};

/* novram nv_lim defines */

#define NOV_INLET_AIR_WARNING		0
#define NOV_INLET_AIR_SHUTDOWN		1
#define NOV_EXHAUST_AIR_WARNING		2
#define NOV_EXHAUST_AIR_SHUTDOWN	3
#define NOV_MAIN_PS_TEMP_WARNING	4
#define NOV_MAIN_PS_TEMP_SHUTDOWN	5
#define NOV_FIVE_VOLT_WARNING		6
#define NOV_FIVE_VOLT_SHUTDOWN		7
#define NOV_TWELVE_VOLT_WARNING		8
#define NOV_TWELVE_VOLT_SHUTDOWN	9
#define NOV_NEG_TWELVE_VOLT_WARNING	10
#define NOV_NEG_TWELVE_VOLT_SHUTDOWN	11
#define NOV_FIVE_VOLT_CURRENT_KL	12	/* kludge to make array work */
#define NOV_CAGE_AIR_WARNING		13
#define NOV_CAGE_AIR_SHUTDOWN		14
#define NUM_NOV_LIMITS			15
#define NOV_EXHAUST_DELTA		15	/* kludge! use only low slot! */

/* psuedo-structure defines	*/

#define inlet_air_warning		nv_lim[NOV_INLET_AIR_WARNING]
#define inlet_air_shutdown		nv_lim[NOV_INLET_AIR_SHUTDOWN]
#define exhaust_air_warning		nv_lim[NOV_EXHAUST_AIR_WARNING]
#define exhaust_air_shutdown		nv_lim[NOV_EXHAUST_AIR_SHUTDOWN]
#define main_ps_temp_warning		nv_lim[NOV_MAIN_PS_TEMP_WARNING]
#define main_ps_temp_shutdown		nv_lim[NOV_MAIN_PS_TEMP_SHUTDOWN]
#define five_volt_warning		nv_lim[NOV_FIVE_VOLT_WARNING]
#define five_volt_shutdown		nv_lim[NOV_FIVE_VOLT_SHUTDOWN]
#define twelve_volt_warning		nv_lim[NOV_TWELVE_VOLT_WARNING]
#define twelve_volt_shutdown		nv_lim[NOV_TWELVE_VOLT_SHUTDOWN]
#define neg_twelve_volt_warning		nv_lim[NOV_NEG_TWELVE_VOLT_WARNING]
#define neg_twelve_volt_shutdown	nv_lim[NOV_NEG_TWELVE_VOLT_SHUTDOWN]
#define five_volt_current_warning	nv_lim[NOV_FIVE_VOLT_CURRENT_KL].low
#define five_volt_current_shutdown	nv_lim[NOV_FIVE_VOLT_CURRENT_KL].high
#define five_volt_current_kl		nv_lim[NOV_FIVE_VOLT_CURRENT_KL]
#define cage_air_warning		nv_lim[NOV_CAGE_AIR_WARNING]
#define cage_air_shutdown		nv_lim[NOV_CAGE_AIR_SHUTDOWN]

typedef struct novram {
	/* prom area */

	unchar	novram_ver;
	char	spm_boot_disk[PATH_LENGTH];	/* pathname to SPM runtime */ 
	unchar	diag_boot[PATH_LENGTH];			/* (32) Diag Image. */ 
	unchar	css_slot[SBUS_NUM_SLOT];		/* css slot id's */	
	union {
		struct new_iom_slot  new_iom_slot[NUM_IOM_PER_SYS];
		struct old_iom_slot  old_iom_slot[NUM_IOM_PER_SYS];
	} iom_slot;
	struct  pwr_sensor main_pwr[NUM_PS_PER_SYS]; /* main power supplies */
	struct	cab_sensor cab_present[NUM_CAB_PER_SYS]; /* cabinets */
	struct	local_sensor spm_sensor;

	unchar	diag_fly_by;			/* flag for skipping diags */
	unchar	keywas;				/* Key status. */
	unchar	cmdwas;				/* Command Status. */
	unchar	boot_dev;			/* Boot Device. */
	unchar	pwrstat;			/* Power status. */
	unchar	newpwr;				/* New power indicator. */
	unchar	sys_type;			/* sys type (15/25/45-85) */
	unchar	fan_status;			/* fan status */
	unchar	pad_1;				/* Word Realignment. */
	uint	prom_spare0;	
	uint	prom_spare1;	
	uint	prom_spare2;	
	uint	prom_spare3;	
	uint	prom_spare4;	
	uint	prom_spare5;	
	uint	prom_spare6;	
	uint	prom_spare7;	
	uint	prom_spare8;	
	uint	prom_spare9;	
	uint	prom_spare10;	
	uint	prom_spare11;	
	uint	prom_spare12;	
	uint	prom_spare13;	
	uint	prom_spare14;	
	uint	prom_spare15;	
	uint	prom_spare16;	
	uint	prom_spare17;	
	uint	prom_spare18;	
	uint	prom_spare19;	
	uint	prom_spare20;	
	uint	rwi_val_crc;		/* Chksum of nv_lim array only */
	uint	prom_crc;		/* Chksum of novram_ver to fly_by */

	/* shared area */

	limit_t	nv_lim[NUM_NOV_LIMITS];		/* see the above defines */

	unchar	cage_air_delta; 

	ushort	console_baud_rate;
	ushort	modem_baud_rate;
	ushort	printer_baud_rate;
	ushort	ups_baud_rate;
	char	password[PASSWORD_LENGTH];
	unchar	autoboot;			/* autoboot flag */
	unchar	magic_num;			/* set after initializing the
						   ride thru time */
	unchar	rshutdown;			/* signal to the firmware not */
						/* to apply power */
	uint	modem_active;
	uint	printer_active;
	uint	shared_spare2;
	uint	shared_spare3;	
	uint	shared_spare4;	
	uint	shared_spare5;	
	uint	shared_spare6;	
	uint	shared_spare7;	
	uint	shared_spare8;	
	uint	shared_spare9;	
	uint	shared_spare10;	
	uint	shared_spare11;	
	uint	shared_spare12;	
	uint	shared_spare13;	
	uint	shared_spare14;	
	uint	shared_spare15;	
	uint	shared_crc;	/* Chksum of nv_lim[0] to shared_spare15 */

	/* spm runtime area */

	uint	runtime_crc;		/* Chksum of shutdown to runtime_end */
	/* the following three uints are NOT included in the runtime_crc */
	/* and will never be used -- remove them next opportunity */
	uint	time_on_batteries;		/* seconds spent on batteries */
	uint	power_off_time_stamp;
	uint	ups_ride_thru_limit;		/* ride thru time limit */

	unchar	shutdown;			/* clean shutdown flag */
	unchar	rubber_room;	
	unchar	poll;
	char	kernel_boot_disk[PATHNAME_LENGTH]; /* pathname to Kernel code */
	char	sa_boot_disk[PATHNAME_LENGTH];
	unchar	timestamp;			/* time stamp printfs if true */
	unchar	runtime_end;
} novram_t;

#endif /* NOVRAM_H */
