#ifndef MM_H
#define MM_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mm.h: version 25.1 created on 11/27/91 at 15:34:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mm.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * mm.h
 *
 *	Defines for the S3000 Memory Module
 */

#define MM_STATUS_REG		(unsigned *)0xfffffffc

/*
 * MM_STATUS_REG fields:
 */

#define MM_BOARD_ID_MASK	0xff

/* set if board is stuffed with 4Mbit rams */

#define MM_4MBIT_RAM		0x400

/* 2 bits which specify how many quadrants of the board are stuffed */

#define MM_STUFFING_MASK	0x300

/* last check bits written to either array (n/a on a partial write) */

#define MM_LCBW_MASK		0x7f0000


/*
 * unshifted values for interpreting the MM_STUFFING_MASK
 */

#define MM_FULLY_STUFFED	0x300
#define MM_HALF_STUFFED		0x200
#define MM_QUARTER_STUFFED	0x100

/* number of bytes for different stuffing options, stuffed with 1Mbit chips */

#define MM_FULL_COUNT		0x2000000
#define MM_HALF_COUNT		0x1000000
#define MM_QUARTER_COUNT	0x0800000



/*
 * A long word read from this register will show the address at which
 * the last EDAC error occurred which has not yet had its interrupt
 * reset.
 *
 */

#define MM_ERR_ADDR_REG		(unsigned *)0xfffffff4



#define MM_ERR_INFO_REG		(unsigned *)0xffffffec

/*
 * MM_ERR_INFO_REG fields:
 */


/* single bit error (correctable) on array 0 */
#define MM_A0_SB_ERR		0x80000000		/* ACTIVE LOW */

/* mask syndrome for error on array 0 */
#define MM_A0_SYN_MASK		0x7f000000		/* ACTIVE LOW */

/* multiple bit error (uncorrectable) on array 0 */
#define MM_A0_MB_ERR		0x00800000		/* ACTIVE LOW */

/* error information for array 0 */
#define MM_A0_ERR_INFO_MASK	0x007f0000		/* ACTIVE LOW */


/* single bit error (correctable) on array 1 */
#define MM_A1_SB_ERR		0x00008000		/* ACTIVE LOW */

/* mask syndrome for error on array 1 */
#define MM_A1_SYN_MASK		0x00007f00		/* ACTIVE LOW */

/* multiple bit error (uncorrectable) on array 1 */
#define MM_A1_MB_ERR		0x00000080		/* ACTIVE LOW */

/* error information for array 1 */
#define MM_A1_ERR_INFO_MASK	0x0000007f		/* ACTIVE LOW */

/*
 * defines for dealing with the error information:
 */

#define MM_A0_SYN_SHIFT		24
#define MM_A1_SYN_SHIFT		8
#define MM_A0_ERR_INFO_SHIFT	16
#define MM_A1_ERR_INFO_SHIFT	0
/* picking active low bits out of right shifted error information */
#define MM_READ_ERROR		0x40
#define MM_READ_16_ERROR	0x20
#define MM_READ_32_ERROR	0x10

/* for use with these active low bits */
#define MM_ERROR		0

/* given the value from the mm_err_info_reg, pick out the syndrome */
#define GET_A0_SYNDROME(n)	~((n & MM_A0_SYN_MASK) >> MM_A0_SYN_SHIFT)
#define GET_A1_SYNDROME(n)	~((n & MM_A1_SYN_MASK) >> MM_A1_SYN_SHIFT)

#define GET_A0_ERR_INFO(n)	((n&MM_A0_ERR_INFO_MASK)>>MM_A0_ERR_INFO_SHIFT)
#define GET_A1_ERR_INFO(n)	((n&MM_A1_ERR_INFO_MASK)>>MM_A1_ERR_INFO_SHIFT)

/* return the slot bits from right shifted error information */
#define GET_SLOT_FROM_ERR_INFO(n)	(n & 0x3)


/*
 * the MM control register is readable only as a long word.
 *
 * it is BYTE WRITABLE ONLY.
 *
 */
#define MM_CONTROL_REG		(unsigned char *)0xffffffe4

/*
 * MM_CONTROL_REG fields:
 */

#define MM_RED_LED_OFF		0x40		/* ACTIVE LOW */
#define MM_GREEN_LED_OFF	0x20		/* ACTIVE LOW */
#define MM_ERR_INT_ENABLE	0x10
#define MM_EDAC_ENABLE		0x08
/* force parity errors */
#define MM_PARITY_ENABLE	0x04
/* enable check bit as data mode */
#define MM_CB_AS_DATA_ENABLE	0x02
/* enable diagnostic mode */
#define MM_DIAG_MODE_ENABLE	0x01


#define MM_INT_INFO_REG		(unsigned *)0xffffffc4

/*
 * MM_INT_INFO_REG fields:
 */


#define MM_INT_VECTOR_MASK	0xff000000
#define MM_INT_PRI_MASK		0x007f0000
#define MM_INT_SLOT_MASK	0x0000f000

/*
 * MM BUG here:
 * 	low order 12 bits of address to write interrupt to,
 * 	high order 20 are whatever happens to be programed into
 * 	the upper 20 of the int info reg.
 */
#define MM_INT_ADDR_MASK	0x00000fff


/* number of bits to shift a slot id to place it into the int_info_reg */
#define MM_INT_ID_SHIFT		12

/* shift to place a value in the vector byte of the int_info_reg */
#define MM_INT_VEC_SHIFT	24

#endif /* MM_H */
