#ifndef MISC_H
#define MISC_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) misc.h: version 25.1 created on 11/27/91 at 15:34:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)misc.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* misc.h */

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif

/*
 * SPM ID Number -- increment this for every SPM Runtime change
 */
#define SPM_ID_NUM	0x305

/******************************************************************************
 *
 * miscellaneous defines 
 *
 ******************************************************************************/
#define TRUE 		1
#define FALSE 		0
#define OFF_ARG		0	/* the *_ARG defines are for on_off() */
#define ON_ARG		1
#define NO_ARG		2
#define BAD_ARG		3
#define XOFF 		0x40
#define NULL 		0
#define BELL		0x07
#define ESCAPE 		0x1b  /* ascii ESCAPE character */
#define DELETE		0x7f
#define BACKSPACE 	0x08
#define CTRL_C		0x03
#define CTRL_Q		0x11
#define CTRL_R		0x12
#define CTRL_S		0x13
#define CTRL_T		0x14
#define CTRL_Z		0x1a
#define RETURN 		0x0d
#define LINEFEED	0x0a
#define SPACE		0x20

/* console defines */
#define CQSIZ 		16   	/* queue size for i/o characters */
#define CBUFSIZ 	80	/* command buffer size */

/* error queue defines */
#define ERROR_SIZE	128	/* size of error buffer */
#define CSS_ERROR	0
#define DISP_ERROR	1
	
#define BYTE 1
#define WORD 2
#define LWORD 4
#define MASK1	0x01
#define	MASK2	0x03
#define	MASK3	0x07
#define	MASK4	0x0f
#define	MASK5	0x1f
#define	MASK6	0x3f
#define	MASK7	0x7f
#define	MASK8	0xff

#define MAXARGS 16
#define MAXARGSIZE 32

#define STAMP_WIN_ON	10	/* timestamp window when on		*/
#define STAMP_WIN_OFF	~0	/* timestamp window when off		*/

/* misc flags used by wait_for_clear and friends */

#define SCC_XON		0x01	/* XON has been received		*/
#define SCC_XOFF	0x00	/* XOFF has been received		*/

/* other */

#ifndef NEL
#define NEL(x)		(sizeof(x) / sizeof(*x))
#endif

#ifndef MIN
#define MIN(a, b)	((a) > (b) ? (b) : (a))
#endif

#define ALIGN(adr, bnd)	(((uint)(adr) + (bnd) - 1) & ~((bnd) - 1))
#define BAD_UINT	(~(uint)0)	/* unsigned error value	*/

#define	UMOD_OFF	0	/* for load and boot routines */
#define	UMOD_ON		1

extern uint		iomap_save();

#endif /* MISC_H */
