#ifndef MENU_H
#define MENU_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) menu.h: version 25.1 created on 11/27/91 at 15:34:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)menu.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * menu.h
 */

#include "typedef.h"

/* This is to allow building the menu table, since the compiler is too
 * stupid to initialize a union.
 */

struct init_menu {
	char		*comm_text;
	char		*comm_desc;
	unsigned char	flags;
	unsigned char	lo_limit;
	unsigned char	hi_limit;
	PFI		procedure;
	char		*help;
};

struct menu {
	char		*comm_text;
	char		*comm_desc;
	unsigned char	flags;
	unsigned char	lo_limit;
	unsigned char	hi_limit;
	union {
		PFI		procedure;
		struct menu	*menu_p;
	} command;
	char		*help;
};

/* menu flags (comm_flags) */

#define MF_MENU		0x01		/* is a menu, not a command	*/
#define MF_EXPERT	0x04		/* display only in non-restriced mode */
#define MF_PREBOOT	0x08		/* display only before booting	*/
#define MF_POSTBOOT	0x10		/* display only after booting	*/

    /* Required menus */
extern struct menu *global_comm;
extern struct menu *runtime_boot_level;

#define MENUSTACKSIZE 16

struct mstack {
    struct menu *m_ptr;
    char *name;
};

extern struct mstack	menu_stack[];
extern int		menu_idx;

#endif /* MENU_H */
