#ifndef MEMSTRIPE_H
#define MEMSTRIPE_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) memstripe.h: version 25.1 created on 11/27/91 at 15:34:09	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)memstripe.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif

#ifndef SYS_SBUS_H
#include "sys/sbus.h"
#endif


typedef struct mem_stripe {
	uint	num_mm;
	uint	base_km;
#ifdef BARBER_POLE
	uint	pages_per_board;
#endif
	uint	mb_per_lpfn;
	uint	base_xpfn[SBUS_NUM_SLOT];	/* 020: spfn; 040: lpfn */
} MEM_STRIPE;

#define MM_NUM_SIZES	7	/* how many different sizes MMs come in
				 * 2, 4, 8, 16, 32, 64, 128
				 */

extern MEM_STRIPE	mem_stripe_tbl[MM_NUM_SIZES + 1];

extern uchar		mem_slots[SBUS_NUM_SLOT];
extern uint		mem_sizes[SBUS_NUM_SLOT];
extern uint		mem_mm_i[SBUS_NUM_SLOT];
extern uchar		did_mem_stripe;

#endif /* MEMSTRIPE_H */
