#ifndef LIMIT_H
#define LIMIT_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) limit.h: version 25.1 created on 11/27/91 at 15:34:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)limit.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* limit.h */

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif

/* OVER_LIMIT is true if val is on or beyond the limits (use N if negative) */
#define OVER_LIMIT(val, limp)	((val) <= (limp)->low || (val) >= (limp)->high)
#define OVER_N_LIMIT(val, limp)	((val) <= (limp)->high || (val) >= (limp)->low)

/*
 * structure for limiting a value somewhere between low and high
 */
typedef struct limit {
	uchar	low;
	uchar	high;
} limit_t;

#endif /* LIMIT_H */
