#ifndef IOSBA_H
#define IOSBA_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iosba.h: version 25.1 created on 11/27/91 at 15:33:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iosba.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* head/iosba.h */

#include "sys/types.h"

/**** IOSBA specific afifo register init values. ************************/

#define	FIFO_READ_WRITE		0x97	/* read/write flags, cleared by reset */
#define IN_PAR_GEN_DIS		0x80	/* input parity gen disabled  */
#define READYAB_SYNC		0x02	/*                            */

/**** IOSBA specific afifo control register addresses *******************/
/*									*/
/*	these registers are byte read-writable				*/
/*									*/
/************************************************************************/

#define	IOSBA_DL_CMD_AR	0xFFFFEB00	/* dl command fifo A reg(byte)	*/
#define	IOSBA_DL_CMD_BR	0xFFFFEB04	/* dl command fifo B reg(byte)	*/
#define	IOSBA_DL_RSP_AR	0xFFFFEB08	/* dl resp fifo A reg	(byte)	*/
#define	IOSBA_DL_RSP_BR	0xFFFFEB0C	/* dl resp fifo B reg	(byte)	*/
#define	IOSBA_UL_CMD_AR	0xFFFFEB10	/* ul command fifo A reg(byte)	*/
#define	IOSBA_UL_CMD_BR	0xFFFFEB14	/* ul command fifo B reg(byte)	*/
#define	IOSBA_UL_RSP_AR	0xFFFFEB18	/* ul resp fifo A reg	(byte)	*/
#define	IOSBA_UL_RSP_BR	0xFFFFEB1C	/* ul resp fifo B reg	(byte)	*/

#define	IOSBA_DL_CMD_AP	0xFFFFEB20	/* dl command fifo A ptr(byte)	*/
#define	IOSBA_DL_CMD_BP	0xFFFFEB24	/* dl command fifo B ptr(byte)	*/
#define	IOSBA_DL_RSP_AP	0xFFFFEB28	/* dl resp fifo A ptr	(byte)	*/
#define	IOSBA_DL_RSP_BP	0xFFFFEB2C	/* dl resp fifo B ptr	(byte)	*/
#define	IOSBA_UL_CMD_AP	0xFFFFEB30	/* ul command fifo A ptr(byte)	*/
#define	IOSBA_UL_CMD_BP	0xFFFFEB34	/* ul command fifo B ptr(byte)	*/
#define	IOSBA_UL_RSP_AP	0xFFFFEB38	/* ul resp fifo A ptr	(byte)	*/
#define	IOSBA_UL_RSP_BP	0xFFFFEB3C	/* ul resp fifo B ptr	(byte)	*/


/* IOSBA error status register. */

#define IOSBA_ERROR_REGISTER	0xffffe800

#define ERROR_RESET	0

#define	GTO_BIT		0x01
#define	XE_BIT		0x02
#define	BE_BIT		0x04
#define	DL_BIT		0x08
#define	DCSD_BIT	0x10
#define	UL_BIT		0x20
#define	UCSD_BIT	0x40
#define	EOI_BIT		0x80

/* IOSBA interrupt control register -- set with a disp_int_t (sys/sbus_spm.h) */

#define IOSBA_INTERRUPT_CTRL	0xffffe804

#define IOSBA_RESET_CNTL_REG_3	0xffffe900
#define IOSBA_MODE_CNTL_REG_3	0xffffe901

#define IOSBA_TRANSMIT_EN	0x04	/* Enables IOSBA output section. */
#define IOSBA_RECEIVE_EN	0x20	/* Enables IOSBA input section. */
#define IOSBA_INTERFACE_EN	(IOSBA_TRANSMIT_EN | IOSBA_RECEIVE_EN)

#define	IOSBA_READY_LED_ON	0xC0	/* Ready LED on, fault off. */
#define	IOSBA_BOTH_LEDS_OFF	0x40	/* Ready and fault LED's off. */

/* Writes through this address allow 'control write' command through the 
 * IOSBA.  This offset (0xffffe00X) where X is the subslot number gives
 * access to ios boards control registers.
 */
#define IOS_CNTL_REG_OFFSET	0xffffe000

#define IOS_BUS_MODULE_DIS	0x00  /* Deassert (disable) module enable. */
#define IOS_BUS_MODULE_EN	0x01  /* Assert (enable) module enable. */
#define IOS_BUS_INTERFACE_DIS	0x02  /* Deassert (disable) interface enable. */
#define IOS_BUS_INTERFACE_EN	0x03  /* Assert (enable) interface enable. */

#define IOSBA_PHYS_SLOT		0xffffea16

#endif /* IOSBA_H */
