#ifndef IOPM_DATA_H
#define IOPM_DATA_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iopm_data.h: version 25.1 created on 11/27/91 at 15:33:52	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iopm_data.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "cpu_method.h"
#include "slotdefs.h"

#ifndef SYS_IUNIT_H
#include "sys/iunit.h"
#endif

/* various iopm states. */
/* FIX THIS joe, how much of this do we want to broadcast. */
#define STATE_INIT	0	/* iopm reinit and hold, in effect disabled. */
#define STATE_LOADED	1	/* iopm has been downloaded. */
#define STATE_ENABLED	2	/* iopm go, go after reinit and hold */
#define STATE_STOPPED	3	/* iopm is stopped. */
#define STATE_RUNNING	4	/* iopm is running. */
#define STATE_DECONFIG	5	/* iopm decoupled from software. */
#define STATE_LOST	99	/* iopm is in an indeterminent state */

typedef	struct iopm_info {
	cpu_data_t	cpu_data;
	uint		state;
	uint		memsize;
	uint		entry;
	uint		at_brkpt;
	uint		offline_delay;	/* iopm's delay before dying. */
	uint		db_id;		/* iopm device-board id. */
	uint		iopm_comm_map;	/* saved iopm_comm mapping info */
	struct iopm_comm *iopm_comm_ptr;
} iopm_data_t;

#endif /* IOPM_DATA_H */
