#ifndef IOMAP_H
#define IOMAP_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomap.h: version 25.1 created on 11/27/91 at 15:33:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomap.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* iomap.h */

#define	UintBits	32	/* number of bits in a uint */

/* How mapper works on addresses */ 
#define	UnmappedBits	28	/* lower 28 bits don't get mapped */
#define	MapInBits	 3	/* next 3 bits get mapped */
#define	MapOutBits	 8	/* to 8 bits */

/* Layout of mapper register */
#define	MapOutShft	0	/* offset of MapOut in map register */


#define	IOMAP_SIZE	0x10000000 /* size of a mapped region */


#define	IO_MAPPER	((unchar *)SPM_IOMAP_BASE) /* array of map registers */
#define	IO_SPACE	((unsigned char *)0x80000000)	/* mapped region */
#define SPM_IOMAP_MANY	8
#define SPM_PIOMAP_MANY	7


#define	MyMap	0		/* map that iomap uses */

#define	AltMap	1		/* map that iomap uses */

#define	LowBits(nbits, value)	((value) & ((1 << (nbits)) - 1))
#define	HighBits(nbits, value)	((value) >> (nbits))

#endif /* IOMAP_H */
