#ifndef ERROR_H
#define ERROR_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) error.h: version 25.1 created on 11/27/91 at 15:33:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)error.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* error.h */

/* error queue defines */
#define ERROR_SIZE	128	/* size of error buffer */
#define CSS_ERR		0
#define DISP_ERR	1
#define	IOM_ERR		2
#define IOSBA_ERR	3
#define MEM_ERR		4
#define SPM_ERR		5

typedef struct error {
	uint	type;
	union error_u {
	    uint	disp_reg;
	    struct iom {
		uint	iom_slot;
		uint	err_reg;
	    } iom;	
	    struct iosba {
		uint	iom_slot;
		uint	iosba_error_reg;
	    } iosba;	
	    struct css {
		uint	err_reg;
		uint	status_reg;
	    } css;
	    struct mm {
		uint	slot;
		uint	addr_reg;
		uint	info_reg;
	    } mm;
	    struct spm {
		char *str;
	    } spm;
	    
	} data;
} error_t; 

extern uint	error_head, error_tail;

extern error_t	error[ERROR_SIZE];

#endif /* ERROR_H */
