#ifndef DPM40_TDB_H
#define DPM40_TDB_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dpm40_tdb.h: version 25.1 created on 11/27/91 at 15:33:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dpm40_tdb.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ifndef SLOTDEFS_H
#include "slotdefs.h"
#endif

typedef struct _pm40_info {
	/* methods must be first */
	cpu_data_t	cpu_data;	/* routines that change pm_info */
	uint		interrupt_addr;	/* hanna FIX: this is pattern to
					 * stick into dir_int command
					 */
	uint		pm_id;		/* its index into the list of pm's */
	uint		state;		/* state of this PM */
	uint		own;		/* own structure in kmem */
	uint		own_map;	/* saved map info to own structure */
	own_t		*own_ptr;	/* saved map info to own structure */
} pm40_info_t;

#define	STATE_INIT	0	/* Proms are in control */
#define	STATE_DECONFIG	1	/* Board has been disabled */
#define	STATE_LOADED	2	/* Program loaded in memory */
#define	STATE_START	3	/* PM started, but hasn't responded */
#define	STATE_RUNNING	4	/* Running kernel */
#define	STATE_STOPPED	5	/* Stopped or stopping in debugger */
#define	STATE_STOP_BRK	6	/* Stopped in debugger at breakpint */

/* flags for break points */
#define	BRK_INMEM	1	/* break point is active */
#define	BRK_TEMP	2	/* break point is temporary */


/* hanna FIX: explain, here why subslot definitions are awkward.
 * the fact that the hardware sees A=0 and B=1
 */
#define	BASE_PM_SUB_SLOT	NO_SUB_SLOT
#define	PMA_SUB_SLOT		BASE_PM_SUB_SLOT
#define	PMB_SUB_SLOT		0x01

#endif /* DPM40_TDB_H */
