#ifndef DPM40_IPCC_H
#define DPM40_IPCC_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dpm40_ipcc.h: version 25.1 created on 11/27/91 at 15:33:25	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dpm40_ipcc.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * dpm40_ipcc.h -- Interprocessor communication and control
 */

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif
#ifndef SBUS_PM_H
#include "sbus_pm.h"
#endif

#define IPCC_ADDR_SLOT (PM_CMD_MIN_BITS)

/* Comm data structure */

struct ipcc {
	ulong addr;
	ulong data;
	ulong count;
	ulong MMaddr;
	uchar slot;
	uchar size;
	uchar MMslot;
	uchar last_icmd;
	uchar last_ocmd;
	uchar stdout;
	uchar acck;
	uchar nack;
	uchar error;
	uchar cancel;
	uchar d_handle;
	uchar d_ack;
	uchar d_stats;
};


#define IPCC_ACK	(0x00)		/* Generic acknowledge         */
#define IPCC_NACK	(0x01)		/* Nope I won't do that        */
#define IPCC_ERROR	(0x02)		/* Report of error             */
#define IPCC_CANCEL	(0x03)		/* Cancel 		       */

#define IPCC_NOP	(0x10)		/* NOP, tests link,        ACK */
#define IPCC_SLOT	(0x11)		/* DATA is slot info,      ACK */
#define IPCC_ADDR	(0x12)		/* DATA is addr info,      ACK */
#define IPCC_DATA	(0x13)		/* DATA is data info,      ACK */
#define IPCC_SIZE	(0x14)		/* DATA is size info,      ACK */
#define IPCC_PACKET	(0x15)		/* DATA is packet info,    ACK */
#define IPCC_STDIO	(0x16)		/* DATA is stdio info,     ACK */
#define IPCC_FDATA	(0x17)		/* DATA is from data,      ACK */
#define IPCC_COUNT	(0x18)		/* DATA is count info,     ACK */

#define IPCC_WRITE	 (0x20)		/* Write data at DATA,     ACK */
#define IPCC_READ        (0x21)		/* Read from DATA to data, ACK */
#define IPCC_XTO_START   (0x22)		/* Start xfer to DATA,     ACK */
#define IPCC_XFROM_START (0x23)		/* Start xfer from DATA,       */
#define IPCC_XEND        (0x24)		/* End xfer,               ACK */
#define IPCC_EXECUTE     (0x25)		/* Execute at DATA             */
#define IPCC_NWRITE      (0x26)
#define IPCC_NREAD       (0x27)
#define IPCC_DSEND	 (0x28)		/* Send data back,	   ACK */

#define IPCC_STDOUT_ENA	 (0x30)
#define IPCC_STDOUT_DIS	 (0x31)
#define IPCC_DISP_ON	 (0x32)
#define IPCC_DISP_OFF	 (0x33)
#define IPCC_DISP_ACK	 (0x34)
#define IPCC_DISP_NOACK	 (0x35)
#define IPCC_MM_SLOT	 (0x36)
#define IPCC_MM_OFFSET	 (0x37)
#define IPCC_SM_SLOT	 (0x38)
#define IPCC_ID_ACCT_ON	 (0x39)
#define IPCC_ID_ACCT_OFF (0x3A)

#define IPCC_MM_FILL	(0x40)
#define IPCC_MM_VERIFY	(0x41)
#define IPCC_MM_TEST	(0x42)

#define IPCC_PM_KRP		(0x80)		/* with sending int ack */
#define IPCC_PM_NKRP	(0x81)		/* without sending int ack */

#define IPCC_SM_CLOCK	(0xA0)
#define IPCC_SM_CONFIG	(0xA1)
#define IPCC_SM_FLOPPY	(0xA2)
#define IPCC_SM_FACK	(0xA3)
#define IPCC_SM_PRINTF	(0xA4)

#endif /* IPCC_H */
