#ifndef DEV_H
#define DEV_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dev.h: version 25.1 created on 11/27/91 at 15:33:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dev.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ifndef SYS_TYPES_H
#include "sys/types.h"
#endif

#ifndef SYS_CSS_BD_DAT_H
#include "sys/css_bd_dat.h"
#endif

#ifndef SYS_IUNIT_H
#include "sys/iunit.h"
#endif


/*
 * defines for device types
 */

/* controller codes */
#define DV_IOPM		0x0100
/* #define	DV_EDT	0x0200	*/
/* #define DV_SCSI	0x0400	*/

/* device type codes */
#define DV_DK		0x01
#define DV_RV		0x02
#define DV_MT		0x04
#define DV_9T		0x08
#define DV_SLOT		0xfe		/* psuedo-device for slot only	*/

/* result codes */
#define DV_NO_DEV	0x00		/* malformed device string	*/
#define DV_HELP_REQUEST 0xff		/* for help call dev_help_message */

#define DV_TYPE_MASK	0x00ff
#define DV_CTRL_MASK	0xff00

/* complete device codes for devsw */
#define DV_IOPM_DK	(DV_IOPM | DV_DK)
#define DV_IOPM_RV	(DV_IOPM | DV_RV)
#define DV_IOPM_MT	(DV_IOPM | DV_MT)
#define DV_IOPM_9T	(DV_IOPM | DV_9T)


/*	iob.i_unit
 *         format: xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
 *		   css_slot sub_slot   pd #     ld_# 
 *
 *	controller number is used as an index into the dev_slot array.
 */
#define	I_UNIT_CSS_SLOT		0
#define	I_UNIT_SUB_SLOT		1
#define	I_UNIT_PD_NUM		2
#define	I_UNIT_LD_NUM		3
#define	I_UNIT_IOSLOT		4

#define	I_UNIT_NODEV		(~0)

#define	I_UNIT_CONTROLLER	0x10
#define	I_UNIT_DEV_NUM		0x11

#ifndef NO_SUB_SLOT
#define NO_SUB_SLOT		(0xff)
#endif

/* #define	RV_STRING		"rv" */
#define DEV_NAMLEN		80	/* length of a device name */
#define	MAX_DEV			64	/* maximum number of disk controllers */

typedef struct dev_slot {
	iunit_t	unit;
	ushort	dev_id;		/* DV_EDT, DV_SCSI, DV_IOPM, DV_??? */
} dev_slot_t; 

extern dev_slot_t	dev_slot[MAX_DEV];

#endif /* DEV_H */
