#if	!defined(CPU_METHOD_H)
#define	CPU_METHOD_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) cpu_method.h: version 25.1 created on 11/27/91 at 15:33:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)cpu_method.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "spm_tdb.h"

#ifndef SYS_IUNIT_H
#include "sys/iunit.h"
#endif

typedef struct cpu_methods {

	/* SPM PROVIDED SERVICES */
	void	(*check_printf)();	/* check for messages */
	uint	(*send_clock)();	/* send clock interrupt */

	/* OTHER ROUTINES CALLED ANYTIME */
	void	(*stop)();		/* stop, force to enter debugger */
	uint	(*check_tdb)();		/* check if cpu has stopped */

	/* BASIC CONTROL FUNCTIONS */
	void	(*display_slot)();	/* display what slot */
	uint	(*load)();		/* load executable to cpu */
	uint	(*check_coffdata)();	/* Make sure load addresses valid */
	uint	(*check_magic)();	/* Make sure code is valid */
	uint	(*prep_for_syms)();	/* prepare to load symbols to cpu */
	uint	(*load_syms)();		/* load symbols (if any) */
	void	(*set_pm_id)();		/* set pm id for each pm configured */
	uint	(*prep_boot)();		/* load all cpus needed to boot sys */
	void	(*start)();		/* start cpu going */
	uint	(*prepare_to_go)();	/* e.g. step over brkpt */
	void	(*go)();		/* exit debugger */ 

	uint	(*pm_first)();		/* return first CPU SNS */
	void	(*print_vtop)();	/* print virtual to physical xlation */
	uint	(*mem_stripe_init)();	/* init memory striping tables */
	void	(*build_page_table)();	/* build kernel virtual page tables */
	uint	(*get_u_addr)();	/* return u struct address */

	/* DEBUGGER PRIMITIVES */
	uint	(*get_byte)();		/* get byte from virtual address */
	void	(*put_byte)();		/* put byte from virtual address */

	uint	(*get_short)();		/* get short from virtual address */
	void	(*put_short)();		/* put short from virtual address */

	uint	(*get_long)();		/* get long from virtual address */
	void	(*put_long)();		/* put long from virtual address */

	uint	(*get_named_reg)();	/* get contents of named register */
	void	(*put_named_reg)();	/* put contents of named register */

	/* DEBUGGER MENU OPERATIONS */
	void	(*show_trap)();		/* display why it stopped */ 
	void	(*step)();		/* single step */
	void	(*jump)();		/* step over subroutine */
	uint	(*display_dis)();	/* display disassembled instructions */
	void	(*backtrace)();		/* backtrace */
	uint	(*valid_fp)();		/* is frame pointer valid */

	/* BREAKPOINT OPERATIONS */
	BRK_TAB	*(*find_bp)();		/* find breakpoint for dis */
	void	(*brkpt_check)();	/* check if hit breakpoint */
	void	(*set_brkpt)();		/* set one breakpoint */
	void	(*clear_one_brkpt)();	/* clear one breakpoint */
	void	(*clear_brkpts)();	/* clear all breakpoints */
	void	(*display_brkpts)();	/* display all breakpoints */

	/* MISC UNRELATED OPERATIONS */
	void	(*display_own)();	/* dispaly per cpu vars */
	unchar	*(*symbolic_version)();	/* generate symbolic version */
	void	(*check_tags)();	/* check cache consistency */
	void	(*solo)();		/* deconfigure all but current cpu */
	void	(*deconfigure)();	/* deconfigure current cpu */
	void	(*configure)();		/* configure current cpu */

	/* MISC MEMORY UTILITIES */
	uint	(*cpu_copyout)();	/* copy from source to cpu local mem */
	uint	(*cpu_copyin)();	/* copy from cpu local mem to source */
	uint	(*cpu_malloc)();	/* allocate cpu specific memory */
	uint	(*cpu_zero)();		/* clear cpu specific memory */
} method_t; 


/* MACROS USED TO INVOKE METHODS */

#define	CPU_check_printf()	(cpu_cur_method()->check_printf())
#define	CPU_send_clock(up_id)	(cpu_cur_method()->send_clock(up_id))
#define	CPU_stop()		(cpu_cur_method()->stop())

#define	CPU_match_slot(slot, subslot)	\
				(cpu_cur_method()->match_slot(slot, subslot))
#define	CPU_match_dbslot(s, ss)	(cpu_cur_method()->match_dbslot((s), (ss)))
#define	CPU_display_slot()	(cpu_cur_method()->display_slot())

#define	CPU_load(dev, u_flag)	(cpu_cur_method()->load((dev), (u_flag)))
#define	CPU_check_coffdata(ta)	(cpu_cur_method()->check_coffdata(ta))
#define	CPU_check_magic(ta)	(cpu_cur_method()->check_magic(ta))
#define	CPU_prep_syms(eb, et)	(cpu_cur_method()->prep_for_syms((eb), (et)))
#define	CPU_load_syms(ap, hdr)	(cpu_cur_method()->load_syms((ap), (hdr)))
#define	CPU_start()		(cpu_cur_method()->start())
#define	CPU_set_pm_id()		(cpu_cur_method()->set_pm_id())
#define	CPU_prep_boot(dev, u)	(cpu_cur_method()->prep_boot((dev), (u)))
#define	CPU_prepare_to_go()	(cpu_cur_method()->prepare_to_go())
#define	CPU_go()		(cpu_cur_method()->go())
#define	CPU_pm_first()		(cpu_cur_method()->pm_first())
#define	CPU_print_vtop(va, pr)	(cpu_cur_method()->print_vtop(va, pr))
#define	MAINCPU_mpfn_to_spfn(m)	(maincpu_mpfn_to_spfn(m))
#define	CPU_mem_stripe_init()	(cpu_cur_method()->mem_stripe_init())
#define	CPU_build_page_table()	(cpu_cur_method()->build_page_table())
#define	CPU_get_u_addr()	(cpu_cur_method()->get_u_addr())
#define	CPU_check_tdb()		(cpu_cur_method()->check_tdb())

#define	CPU_get_byte(addr)	(cpu_cur_method()->get_byte(addr))
#define	CPU_put_byte(addr, val)	(cpu_cur_method()->put_byte((addr), (val)))
#define	CPU_get_short(addr)	(cpu_cur_method()->get_short(addr))
#define	CPU_put_short(ad, val)	(cpu_cur_method()->put_short((ad), (val)))
#define	CPU_get_long(addr)	(cpu_cur_method()->get_long(addr))
#define	CPU_put_long(addr, val)	(cpu_cur_method()->put_long((addr), (val)))
#define	CPU_get_named_reg(name)	(cpu_cur_method()->get_named_reg(name))
#define	CPU_put_named_reg(n, v)	(cpu_cur_method()->put_named_reg((n), (v)))

#define	CPU_show_trap()		(cpu_cur_method()->show_trap())
#define	CPU_step()		(cpu_cur_method()->step())
#define	CPU_jump()		(cpu_cur_method()->jump())
#define	CPU_display_dis(addr)	(cpu_cur_method()->display_dis(addr))
#define	CPU_backtrace(addr)	(cpu_cur_method()->backtrace(addr))
#define	CPU_valid_fp(addr)	(cpu_cur_method()->valid_fp(addr))

#define	CPU_find_bp(addr)	(cpu_cur_method()->find_bp(addr))
#define	CPU_find_bp(addr)	(cpu_cur_method()->find_bp(addr))
#define	CPU_brkpt_check()	(cpu_cur_method()->brkpt_check())
#define	CPU_set_brkpt(addr)	(cpu_cur_method()->set_brkpt(addr))
#define	CPU_clear_one_brkpt(a)	(cpu_cur_method()->clear_one_brkpt(a))
#define	CPU_clear_brkpts()	(cpu_cur_method()->clear_brkpts())
#define	CPU_display_brkpts()	(cpu_cur_method()->display_brkpts())

#define	CPU_display_own()	(cpu_cur_method()->display_own())
#define	CPU_symbolic_version(a)	(cpu_cur_method()->symbolic_version(a))
#define	CPU_check_tags()	(cpu_cur_method()->check_tags())
#define	CPU_solo()		(cpu_cur_method()->solo())
#define	CPU_deconfigure()	(cpu_cur_method()->deconfigure())
#define	CPU_configure()	    	(cpu_cur_method()->configure())
#define	CPU_copyout(s, d, cnt)	(cpu_cur_method()->cpu_copyout((s), (d), (cnt)))
#define	CPU_copyin(s, d, cnt)	(cpu_cur_method()->cpu_copyin((s), (d), (cnt)))
#define	CPU_malloc(s, b)	(cpu_cur_method()->cpu_malloc((s), (b)))
#define	CPU_zero(addr, cnt)	(cpu_cur_method()->cpu_zero((addr), (cnt)))

/* all CPU driver data structures must start with this structure */

typedef struct cpu_data {
	method_t	*cd_methods;
	iunit_t		cd_unit;
} cpu_data_t;

/* if you name the cpu_data structure cpu_data, you can use these defines */
#define cu_methods	cpu_data.cd_methods
#define cu_unit		cpu_data.cd_unit

extern uint	(*maincpu_mpfn_to_spfn)(); /* convert kv pfn to system pfn */

extern cpu_data_t *cpu_get_cur();	/* returns current cpu_data	*/
extern method_t	*cpu_cur_method();	/* returns pointer to methods	*/
extern uint	cpu_set_slot();		/* set new slot[/subslot]	*/
extern void	cpu_enroll();		/* enroll new CPU		*/
extern void	cpu_all_stop();		/* stop all CPUs		*/

#endif	/* CPU_METHOD_H */
