#ifndef HEAD_COFF_HDR_H
#define HEAD_COFF_HDR_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) coff_hdr.h: version 25.1 created on 11/27/91 at 15:33:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)coff_hdr.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * coff_hdr.h -- structure of File information extracted from COFF header.
 */

typedef struct coff_hdr_data {
	uint	nsyms;		/* Number of symbol table entries. */
	int	nscns;		/* Number of sections. */
	uint	sec_size;	/* Number of bytes of section's extra data. */

	uint	tsize;		/* Size in bytes of 'text' section. */
	uint	dsize;		/* Size in bytes of 'data' section. */
	uint	bsize;		/* Size in bytes of 'bss' section. */

	unchar 	*text_start;	/* Download text TO this address. */
	unchar 	*data_start;	/* Download data TO this address. */
	unchar 	*bss_start;	/* ALLOCATE from this address.... */
				/* ....to bss_end for the 'bss'.  */

	uint	entry;		/* Jump to this point at boot time. */

	uint 	fp_text;	/* Download text FROM this address. */
	uint 	fp_data;	/* Download data FROM this address. */
	ushort	vstamp;		/* version stamp		    */
} coff_hdr_data_t;

#endif /* HEAD_COFF_HDR_H */
