/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tp.c: version 25.1 created on 11/27/91 at 15:32:32	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "global.h"
#include "misc.h"
#include "saio.h"
#include "sa_dir.h"
#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "spm_debug.h"
#include "sys/ioctl.h"

#include "scsi_error.h"
#include "stp_cdb.h"
#include "dsdb_macro.h"
#include "req_box.h"
#include "dev.h"




#define FRDWR		(F_READ | F_WRITE)

#define TM_EOM		1
#define TM_FM		2

#define TAPE_BSIZE		512
#define FIVE_SECS	5

#define	GET_BLK_CNT(x)	((x) >> 9)
#define NOT_ON_BLK_BOUNDARY(x)	((x)&0x1FF)
#define	GET_SPACE_CODE(x)	(((x)>>8)&0x03)
#define	GET_SPACE_COUNT(x)	((x)&0xFF)

#define	BASIC_TIME_SLICE	(30*HZ+1)
#define	UNIT_TIME_SLICE		(20*HZ+1)
#define	REWIND_TIME_SLICE	(5*60*HZ+1)
#define SKIP_TIME_SLICE		(20*60*HZ+1)
#define RDWR_TIME_SLICE		(HZ/50+1)	/* 1k data */
#define BUSY_TIME_SLICE		(HZ+1)

static REQ_BOX	cmb;

extern char	*scsi_sns_msg(), *scsi_err_msg();

static ushort	dev_flags;
static uint	dev;
static uint	scsi_lockflg = 0;


/* 
   This function gets the io structure information from the open
   module in SYS.c. It then uses the functions in the prom code
   to perform the actual tape operations
*/

itopen(io) 
iob_t	*io; 
{
	unchar	*wp_ptr;

	extern char 	*gs_str();

	dev = io->i_unit.i;

	if((io->i_flgs & FRDWR) == FRDWR) {
		printf("it: open flags is not accepted by tape drive\n");
		return(-1);
	}

	if (dbug)
		printf("itopen: 0x%08x\n", io->i_unit);

	if (!check_ios_bd(io->i_unit, "itopen"))
		return(-1);	/* Return if access to non-valid board. */

	if (scsi_lockflg) {
		printf("scsi_lockflg set for unit number %08x\n", dev);
		return(-1);
	}

	io->i_ma = (char *)xtra_block;

	if (itstart(io, CDB_REQUEST_SENSE<<24) == -1)
		return(-1);

	/* inquiry drive data */
	if (itstart(io, CDB_INQUIRY<<24) == -1)
		return(-1);	 

	/* check device type */
	if (*(uchar *)xtra_block != SA_DEV) {
		display_msg(io->i_unit, "not a tape device");
		return(-1);	 
	}

	/* check if drive is ready */
	if(itstart(io,CDB_TEST_UNIT_READY<<24) == -1)
		return(-1);	 

	if(itstart(io,CDB_MODE_SENSE<<24) == -1)
		return(-1);

	wp_ptr = (unchar *)xtra_block + 2;

	if ((*wp_ptr & 0x80) && (io->i_flgs & F_WRITE)) {
		display_msg(io->i_unit, "write protected");
		return(-1);	 
	}

	if(dbug)
		printf("itopen: rewinding tape\n");

	if(itstart(io,CDB_REWIND<<24) == -1)
		return(-1);

	if(itstart(io,CDB_LOAD<<24|LD) == -1)
		return(-1);

/* tmp comment out for DAT
	if(itstart(io,CDB_MODE_SELECT<<24) == -1)
		return(-1);
*/
	if(itstart(io,CDB_MEDIUM_REMOVAL<<24|PREVENT) == -1)
		return(-1);

	dev_flags = 0;

	return(0);

}

itclose(io)
iob_t	*io;
{
	if (dbug)
		printf("mtclose: io = %#x, unit=0x%08x\n", io, io->i_unit);

	dev = io->i_unit.i;
	if (io->i_flgs & F_WRITE)
		(void) itstart(io, CDB_WRITE_FILEMARKS << 24 | 2);
	(void) itstart(io, CDB_REWIND << 24);
	(void) itstart(io, CDB_MEDIUM_REMOVAL << 24 | ALLOW);
	scsi_lockflg = 0;
	
}

itcommand(command, device)
int	command;
iunit_t	device;
{
	register iob_t	*itbuf = &iob[NFILES];
	int		cmd;

	if(dbug)
		printf("itcommand: itbuf = %x\n", itbuf);

	itbuf->i_unit = device;
	itbuf->i_cc = BSIZE;
	itbuf->i_bn = command;
	switch(command) {
	case REWIND:
		cmd = CDB_REWIND << 24;
		break;
	case TAPESTAT:
		cmd = CDB_TEST_UNIT_READY << 24;
		break;
	case REOF:
		cmd = (CDB_SPACE << 24 | S_FMK << 8 | 1);
		break;
	default:
		printf("itcommand does not support %x\n", command);
		return(-1);
	}
		
	return(itstart(itbuf,cmd));
}
/*
    This function takes the read or write operation along with the
    information in the io structure and passes them on to the
    rtbcom module which keeps track of any errors, location on the
    tape, block count, and performs the necessary operation.
*/
static itstart(io, cmd)
register iob_t	*io;
int		cmd;
{
	register struct g0_cdb	*cdb;
	unchar			opcode;
	uint			blklen;
     	struct blk_dscptr	*dsp;
	struct mode_head	*mh;

	/* clear out the command mailbox */
	bzero(&cmb,sizeof (REQ_BOX));

	cmb.unit = io->i_unit;
	cmb.mem = (unchar *)io->i_ma;
	opcode = cmd>>24;
	/* format command descriptor box and command mailbox	*/
if(dbug)
	printf("tp: itstart with opcode = %x, and io = %x\n",opcode,io);
	cdb = (struct g0_cdb *)cmb.cmd_dsc_blk;
	switch(opcode){
	/* category scsi command to different group */
		case CDB_READ:
			if(dev_flags  & TM_FM){
				dev_flags &= ~TM_FM;
				cmb.resid = io->i_cc;
				return(0);
			} else
				cmb.xfer_flag = SCSI_DATA_IN;
				goto common_rw;
		case CDB_WRITE:
			if(dev_flags & TM_EOM){
				cmb.resid = io->i_cc;
				return(0);
			}
			cmb.xfer_flag = SCSI_DATA_OUT;
common_rw:			
		/* setup xfer length */	
			cdb->lun_flags =FIXED;
			blklen = GET_BLK_CNT(io->i_cc);
			if (NOT_ON_BLK_BOUNDARY(io->i_cc)) {
				display_msg(io->i_unit,
				  "block length is wrong");
				return(-1);
			}
			ITOC3(cdb->xfer_len_msb, cdb->xfer_len, cdb->xfer_len_lsb, blklen);
			cmb.timer = RDWR_TIME_SLICE * blklen + BASIC_TIME_SLICE;
			cmb.xfer_len = io->i_cc;
			goto setop;

		case CDB_MODE_SENSE:
			cdb->alloc_len = TAPE_SENSE_DATA_LEN;
			cmb.xfer_len = TAPE_SENSE_DATA_LEN;
			cmb.xfer_flag = SCSI_DATA_IN;
			cmb.timer = BASIC_TIME_SLICE;
			goto setop;	
		case CDB_MODE_SELECT:
			mh = (struct mode_head *)io->i_cc;
			mh->sd_len = 0;
			mh->med_type = 0;
			mh->wp_bm_speed = 0;
			mh->dscptr_len = DSCPTR_LEN;
			dsp = (struct blk_dscptr *)(io->i_cc+MODEHEAD_LEN);
			dsp->density = 0;
			ITOC3(dsp->numblk_msb, dsp->numblk, dsp->numblk_lsb,0);
			ITOC3(dsp->blk_len_msb, dsp->blk_len, dsp->blk_len_lsb,
				TAPE_BSIZE);
			dsp->pad = 0;
			cdb->alloc_len = TAPE_SENSE_DATA_LEN;
			cmb.xfer_len = TAPE_SENSE_DATA_LEN;
			cmb.xfer_flag = SCSI_DATA_OUT;
			cmb.timer = (uint )BASIC_TIME_SLICE;
			goto setop;	
		case CDB_REQUEST_SENSE:
		case CDB_INQUIRY:
			cmb.timer = (uint )BASIC_TIME_SLICE;
			cdb->alloc_len = INQUIRY_LEN;
			cmb.xfer_len = INQUIRY_LEN;
			cmb.xfer_flag = SCSI_DATA_IN;
			goto setop;
 		case CDB_SPACE: 	
			cdb->lun_flags = GET_SPACE_CODE(cmd);
			cdb->count_lsb = GET_SPACE_COUNT(cmd);
			cmb.timer = (uint )SKIP_TIME_SLICE;
			if(cdb->count_lsb & 0x80){
			/* sign bit propergatation */
				cdb->count = 0xFF;
				cdb->count_msb = 0xFF;
			}
			goto setop;
		case CDB_LOAD:
			cdb->reten_load = cmd; /* get load/unload mark */

		case CDB_ERASE:
		case CDB_REWIND:
			cmb.timer = (uint)REWIND_TIME_SLICE;
			goto setop;
 		case CDB_WRITE_FILEMARKS:
			cdb->alloc_len = cmd; /* get number of filemark to write */
			cmb.timer = (uint)BASIC_TIME_SLICE;
			goto setop;
		case CDB_MEDIUM_REMOVAL:
			cdb->prvnt = cmd;
		case CDB_READ_BLKLI:
		case CDB_TEST_UNIT_READY:
			cmb.timer = (uint)BASIC_TIME_SLICE;
setop:			cdb->opcode = opcode;
			cdb->ctl = 0;
			cmb.cmd_dsc_len = G0SIZE;
			break;
		default:
			/* unknown command */
			panic("\nstpxstart: unknown scsi command :%x", opcode);
	}
       	scsi_send_cmd(&cmb);
	return(itdone(&cmb));
}

static itdone(cm)
REQ_BOX *cm;
{
	EX_SENSE_DATA *sns;
	ushort	status;


	status = cm->err_code;

	sns = (EX_SENSE_DATA *)cm->error;

	if(dbug)
		printf("itdone: retcode = %x\n", status);
	if (cm->err_code == SCSIERR_NODEV) {
		retry_no_dev(cm);
		status = cm->err_code;
	}
	if (cm->err_code == SCSIERR_BUSY) {
		retry_busy(cm);
		status = cm->err_code;
	}
	if(cm->err_code == SCSIERR_SENSE) {
	/* if it just get warning message */
		if(sns->sense_key & FMD)
		/* if it is file mark detected warning */
			dev_flags |= TM_FM;
		if(sns->sense_key & EOMD)
			dev_flags |= TM_EOM;
		
		switch ( cm->cmd_dsc_blk[0] ){

		case CDB_READ:
                        if (sns->sense_key & (FMD|ILI))
				status = 0;
			break;
			
		case CDB_WRITE:
			if (sns->sense_key & EOMD)
				status = 0;
			break;

		case CDB_WRITE_FILEMARKS:

			if (( sns->sense_key& FMD) || (sns->sense_key & EOMD))
				status =0;
			break;

		case CDB_SPACE:

			if(sns->sense_key & FMD) 
				status = 0;
			break;

		case CDB_REWIND:

			if( sns->sense_key & EOMD)
				status = 0;
			break;

		} /* end of switch of command */
	}

	if ((sns->sense_key == SNSKEY_UNIT_ATTN) && (cm->cmd_dsc_blk[0] == ERASE))
		status = 0;

	/* Show error message */
	if (status != 0) {
		if (dev_flags & TM_FM)
			display_msg(cm->unit, "file mark detected");
		if (dev_flags & TM_EOM)
			display_msg(cm->unit, "end of tape detected");
		if(sns->sense_key & ILI)
			display_msg(cm->unit, "illegal length detected");
		if ( cm->err_code == SCSIERR_SENSE)
			set_sense_error(cm);
		else
			set_scsi_err(cm);
			
		return(-1);
	}
	return(0);
} /* end of itdone */
		

static
set_sense_error(cm)
REQ_BOX *cm;
{
	EX_SENSE_DATA *sd;

	sd = (EX_SENSE_DATA *)cm->error;
	
	display_header(cm->unit);
	if ((sd->err_class & ERR_CLASS_MASK) != ANSI_CLASS )
		printf(" vendor unique error\n");
	else {
		printf(" %s", scsi_sns_msg(sd->sense_key)); /* display error message */
		printf(".\n");
		display_sense(sd);	
	}
	return(0);
}

static
set_scsi_err(cm)
REQ_BOX *cm;
{
	display_header(cm->unit);
	printf("%s", scsi_err_msg(cm->err_code)); /* display error message */
	printf(".\n");
	
}

static
display_sense(sd)
EX_SENSE_DATA	*sd;
{
	if (sd->err_class & INFO_VALID)
	    printf("at logical block address %x(h),",
	     CAT4(sd->info_msb,sd->info_2,sd->info_1,sd->info_lsb));
	if( sd->xsense_len ){
		    printf(" with extension error code %x",sd->err_code);
	}
						
	
	if(sd->flags & FPV){
		    printf(",at field(byte) pointer %x" , 
			CAT2(sd->field_hi, sd->field_lo));
		    if(sd->flags & BPV)
		   	printf(", on bit %x", sd->flags & BIT_POINTER_MASK);
		    if(sd->flags & CDBIT)
		    	printf(" of CDB");
		    else
			printf(" of data");
	}
}

itstrategy(io, func)
register iob_t	*io;
int		func;
{
	int cmd;

	if(dbug)
		printf("itstrategy\n");

	if(func == READ)
		cmd = CDB_READ<<24;
	else
	if(func == WRITE)
		cmd = CDB_WRITE<<24;
	else
		cmd = (func << 24);
	(void) itstart(io,cmd);

	if(dbug)
		printf("itstrategy: resid = %x\n", cmb.resid);
	
	return(io->i_cc - cmb.resid);
	
}


itioctl(unit, cmd, addr)
iunit_t	unit;
int	cmd;
uint	addr;
{
	switch (cmd) {
		case REOF:
		case TAPESTAT:
		case REWIND:
			return(itcommand(cmd, unit));
		default:
			printf("itioctl: invalid command\n");
			return(-1);
	}
}

static
retry_busy(cm)
REQ_BOX *cm;
{
	int retry_cnt = 10;
	/* retry the  command every 5 secs */
	while (retry_cnt--) {
		cm->err_code = 0;
		cm->err_len = 0;
		cm->act = 0;
		cm->resid = 0;
		wait_5_secs();
		scsi_send_cmd(cm);
		if (cm->err_code != SCSIERR_BUSY)
			return;
	}
}
	
static
retry_no_dev(cm)
REQ_BOX *cm;
{
	int retry_cnt = 1;
	/* retry the  command every 5 secs */
	while (retry_cnt--) {
		cm->err_code = 0;
		cm->err_len = 0;
		cm->act = 0;
		cm->resid = 0;
		wait_5_secs();
		scsi_send_cmd(cm);
		if (cm->err_code != SCSIERR_BUSY)
			return;
	}
}
extern	uint	n_seconds;
static
wait_5_secs()
{
	uint time_stamp = n_seconds;
	while (n_seconds - time_stamp < FIVE_SECS);
}
