/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sdk_cdb.h: version 25.1 created on 11/27/91 at 15:32:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sdk_cdb.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/************************************************
*						*
*	cdb definition for direct device 	*
*						*
************************************************/

#include "cdb.h"

/************************************************
	cdb command code definitons
************************************************/


#define CDB_REZERO		0x01
#define CDB_FORMAT_UNIT		0x04
#define	CDB_REASSIGN		0x07
#define CDB_SEEK_G0		0x0B
#define	CDB_START_STOP		0x1B
#define CDB_READ_CAPACITY	0x25
#define CDB_READ_EXTENDED	0x28
#define	CDB_SEEK_G1		0x2B
#define CDB_WRITE_EXTENDED  	0x2A
#define	CDB_WRVFY		0x2E
#define	CDB_VERIFY		0x2F
#define	CDB_SEARCH_HI		0x30
#define	CDB_SEARCH_EQ	 	0x31
#define	CDB_SEARCH_LO		0x32
#define	CDB_SET_LIMITS		0x33
#define	CDB_READ_DEFECT		0x37
#define	CDB_WRITE_BUFFER	0x3B
#define	CDB_READ_BUFFER		0x3C


/***************************************
	cdb structure definitions
****************************************/

/*
 *	format unit
*/
#define	interleave_msb cdp1
#define interleave_lsb cdp2

/* flags definitions */

#define	FORMAT_DATA	0x10
#define CMP_LIST	0x08
#define DEFECT_FMT	0x07


/*
 *	read/write
*/
#define lbaddr_msb	lun_flags	
#define lbaddr		cdp0		
#define lbaddr_lsb	cdp1		
#define xfer_len	cdp2

/*
 * 	mode sense
*/

struct disk_mode_data {
	struct mode_head  mh;
	struct blk_dscptr bdp; 
};
#define	page_flags	cdp0

/* definition of page code	*/
#define	PAGE01	0x01	/* error recovery parameters */
#define PAGE02	0x02	/* Disconnect/Reconnect Control paramters */
#define PAGE03	0x03	/* Format parameters	*/
#define PAGE04	0x04	/* Rigid Disk Drive Geometry parameters	*/
#define	PAGEALL	0x3F	/* return all supported paged	*/

#define	PG_PF	0x80	/* standard page format		*/
#define PG_SP	0x01	/* save current page value except pg 3,4,5 */

/* definition of Page Control Field	*/
#define	CURRENT	0x00	/* return current values	*/
#define CHANGE	0x40	/* return changeable values	*/
#define DEFAULT 0x80	/* return default values	*/
#define SAVED	0xC0	/* return saved values		*/

struct page_hd {
	unchar	code;	/* page code */
	unchar	len;	/* size of page	*/
};
#define	PGHD_LEN	sizeof(struct page_hd)


/* page 1 -- error recovery parameters lists	*/
struct page_01 {
	unchar	err_flags;
	unchar	retry_cnt;
	unchar	correction;
	unchar	hd_offset;
	unchar	strobe;
	unchar	time_limit;
};
#define PAGE01_LEN 	sizeof(struct page_01)
/* definition of err_flags */
#define	AWRE	0x80	/* automatic write reallocation	*/
#define	ARRE	0x40	/* automatic read reallocation	*/
#define	TB	0x20	/* the failing data block transfer */
#define RC	0x10	/* read continuous	*/
#define EEC	0x08	/* enable early correction */
#define	PER	0x04	/* post error		*/
#define	DTE	0x02	/* disable transfer on error	*/
#define	DCR	0x01    /* disable correction		*/

struct	page_03 {
	unchar	tpz_msb;	/* track per zone */
	unchar	tpz_lsb;	
	unchar	aspz_msb;	/* alternate sectors per zone */
	unchar	aspz_lsb;
	unchar	atpz_msb;	/* alternate track per zone	*/
	unchar	atpz_lsb;
	unchar	alttk_msb;	/* alternate tracks	*/
	unchar	alttk_lsb;	
	unchar	spt_msb;	/* sector per track	*/
	unchar	spt_lsb;	
	unchar	bps_msb;	/* byte per sector	*/
	unchar	bps_lsb;	
	unchar	intrlv_msb;	/* interleave	*/
	unchar	intrlv_lsb;	
	unchar	tksf_msb;	/* track skew factor	*/
	unchar	tksf_lsb;		
	unchar	cylnsf_msb;	/* cylinder skew factor		*/
	unchar	cylnsf_lsb;
	unchar	flags;		/* characteristic flag 	*/
	unchar  pad[3];
};
#define PAGE03_LEN 	sizeof(struct page_03)

/* definition of flags in page 3	*/
#define	SSEC	0x80	/* soft  sector formatting	*/
#define	HSEC	0x40	/* hard sector formatting	*/
#define	RMB	0x20	/* removable media	*/
#define SURF	0x10	/* allocating surface first */
#define INS	0x08	/* inhibit save		*/

struct	page_04 {
	unchar	cylns_msb;	/* number of cylinders	*/
	unchar	cylns;		
	unchar	cylns_lsb;	
	unchar	heads;		/* number of heads */
	unchar  reserved[6];
	unchar	sprate_msb;	/* drive step rate	*/
	unchar	sprate_lsb;
	unchar	pad[6];		
};
#define PAGE04_LEN	sizeof( struct page_04)


struct IBM_pg0 {
	struct page_hd ph;
	unchar qpe_flag;
};
#define IBM_PG0_SIZE 3

#define	QPE	0x80	/* quality post error */

struct IBM_pg1 {
	struct page_hd ph;
	unchar	err_flags;
};
#define IBM_PG1_SIZE	3

struct IBM_pg2 {
	struct page_hd ph;
	unchar rbf_ratio;
	unchar wbe_ratio;
};
#define IBM_PG2_SIZE	4

struct IBM_pg7 {
	struct page_hd ph;
	unchar verify_flags;
};
#define IBM_PG7_SIZE	3

struct IBM_pg8 {
	struct page_hd ph;
	unchar rcd_flag;
};
#define IBM_PG8_SIZE	3

#define	RCD	0x01


/* 
 *	read extended / write extended 
*/
#define lbadr_msb	g1cdp0
#define lbadr_2		g1cdp1
#define lbadr_1		g1cdp2
#define lbadr_lsb	g1cdp3
#define xferlen_msb	g1cdp4
#define xferlen_lsb	g1cdp5

/*
 * 	start stop unit
*/
#define	start_flags	cdp2

#define START_BIT	0x01
/*
 * 	read capacity
*/

#define calba_msb	g1cdp0
#define calba_2		g1cdp1
#define calba_1		g1cdp2
#define calba_lsb	g1cdp3
#define ca_pmi		g1cdp5

#define PMI	0x01	/* partial media indicator */

struct capacity {
	unchar	lba_msb;
	unchar	lba_2;
	unchar	lba_1;
	unchar	lba_lsb;
	unchar	bl_msb;
	unchar  bl_2;
	unchar  bl_1;
	unchar  bl_lsb;
};
#define CA_DATA_SIZE sizeof(struct capacity)

