/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_drv.h: version 25.1 created on 11/27/91 at 15:31:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_drv.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifndef DSDB_SCSI_DRV_H
#define DSDB_SCSI_DRV_H

#ifndef SYS_IUNIT_H
#include "sys/iunit.h"
#endif

#define	ESPWREG(x,y)	(esp->un.w.x = y) /* write to ncr register */
#define ESPRREG(x,y)  (y = (esp->un.r.x)) /* read ncr register */
#define	ESPCMD(x)	ESPWREG(cmd,x)	  /* send ncr command */
#define SETFIFO(x)	ESPWREG(fifo,(x)) /* fill one byte in ncr fifo */
#define GETFIFO(x)	ESPRREG(fifo,(x)) /* read one byte from ncr fifo */

#define	BCR_A	&extr->un.w.bcr[0]  /* dsdb channel 0 command register */
#define BCR_B	&extr->un.w.bcr[1]  /* dsdb channel 1 command register */

#define	GET_SCSI_PHASE(status)	((status) & 0x07)  /* get scsi phase from 
							status register */
#define GET_CHAN_ID(unit_id)	(((unit_id) & 0x08) >> 3) /* get chennel id from
						       unit id */
#define GET_BUS_ID(unit_id)	((unit_id) & 0x07) /* get bus id from unit id */


#define SET_SPM_ADDR(x)	(mapped_iopm + ((x) - IOPM_DB_BASE)) /* convert
					iopm base address to spm base address */

/* set deivce board register address for the spm point of view	*/
#define ENABLE_DEV	0x6000
#define	MAXNOBDS	2 /* max number of iopm scsi boards */
#define MAXNOCHANS	2  /* no of channels per board */
#define INITIATOR_ID	0x07 	/* initiator ID number */

#define TRGT_GOOD		0x00	/* good condition */
#define TRGT_CHECK_CON		0x02	/* Any error,REQUEST SENSE condition
					   should be issued */
#define TRGT_CON_MET		0x04	/* The search data commands shall return
					   this status whenever a search con-
					   dition is satisfied */
#define TRGT_BUSY		0x08	/* Target is busy	*/
#define TRGT_INTERM		0x10    /* intermediate command response */
#define TRGT_RESERVE		0x18	/* logical unit conflict	*/

#define CCF	 	4 	   /* clock convert factor */
#define SEL_TIMEOUT	250000000/(8192*200)   /* select timeout 250 ms  */
#define REQUEST_TIME_SLICE (HZ/20+1)	/* request sense time out */
#define	BUS_RESET_DELAY	(HZ+1)	/* 1 secs delay after bus reset */
#define	RESET_CHIP_DELAY  5		/* 5 ms delay after chip reset */


#define SEQ_NO_DEVICE		0x0020	/* selection timeout */
#define SEQ_NO_MSGOUT		0x0018	/* no message out phase */
#define SEQ_NO_CMMD		0x0218	/* no command phase	*/
#define SEQ_PREMATURE		0x0318	/* command phase change premature */
#define SEQ_COMPLETE		0x0418	/* complete command phase	*/

typedef struct chan {
	uint	bcr_cmd;
	uint	bus_status;
} chan_t;

/* bus_status definitions */
#define	CONNECT_INITED	0x01 /* scsi bus connection has been determined */
#define ST_BUS_RESET	0x02 /* bus has been reset */

typedef struct iopm_dsdb {
	iunit_t	unit;
	uint	last_acc_time; 	/* last time this board has been access */
	chan_t 	chan_table[MAXNOCHANS];
} iopm_dsdb_t;

#endif /* DSDB_SCSI_DRV_H */
