/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_drv.c: version 25.1 created on 11/27/91 at 15:31:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_drv.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_drv.c -- low level dsdb spm driver */

#include "global.h"
#include "iomap.h"
#include "sys/param.h"
#include "sys/types.h"
#include "sys/sbus_iopm.h"
#include "sys/debug.h"
#include "sys/iunit.h"

#include "scsi_ncr.h"
#include "scsi_db.h"
#include "req_box.h"
#include "cdb.h"
#include "scsi_error.h"
#include "scsi_msgs.h"
#include "scsi_drv.h"

static struct iopm_dsdb dsdb_table[MAXNOBDS];
static SCSI_DB_REGS *extr;
static uint *bsr;
static uint *bcr;
static SCSI_R	*esp;
static REQ_BOX rqcmd;
static uint	save_map_regs, mapped_iopm;
static unchar	int_step, status, int_status;
static uchar	did_dsdb_init;
static uint	start_time;

chan_t	*get_chan();

extern uchar	*sio_map();

scsi_send_cmd(cm)
register REQ_BOX	*cm;
{
	chan_t	*ch;
	uint	err;

	if (!did_dsdb_init)
		init_dsdb_table();
		
	clear_err_status(cm);

	save_map_regs = iomap_save();
	mapped_iopm = (uint)sio_map(cm->unit, IOPM_DB_BASE);
	extr = (SCSI_DB_REGS *)SET_SPM_ADDR(DB_CONTROL);

	bsr = &(extr->un.r.bsr);
	ch = get_chan(cm->unit);

	if (GET_BUS_ID(cm->unit.s.phys) == INITIATOR_ID){
		cm->err_code = SCSIERR_UNIT_ID;
		iomap_restore(save_map_regs);
		return;
	}
	cm->resid = cm->xfer_len;
	start_time = int_counter;
	if ((err = issue_cmd(ch, cm)) != 0)
		set_err(cm, err);
	cm->act = int_counter - start_time;
	iomap_restore(save_map_regs);
}


static
issue_cmd(ch, cm)
struct chan *ch;
REQ_BOX	*cm;
{
	uint	err = 0;

	if (ch->bus_status & CONNECT_INITED)
		err = send_cdb_cmd(cm);
	else
	        err = first_time_send_cdb(ch, cm);
	
	if (err != 0)
		return(err);
			
	if ((err = xfer_info(cm)) == SCSIERR_SENSE) {
		if (request_sense(cm) != 0)
			return(SCSIERR_FATAL);
	}
	return(err);
}

static first_time_send_cdb(ch, cm)
struct	chan *ch;
REQ_BOX	*cm;
{
	uint ret_value;

	init_chan(ch, BCR_SINGLE); /* set differential mode */
	if ((ret_value = send_cdb_cmd(cm)) != SCSIERR_NODEV) {
		ch->bus_status |= CONNECT_INITED;
		return(ret_value);
	}
	ch->bus_status &= ~ST_BUS_RESET;
	init_chan(ch, BCR_DIFF);	/* set single ended mode */
	if ( (ret_value = send_cdb_cmd(cm)) != SCSIERR_NODEV) 
		ch->bus_status |= CONNECT_INITED;
	else {
		/* to make sure the bus is clear */
		ch->bus_status &= ~ST_BUS_RESET;
		init_chan(ch, BCR_SINGLE);
	}
	return(ret_value);
}

set_err(cm, err)
REQ_BOX *cm;
uint	err;
{
	switch (cm->err_code = err) {
		case SCSIERR_XFER_FLAG:
		case SCSIERR_INTERR:
		case SCSIERR_UXPCTMSG:
		case SCSIERR_PHASE:
		case SCSIERR_ILLESP:
		case SCSIERR_DMACNT:
		case SCSIERR_CMDTIMEOUT:
		case SCSIERR_FATAL:
			reset_bus();
			break;
		default:
			break;
	}
}

static request_sense(cm)
REQ_BOX	*cm;
{
	uint	err;

	rqcmd.unit = cm->unit;
	rqcmd.mem = cm->error;
	rqcmd.xfer_len = MAX_REQ_DATA_LEN;
	rqcmd.cmd_dsc_blk[0] = CDB_REQUEST_SENSE;
	rqcmd.cmd_dsc_blk[1] = 0;
	rqcmd.cmd_dsc_blk[2] = 0;
	rqcmd.cmd_dsc_blk[3] = 0;
	rqcmd.cmd_dsc_blk[4] = MAX_REQ_DATA_LEN;
	rqcmd.cmd_dsc_blk[5] = 0;
	rqcmd.cmd_dsc_len = G0SIZE;
	rqcmd.xfer_flag = SCSI_DATA_IN;
	rqcmd.timer = REQUEST_TIME_SLICE;
	rqcmd.resid = MAX_REQ_DATA_LEN;
	clear_err_status(&rqcmd);
	start_time = int_counter; 	/* start timer */

	if ((err = send_cdb_cmd(&rqcmd)) != 0)	/* send scsi cdb */
		return(err);

	if ((err = xfer_info(&rqcmd)) != 0)
		return(err);
	cm->err_len = MAX_REQ_DATA_LEN - rqcmd.resid;
	return(0);
}
	

	
static xfer_info(cm)
REQ_BOX	*cm;
{
	unchar	phase;

	ESPCMD(ESP_NOP);	/* ajust chip */
	ESPCMD(ESP_FLSH_FIFO); /* clear fifo */
	phase = GET_SCSI_PHASE(status);
	switch(phase){
		case ST_DATAIN:
			if (cm->xfer_flag != SCSI_DATA_IN) 
				return(SCSIERR_XFER_FLAG);
			return(xfer_data_in(cm));

		case ST_DATAOUT:
			if (cm->xfer_flag != SCSI_DATA_OUT)
				return(SCSIERR_XFER_FLAG);
			return(xfer_data_out(cm));

		case ST_MSGIN:
			ESPCMD(ESP_XFER_INFO); /* async xfer without dma */
			if (!wait_cmd_done(cm))
				return(SCSIERR_CMDTIMEOUT);
			get_int_status();
			return(message_in(cm));
		case ST_MSGOUT:
			return(message_out(cm));
		case ST_STATUS:
			return(get_status(cm));
	}
	return(SCSIERR_NOERR);		/* JPC: is noerr correct??? */
}
	
static get_status(cm)
REQ_BOX	*cm;
{
	unchar trgt_status,msg;
	int time;

	ESPCMD(ESP_CMD_CMP);
	if (!wait_cmd_done(cm))
		return(SCSIERR_CMDTIMEOUT);
	get_int_status();

	if(int_status == INT_BUS_SERV)
		return(SCSIERR_INTERR);
	GETFIFO(trgt_status);
	time = 1; 	/* doing small time delay for 2nd byte in fifo ready */
	while(time -- );	
	GETFIFO(msg);
	if(msg != MSG_COMP)
		return(SCSIERR_UXPCTMSG);
	/* check status */
	
	ESPCMD(ESP_MSG_ACPT);
	if (!wait_cmd_done(cm))
		return(SCSIERR_CMDTIMEOUT);
	get_int_status();
	if (int_status != INT_DISCONNECT)
		reset_bus();
	if(trgt_status  == 0)		/* good condition */
		return(0);
	if(trgt_status & TRGT_CHECK_CON) /* device ask for check condition */
		return(SCSIERR_SENSE);
	if(trgt_status & TRGT_BUSY)	/* device is busy */
		return (SCSIERR_BUSY);
	return(SCSIERR_UXPSTATUS);	/* unexpected status */
} /* end of check_status	*/

static message_out(cm)
REQ_BOX	*cm;
{
	ESPCMD(ESP_FLSH_FIFO);
	SETFIFO(MSG_RJCT);
	ESPCMD(ESP_XFER_INFO);
	if (!wait_cmd_done(cm))
		return(SCSIERR_CMDTIMEOUT);
	get_int_status();
	return(xfer_info(cm));
}

static message_in(cm)
REQ_BOX	*cm;
/* message_in -- process the msg data */
{
	unchar	message;
		
	GETFIFO(message);
	switch(message){
		case MSG_COMP:
			break;
		default:
			ESPCMD(ESP_SET_ATN);
			break;
		}
		
	ESPCMD(ESP_MSG_ACPT);
	if (!wait_cmd_done(cm))
		return(SCSIERR_CMDTIMEOUT);
	get_int_status();
	return(xfer_info(cm));
} /* end of message in */

static xfer_data_out(cm)
REQ_BOX	*cm;
{
	register unchar *buf;
	register int	len;
	register uint	*fifo = &esp->un.r.fifo;
	register uint	*espcmd = &esp->un.w.cmd;
	register uint	cmd_done_mask;
	register uint	*fbsr = bsr; 
	register uint	int_regs,status_regs;
	register uint	expire_time;

	cmd_done_mask = (GET_CHAN_ID(cm->unit.s.phys) == 0) ?
	  BSR_SCSIA : BSR_SCSIB; 
	buf = cm->mem;
	if ((len = cm->xfer_len) == 0)
		return(SCSIERR_DMACNT);
	expire_time = cm->timer + start_time;

	do {
		*fifo = *buf;
		*espcmd = ESP_XFER_INFO; /* async xfer without dma */
		buf++;
		len--;
		do {
			if (int_counter > expire_time)
				return(SCSIERR_CMDTIMEOUT);
		} while (*fbsr & cmd_done_mask);

		ESPRREG(status, status_regs);
		ESPRREG(int_status, int_regs);

		if ( (int_regs & INT_BUS_SERV) && 
			(GET_SCSI_PHASE(status_regs) == ST_DATAOUT))
			continue;

		return(xfer_data_done(int_regs, status_regs, cm, len));
	} while(len);

	return(SCSIERR_DMACNT);
}

static xfer_data_in(cm)
REQ_BOX	*cm;
{
	register unchar *buf;
	register int	len;
	register uint	*fifo = &esp->un.r.fifo;
	register uint	*espcmd = &esp->un.w.cmd;
	register uint	cmd_done_mask;
	register uint	*fbsr = bsr; 
	register uint   int_regs;
	register uint	status_regs;
	register uint	expire_time;

	cmd_done_mask = (GET_CHAN_ID(cm->unit.s.phys) == 0) ?
	  BSR_SCSIA : BSR_SCSIB;
	buf = cm->mem;
	if ((len = cm->xfer_len) == 0)
		return(SCSIERR_DMACNT);
	expire_time = cm->timer + start_time;
	do {
		*espcmd = ESP_XFER_INFO; /* async xfer without dma */

		do {
			if (int_counter > expire_time)
				return(SCSIERR_CMDTIMEOUT);
		} while (*fbsr & cmd_done_mask);

		ESPRREG(status, status_regs);
		ESPRREG(int_status, int_regs);
		*buf++ = *fifo;
		len--;
		if ( (int_regs & INT_BUS_SERV) && 
			GET_SCSI_PHASE(status_regs) == ST_DATAIN) {
			continue;
		}
		return(xfer_data_done(int_regs, status_regs, cm, len));
	} while(len);

	return(SCSIERR_DMACNT);
}


static	
xfer_data_done(int_regs, status_regs, cm, len)
uint int_regs, status_regs;
int len;
REQ_BOX	*cm;
{
	if (int_regs & INT_BUS_SERV) {
		cm->resid = len;
		int_status = int_regs;
		status = status_regs;
		return(xfer_info(cm));
	}

	if(int_regs & INT_DISCONNECT) 
		return(SCSIERR_DISC);

	if(int_regs & INT_ILLEGAL_CMD) 
		return(SCSIERR_ILLESP);
	return(SCSIERR_NOERR);		/* JPC: is noerr correct??? */
}
static send_cdb_cmd(cm)
REQ_BOX *cm;
{
	unchar *buffer;
	int	len;

	ESPCMD(ESP_FLSH_FIFO);


	buffer = cm->cmd_dsc_blk;
	if ((len = cm->cmd_dsc_len) == 0)
		return(SCSIERR_NOCDB);

	ESPWREG(bus_id, GET_BUS_ID(cm->unit.s.phys));
	SETFIFO(MSG_IDFY); /* set identify message */
	while (--len >= 0) {
		SETFIFO(*buffer);
		buffer++;
	}
	ESPCMD(ESP_SELATN);

	if (!wait_cmd_done(cm))
		return(SCSIERR_CMDTIMEOUT);
	get_seq_status();
	return(sequence_check());
}

static wait_cmd_done(cm)
REQ_BOX *cm;
{
	uint cmd_done_mask;

	cmd_done_mask = (GET_CHAN_ID(cm->unit.s.phys) == 0) ?
	  BSR_SCSIA : BSR_SCSIB;
	while (*bsr & cmd_done_mask)
		if ((int_counter - start_time) > cm->timer)
			return(0);
	return(1);
}

static sequence_check()
{
	int seq_state;
	int_step &= 0x07;	/* only the least significant 3 bits are available */
	seq_state = (int_step << 8) | int_status; 

	if (seq_state == SEQ_COMPLETE)	/* select successful */
		return(0);
	if (seq_state == SEQ_NO_DEVICE) /* select timeout */
		return(SCSIERR_NODEV);
	if (seq_state == SEQ_NO_MSGOUT) /* no message out phase */
		return(SCSIERR_PHASE);
	if (seq_state == SEQ_NO_CMMD)	/* no command out phase */
		return(SCSIERR_PHASE);
	if (seq_state == SEQ_PREMATURE) /* command phase change premature */
		return(SCSIERR_PHASE);	
	return(SCSIERR_NODEV);		/* may be connected to wrong port */
}

static init_chan(ch, mode)
struct chan *ch;
uint	mode;
{
	/* set deivce board in reset state */
	if (ch->bus_status & ST_BUS_RESET)
		return;
	set_db_reset(ch);
	/* reset device board */
	bcrcmd(ch,BCR_UNRESET);
	bcrcmd(ch,BCR_UNSCSIRES);
	if (mode  == BCR_SINGLE)
		bcruncmd(ch,BCR_DIFF);
	else
		bcrcmd(ch, BCR_DIFF);
	config_chip();
	ESPCMD(ESP_RESET_BUS);
	delay(BUS_RESET_DELAY);
	ch->bus_status |= ST_BUS_RESET;

} /* initialize channel */

config_chip()
{
	ESPCMD(ESP_RESET_CHIP);
	delay_no_poll(RESET_CHIP_DELAY);
	ESPCMD(ESP_NOP);
	ESPWREG(config,(CF_PARITY | CF_SCSI_RID | INITIATOR_ID ));
	ESPWREG(ccf,CCF);
	ESPWREG(timeout, SEL_TIMEOUT);
}


static reset_bus()
{
	ESPCMD(ESP_RESET_BUS);
	delay(BUS_RESET_DELAY);
	config_chip();
	delay(RESET_CHIP_DELAY);
}

static bcrcmd(ch,bcr_cmd)
struct chan *ch;
unchar bcr_cmd;
{
	
	ch->bcr_cmd |= bcr_cmd;
	if(bcr == BCR_A)
		*bcr = ch->bcr_cmd << BCR_SHIFT_A;
	else
		*bcr = ch->bcr_cmd << BCR_SHIFT_B;
}
static bcruncmd(ch,bcr_cmd)
struct chan *ch;
unchar bcr_cmd;
{
	ch->bcr_cmd &= ~bcr_cmd;
	if (bcr == BCR_A)
		*bcr = ch->bcr_cmd << BCR_SHIFT_A;
	else
		*bcr = ch->bcr_cmd << BCR_SHIFT_B;
}

static set_db_reset(ch)
struct chan *ch;
{
	ch->bcr_cmd = 0;
        *bcr = 0;
}	

static
clear_err_status(cm)
REQ_BOX	*cm;
{
	cm->err_code = SCSIERR_NOERR;
	cm->err_len = 0;
	cm->act = 0;
}

init_dsdb_table()
{
	int		i;
	iopm_dsdb_t	*ds;

	for (ds = dsdb_table, i = MAXNOBDS; --i >= 0; ds++) {
		ds->unit.i = IUNIT_NO_DEV;
		ds->last_acc_time = 0;
	}
	did_dsdb_init = 1;
}

static chan_t *
get_chan(unit)
iunit_t	unit;
{
	register iopm_dsdb_t	*ds, *empty_entry, *old_entry;
	register int		i;
	register uint		chan_id;
	uint			old_age;
	extern uint		n_seconds;

	chan_id = GET_CHAN_ID(unit.s.phys);
	empty_entry = NULL;
	old_entry = NULL;
	old_age = 0xFFFFFFFF;

	for (ds = dsdb_table, i = MAXNOBDS; --i >= 0; ds++) {
		/* found matched one */
		if (ds->unit.w.sns == unit.w.sns)
			break;
		/* get empty entry */
		if (ds->unit.i == IUNIT_NO_DEV) {
			empty_entry = ds;
			continue;
		}
		/* get one who is in idle for the longest time */
		if (ds->last_acc_time < old_age) {
			old_age = ds->last_acc_time;
			old_entry = ds;
		}
	}

	if (i < 0) {	/* cannot found match one */

		/* init dsdb */
						/* enable device board */
		*(ushort *)SET_SPM_ADDR(CONFIG_REG) = ENABLE_DEV;
		ds = (empty_entry) ? empty_entry : old_entry;
		ds->unit = unit;
		for (i = MAXNOCHANS; --i >= 0; ) {
			ds->chan_table[i].bus_status = 0;
			ds->chan_table[i].bcr_cmd = 0;
		}
		bcr = BCR_A;
		set_db_reset(&ds->chan_table[0]);
		bcr = BCR_B;
		set_db_reset(&ds->chan_table[1]);
	}
	ds->last_acc_time = n_seconds;
	set_chan_reg(chan_id);
	return(&ds->chan_table[chan_id]);
}



static
set_chan_reg(chan_id)
unchar chan_id;
{

	if (chan_id == 0) {
		esp = (SCSI_R *)SET_SPM_ADDR(SCSI_CHIPA);
		bcr = BCR_A;
	}
	else {
		esp = (SCSI_R *)SET_SPM_ADDR(SCSI_CHIPB);
		bcr = BCR_B;
	}
}

static	get_seq_status()
{
	ESPRREG(seq_stp,int_step);
	int_step &= 0xff;
	get_int_status();
}

static
get_int_status()
{
	ESPRREG(status,status);
	status &= 0xff;
	ESPRREG(int_status,int_status);
	int_status &= 0xff;
}
