/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_comon.h: version 25.1 created on 11/27/91 at 15:31:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_comon.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_comon.h -- The common header file for scsi device driver */


/* Adjust buffer address to 16-byte boundry */
#define	addr16(x)	(unchar *)(((uint)x+16)&(~(16-1)))

/*  combines bytes to a integer */
#define CTOI4(w, x, y, z) 	(w << 24 | x << 16 | y << 8 | z)
#define CTOI3(x, y, z) 		( x<<16 | y<<8 | z)
#define CTOI2(y, z) 		(y<<8 | z)

/* set a interger to  chars */
#define ITOC4(w, x, y, z, i)	\
				w=i>>24; \
			        x=i>>16; \
				y=i>>8; \
				z=i
				
#define ITOC3(x, y, z, i)	\
			        x=i>>16; \
				y=i>>8; \
				z=i

#define ITOC2(y, z, i)	\
				y=i>>8; \
				z=i

#define	ERR_TYPE	0xE0
#define	ERR_CODE	0x1F

/* error code definition */
/* scsi drive report error */
#define DEVERR_BASE		0x20
#define	DEVERR_NO_SENSE		0x20
#define DEVERR_RECOVERED_ERR 	0x21
#define DEVERR_NOT_READY	0x22
#define DEVERR_MEDIUM_ERR	0x23
#define DEVERR_HARD_ERR		0x24
#define DEVERR_ILL_REQUEST	0x25
#define DEVERR_UNIT_ATTN	0x26
#define	DEVERR_DATA_PROCTECT	0x27
#define DEVERR_BLANK_CHECK	0x28
#define	DEVERR_UNKNOWN_ERR	0x29 
#define	DEVERR_COPY_ABORT	0x2A
#define	DEVERR_ABORTED_CMD	0x2B
#define	DEVERR_EQUAL		0x2C
#define DEVERR_VOL_OVERFLOW	0x2D
#define DEVERR_MISCOMPARE	0x2E
#define DEVERR_MARK_DETECTED	0x30
#define DEVERR_FM_DETECTED	0x31
#define DEVERR_EOM_DETECTED	0x32
#define DEVERR_ILI_DETECTED	0x33
#define DEVERR_BOM		0x34
#define DEVERR_BUSY		0x35

/* scsi driver error code definition */
#define SCSIERR_BASE	0x40	/* base code for scsi driver error */
#define SCSIERR_INVAIL  0x40	/* invaild parameter to scsi driver */
#define SCSIERR_UNIT_ID 0x41	/* invalid unit id		    */
#define SCSIERR_XFERTIMEOUT 0x42	/* scsi bus accessing timeout	    */
#define SCSIERR_NODEV	0x43	/* scsi device is not on line	    */
#define SCSIERR_UNINIT  0x44	/* The device is in uninitialized state */
#define	SCSIERR_PHASE	0x45	/* illegal phase changed */
#define	SCSIERR_DATA	0x46   	/* data error */
#define SCSIERR_UXPCTMSG 0x47	/* unexpected message received */
#define SCSIERR_PARITY  0x48	/* parity error		*/
#define	SCSIERR_BUSRESET 0x49	/* bus reset	*/
#define SCSIERR_CMDTIMEOUT 0x4A /* command excution timeout	*/
#define SCSIERR_NOCCS	0x4B	/* target doesn't support ccs command set */
#define SCSIERR_ILLSEQ	0x4C	/* illegal sequence number	*/
#define SCSIERR_DMABUS   0x4D	/* dma bus error */
#define SCSIERR_FATAL	 0x4E	/* fatal error such as get check condition
					on request sense command */
#define SCSIERR_CONN	0x4F	/* scsi bus connection confuse */
#define SCSIERR_DISC	0x50	/* illegal disconnect */
#define SCSIERR_ILLESP  0x51    /* illegal esp command */
#define SCSIERR_SHORTLEN  0x52    /* illegal esp command */

/* driver error code definition */
#define DRVERR_BASE	0x80
#define	DRVERR_DEVTYPE	0x80
#define DRVERR_WRTPROT	0x81
#define DRVERR_BLKLEN	0x82	/* the block length is out of range */
#define DRVERR_MULTI_DRVS 0x83	/* the block length is out of range */



/* the header type of error message */
#define IOPM_DSK	0x00
#define IOPM_CTAPE	0x02
#define IOPM_9TAPE	0x04
#define IOPM_OPTICAL	0x08


#define MAXNODRVS	14	/* max number of drvs */
