/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_ccs.h: version 25.1 created on 11/27/91 at 15:31:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_ccs.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
#define SIMULATION 	1
*/

/* CCS Required Commands	*/
#define	CDB_TEST_UNIT_READY	0x00
#define CDB_REQUEST_SENSE	0x03
#define	CDB_READ		0x08
#define CDB_WRITE		0x0A
#define CDB_INQUIRY		0x12
#define CDB_RESERVE_UNIT	0x16
#define CDB_RELEASE_UNIT	0x17
#define CDB_SEND_DIAG	0x1D

/* SCSI common command set for Direct-Access Device */

#define CDB_FORMAT_UNIT	0x04
#define CDB_READ_CAPACITY	0x25
#define CDB_READ_EXTENDED	0x28
#define CDB_WRITE_EXTENDED  0x2A

/* SCSI common command set for Sequential-Access Device */
#define CDB_REWIND		0x01
#define CDB_READ_BLKLI	0x05
#define CDB_TRACK_SELECT 	0x0B
#define CDB_READ_REV	0x0F
#define CDB_WRITE_FILEMARKS 0x10
#define CDB_SPACE 		0x11
#define CDB_TAPE_VERIFY 	0x13
#define CDB_REC_BUF_DATA	0x14
#define CDB_ERASE		0x19
#define CDB_LOAD 		0x1B
#define CDB_UNLOAD 		0x1B
#define CDB_MEDIUM_REMOVAL	0x1E
/* CCS Optional Commands for Direct-Access Devices	*/

#define	CDB_REASSIGN	0x07
#define CDB_MODE_SELECT	0x15
#define	CDB_MODE_SENSE	0x1A
#define	CDB_READ_DEFECT	0x37
#define	CDB_WRITE_BUFFER	0x3B
#define	CDB_READ_BUFFER	0x3C

/* CCS Optional Commands in the draft standard */

#define CDB_REZERO		0x01
#define CDB_SEEK_G0		0x0B
#define CDB_COPY		0x18
#define	CDB_START_STOP	0x1B
#define	CDB_RECEIVE_DIAG	0x1C
#define	CDB_SEEK_G1		0x2B
#define	CDB_WRVFY		0x2E
#define	CDB_VERIFY		0x2F
#define	CDB_SEARCH_HI	0x30
#define	CDB_SEARCH_EQ	0x31
#define	CDB_SEARCH_LO	0x32
#define	CDB_SET_LIMITS	0x33
#define CDB_COMPARE		0x39
#define	CDB_CPVFY		0x3A

/* options paramter for tape command */
/* media removal	*/
#define ALLOW		0x00
#define PREVENT		0x01

/* Load/unload */
#define UNL		0x00
#define	LD		0x01
/* space code */
#define S_BLK		0x00
#define S_FMK		0x01
#define S_SFM		0x02
#define S_EOD		0x03
/*
	definition of mode sense data
*/
 
struct mode_head {
	unchar	sd_len;		/* sense data length */
	unchar	med_type;	/* medium type 		*/
	unchar	wp;		/* write protect bit	*/
	unchar	dscptr_len;  	/* block descriptorlength	*/
};
#define WP	0x80		/* write protect bit */
#define	MODEHEAD_LEN	sizeof(struct mode_head)

struct blk_dscptr {
	unchar	density;	/* density code	*/
	unchar	numblk_msb;	/* number of block	*/
	unchar	numblk;		
	unchar	numblk_lsb;	
	unchar	pad;		/* reserved	*/
	unchar	blk_len_msb;	/* block length	*/
	unchar	blk_len;
	unchar	blk_len_lsb;	
};
#define DSCPTR_LEN	sizeof(struct blk_dscptr)

struct page_hd {
	unchar	code;	/* page code */
	unchar	len	/* size of page	*/
};
#define	PGHD_LEN	sizeof(struct page_hd)

/* definition of page code	*/
#define	PAGE01	0x01	/* error recovery parameters */
#define PAGE02	0x02	/* Disconnect/Reconnect Control paramters */
#define PAGE03	0x03	/* Format parameters	*/
#define PAGE04	0x04	/* Rigid Disk Drive Geometry parameters	*/
#define	PAGEALL	0x3F	/* return all supported paged	*/
#define	PS	0x80	/* parameters saveable bit	*/

/* definition of Page Control Field	*/
#define	CURRENT	0x00	/* return current values	*/
#define CHANGE	0x40	/* return changeable values	*/
#define DEFAULT 0x80	/* return default values	*/
#define SAVED	0xC0	/* return saved values		*/

struct page_01 {
	unchar	err_flags;
	unchar	retry_cnt;
	unchar	correction;
	unchar	hd_offset;
	unchar	strobe;
	unchar	time_limit;
};
/* definition of err_flags */
#define	AWRE	0x80	/* automatic write reallocation	*/
#define	ARRE	0x40	/* automatic read reallocation	*/
#define	TB	0x20	/* the failing data block transfer */
#define RC	0x10	/* enable early correction */
#define ECC	0x08	/* read continuous	*/
#define	PER	0x04	/* post error		*/
#define	DTE	0x02	/* disable transfer on error	*/
#define	DCR	0x01    /* disable correction		*/

struct	page_03 {
	unchar	tpz_msb;	/* track per zone */
	unchar	tpz_lsb;	
	unchar	aspz_msb;	/* alternate sectors per zone */
	unchar	aspz_lsb;
	unchar	atpz_msb;	/* alternate track per zone	*/
	unchar	atpz_lsb;
	unchar	alttk_msb;	/* alternate tracks	*/
	unchar	alttk_lsb;	
	unchar	spt_msb;	/* sector per track	*/
	unchar	spt_lsb;	
	unchar	bps_msb;	/* byte per sector	*/
	unchar	bps_lsb;	
	unchar	intrlv_msb;	/* interleave	*/
	unchar	intrlv_lsb;	
	unchar	tksf_msb;	/* track skew factor	*/
	unchar	tksf_lsb;		
	unchar	cylnsf_msb;	/* cylinder skew factor		*/
	unchar	cylnsf_lsb;
	unchar	flags;		/* characteristic flag 	*/
};

/* definition of flags in page 3	*/
#define	SSEC	0x80	/* soft  sector formatting	*/
#define	HSEC	0x40	/* hard sector formatting	*/
#define	RMB	0x20	/* removable media	*/
#define SURF	0x10	/* allocating surface first */
#define INS	0x08	/* inhibit save		*/

struct	page_04 {
	unchar	cylns_msb;	/* number of cylinders	*/
	unchar	cylns;		
	unchar	cylns_lsb;	
	unchar	heads;		/* number of heads */
	unchar  reserved[6];
	unchar	sprate_msb;	/* drive step rate	*/
	unchar	sprate_lsb;
	unchar	pad[3];		
};
/*
	structure of inquiry_data
*/
struct inquiry_data{
		unchar	dev_type;
		unchar	dev_qual;
		unchar	version;
		unchar	rep_fmt;
		unchar	len;
		unchar	pad[3];
		unchar	vendor[8];
} ;
	
typedef	struct inquiry_data	INQURY;	

/* device type definition */
#define	 DA_DEV	0x00	/* direct-access device */
#define	 SA_DEV 0x01	/* sequential-access device */
#define	 PR_DEV 0x02	/* printer device */
#define	 PC_DEV	0x03	/* processor device	*/
#define  WO_DEV 0x04	/* write-once read-multiple device */
#define	 RO_DEV	0x05	/* read-only direct-access device */
struct g0cdb {
	unchar	opcode;
	unchar	lun_msb;
	unchar	lbaddr;
	unchar	lbaddr_lsb;
	unchar  xfer_len;
	unchar	ctl;
};

struct g1cdb {
	unchar	opcode;
	unchar	lun_ladr;
	unchar	lbaddr_msb;
	unchar	lbaddr_2;
	unchar	lbaddr_1;
	unchar	lbaddr_lsb;
	unchar	;		/* reserve */
	unchar	len_msb;	/* transfer length */
	unchar	len_lsb;
	unchar	ctl;
};

struct	g5cdb {
	unchar opcode;
	unchar lun_ladr;
	unchar	lbaddr_msb;
	unchar	lbaddr_2;
	unchar	lbaddr_1;
	unchar	lbaddr_lsb;
	unchar	;		/* reserve */
	unchar	;		/* reserve */
	unchar	;		/* reserve */
	unchar	len_msb;	/* transfer length */
	unchar	len_lsb;
	unchar	ctl;
};

typedef struct g0cdb G0CDB;
typedef struct g1cdb G1CDB;
typedef struct g5cdb G5CDB;
struct cdb {
	union {
		G0CDB g0;
		G1CDB g1;
		G5CDB g5;	
	      } gp;
	};
typedef	struct cdb CDB; 
#define	G0SIZE sizeof(G0CDB)
#define G1SIZE sizeof(G1CDB)
#define G5SIZE sizeof(G5CDB)

/* init -- initialize all the drives */

#define	get_cdr(x) 	&x->cmd_dsc_blk /* point to command descriptor */
#define G0	0
#define G1	0x20
#define G5	0xA0

struct capacity {
	unchar	lba_msb;
	unchar	lba_2;
	unchar	lba_1;
	unchar	lba_lsb;
};
#define CA_DATA_SIZE sizeof(struct capacity)

typedef struct {
        unchar err_class;
	unchar segment;
	unchar sense_key;
	unchar info_msb;
	unchar info_2;
	unchar info_1;
	unchar info_lsb;
	unchar xsense_len;
	unchar sense_bytes[12];
} EX_SENSE_DATA;

typedef struct {
	unchar err_class;
	unchar lba_msb;
	unchar lba;
	unchar lba_lsb;
} SENSE_DATA;

/* definition of err_class */
#define INFO_VALID	0x80	/* information bytes is valid */
#define ERR_CLASS_MASK  0x70	/* error class field */
#define ERR_CODE_MASK	0x0F
#define CLASS_7		0x70	/* error class 7 */
/* definition of sense_key */
#define FMD		0x80	/* filemark */
#define EOMD		0x40	/* eom */
#define ILI		0x20	/* incorrect length indicator */
#define SENSE_KEY	0x0F	/* marsk for sense key */

