/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) req_box.h: version 25.1 created on 11/27/91 at 15:31:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)req_box.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* The structure of command mail box */

#ifndef SYS_IUNIT_H
#include "sys/iunit.h"
#endif

/* this structure is shared by both virtural driver and scsi driver */

#define	MAX_REQ_DATA_LEN	28
struct req_box {
	iunit_t		unit;
	ushort 		cmd_dsc_len;	/* the length of scsi command 
					   descriptor block */
	unchar  	cmd_dsc_blk[14]; /* scsi command descriptor block */
	unchar		*mem;		/* memory address */
	uint		xfer_len;	/* byte to transfer */
	uint		timer;		/* time out */
	uint		xfer_flag;	/* data in/out */

	ushort    	err_code;	/* the error code */
	ushort		err_len;	/* actual error buf length */
	unchar		error[MAX_REQ_DATA_LEN];	
	uint	  	resid;		/* the dma complete transfer count */
	uint		act;		/* actual time for access command */
};


typedef struct req_box	REQ_BOX;
/* definition of xfer_flags	*/
#define		SCSI_NO_DATA	0	/* no data phase involve	*/
#define		SCSI_DATA_IN	1	/* data in phase involve	*/
#define		SCSI_DATA_OUT	2	/* data out phase involve	*/
