/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pt.c: version 25.1 created on 11/27/91 at 15:31:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pt.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* This SCSI pass thru driver is intended for stand-alone use only
 */

#include "global.h"
#include "misc.h"
#include "saio.h"
#include "iomap.h"
#include "dev.h"
#include "sys/param.h"
#include "sys/types.h"
#include "sys/file.h"
#include "sys/debug.h"

#include "req_box.h"
#include "passthru.h"

static REQ_BOX	pt_box;
static uint	pt_state;
#define	STATE_INIT	0
#define	STATE_GOT_CMD	1
#define	STATE_DID_CMD	2


pt_open(io)
iob_t	*io;
{
	if (dbug)
		printf("pt_open(%#x) unit=0x%08x\n", io, io->i_unit.i);

	if (!check_ios_bd(io->i_unit, "pt_open"))
		return(-1);	/* Return if access to non-valid board. */

	pt_box.unit = io->i_unit;
	pt_state = STATE_INIT;
	return(0);
}

pt_strategy(io, func)
register iob_t	*io; 
int	 	func; 
{
	if (dbug)
		printf("pt_strategy(%#x, %#x) unit=0x%08x, pt_state=%d\n",
		  io, func, io->i_unit.i, pt_state);

	if (pt_state != STATE_GOT_CMD) {
		printf("pt_strategy: pass thru invalid sequence\n");
		return(-1);
	}
	pt_box.unit = io->i_unit;
	pt_box.mem = (unchar *) io->i_ma;
	pt_box.xfer_len = io->i_cc;
	pt_box.xfer_flag = (func == READ) ? SCSI_DATA_IN : SCSI_DATA_OUT;
	/* FIX MSS, don't we need to use func anywhere */
	scsi_send_cmd( &pt_box);
	pt_state = STATE_DID_CMD;
	return(pt_box.resid);
}

pt_ioctl(unit, cmd, addr)
iunit_t		unit;
register int 	cmd;
register uint 	addr;
{
	SCSI_CMD	user_box;
	SCSI_RESULT	user_result;

	if (dbug)
		printf("pt_ioctl(0x%08x, %#x, %#x) pt_state=%d\n",
		  unit.i, cmd, addr, pt_state);
pt_box.unit = unit;

	switch (cmd) {
	case PT_SET_CMD:
		bcopy(addr, &user_box, sizeof(user_box));
		if ((pt_box.cmd_dsc_len = user_box.cmd_dsc_len) == 0) {
			printf("pt_ioctl: Nothing in the CDB!\n");
			return(-1);
		}

		bcopy(user_box.cmd_dsc_blk, pt_box.cmd_dsc_blk,
		      sizeof(user_box.cmd_dsc_blk));
		pt_box.timer = user_box.mil_sec;
		pt_state = STATE_GOT_CMD;
		break;
	case PT_EXECUTE:
		if (pt_state != STATE_GOT_CMD) {
			printf("pt_ioctl(PT_EXECUTE): Illegal sequence.\n");
			return(-1);
		}
		pt_box.xfer_len = 0;
		pt_box.mem = NULL;
		scsi_send_cmd(&pt_box);
		pt_state = STATE_DID_CMD;
		break;
	case PT_GET_RESULTS:
		if (pt_state != STATE_DID_CMD) {
			printf("pt_ioctl(PT_GET_RESULTS): Illegal sequence.\n");
			return(-1);
		}
		user_result.act_time = pt_box.act;
		user_result.disc_count = 0;
		user_result.err_code = pt_box.err_code;
		user_result.err_len = pt_box.err_len;
		if (user_result.err_len)
			bcopy(pt_box.error, user_result.error, 
					user_result.err_len);
		bcopy(&user_result, addr, sizeof(user_box));
		pt_state = STATE_INIT;
		break;
	default:
		printf("pt_ioctl: unknown cmd.\n");
		return(-1);
	}
	return(0);
}
