/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dk.c: version 25.1 created on 11/27/91 at 15:31:15	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dk.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* This disk device driver is intended for stand-alone use only, */
/* and used to access iopm scsi disk device 			 */
/*
 * NOTES:
   1. Only one device can been access at a time. Which means
      that only one device can be open at a time.
 */

#include "global.h"
#include "misc.h"
#include "saio.h"
#include "sa_dir.h"
#include "iomap.h"
#include "sys/param.h"
#include "sys/types.h"
#include "sys/file.h"
#include "sys/debug.h"
#include "sys/ioctl.h"

#include "sdk_ioctl.h"
#include "sdkcfg.h"
#include "sdk_cdb.h"
#include "dsdb_macro.h"
#include "req_box.h"
#include "scsi_error.h"
#include "scsi_drv.h"
#include "disksect.h"
#include "sdk_disk.h"
#include "dev.h"



#define BSIZE		1024
#define MAXOPENS	2
#define MAX_UNIX_SLICE_NO	15


extern char	*scsi_err_msg(), *scsi_sns_msg();

static REQ_BOX	cmb;

typedef struct device {
	iunit_t	unit;
	uint	offset;
	uint	noblk;
	uint	blk_ratio;
	uint	dsk_blk_len;
	uint	type;
	uint	time_stamp;	/* last time had been reference */
	uint	swap;		/* swap device slice number */
} device_t;

static device_t	dev_table[MAXOPENS]; /* the max outstanding open drive is 2  */


/* definition of timer */
#define INQUIRY_TIMER	(5 * HZ )	/* 2 seconds for inquiry command */
#define BASIC_TIMER	(10 * HZ)  /* the basic timer is used for the command
				   without data xfer */
#define SENSE_TIMER	(5 * HZ + 1)	/* request sense command */
#define MODE_TIMER 	(5 * HZ + 1)	/* mode sense command */
#define RWUNIT_TIMER	(4 * HZ )	/* one block data transfer */
#define RDCP_TIMER 	(5 * HZ )	/* read capacity */
#define FORMAT_TIMER 	(30 * 60 * HZ + 1) /* 30 mins for format unit command */
#define START_TIMER	(60 * HZ + 1)	/* spin up timer */

/* get_new_dp : 
	 if there is free one , get it ; else, get the one is sitting there
	   for the longest time without reference 
*/

static device_t *
get_new_dp(unit)
iunit_t	unit;
{
	register int		i;
	register uint		time = 0;
	register device_t	*dp, *dp_to_use;
	device_t		*old_dp;

	old_dp = dp_to_use = NULL;
	for (dp = dev_table, i = 0; i < MAXOPENS; i++, dp++) {
		if (dp->unit.i == IUNIT_NO_DEV) {
			dp_to_use = dp;
			break;
		}
		if (dp->time_stamp >= time) {
			old_dp = dp;
			time = dp->time_stamp;
		}
	}

	if (dp_to_use == NULL)
		dp_to_use = old_dp;
	ASSERT(dp_to_use);
	dp_to_use->unit = unit;
	dp_to_use->time_stamp = int_counter;

	if (!initdrv(dp_to_use)) {
	/* free this device table entry */
		dp_to_use->unit.i = IUNIT_NO_DEV;
		dp_to_use->time_stamp = 0;
		return(NULL);
	}
	return(dp_to_use);
}

static uint	dp_once;

static device_t *
get_dp(unit)
iunit_t	unit;
{
	register int		i;
	register device_t	*dp;

	if (dp_once == 0) {
		bzero(dev_table, sizeof(dev_table));
		for (dp = dev_table, i = MAXOPENS; --i >= 0; dp++)
			dp->unit.i = IUNIT_NO_DEV;
		dp_once = 1;
		return(get_new_dp(unit));
	}

	for (dp = dev_table, i = MAXOPENS; --i >= 0; dp++) {
		if (dp->unit.i == unit.i) {
			dp->time_stamp = int_counter;
			return(dp);
		}
	} 
	return(get_new_dp(unit));
}

static void
remove_dp(unit)
iunit_t	unit;
{
	register int	i;
	device_t	*dp;

	for (dp = dev_table, i = MAXOPENS; --i >= 0; dp++) {
		if (dp->unit.i == unit.i) {
			dp->time_stamp = 0;
			dp->unit.i = IUNIT_NO_DEV;
			return;
		}
	} 
}

ipopen(io)
iob_t	*io;
{
	extern char *gs_str();

	if (dbug)
		printf("ipopen: board = %s\n", gs_str(io->i_unit));

	if (!check_ios_bd(io->i_unit, "ipopen"))
		return(-1);	/* Return if access to non-valid board. */

	io->i_ma = (char *)xtra_block;
	if (sdk_req_sense(io->i_unit, (uchar *)xtra_block) == -1)
		return(-1);

	/* inquiry drive data */
	if (sdk_inquiry(io->i_unit, (uchar *)xtra_block) == -1)
		return(-1);

	if (*io->i_ma != DA_DEV) {
		display_msg(io->i_unit, "device is not a disk");
		return(-1);
	}

	if (sdk_start_unit(io->i_unit) == -1)
		return(-1);
	if (sdk_test_unit_ready(io->i_unit) == -1)
		return(-1);

	remove_dp(io->i_unit);		/* remove old device table entry */

	return(0);
}

ipclose(io)
iob_t	*io;
{
	if (dbug)
		printf("ipclose\n");

	return(0);	
}

ipstrategy(io, func)
register iob_t	*io; 
int	 	func; 
{
	int		totcnt;
	device_t	*dp;

	if ((dp = get_dp(io->i_unit)) == NULL) 
		return(-1);
	totcnt = ipstart(dp, io,
		  (func == READ) ? CDB_READ_EXTENDED : CDB_WRITE_EXTENDED);
	if (totcnt == -1) 
		return(-1);
	else 
		return(io->i_cc - totcnt);
}

static
ipstart(dp, io, cmd)
device_t	*dp;
iob_t		*io;
int		cmd;
{
	uint lblk, resid;

	/* check read/write range */
	if (io->i_bn >= dp->noblk){
		display_msg(dp->unit, "block is out of slice space");
		printf("block number is %d\n", io->i_bn);
		return(-1);
	}	

	if((lblk = io->i_bn + (io->i_cc / BSIZE) - 1) >= dp->noblk) 
		resid = BSIZE * (lblk - dp->noblk + 1);
	else
		resid = 0;
	
	if (sdk_disk_rw(dp, io->i_ma, io->i_bn + dp->offset, io->i_cc - resid, cmd) == -1)
		return(-1);
	else 
		return(resid +	cmb.resid); 
	
	
} /* end of ipstart */


ipioctl(unit, cmd, addr)
iunit_t	unit;
int	cmd;
uint	addr;
{
	device_t	*dp;

	if (dbug)
		printf("ipioctl(0x%08x, %#x, %#x)\n", unit.i, cmd, addr);

	if ((dp = get_dp(unit)) == NULL)
		return(-1);

	switch (cmd) {

	case GET_DISK_SIZE:
		return(dp->noblk);

	case GET_CYLINDER_SIZE:  /* number of blocks per cylinder */
	{	uint	offset;	int	cclb, nclb;

		offset  = dp->offset * dp->blk_ratio;
		if ((cclb = get_cyln_last_blk(dp, offset)) == -1)
			return(-1);	
		if ((nclb = get_cyln_last_blk(dp, cclb + 1)) == -1)
			return(-1);
		return (nclb - cclb);
	}
	case GET_INTERLACE: 
		return (1);

	case GET_DEV_TYPE:
		return (SCSI_TYPE);
		
	case GET_LOG_TYPE:
		return (dp->type);	

	case DSDB_GET_SWAP_SLICE:
		return (dp->swap);
			
	default:
		return(-1);
	}
}

static
get_cyln_last_blk(dp, offset)
device_t	*dp;
uint		offset;
{
	struct capacity	ca;
	uint	last_log_blk, scsi_log_blk;

	scsi_log_blk = offset * dp->blk_ratio;
	if (sdk_read_cap(dp, &ca, scsi_log_blk, PMI) == -1)
		return(-1);
	last_log_blk = CAT4(ca.lba_msb, ca.lba_2, ca.lba_1, ca.lba_lsb);
	return(last_log_blk/dp->blk_ratio);
}

/* initdrv -- initialize scsi disk table.
	setup configuration table.
	initialize slice table.
*/
static
initdrv(dp)
device_t	*dp;
{
	struct sdk_block_0 s0;
	struct capacity ca;

	/* get block size and total number of blocks */
	
	if (sdk_read_cap(dp, &ca, 0, 0) == -1)
		return(0);

	dp->dsk_blk_len = CAT4(ca.bl_msb, ca.bl_2, ca.bl_1, ca.bl_lsb);

	dp->blk_ratio = BSIZE/dp->dsk_blk_len;

	/* read config block */
	if (sdk_disk_read(dp, &s0, CONFIG_BLOCK, BSIZE) == -1)
		return(0);
	if (is_scsi_edt((SDK_SECTOR0 *)&s0))
		set_edt_slice((struct sector0 *)&s0, dp);
	else {
		if(is_iopm_disk(&s0)) {
			if (is_old_disk(&s0))
				set_old_disk_slice((SDK_SECTOR0 *)&s0, dp);
			else
				set_new_disk_slice(&s0,dp);
		}
		else {
			printf("Disk not formated yet!\n");
			return(0);
		}
	}
	return(1);

}

static
is_scsi_edt(sp)
SDK_SECTOR0 *sp;
{
	struct sector0		*edt_sp = (struct sector0 *) sp;

	if (strncmp(edt_sp->id, "INIT", 4))
		return(0);
	if (edt_sp->pd_ldmaxnum > LOGDR)
		return(0);
	if (edt_sp->pd_ldnum > LOGDR)
		return(0);
	return(1);
}

	
static
is_iopm_disk(s0)
struct sdk_block_0	*s0;
{
	return(!strncmp(s0->misc.disk_info.vol_id,"IOPMSCSI",8));
}

static
is_old_disk(s0)
struct sdk_block_0	*s0;
{
	return(s0->misc.disk_info.date < VERSION_DATE );
}

static
set_edt_slice(sp, dp)
struct sector0 *sp;
device_t	*dp;
{
	register int	i;
	struct logtype	*lp;

	ASSERT(dp->unit.s.log <= MAX_UNIX_SLICE_NO);
	lp = &sp->logdrive[dp->unit.s.log];

	dp->noblk = lp->ld_size;
	dp->offset = lp->ld_strt;
	dp->type = lp->ld_type;
	/* get swap device number */
	for (lp = sp->logdrive, i = 0; i <= MAX_UNIX_SLICE_NO; i++, lp++) {
		if (lp->ld_type == LD_SWAP) {
			dp->swap = i;
			return;
		}
	}
	dp->swap = ~0;
}

static
set_old_disk_slice(s0,dp)
SDK_SECTOR0	*s0;
device_t	*dp;
{
	SLSIZE	*slp;

	ASSERT(dp->unit.s.log <= MAX_UNIX_SLICE_NO);
	slp = &s0->sltable[dp->unit.s.log];
	dp->noblk = slp->noblk;
	dp->offset = slp->offset + s0->phyblkno;
	dp->type = LD_UNIX_SLICE;
	dp->swap = 1;
}

static
set_new_disk_slice(s0, dp)
struct sdk_block_0	*s0;
device_t		*dp;
{
	register int		i;
	union slice_table	*sltp;

	ASSERT(dp->unit.s.log <= MAX_UNIX_SLICE_NO);
	sltp = &s0->slice_table[dp->unit.s.log];
	dp->offset = sltp->ldrv.ld_strt;
	dp->noblk  = sltp->ldrv.ld_size;
	dp->type   = sltp->ldrv.ld_type;
	/* get swap device number */
	sltp = s0->slice_table;
	for (i = 0; i <= MAX_UNIX_SLICE_NO; i++, sltp++) {
		if (sltp->ldrv.ld_type == LD_SWAP_SLICE) {
			dp->swap = i;
			return;
		}
	}
	dp->swap = ~0;
}

static 
sdk_start_unit(unit)
iunit_t	unit;
{
	struct g0_cdb	*cdb = (struct g0_cdb *)cmb.cmd_dsc_blk;
	
	bzero(&cmb,sizeof (REQ_BOX));

	cmb.cmd_dsc_len = sizeof(struct g0_cdb);
	cmb.timer = START_TIMER;
	cmb.unit = unit;
	cdb->opcode = CDB_START_STOP;
	cdb->start_flags = START_BIT;
	scsi_send_cmd(&cmb);
	return(cmd_done(&cmb));
}

static 
sdk_req_sense(unit, buf)
iunit_t	unit;
unchar	*buf;
{
	struct g0_cdb	*cdb = (struct g0_cdb *)cmb.cmd_dsc_blk;
	
	bzero(&cmb,sizeof (REQ_BOX));

	cmb.cmd_dsc_len = sizeof(struct g0_cdb);
	cmb.timer = INQUIRY_TIMER;
	cmb.unit = unit;
	cmb.xfer_len = SENSE_DATA_SIZE;
	cmb.mem = (unchar *)buf;
	cmb.xfer_flag = SCSI_DATA_IN;
	cdb->opcode = CDB_REQUEST_SENSE;
	cdb->xfer_len = SENSE_DATA_SIZE;

	scsi_send_cmd(&cmb);
	return(cmd_done(&cmb));
}

static 
sdk_test_unit_ready(unit)
iunit_t	unit;
{
	struct g0_cdb	*cdb = (struct g0_cdb *)cmb.cmd_dsc_blk;
	
	bzero(&cmb,sizeof (REQ_BOX));

	cmb.cmd_dsc_len = sizeof(struct g0_cdb);
	cmb.timer = BASIC_TIMER;
	cmb.unit = unit;
	cdb->opcode = CDB_TEST_UNIT_READY;
	scsi_send_cmd(&cmb);
	return(cmd_done(&cmb));

}

static 
sdk_inquiry(unit, buf)
iunit_t	unit;
unchar	*buf;
{
	struct g0_cdb	*cdb = (struct g0_cdb *)cmb.cmd_dsc_blk;
	
	bzero(&cmb,sizeof (REQ_BOX));

	cmb.cmd_dsc_len = sizeof(struct g0_cdb);
	cmb.timer = INQUIRY_TIMER;
	cmb.unit = unit;
	cmb.xfer_len = sizeof (struct inquiry_data);
	cmb.mem = (unchar *)buf;
	cmb.xfer_flag = SCSI_DATA_IN;
	cdb->opcode = CDB_INQUIRY;
	cdb->xfer_len = sizeof (struct inquiry_data);
	scsi_send_cmd(&cmb);
	return(cmd_done(&cmb));

}

static
sdk_read_cap(dp, ca, blkno, pmi_set)
device_t	*dp;
struct capacity	*ca;
uint		blkno;
unchar		pmi_set;
{
	struct g1_cdb	*cdb = (struct g1_cdb *)cmb.cmd_dsc_blk;
	uint	drv_blkno;	
	bzero(&cmb,sizeof (REQ_BOX));

	cmb.cmd_dsc_len = sizeof(struct g1_cdb);
	cmb.unit = dp->unit;

	cmb.xfer_len = sizeof (struct capacity);
	cmb.mem = (unchar *)ca;
	cmb.xfer_flag = SCSI_DATA_IN;
	cdb->opcode = CDB_READ_CAPACITY;

	if (pmi_set) {
		if (blkno == 0)
			blkno = 1;
		drv_blkno = blkno * dp->blk_ratio;
		ITOC4(cdb->calba_msb, cdb->calba_2, cdb->calba_1, 
			cdb->calba_lsb, drv_blkno);
		cdb->ca_pmi = pmi_set;
	}
	cmb.timer = BASIC_TIMER;
	scsi_send_cmd(&cmb);
	return(cmd_done(&cmb));

}

static
sdk_disk_read(dp, buf, offset, len)
device_t	*dp;
unchar		*buf;
uint		offset, len;
{
	return(sdk_disk_rw(dp, buf, offset, len, CDB_READ_EXTENDED));
}

#if 0 /* JPC: not used... */
static
sdk_disk_write(dp, buf, offset, len)
device_t	*dp;
unchar		*buf;
uint		offset, len;
{
	return(sdk_disk_rw(dp, buf, offset, len, CDB_WRITE_EXTENDED));
}
#endif /* 0 */

static
sdk_disk_rw(dp, buf, offset, len, opcode)
device_t	*dp;
unchar		*buf;
uint		offset, len;
unchar		opcode;
{
	register struct g1_cdb *cdb = (struct g1_cdb *)cmb.cmd_dsc_blk;
	
	uint	blk_cnt, drv_blkno;

	ASSERT(opcode == CDB_READ_EXTENDED || opcode == CDB_WRITE_EXTENDED);

	bzero(&cmb,sizeof (REQ_BOX));

	cmb.cmd_dsc_len = sizeof(struct g1_cdb);
	cdb->opcode = opcode;	
	drv_blkno = offset * dp->blk_ratio; /* caculate drive block no */
	ITOC4(cdb->lbadr_msb, cdb->lbadr_2, cdb->lbadr_1, cdb->lbadr_lsb, drv_blkno);

	blk_cnt = len / dp->dsk_blk_len;	
	ITOC2(cdb->xferlen_msb, cdb->xferlen_lsb, blk_cnt);
	cmb.timer = RWUNIT_TIMER * blk_cnt;
	cmb.unit = dp->unit;
	cmb.xfer_len = len;
	cmb.mem = buf;
	if (opcode == CDB_READ_EXTENDED)
		cmb.xfer_flag = SCSI_DATA_IN;
	else
		cmb.xfer_flag = SCSI_DATA_OUT;

	scsi_send_cmd(&cmb);
	return(cmd_done(&cmb));

}

cmd_done(cm)
REQ_BOX *cm;
{
	if (cm->err_code == SCSIERR_NOERR)
		return(cm->resid);
	else {
		err_process(cm);
		return(-1);
	}

}

static
err_process(cm)
REQ_BOX *cm;
{
	
	if ( cm->err_code == SCSIERR_SENSE)
		 set_sense_error( cm);
	else
		 set_scsi_err(cm);
		
}

static
set_sense_error(cm)
REQ_BOX *cm;
{
	EX_SENSE_DATA *sd;

	sd = (EX_SENSE_DATA *)cm->error;
	
	display_header(cm->unit);
	if ((sd ->err_class & ERR_CLASS_MASK) != ANSI_CLASS )
		printf("vendor unique error\n");
	else {
		printf("%s.\n", scsi_sns_msg(sd->sense_key));
		display_sense(sd);	
	}
	return(0);
}

static
set_scsi_err(cm)
REQ_BOX *cm;
{
	display_header(cm->unit);
	printf("%s.\n", scsi_err_msg(cm->err_code)); /* display error message */
}

display_sense(sd)
EX_SENSE_DATA	*sd;
{
	if (sd->err_class & INFO_VALID)
		printf("at logical block address 0x%x%x%x%x,",
		  sd->info_msb,sd->info_2,sd->info_1,sd->info_lsb);
	if (sd->xsense_len)
		printf(" with extension error code %x",sd->err_code);
	if (sd->flags & FPV) {
		printf(",at field(byte) pointer 0x%x%x",
		  sd->field_hi, sd->field_lo);
		if (sd->flags & BPV)
			printf(", on bit %x", sd->flags & BIT_POINTER_MASK);
		printf((sd->flags & CDBIT) ? " of CDB" : " of data");
	}
	printf(".\n");
}

display_header(unit)
iunit_t	unit;
{
	printf("Slot %s, channel id %u, bus id %u: ",
	  gs_str(unit), GET_CHAN_ID(unit.s.phys), GET_BUS_ID(unit.s.phys));
}

display_msg(unit, s)
iunit_t	unit;
char	*s;
{
	printf("IOPM SCSI disk error on ");
	display_header(unit);
	printf("%s\n", s);
}
