/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mmu.c: version 25.1 created on 11/27/91 at 15:30:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mmu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:mmu.c	25.1"
/* pagetable.c */

#ifdef M68020
#undef M68020
#define M68040
#endif

#include "sbus_conf.h"	/* hanna FIX: in temporarily for pre compile */
#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/kmem.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "sys/proc.h"
#include "sys/immu.h"
#include "sys/iopm_mmu.h"
#include "sys/lio.h"
#include "memstripe.h"
#include "sys/pm_iomap.h"

	/* these defines coorespond to those in sys/M68040/Mimmu.h */
#define dpm40_lpfn_to_pfn(x)	dpm40_lpfn_to_mpfn(x)
#define dpm40_pfn_to_lpfn(x)	dpm40_mpfn_to_lpfn(x)

rde_t		dpm40_km_to_rde();
static qde_t	dpm40_km_to_qde();
static sde_t	dpm40_km_to_sde();
static pde_t	dpm40_km_to_pde();

static uint	dpm40_rde_to_km();
static uint	dpm40_qde_to_km();
static uint	dpm40_sde_to_km();

extern uint	km_allocate();
extern unchar	*km_map();
extern own_t	*dpm40_map_own();
extern uint	dpm40_get_pm_id();
extern uint	dpm40_lpfn_to_mpfn();
extern uint	dpm40_mpfn_to_lpfn();

/*
 * dpm40_invalid_tbl()  - set up entries in sbus_config that denote invalid
 *  mmu entries.  (on the 020, this involves pointing to poison pages and
 *  setting up the poison pages. on the 040, this just involves making
 *  invalid entry patterns)
 */

static void
dpm40_invalid_tbl() 
{
	qde_t	*qdep = (qde_t *)&sbus_config.invalid_qde;
	pde_t	pde;
	sde_t	sde;

	sbus_config.invalid_rde = 0x11111111; /* hanna DEBUG pattern */

	qdep->qde_all = 0x22222220;	 /* hanna DEBUG pattern */
	qdep->qde.u = 1;		/* prevent excess RMW?*/
	qdep->qde.wp = 1;		/* write protect */
	qdep->qde.udt = UDT_INVALID;	/* not present */

	sde.sde_all = 0x33333330;	/* hanna DEBUG pattern */
	sde.sde.u = 1;			/* prevent excess RMW?*/
	sde.sde.wp = 1;			/* write protect */
	sde.sde.udt = UDT_INVALID;	/* not present */
	sbus_config.invalid_sde = sde.sde_all;

	pde.pde_all = 0x44444400;	/* hanna DEBUG pattern */
	pde.pde.pres0 = 0;
	pde.pde.pres = 0;
	sbus_config.invalid_pde = pde.pde_all;
}

static pde_t
dpm40_km_to_pde(km, mode)
uint	km, mode;
{
	pde_t	retval;
	ASSERT( !(km & ((1 << PNUMSHFT) - 1)));

	mode |= PG_S|PG_G; /* all pages being assigned are kernel only */
/* hanna DEBUG -- til cas fixed if ((mode & PG_WP))*/ mode |= PG_REF|PG_M;
	/* compute lpfn of page and shift into position */
		/* don't set any other fields. */
	retval.pde_all = dpm40_pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

	retval.pde_all |= pde_mode_to_mask(mode);
	return(retval);

}

/*
 * build a table in main memory for the kernel to
 * use in converting lpfns to pfns.
 */
static void
dpm40_lpfn_tbl_init()
{
	register int	n;
	register uint	*lpfn_ptr;
	register uint	km_addr, index, pg_num;
	uint		saved_map = iomap_save();

	/* The lpfn_tbl used to be on a page table boundary, but this doesn't
	 * seem to be required, so I'm putting it on a pde boundary.  JPC
	 */

	sbus_config.lpfn_tbl = lpfn_ptr =
	  (uint *)km_allocate(num_pages * sizeof(pde_t), sizeof(pde_t));

	for (km_addr = MAINSTORE, n = num_pages; --n >= 0; km_addr += NBPP) {
		pg_num = pnum(km_addr);
		index = dpm40_mpfn_to_lpfn(pg_num);
		index = (index_fm_lpfn(index) * 0x100) + pg_fm_lpfn(index);
		*(uint *)km_map((uint)&lpfn_ptr[index]) = pg_num;
	}

	iomap_restore(saved_map);
#if 0
	register uint	km_addr, index;

	/* allocate lpfn table on next page table boundary */
	/* round km_used up to next page boundary */

	km_used = ((km_used + ((1 << BPTSHFT) - 1)) & ~((1 << BPTSHFT) - 1));
	sbus_config.lpfn_tbl =  km_used;
	km_used += num_pages * sizeof(pde_t);

	for (km_addr = MAINSTORE; km_addr != MAINSTORE + ctob(num_pages);
	  km_addr += NBPP) {
		index = dpm40_mpfn_to_lpfn(pnum(km_addr));
		index = ((index_fm_lpfn(index)*0x100) + pg_fm_lpfn(index))
			* sizeof(uint);
		*(uint *)km_map(sbus_config.lpfn_tbl + index) = pnum(km_addr);
	}
#endif
} /* lpfn_tbl_init */

/*
 * dpm40_ptbl() - build Kernel page tables
 */
static void
dpm40_ptbl()
{
	register pde_t	*pt_ptr;
	register int	km_addr;
	register uint	pages;
	register uint	saved_map = iomap_save();

	/*
	 * build kernel memory page tables
	 */

	 ASSERT(num_pages != 0); /* lpfn_init should be called by now */

	/* allocate memory page tables on next page table boundary */
	/* round km_used up to next page boundary */

	sbus_config.mem_ptbl = km_allocate(num_pages * sizeof(pde_t),
					(1 << BPTSHFT));

	/* first 8 pages before the Kernel */

 	pt_ptr = (pde_t *)sbus_config.mem_ptbl;
	for (km_addr = MAINSTORE; km_addr < ADDR_KERNEL; km_addr += NBPP)
		*((pde_t *) km_map(pt_ptr++)) =
			dpm40_km_to_pde(km_addr, PG_P|PG_R|PG_W|PG_CB);

	/* pages of the Kernel text */

	for (; km_addr < (uint)kernel_etext; km_addr += NBPP)
		*((pde_t *) km_map(pt_ptr++)) =
			dpm40_km_to_pde(km_addr, PG_P|PG_R|PG_X|PG_CB);

	/* pages from the data portion to the end of free space */
	for (; km_addr != MAINSTORE + ctob(num_pages); km_addr += NBPP)
		*((pde_t *) km_map(pt_ptr++)) =
			dpm40_km_to_pde(km_addr, PG_P|PG_R|PG_W|PG_CB);

#if 0 /* JPC: move this to iopm driver */
	build_iopm_pt();
#endif
	/* copy dpm's iomap to place everyone can use */
	dpm40_kv_iomap_public();

	dpm40_lpfn_tbl_init();

	iomap_restore(saved_map);
} /* dpm40_ptbl */

/*
 * dpm40_own -- Allocate ownseg areas for each processor
 *	this is the segment that contains the own stucture,
 *	per processor u area, and the current u area.
 */

static
dpm40_own()
{
    /*
     * Warning this code assumes that a segment table and
     * a page table will fit in one page.
     *
     * This code also assumes that the own structure will
     * fit in one page.
     * This code on System 90 assumes that USIZE is 1.
     * This code on System 95 no longer assumes that USIZE is 1.
     */
    register uint	sbus_slot;
    register sde_t	*st_ptr;
    register pde_t	*pt_ptr;
    register own_t	*own_ptr;
    register uint	pageno;
    uint		addr_qtbl, addr_stbl, addr_ptbl, addr_own_u, addr_own;
    uint		addr_extra_stk, addr_own_extra;
    register uint	saved_map = iomap_save();
    uint		pm_id = 0, base_pm_id, last_pm_id;
    int			num_pm;

    for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; 
	sbus_slot++, base_pm_id = 0) {

	if (!SBUS_IS_PM(sbus_config.slot_id[sbus_slot]))
		continue;

	/* figure out how many pm's to initialize in this slot */
	switch (sbus_config.slot_id[sbus_slot]) {
		case SBUS_DPM40_DBL :
			num_pm = 2;
			last_pm_id = pm_id + 1;
			break;
		case SBUS_DPM40_SGL :
			num_pm = 1;
			last_pm_id = pm_id;
			break;
		default : 
			panic("bad dpm40 slot id");		
	}

	base_pm_id = pm_id;

	while (--num_pm >= 0) {

	    /* allocate PM's own q-segment table on page boundary */
	    /* hanna FIX: doesn't need to be on pg bound, but ok for test */
	    addr_qtbl = sbus_config.pm_qtbl[pm_id] =
		    km_allocate( NBPQT, PGALIGN);

	    /* allocate PM's own segment table(s) on page boundary */
	    /* hanna FIX: doesn't need to be on pg bound, but ok for test */
	    /* WARNING: may allocate multiple tables, contiguously */
	    addr_stbl = sbus_config.pm_stbl[pm_id] =
		    km_allocate(KMEM_SIZE / NBPSE * sizeof(sde_t), PGALIGN);

	    /* allocate PM's own page table on page table boundary */
	    /* hanna FIX: doesn't need to be on pg bound, but ok for test */
	    addr_ptbl = km_allocate(NBPPT, PGALIGN);

	    /* allocate PM's extra system stack page */
	    addr_extra_stk = km_allocate(USIZE, PGALIGN);

	    /* allocate PM's extra own stack page */
	    addr_own_extra = km_allocate(USIZE, PGALIGN);

	    /* allocate PM's own u area on page boundary */
	    addr_own_u = km_allocate(USIZE, PGALIGN);
	    K_ASSERT(USIZE < NBPP);

	    /* allocate PM's own variable area on page boundary */
	    addr_own = km_allocate(sizeof(struct own), PGALIGN);
	    K_ASSERT(sizeof(struct own) < NBPP);

	    /* round up to next page boundary */
	    (void *) km_allocate(0, PGALIGN);

	    dpm40_utbls(addr_qtbl, addr_stbl);
	    st_ptr = (sde_t *) km_map(addr_stbl);

	    /*
	     * Fill in the entry for the own segment
	     */

	    st_ptr[snum(ADDR_OWN_SEGS-ADDR_OWN_SEGS)] =
	      dpm40_km_to_sde(addr_ptbl);



	    /* Now ready to set up each PM's own page table */

	    pt_ptr = (pde_t *) km_map(addr_ptbl);

	    for (pageno = 0; pageno != NPGPT; pageno++)
		    pt_ptr[pageno].pde_all = sbus_config.invalid_pde;

	    /*
	     * Subtract off ADDR_OWN_SEGS to obtain an address 
	     * referenced from 0 into the pagetable
	     * since segment starts at ADDR_OWN_SEGS
	     */

	    /* assign page used for own stbl and own ptbl */
	    pt_ptr[PNUM(ADDR_OWN_STBL - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_stbl, PG_P|PG_R|PG_W|PG_CB);

	    /* Page table may be on a different page than other tables */
	    pt_ptr[PNUM(ADDR_OWN_PTBL - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_ptbl & ~(PGALIGN-1), 
				    PG_P|PG_R|PG_W|PG_CB);

	    pt_ptr[PNUM(ADDR_OWN_QTBL - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_qtbl, PG_P|PG_R|PG_W|PG_CB);
	    /* The segment table may be greater than one page */
	    { /* local */
	       register uint tmp_addr = addr_stbl;
	       for (pageno = 0; 
		    pageno < ((KMEM_SIZE / NBPSE) * sizeof(sde_t)) / NBPP;
		    pageno++, tmp_addr+=NBPP)
			pt_ptr[PNUM(ADDR_OWN_STBL - ADDR_OWN_SEGS)+pageno] =
			    dpm40_km_to_pde(tmp_addr & ~(PGALIGN-1), 
					    PG_P|PG_R|PG_W|PG_CB);
		    
	    } /* local */

	    /* assign pages used for per processor u area */
	    pt_ptr[PNUM(ADDR_EXTRA_STK - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_extra_stk, 
			    PG_P|PG_R|PG_W|PG_CB);
	    pt_ptr[PNUM(ADDR_U - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_own_u, PG_P|PG_R|PG_W|PG_CB);
	    pt_ptr[PNUM(ADDR_OWN_EXTRA - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_own_extra, PG_P|PG_R|PG_W|PG_CB);
	    pt_ptr[PNUM(ADDR_OWN_U - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_own_u, PG_P|PG_R|PG_W|PG_CB);

	    /* assign page used for own variables */
	    pt_ptr[PNUM(ADDR_OWN - ADDR_OWN_SEGS)] =
		    dpm40_km_to_pde(addr_own, PG_P|PG_R|PG_W|PG_CB);

	    /* hanna FIX: set this up as pm_id */
	    sbus_config.pm_own[pm_id] = addr_own;

	    /* done with own page table, now ready to initialize own */

	    own_ptr = (own_t *) km_map(addr_own);
	    bzero((caddr_t)own_ptr, sizeof(*own_ptr));

	    own_ptr->o_qtbl = (qde_t *) addr_qtbl;
	    own_ptr->o_stbl = (sde_t *) addr_stbl;
	    own_ptr->o_pm_id = pm_id;
	    own_ptr->o_cur_root.rde_all = sbus_config.invalid_rde;
	    own_ptr->o_base_pm_id = base_pm_id;
	    own_ptr->o_last_pm_id = last_pm_id;
	    own_ptr->o_slot = sbus_slot;
	    own_ptr->o_lock_id = pm_id;
	    pm_id++;

	} /* while --- do once for each pm in slot */
    } /* for --- each slot */

    iomap_restore(saved_map);

} /* dpm40_own */



/*
 * dpm40_utbls - build kernel Upper level TaBLeS (q & s)
 * This assumes the kernel pagetables have been built at some given address.
 * Now the segment tables are built above it, starting at addr_stbl.
 * For sparc, the level above this is also built (an qtbl).
 * The address of qtbl is just after the filled stbl(s).
 */

static
dpm40_utbls(addr_qtbl, addr_stbl)
register uint	addr_qtbl;
register uint	addr_stbl;
{
	register uint	*st_ptr;
	uint	*st_save;
	xde_t	invalid_xde;
	register uint	segno;
	register uint	addr_pt;
	register uint	saved_map = iomap_save();
	register uint *qt_ptr;
	uint	*qt_save;
	qt_save = qt_ptr = (uint *)(addr_qtbl);


	st_save = st_ptr = (uint *)(addr_stbl);

	/*
	 * invalidate all entries in segment table
	 *
	 * Note: 68040 ( and sparc and 486) has multiple sde tables.
	 *       This code assumes 
	 *	 . the tables are contiguous 
	 * 	 . that the user has allocated enough for KMEM_SIZE
	 *	 . and that KMEM_SIZE fits evenly into these segment tables.
	 */ 
	invalid_xde.sde.sde_all = sbus_config.invalid_sde;
	for (segno = KMEM_SIZE/NBPSE; segno; segno--)
	    *((sde_t *)km_map(st_ptr++)) = invalid_xde.sde;

	/* 
	 * Fill in the  q- table.  
	 */
	 /* Invalidate the q- table before filling */
	invalid_xde.qde.qde_all = sbus_config.invalid_qde;
	for (segno = NEPQT; segno; segno--)
	   *((qde_t *)km_map(qt_ptr++)) = invalid_xde.qde;

	 /* Load the segment table addresses into the Kernel portion */
	qt_ptr = &qt_save[qnum(KMEM_START)];
	for (segno = KMEM_SIZE/NBPQE; segno; segno--, addr_stbl += NBPST)
	    *((qde_t *)km_map(qt_ptr++)) = dpm40_km_to_qde(addr_stbl);

	/*
	 * Fill in the entries for kernel memory
	 */
	st_ptr = st_save + snum(MAINSTORE - KMEM_START);
	addr_pt = sbus_config.mem_ptbl;
	for (segno = 0; segno != num_pages / NPGPT; segno++) {
		*((sde_t *)km_map(st_ptr++)) = dpm40_km_to_sde(addr_pt);
		addr_pt += NBPPT;
	}
	iomap_restore(saved_map);
} /* dpm40_utbls */


/* 
 * [rqsp]de <--> km conversion routines
 *
 * . General notes.
 *   . Each descriptor entry consists of:
 *     . various permissions/modes/status bits.
 *     . for [rqs]de's there are some unused bits (these should be 0).
 *     . an lpfn (in the fn field) with the granularity of 1 page (0x1000).
 *       For the higher level tables, there is an additional offset on the
 *       fn to point into the next level table (since the tables are smaller
 *       than one page.)
 *   . No other fields are set in the descriptor entry other than pfn.
 *     It is the responsibility of the caller to set these.
 * 
 * . Converting a kernel virtual address to a mmu descriptor entry
 *   . Compute the lpfn from the virtual address.
 *   . Shift this so it is left justified in the descriptor entry
 *     (via LPFN_XDE_SHFT)
 *   . If the descriptor entry points to a table that is less than 1 page
 *     (which is the granularity of the lpfn), then compute the additional
 *     offset according to the size of the table this descriptor points to
 *     (that is the size of the next level down, not its own level table).
 *     The bits for this additional offset are offset in the virtual addr
 *     by the shift of the tablesize in question.  The mask for this offset
 *     can be computed by taking the difference between the shifts of a 
 *     pagesize (the granularity of an lpfn) and the tablesize in question.
 *     The additional offset is added (or or'd in) to the fn field.
 * . Converting an mmu descriptor entry to a kernel virtual address.
 *     . Convert the lpfn portion of the descriptor to a km address.
 *       (Right justifying the lpfn by shifting right by LPFN_XDE_SHFT, 
 *        then calling the conversion routines).
 *       This yields a kernel virtual address aligned to a page boundary.
 *     . If the mmu entry is an upper level descriptor, the appropriate
 *       lower bits of the fn can be or'd in to the kernel address, reversing
 *       the translation described above. (Recalling that the conversion
 *       constants used are that for the next lower table, not the same
 *       level table as the descriptor).
 */


static uint
dpm40_rde_to_km(rde)
rde_t	rde;
{
    register uint km;

	/* compute virtual addr of page of the table */

    km = pfn_to_km(dpm40_lpfn_to_pfn(rde.rde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
    return(km + ((rde.rde.fn & ((1 << (PNUMSHFT - BQTSHFT)) - 1)) << BQTSHFT));

} /* dpm40_rde_to_km */

rde_t
dpm40_km_to_rde(km)
uint	km;
{
	rde_t	retval;

	ASSERT( !(km & ((1 << BQTSHFT) - 1)));

		/* compute lpfn of page and shift into position */
	retval.rde_all = dpm40_pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

		/* add in the offset to the table */
	retval.rde.fn += (km>>BQTSHFT) & ((1 << (PNUMSHFT - BQTSHFT)) - 1);
	return(retval);
}


static uint
dpm40_qde_to_km(qde)
qde_t	qde;
{
    register uint km;

	/* compute virtual addr of page of the table */
    km = pfn_to_km(dpm40_lpfn_to_pfn(qde.qde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
    return(km + ((qde.qde.fn & ((1 << (PNUMSHFT - BSTSHFT)) - 1)) << BSTSHFT));

}

static qde_t
dpm40_km_to_qde(km)
uint	km;
{
	qde_t	retval;

	ASSERT( !(km & ((1 << BSTSHFT) - 1)));

		/* compute lpfn of page and shift into position */
	retval.qde_all = dpm40_pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

		/* add in the offset to the table */
	retval.qde.fn += (km>>BSTSHFT) & ((1 << (PNUMSHFT - BSTSHFT)) - 1);

	retval.qde.u = 1;		/* avoid extra RMW cycle */
	retval.qde.udt = UDT_PRES;	/* assume present */

	return(retval);
}


static uint
dpm40_sde_to_km(sde)
sde_t	sde;
{
    register uint km;

	/* compute virtual addr of page of the table */
    km = pfn_to_km(dpm40_lpfn_to_pfn(sde.sde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
    return(km + ((sde.sde.fn & ((1 << (PNUMSHFT - BPTSHFT)) - 1)) << BPTSHFT));

}

static sde_t
dpm40_km_to_sde(km)
uint	km;
{
	sde_t	retval;

	ASSERT( !(km & ((1 << BPTSHFT) - 1)));

		/* compute lpfn of page and shift into position */
	retval.sde_all = dpm40_pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

		/* add in the offset to the table */
	retval.sde.fn += (km>>BPTSHFT) & ((1 << (PNUMSHFT - BPTSHFT)) - 1);

	retval.sde.u = 1;		/* avoid extra RMW cycle */
	retval.sde.udt = UDT_PRES;	/* assume present */

	return(retval);
}


uint
dpm40_pde_to_km(pde)
pde_t	pde;
{
	return(pfn_to_km(dpm40_lpfn_to_pfn(pde.pde_all >> LPFN_XDE_SHFT)));
}

/*
 * dpm40_build_page_table() - build all the tables
 */

void
dpm40_build_page_table()
{
	dpm40_invalid_tbl();	/* set up pointers to invalid entries */
	dpm40_ptbl();		/* build page tables */
	dpm40_utbls(ADDR_MEM_QTBL, ADDR_MEM_STBL);/* do upper segment tables */
	dpm40_own();
}


/*
 * dpm40_print_vtop
 *
 *	break down virtual address into translation components
 *	print root pointer, page table pointer, page descriptor.
 */
void
dpm40_print_vtop(addr, proc_addr)
uint	addr, proc_addr;
{
	uint	saved_map = iomap_save();
	own_t	*o;
	rde_t	rde;
	uint	r_kv;

	qde_t	qde;
	uint	q_kv = 0, q_offset = 0;

	sde_t	sde;
	uint	s_kv = 0, s_offset = 0;

	pde_t	pde;
	uint	p_kv = 0, p_offset = 0;

	uint	kv = 0;

	uint	addr_adj;
	uint	pm_id;
	int	not_booted = FALSE;
	uint	*root;

	rde.rde_all = 0;
	qde.qde_all = 0;
	sde.sde_all = 0;
	pde.pde_all = 0;

	if (kernel_not_booted())
		not_booted = TRUE;

	pm_id = dpm40_get_pm_id();

	if (not_booted)
		o = (own_t *)km_map((uint)sbus_config.pm_own[pm_id]);
	else
		o = dpm40_map_own();

	addr_adj = addr;


	/* get root pointer */
	if (proc_addr == 0) {
	    r_kv = sbus_config.pm_qtbl[pm_id];
	    rde = dpm40_km_to_rde(r_kv);

	} else {
	    copy_from_km(proc_addr+((uint)&((struct proc *)0)->p_urde), 
		&rde.rde_all, sizeof(rde_t));
	} /* if */

	/*  calulate offset within segment table */
	q_offset = qnum(addr_adj) * sizeof(qde_t);
	s_offset = SNUM(addr_adj) * sizeof(sde_t);
	p_offset = PNUM(addr_adj) * sizeof(pde_t);
	/* kernel virtual to base of segment table */
	q_kv = dpm40_rde_to_km(rde);

	/* get qde */
	q_kv = q_kv + q_offset;
	copy_from_km(q_kv, &qde.qde_all, sizeof(qde.qde_all));

	if (qde.qde.udt != UDT_PRES) {
	    printf("Q-level Pointer Not Present: %#x\n", qde.qde_all);
	    goto printout;
	} /* if */

	s_kv = dpm40_qde_to_km(qde);

	/* get sde */
	s_kv = s_kv + s_offset;
	copy_from_km(s_kv, &sde.sde_all, sizeof(sde.sde_all));

	/* get page table pointer */
	p_kv = dpm40_sde_to_km(sde);

	if (sde.sde.udt != UDT_PRES) {
	    printf("S-level Pointer Not Present: %#x\n", sde.sde_all);
	    goto printout;
	} /* if */

	/* get page table entry */
	p_kv += p_offset;
	copy_from_km(p_kv, &pde.pde_all, sizeof(pde.pde_all));
	
	if (pg_isvalid(&pde))
	    kv = dpm40_pde_to_km(pde);

printout:
	printf("%s Addr %8x maps to %8x\n", 
		(proc_addr)?"USER":"KERNEL", addr, kv);
	printf("rof:  %8x  qof:  %8x  sof: %8x pof: %8x\n",
		0, q_offset, s_offset, p_offset);
	printf("rkv:  %8x  qkv:  %8x  skv: %8x pkv: %8x\n",
		r_kv, q_kv, s_kv, p_kv);
	printf("rde:  %8x  qde:  %8x  sde: %8x pde: %8x\n",
		rde.rde_all, qde.qde_all, sde.sde_all, pde.pde_all);
	if (pde.pde.g)
	    printf("GLOBAL ");
	if (pde.pde.lock)
	    printf("NO_SWAP ");
	if (pde.pde.cw)
	    printf("C_O_W ");
	if (pde.pde.s)
	    printf("SYS_ONLY ");
	if (pde.pde.nocache)
	    printf("~");
	printf("CACHABLE ");
	if (pde.pde.mod)
	    printf("MOD ");
	if (pde.pde.ref)
	    printf("REF ");
	if (pde.pde.wp)
	    printf("~");
	printf("WRITABLE ");
	if (pde.pde.pres)
	    printf("PRES ");
	printf("\n");

	iomap_restore(saved_map);
} /* dpm40_vtop */
