/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) kv_iomap.c: version 25.1 created on 11/27/91 at 15:30:51	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)kv_iomap.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* add SCCS header here */

/*
 * kv_iomap.c
 */

#ifdef M68020
#undef M68020
#define M68040
#endif

#include "misc.h"
#include "sys/types.h"
#include "sys/pm_iomap.h"
#include "global.h"
#include "spm_debug.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/kmem.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "sys/immu.h"
#include "sys/lio.h"
#include "memstripe.h"

extern uint	scan_for_mem_board();

/* 
 * PM IO Map Routines for the 68040 Dual Processor Module
 *
 * A few notes for you:
 * . The following routines are used to initialize and manipulate numbers
 *   representing virtual and forms of physical addresses in the system.
 * . The 68040 has an iomap that represents the entire 4Gb address space
 *   (less some of the local space at the top).   Each map entry represents 1Mb.
 * . This differs from the 68020 map that covers only the 0xc0000000+ space.
 * . The first entries starting from 0 up to the number of mb's of memory
 *   boards are filled in by the spm.  This represents the area between
 *   0xa0000000-0xbfffffff.   The kernel will fill in the locations 
 *   mapping 0xc0000000-0xffffffff.  For now, point these locations at the 
 *   cpu boards corresponding address  (c00 --> c00 on that board).
 * . The 040 [rqsp]de entries contain lpfns, unlike the 020 which contain spfns.
 *   The conversion routines:
 *   . The conversion routes are shown below.  These differ from the 020, which
 *     looks something like mpfn--->spfn---->lpfn---->mpfn.
 *   . Striping is done at the conversion from mpfn to lpfn level.  
 *   . The lpfn can then be shifted into the mmu table entry.
 *   . To convert from an lpfn to an spfn, one indexes into the iomap to find
 *     the slot and board offset of the physical memory.
 *   . On the flip side, converting back to an lpfn, the adjust table is used.
 *   . And some "un"striping must be done goting back to the mpfn.
 *
 *                            [rqsp]de     sbus_u32
 *                                |    plus some vaddr bits
 *                                |           |
 *	vaddr -----> mpfn -----> lpfn -----> spfn -----> lpfn -----> mpfn
 *              |           |           |           |           |
 *            >>pageshift   |           |           |           |
 *                        stripe it     |           |           |
 *                       or walk mmu    |           |           |
 *                                  from iomap      |           |
 *                                             adjust tbl       |
 *                                                         unstripe it
 *
 * . Tell about difference in striping.  Not on a sorted by size basis.
 * 
 */

static uint	dpm40_kv_iomap_buf[0x1000];	/* SPM's copy of iomap */


/* 
 * dpm40_mpfn_to_lpfn
 * Modify a kernel virtual page frame number to a linear page frame number.
 * This step includes striping.
 */

uint
dpm40_mpfn_to_lpfn(mpfn)
register uint	mpfn;
{
	register MEM_STRIPE	*msp;
	register uint		s_level, s_page, s_offset;
	uint			s_board;

/* hanna DEBUG */if((mpfn < btoc(MAINSTORE)) || (mpfn > btoc(KIO_START)))printf("mpfn in MPFN_TO_LPFN out of range %#x\n", mpfn);
	K_ASSERT(mpfn >= btoc(MAINSTORE));
	K_ASSERT(mpfn < btoc(KIO_START));

	/* calculate which stripe level this page is on */
	msp = mem_stripe_tbl;
	for (s_level = MM_NUM_SIZES + 1; --s_level >= 0; msp++) {
		if ( msp->num_mm == 0 )
			break;
		if ( mpfn < msp->base_km )
			break;
	}
	if (--msp < mem_stripe_tbl || msp->num_mm == 0) {
		printf("dpm40_mpfn_to_lpfn: out of range! mpfn = 0x%x\n", mpfn);
		rtn_to_monitor();
	}
	/* calculate which page/board/offset in this stripe level */
	s_page = mpfn - msp->base_km;
	s_board = s_page % msp->num_mm;
	s_offset = s_page / msp->num_mm;
#ifdef BARBER_POLE
	{  /* local */
	int rotate;

	rotate = ( btoc(SRAM_SIZE) / msp->num_mm) * s_board;
	s_offset += rotate; 
	s_offset %= msp->pages_per_board;
	} /* local */
#endif
	return (msp->base_xpfn[s_board] + s_offset);
} /* dpm40_mpfn_to_lpfn */


/* 
 * dpm40_lpfn_to_spfn
 * Convert from a linear page frame addr to an sbus (system) page frame addr.
 * The lpfn contains the kv_iomap index (pointing to a megabyte of memory)
 *  and the page offset into that megabyte.
 * The kv_iomap contains the slot of the megabyte and the megabyte offset
 * into that slot.
 */
uint
dpm40_lpfn_to_spfn(lpfn)
uint	lpfn;
{
	int	index = index_fm_lpfn(lpfn);
	uint	sbus_slot = slot_fm_kv_iomap(&dpm40_kv_iomap_buf[index]);
	uint	mb_off = mb_to_spfn(mb_fm_kv_iomap(&dpm40_kv_iomap_buf[index]));

	    /* now assemble all the pieces together */
	return(slot_to_spfn(sbus_slot) | mb_off | pg_fm_lpfn(lpfn));
}


/* 
 * dpm40_spfn_to_lpfn
 * convert a system bus page frame number to the linear page frame number.
 */
uint
dpm40_spfn_to_lpfn(spfn) 
register uint spfn;
{
	register uint	sbus_slot = slot_fm_spfn(spfn);

	return(index_to_lpfn(sbus_slot)	/* kv_iomap map index */
		- sbus_config.pfn_adjust[sbus_slot] 
		+ (spfn & SPFN_MB_MASK)		/* which mb in that slot */ 
		+ pg_fm_spfn(spfn));	/* page offset into that Mb */

} /* dpm40_spfn_to_lpfn */




/* 
 * dpm40_lpfn_to_mpfn
 */
uint
dpm40_lpfn_to_mpfn(lpfn) 
uint	lpfn;
{
	register MEM_STRIPE	*msp;
	register uint		s_level, i; 
	register uint		mem_entry_index = lpfn & LPFN_INDEX_MASK; 
	register uint		page_off = pg_fm_lpfn(lpfn);
	uint			mpfn, mb_offset;

		/* Get to the ballpark */
	/* Find the first greatest base_lpfn less or equal to your lpfn */
	msp = mem_stripe_tbl;
	for (i = msp->num_mm; i; ) 
		if ( msp->base_xpfn[--i] <= mem_entry_index)
			break;

	/* how many megabytes away from that base lpfn is it? */
	mb_offset = mem_entry_index - mem_stripe_tbl[0].base_xpfn[i];

	/* counting the offset from the first base tells which stripe it's on */
	for (s_level=0; msp->num_mm != 0; s_level++, msp++) {
		if (mb_offset >= msp->mb_per_lpfn / 0x1000)  
			mb_offset -= msp->mb_per_lpfn / 0x1000;
		else {
			break;
		}
	} /* for */

	/* now, find the index of the base lpfn in this stripe */
	for (i = msp->num_mm; i; )
		if (msp->base_xpfn[--i] <= mem_entry_index)
			break;

	mb_offset =  mem_entry_index - msp->base_xpfn[i];

	return (msp->base_km
		+ (msp->num_mm * page_off)
		+ (mb_offset * msp->num_mm)
		+ i);
} /* dpm40_lpfn_to_mpfn */


/* 
 * dpm40_mpfn_to_spfn
 * Modify a page frame number to an sbus (or system) page frame number.
 */
uint
dpm40_mpfn_to_spfn(mpfn)
uint	mpfn;
{
	return (dpm40_lpfn_to_spfn(dpm40_mpfn_to_lpfn(mpfn)));
}




/*
 * dpm40_lpfn_init() - initialize the page frame adjustment and
 *		 linear page frame end factors.
 *
 * setup sbus_config structure for pfn_adjust's
 *
 * hanna FIX: questions:
 * 	we shift by slot by 8, not 20 --- why. to put in lpfn map index area?
 */

static void
dpm40_lpfn_init()
{
	register uint	sbus_slot;
	register uint	lpfn, spfn;

	lpfn = 0;

	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {
		spfn = sbus_slot << 8;
		sbus_config.pfn_adjust[sbus_slot] = spfn - lpfn;
		lpfn += sbus_config.slot_size[sbus_slot] / NBPP;
		sbus_config.lpfn_end[sbus_slot] = lpfn;
	} /* for */

	/* WARNING: side effect. global variable, num_pages, set here */
	num_pages = lpfn;
} /* lpfn_init */


/* 
 * dpm40_kv_iomap_init (and dpm40_kv_iomap_set)
 * Master IO Map Initialization
 * Starting at index 0 in the master io map, assign an entry for each
 * megabyte of memory board, starting from the memory board in the 
 * lowest slot, on up.
 * This will map the kernel virtual memory range of 0xa0000000-0xbfffffff.
 * Set the area between the end of the memory modules to 0xc0000000 to be
 * invalid (pointing at the own slot). 
 * Set the area between 0xc0000000 to 0xff000000 also to be invalid. the
 * kernel will set this up for io with other boards.
 * Set the area between 0xff000000 and 0xffffffff to point to the board's
 * own corresponding address.
 */

void
dpm40_kv_iomap_init()
{
    register uint	slot, mem_slot;
    register uint	mb;
    register uint	offset, oldmap;
    register uint	kv_iomap_index = 0;
    uint	entry;
    register uint *	mbptr;


    /* 
     * "zero" out the entire kv_iomap array.
     */

    entry = 0;			/* slot = 0, offset = 0. real slot set later */
    clr_valid_kv_iomap(&entry);
    for (mbptr = dpm40_kv_iomap_buf; mbptr < dpm40_kv_iomap_buf+KV_IOMAP_NUM_MB;
	  mbptr++) 
	*mbptr = entry;

    /*
     * for each of the memory cards fill in the slots for each Mb,
     * starting with the first card and the first slot in the map.
     */

    for ( slot = 0; slot < SBUS_NUM_SLOT; slot++ ) {
	if (  sbus_config.slot_id[slot] == SBUS_MM ) { 

	    /* note base index of board for later striping */
	    mem_mm_i[slot] = kv_iomap_index; 

		/* fill an entry for every megabyte on this board */
	    for (mb = 0; mb < (sbus_config.slot_size[slot] / 0x100000); 
		    mb++, kv_iomap_index++) {

		dpm40_kv_iomap_buf[kv_iomap_index] = slot_to_kv_iomap(slot) | 
					   mb_to_kv_iomap(mb);
		set_valid_kv_iomap(&dpm40_kv_iomap_buf[kv_iomap_index]);

	    } /* for */
	} /* if */
    } /* for */

    /* go find a place to stash the table */
    /* initialize it once and update with each call */
    mem_slot = scan_for_mem_board();

    /* actually, any old offset will do */
    offset=sbus_config.slot_size[mem_slot]-(KV_IOMAP_NUM_MB*sizeof(uint));

    oldmap = iomap_save();
    for ( slot = 0; slot < SBUS_NUM_SLOT; slot++ )
	if (  SBUS_IS_PM(sbus_config.slot_id[slot]) ) 
	    dpm40_kv_iomap_set(slot, mem_slot, offset);

#if 0  /* hanna DEBUG take out cleanup for debugging */
    /* now clean up your mess */
    for (mb = 0; mb < KV_IOMAP_NUM_MB;  mb++)
	*(uint *)iomap(mem_slot, offset+(mb*sizeof(uint))) = 0;
#endif /* hanna DEBUG take out cleanup for debugging */

    iomap_restore(oldmap);

} /* dpm40_kv_iomap_init */





/* 
 * dpm40_mem_stripe_init
 * Set up a data structure that describes memory such that no
 * contiguous two pages are on the same memory board.
 * This differs from the 68020 version in that memory on any given
 * stripe level is not allocated according to the largest board first,
 * rather in sorted ascending order by slot. 
 * (This makes conversion of lpfn_to_mpfn much easier on the 68040)
 * Also, the 040 uses a base lpfn, not base spfn, since the striping is used
 * to convert to and from an lpfn (not spfn as on the 68020).
 * Also, to help in the conversion, another field has been added to describe
 * the stripe size.
 */

uint
dpm40_mem_stripe_init()
{
	register MEM_STRIPE	*msp;
	register uint		i, num_mm = 0;
	register uint		base_km, board_offset;
	register uint		s_num_board;
	uint			s_size, s_level;

	if (did_mem_stripe)
		return (0);

	dpm40_lpfn_init();	/* first, set up pfn_adjust, etc */
	dpm40_kv_iomap_init();	/* then, initialize the dpm40's iomap */

	for (i = 0; i < SBUS_NUM_SLOT; i++)
		if (sbus_config.slot_id[i] == SBUS_MM) {
			mem_sizes[num_mm] = sbus_config.slot_size[i];
			mem_slots[num_mm] = i;
			num_mm++;
		} /* for */

	if (num_mm == 0) {
		printf("No memory boards found -- cannot boot!\n");
		return(1);
	}

	/* set all pm_own pointers to point to a bad address */
	for (i = 0; i < SBUS_MAX_NUM_PM; i++)
		sbus_config.pm_own[i] = ADDR_OWN_BAD;

	board_offset = s_level = 0;
	base_km = ADDR_MEM_SEGS;
	msp = mem_stripe_tbl;

	for ( ; ; ) {

		s_num_board = 0;

		s_size = 0;

		/* find the minimum sized board in the set */
		for ( i = 0; i < num_mm; i++ ) {
		    if (!mem_sizes[i])
			continue;
		    if ((s_size > mem_sizes[i]) || (s_size == 0))
			s_size = mem_sizes[i];
		} /* for */

		if (s_size == 0) { /* must be all done */
#ifdef MEM_STRIPE_DEBUG
			msp = mem_stripe_tbl;
			s_level = 0;
			for ( ; s_level <= MM_NUM_SIZES; msp++, s_level++) {
				if (msp->num_mm == 0)
					break;
				printf("lvl %d: num=%2d, base=%#x, mb=%#x\n", 
				  s_level, msp->num_mm, msp->base_km,
				  msp->mb_per_lpfn);
				for (i = 0; i < msp->num_mm; i++)
					printf("  slot=%#x, base_pfn=%#x\n", 
					  i, msp->base_xpfn[i]);
			}
			delay(500);
#endif /* MEM_STRIPE_DEBUG */
			did_mem_stripe = 1;
			return(0);
		}

		for ( i = 0; i < num_mm; i++ ) {

			if ( mem_sizes[i] == 0 )
				continue;

			mem_sizes[i] -= s_size;

			msp->base_xpfn[s_num_board++] = 
			 index_to_lpfn(mem_mm_i[mem_slots[i]]) 
			  + pnum(board_offset);
		} /* for */

		msp->num_mm = s_num_board;
		msp->mb_per_lpfn = s_size;
		msp->base_km = pnum(base_km);
#ifdef BARBER_POLE
		msp->pages_per_board = btoc(s_size);
#endif
		base_km += s_size * s_num_board;
		board_offset += s_size;
		s_level++;
		msp++;
	} /* for -- ever */
} /* mem_stripe_init */

/* dpm40_kv_iomap_set copies the master kv_iomap from spm's data space to 
 * someplace out on a memory card.  On the way, it sets invalid map 
 * entries and the local area entries to point to the pm's own slot.
 */
dpm40_kv_iomap_set(pm_slot, mem_slot, offset) 
uint pm_slot;
uint mem_slot;
uint		* offset;
{
    register uint	kv_iomap_index = 0;
    uint		entry;
    uint		* index;
    register uint *	mbptr;
    uint		mb;


/* hardware folks have got a couple little kludges here:
 * The first map entry must be set valid.
 *	No worries here, mate.  We started mapping our memory cards 
 *	beginning at the 0'th entry, so it be valid.
 * Any invalid map entries should be set invalid, but the address field
 * should also point to some address that is not an empty slot.
 *	Ok. how about the pm's own slot with offset 0!
 */

    /* set up the area between valid mapped boards and 0xc0000000   */
    /* these will always be invalid, and point to the pm's own slot */
    for (mbptr = dpm40_kv_iomap_buf;
		mbptr < dpm40_kv_iomap_buf+KV_IOMAP_IO_INDEX; 
		mbptr++)
	if (!is_valid_kv_iomap(mbptr))
	    set_slot_kv_iomap(mbptr, pm_slot);

    /* set up area between 0xc0000000 - 0xff000000 to be invalid also     */
    /* the kernel may set up this area later to point to other bds for io */
    for (mbptr = (dpm40_kv_iomap_buf+KV_IOMAP_IO_INDEX); 
		mbptr < (dpm40_kv_iomap_buf+KV_IOMAP_LOCAL_INDEX); mbptr++)
	set_slot_kv_iomap(mbptr, pm_slot);

    /* set up the area between 0xff000000 and the don't care slots   */
    /* set these to point to your own board and the corresponding Mb */
    for (mbptr = dpm40_kv_iomap_buf+KV_IOMAP_LOCAL_INDEX,
	 mb = PM_ROM_START/0x100000; 
		mbptr < dpm40_kv_iomap_buf+KV_IOMAP_UNUSED_INDEX; mbptr++, mb++) {
	set_slot_kv_iomap(mbptr, pm_slot);
	set_mb_kv_iomap(mbptr, mb);
	set_valid_kv_iomap(mbptr);
    } /* for */

    /*
     * now set the last unused 32 entries. It wants the entry set valid, but
     * doesn't care about the slot or mb offset
     * so set it to my own slot with zero offset.
     */
    entry = 0; 
    set_valid_kv_iomap(&entry);
    set_slot_kv_iomap(&entry, pm_slot);
    for (mbptr = dpm40_kv_iomap_buf + KV_IOMAP_UNUSED_INDEX; 
	     mbptr < (dpm40_kv_iomap_buf + KV_IOMAP_NUM_MB); mbptr++)
	*mbptr = entry;

    for (mbptr = dpm40_kv_iomap_buf, index = offset; 
	     mbptr < (dpm40_kv_iomap_buf + KV_IOMAP_NUM_MB); mbptr++, index++) {
	*(uint *)iomap(mem_slot, index) = *mbptr;
    } /* for */

    /* 
     * Now send it off to the board via an ipcc command.
     */
    dpm40_send_map_data(pm_slot, mem_slot, offset, PM_MAP_SIZE);
    
 
} /* kv_iomap_set */


#if 0	/* JPC: seems to be unused */
/* 
 * dpm40_km_to_sbus_u32
 * Translate a kernel virtual memory address (between 0xa0000000-0xbfffffff)
 * to a 32 bit version of a system bus address.
 * Basically, an sbus_u32 address is an spfn, slid left to make room for
 * offset information in the lower 8 bits.
 * The result is 16 byte aligned.  That is, the bottom 4 bits are lost.
 */
uint
dpm40_km_to_sbus_u32(km)
uint km;
{
	return(spfn_to_sbus_u32(
		dpm40_lpfn_to_spfn(dpm40_mpfn_to_lpfn(pnum(km)))) |
	  ln_to_sbus_u32(ln_fm_vaddr(km)));
}


/* 
 * dpm40_sbus_u32_to_km
 * Translate a 32 bit version of a system bus address to a kernel 
 * virtual memory address (between 0xa0000000-0xbfffffff)
 * Basically, an sbus_u32 address is an spfn, slid left to make room for
 * offset information in the lower 8 bits.
 * The result is 16 byte aligned.  That is, the bottom 4 bits are zero.
 */
uint
dpm40_sbus_u32_to_km(sbus_u32) 
uint sbus_u32;
{
	return(mpfn_to_vaddr(dpm40_lpfn_to_mpfn(dpm40_spfn_to_lpfn(
		spfn_fm_sbus_u32(sbus_u32)))) |
	       ln_to_vaddr(ln_fm_sbus_u32(sbus_u32)));
}
#endif /* 0 */

/* 
 * dpm40_kv_iomap_public
 * After memory has been all set up, striped, and the kernel downloaded,
 * take some of the space before the pagetables and make a copy of the
 * dpm's iomap table for use by the iopm.
 * Point to it with spm_mem.kv_iomap.
 * (Is there a better way???)
 */
dpm40_kv_iomap_public()
{
	uint	*base_vaddr;

	base_vaddr = (uint *)km_allocate(
	  (KV_IOMAP_NUM_MB - KV_IOMAP_IO_INDEX) * sizeof(uint), PGALIGN);
	sbus_config.kv_iomap = base_vaddr; /* should this be sbus addr ? */
	copy_to_km((uchar *)dpm40_kv_iomap_buf, (uchar *)base_vaddr,
	  (KV_IOMAP_NUM_MB - KV_IOMAP_IO_INDEX) * sizeof(uint));
} /* dpm40_kv_iomap_public */
