/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tdb.c: version 25.1 created on 11/27/91 at 15:30:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tdb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * tdb.c -- Tiny DeBugger code
 */

#include "sys/types.h"
#include "spm_debug.h"
#include "sys/sbus.h"
#include "sys/spm_mem.h"
#include "misc.h"
#include "spm.h"
#include "menu.h"
#include "rtc.h"
#include "cpu_method.h"
#include "slotdefs.h"
#include "ctype.h"

extern uint 	save_char_flag,
		pm_booting_done,
		kernel_entry_point,
		tdb_check_state,
		unix_console_mode;

extern char	*comm_args[];
extern int	mref_siz;


extern struct	sbus_config;

extern void	PM_start();

BRK_TAB	brk_tab[NUM_BREAKPOINTS + 1];	/* 1 extra for temporarry brk */



stop()
{
	if ( kernel_not_booted() )
		return;
	tdb_check_state = 0;
	cpu_all_stop();
	save_char_flag = 0;	/* stop saving output in review buffer */
}

step()
{
	if (kernel_not_booted())
		return;
	CPU_step();
	CPU_brkpt_check();
	CPU_show_trap();
}

jump()
{
	if (kernel_not_booted())
		return;
	CPU_jump();
	CPU_brkpt_check();
	CPU_show_trap();
}

go()
{
	/* check if kernel is booted, return if it is */
	if( ! pm_booting_done) {
		PM_start();
		return;
	}

	if (!cpu_all_prepare_to_go())
		return;
	cpu_all_go();
	save_char_flag = 1;	/* start saving ouput again */
	tdb_check_state = HZ/4 + 1;/* re-enable spm searching for stopped pms */
}

pm_tag_check(arg_cnt)
int	arg_cnt;
{
	uint	saved_flag;

	if (arg_cnt && !cpu_set_slot(comm_args[1], 0))
		return;

	saved_flag = save_char_flag;
	save_char_flag = 0;

	CPU_check_tags();
	save_char_flag = saved_flag;
}

pm_backtrace(arg_cnt)
int	arg_cnt;
{
	if (arg_cnt == 0 || cpu_set_slot(comm_args[1], 0)) /* slot | no arg */
		CPU_backtrace(0);
	else
		CPU_backtrace(Atox(comm_args[1])); /* arg is frame pointer */
}

pm_showtrap(arg_cnt)
int	arg_cnt;
{
	uint	saved_flag;

	if (arg_cnt && !cpu_set_slot(comm_args[1], 0))
		return;

	saved_flag = save_char_flag;
	save_char_flag = 0;

	CPU_show_trap();
	save_char_flag = saved_flag;
}

/*
 * check with each cpu and see if it has stopped since the last GO command
 */

check_tdb()
{
	if (tdb_check_state == 0)
		return;		/* timer turned off */
	if (--tdb_check_state)
		return;		/* timer still has time left */

	if (!cpu_all_check_tdb()) {
		tdb_check_state = HZ/4 + 1;	/* try again later */
		return;
	}

	/* found something */
	cpu_all_stop();

	/* if the panic_slot is -1, then the panic is from a pm
	 * and the location information will be in panic_pm_id,
	 * otherwise the information is in panic_slot.
	 */
	if (Spm_Mem->panic_flag)
		if (Spm_Mem->panic_slot == -1)
			cpu_set_slot(0, sns_fm_pm_id(Spm_Mem->panic_pm_id));
		else
			cpu_set_slot(0, 
				MAKE_SNS(Spm_Mem->panic_slot, NO_SUB_SLOT));

	CPU_brkpt_check();

	if (!Spm_Mem->panic_flag)
		CPU_show_trap();
	save_char_flag = 0;
	unix_console_mode = 0;
}


/*
 * bp:
 *
 * with 1 arg, set a kernel breakpoint:
 *
 * with no args, display breakpoints.
 *
 */


bp(arg_cnt)
int	arg_cnt;
{
	if (arg_cnt == 0) {
		printf("Breakpoints active:\n");
		cpu_all_display_brkpts();
		return;
	}
	CPU_set_brkpt(Atox(comm_args[1]));
}

/*
 * clear
 *
 *	no arg: clear all breakpoints.
 *
 *	otherwise look for a breakpoint with pc == arg.
 */

clear(arg_cnt)
int	arg_cnt;
{
	if ( arg_cnt == 0 ) {
		printf("Clearing all breakpoints\n");
		cpu_all_clear_brkpts();
		return;
	}
	CPU_clear_one_brkpt(Atox(comm_args[1]));
}

BRK_TAB	*
bp_search(id, pc)
void	*id;
uint	pc;
{
	register BRK_TAB	*bptr;

	for (bptr = brk_tab; bptr != brk_tab + NUM_BREAKPOINTS; bptr++)
		if (bptr->unique_id == id && bptr->pc == pc)
			return(bptr);
	return(NULL);
}

/* FIX joe, move to dev.c */
/* get_unum(char *str, uint *unum) - extract an unsigned integer form a string. 
 *	PARAMS  1. The string to be parsed.
 *		2. A uint pointer where the number is placed.
 * 	RETURNS 1. a pointer to first non-digit.
 *		2. unum is set to the parsed out number.
 *	NOTE: returns NULL if strtol cannot convert a number or if str is NULL.
 */
char *
get_unum(str, unum)
char	*str;
uint	*unum;
{
	char	*p = str;

	if (str == NULL || !isdigit(*str) ||
	    ((*unum = strtol(str, &p, 10)) == 0 && p == str))
		return (NULL);
	return (p);
}

set_tdb_slot(arg_cnt)
int	arg_cnt;
{
	if (arg_cnt == 0 || cpu_set_slot(comm_args[1], 0))
		CPU_display_slot();
}

/*
 * tdb_display_kernel -- display cpu view of memory with optional byte count
 */

tdb_display_kernel(arg_cnt)
int	arg_cnt;
{
	register uint	kaddr, show_cnt, num;

	kaddr = Atox(comm_args[1]);

	if (arg_cnt == 2)
		show_cnt = (Atox(comm_args[2]) + sizeof(long)-1) / sizeof(long);
	else
		show_cnt = 0x7ffffffff;

	line_limit_set(20);
	while (show_cnt && line_limit_use(1)) {
		num = (show_cnt < 4) ? show_cnt : 4;
		show_kern_mem(kaddr, num, 1);
		kaddr += num * sizeof(long);
		show_cnt -= num;
	}
}

kernel_not_booted()
{
	if ( ! pm_booting_done ) {
		printf("Kernel is not booted yet.\n");
		return(1);
	}
	return(0);
}

/*
 * tdb_change_kernel -- interactively change memory via pm.
 */

tdb_change_kernel()
{
	register uint	kaddr;
	uint		val;
	char		input[80];

	kaddr = Atox(comm_args[1]);

	switch(mref_siz) {
	default:
	case 'l':
		val = CPU_get_long(kaddr);
		printf("%08x: %08x   -> ", kaddr, val);
		break;
	case 'w':
		val = CPU_get_short(kaddr);
		printf("%08x: %04x   -> ", kaddr, val);
		break;
	case 'b':
		val = CPU_get_byte(kaddr);
		printf("%08x: %02x   -> ", kaddr, val);
		break;
	}

	if ( getnum(input, &val) == -1 )
		return;

	switch(mref_siz) {
	default:
	case 'l':
		CPU_put_long(kaddr, val);
		break;
	case 'w':
		CPU_put_short(kaddr, val);
		break;
	case 'b':
		CPU_put_byte(kaddr, val);
		break;
	}
}

/*
 * tdb_change_register -- interactively change pm's register contents
 */

tdb_change_register()
{
	uint		reg_val;
	char		input[80];

	reg_val = CPU_get_named_reg(comm_args[1]);
	printf("%s: %08x   -> ", comm_args[1], reg_val);

	if (getnum(input, &reg_val) != -1 )
		CPU_put_named_reg(comm_args[1], reg_val);
}


/*
 * kill_proc -- send a signal to a process
 */

kill_proc(arg_cnt)
int	arg_cnt;
{
	register int	sig = SIGTERM, pid, arg;

	if (kernel_not_booted())
		return;

	for (arg = 1; arg <= arg_cnt; arg++) {
		pid = atoi(comm_args[arg]);
		if (pid < 0 && arg == 1) {
			sig = -pid;
			pid = atoi(comm_args[++arg]);
		}

		printf("Proc %d:  ", pid);
		pid = spm2kern_cmd(S2K_KILL_PROC, sig, pid);
		printf("%s\n", pid ? "Killed" : "Not found");
	}
}

/*
 * kern_func -- call a kernel function with up to 3 arguments
 *
 *	NOTE: this function will be called with an interrupt context!
 */

kern_func(arg_cnt)
int	arg_cnt;
{
	uint	reply, arg1, arg2, arg3;

	if (kernel_not_booted())
		return;

	arg1 = arg2 = arg3 = 0;

	switch (arg_cnt) {
	case 4:
		arg3 = Atox(comm_args[4]);
	case 3:
		arg2 = Atox(comm_args[3]);
	case 2:
		arg1 = Atox(comm_args[2]);
	case 1:
		break;
	default:
		return;
	}
	reply = spm2kern_cmd(S2K_CALL_FUNC, Atox(comm_args[1]),
	  arg1, arg2, arg3);

	printf("Function return value = %d (0x%x)\n", reply, reply);
}

extern int	show_own(), show_u(), u_page_trace(), ps(), disp_save_buf();
extern int	k_link(), pm_dis(), history();

struct init_menu i_tdb[] = {
 { "own",	"<slot</subslot>>- Show own structure",
   MF_EXPERT | MF_POSTBOOT, 0, 1, show_own },
 { "u",		"<slot</subslot>>- Show u structure",
   MF_EXPERT | MF_POSTBOOT, 0, 1, show_u },
 { "utrace",	"kern_addr- u_rsav regs & upage stack trace",
   MF_EXPERT | MF_POSTBOOT, 1, 1, u_page_trace },
 { "ps",	"- ps -el",  MF_POSTBOOT, 0, 0, ps },
 { "slot",	"<sbus_slot</subslot>>- display/change the default tdb slot",
   MF_EXPERT, 0, 1, set_tdb_slot },
 { "review",	"- display the printf buffer",
   0, 0, 0, disp_save_buf },
 { "tags",	"<slot</subslot>>- ask PM in slot to check cache tags",
   MF_EXPERT | MF_POSTBOOT, 0, 1, pm_tag_check },
 { "link",	"kern_addr offset(bytes) <count>- follow a linked list",
   MF_EXPERT, 2, 3, k_link },
 { "ba(cktrace)", "<fp|slot</subslot>>- backtrace, with slot or frame ptr",
   MF_EXPERT | MF_POSTBOOT, 0, 1, pm_backtrace },
 { "showtrap",	"<slot</subslot>>- ask PM in slot to print out state info",
   MF_EXPERT | MF_POSTBOOT, 0, 1, pm_showtrap },
 { "stop",	"- stop all PMs", MF_EXPERT | MF_POSTBOOT, 0, 0, stop },
 { "go",	"- restart all PMs", MF_EXPERT, 0, 0, go },
 { "step",	"- single step stopped processor",
   MF_EXPERT, 0, 0, step },
 { "jump",	"- step over subroutine",
   MF_EXPERT, 0, 0, jump },
 { "bp",	"<addr>- set a breakpoint/display breakpoints",
   MF_EXPERT, 0, 1, bp },
 { "clear",	"<bp_addr>- clear one or all breakpoints",
   MF_EXPERT, 0, 1, clear },
 { "dk",	" addr <count>- display pm view of memory",
   MF_EXPERT | MF_POSTBOOT, 1, 2, tdb_display_kernel },
 { "fk<.[bwl]>", " addr- change memory from pm",
   MF_EXPERT | MF_POSTBOOT, 1, 1, tdb_change_kernel },
 { "fr",	" register_name - change pm register value",
   MF_EXPERT | MF_POSTBOOT, 1, 1, tdb_change_register },
 { "dis",	" addr <count>- disassemble at addr",
   MF_EXPERT, 1, 2, pm_dis },
 { "hi(story)",	" <count>- show command history",
   0, 0, 1, history },
 { "kill",	"[sig_num] pid...- send sig_num (default SIGTERM) to pid",
   MF_EXPERT | MF_POSTBOOT, 1, 15, kill_proc },
 { "kfunc",	"func_addr [arg ...] - call kernel func with up to 3 args",
   MF_EXPERT | MF_POSTBOOT, 1, 4, kern_func },
 { 0 }
};
