/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) kdebug.c: version 25.1 created on 11/27/91 at 15:30:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)kdebug.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* kdebug.c */

#include "sys/types.h"
#include "spm_debug.h"
#include "sys/user.h"
#include "sys/kmem.h"
#include "sys/immu.h"
#include "sys/spm_mem.h"
#include "sys/param.h"
#include "sys/region.h"
#include "sys/sysmacros.h"
#include "sys/proc.h"
#include "sys/tty.h"
#include "sys/sbus_pm.h"
#include "sys/signal.h"
#include "sys/stat.h"
#include "sys/var.h"
#include "sys/sbus.h"
#include "sys/lio.h"
#include "sys/spm_mem.h"
#include "ctype.h"
#include "misc.h"
#include "global.h"
#include "spm.h"
#include "novram.h"
#include "menu.h"
#include "rtc.h"
#include "cpu_method.h"

char	*dis_en_abled[] = { "disabled", "enabled" };
char	*off_on_str[] = { "off", "on" };

extern struct sbus_config;
extern uint	next_symbol;

extern char	*symstr();

show_own(arg_cnt)
int	arg_cnt;
{
	if (arg_cnt == 0 || cpu_set_slot(comm_args[1], 0))
		CPU_display_own();
} 

show_u(arg_cnt)
int	arg_cnt;
{
	register uint	addr, *up, uaddr;
	user_t		u;

	if (arg_cnt > 0 && !cpu_set_slot(comm_args[1], 0))
		return;

	up = (uint *)&u;

	addr = uaddr = CPU_get_u_addr();
	for ( ; addr <= uaddr + sizeof(u) - sizeof(uint); addr += sizeof(uint))
		*up++ = CPU_get_long(addr);

	display_u(&u);
} 

display_u(up)
register user_t	*up;
{
	register uint	*addr;
	register int	n;

	printf("comm: %.14s psargs: %.50s\n", up->u_comm, up->u_psargs);
	printf("acflag  %08x  segflg   %08x  error %08x  base    %08x\n",
	  up->u_acflag, up->u_segflg, up->u_error, up->u_base, up->u_count);
	printf("count   %08x  offset   %08x  u_ap  %08x  u_procp %08x\n",
	  up->u_count, up->u_offset, up->u_ap, up->u_procp);
	printf("fmode   %08x  caddrflt %08x  comp  %08x  nextcp  %08x\n",
	  up->u_fmode, up->u_caddrflt, up->u_comp, up->u_nextcp);
	printf("syscall %08x  uid      %08x  gid   %08x  ruid    %08x\n",
	  up->u_syscall, up->u_uid, up->u_gid, up->u_ruid);
	printf("rgid    %08x  r_val1   %08x  rval2 %08x  u_fmode %08x\n",
	  up->u_rgid, up->u_r.r_reg.r_val1, up->u_r.r_reg.r_val2, up->u_fmode);
	printf("d2: ");
	for (n = 6, addr = (uint *)up->u_rsav; --n >= 0; )
		printf("%s%s", symstr(*addr++), ((n > 0) ? ", " : "\na2: "));
	for (++addr, n = 4; --n >= 0; )
		printf("%s, ", symstr(*addr++));
	for (n = 2; --n >= 0; )
		printf("0x%08x%s", *addr++, ((n > 0) ? ", " : "\n"));
	printf("pc: %s\n", symstr(up->u_rsav[6]));
}

static char	states[] = "-SRZTIOXsU!\"#$%&()*+,./[\\]^{|}~";

ps()
{
	register uchar	*mem_ptr;
	register int	i;
	proc_t		prc;
	struct var	v;

	if ( kernel_not_booted() )
		return;
	if (!is_kern_addr(Spm_Mem->ksym_v) ||
	    !is_kern_addr(Spm_Mem->ksym_proc)) {
		printf("kernel not ready for ps yet.\n");
		return;
	}

	/* load up v struct */
	copy_from_km(Spm_Mem->ksym_v, (caddr_t)&v, sizeof(v));

	/* Locate proc table */
	mem_ptr = (unsigned char *)Spm_Mem->ksym_proc;

	printf(" F S   UID   PID  PPID  C PRI NI     ADDR     SZ    WCHAN TTY     TIME COMD\n");
	/* determine which processes to print info about */
	for (i = 0; i < v.v_proc; i++) {
		copy_from_km(mem_ptr, (caddr_t)&prc, sizeof(prc));
		mem_ptr += sizeof(prc);

		switch (prc.p_stat) {
		case 0:
		/* SIDL: intermediate state in process creation  */
		/* if SIDL then user block address may be bad or */
		/*	contents of user block may be residue	 */
		case SIDL:
			continue;
		case SZOMB:
			przom(&prc);
			break;
		default:
			prcom(&prc);
		}
		printf("\n");
		if (get_possible_char() >= 0)
			break;			/* press any key to stop */
	}
}

prcom(p)			/* print info about the process */
register proc_t	*p;
{
	long		tm;
	struct user	u;

	/* get u page */
	copy_from_km(p->p_userp, (caddr_t)&u, sizeof(u));

	printf("%2x %c", p->p_flag & 0xff, (p->p_stat == SONPROC ?
	  p->p_running + '0' : states[p->p_stat]));	/* F S */
	printf("%6u", p->p_uid);
	printf("%6u", p->p_pid);			/* PID */
	printf("%6u%3d", p->p_ppid, p->p_cpu & 0xff);	/* PPID CPU */
	printf("%4d%3d", p->p_pri, p->p_nice);		/* PRI  NICE */
	printf("%9x%7d", p->p_userp, p->p_size);
	if (p->p_wchan)
		printf("%9x", p->p_wchan);		/* WCHAN */
	else 
		printf("         ");

	if ( u.u_ttyp == 0 )
		printf(" %-5s", "?");			/* TTY */
	else
		printf(" %04x ", u.u_ttyd);

	tm = (u.u_utime + u.u_stime + HZ / 2) / HZ;	/* TIME */
	printf(" %2ld:%.2ld", tm / 60, tm % 60);

	if (u.u_comm[0])				 /* CMD */
		printf(" %.8s", u.u_comm);
	else
		printf(" swapper");
}

#define xp_flag p_flag
#define xp_stat	p_stat
#define xp_pid	p_pid
#define xp_ppid	p_ppid
#define xp_cpu	p_cpu
#define xp_pri	p_pri
#define xp_nice	p_nice
#define xp_utime p_utime
#define xp_stime p_stime

/* print zombie process - zproc overlays mproc */
przom(p)
register proc_t	*p;
{
	long	tm;

	printf("%2x %c", p->xp_flag & 0xff, states[p->xp_stat]);  /* F S */
	printf("%6u", p->p_uid);
	printf("%6u", p->xp_pid);				/* PID */
	printf("%6u%3d", p->xp_ppid, p->xp_cpu & 0xff); 	/* PPID CPU */
	printf("%4d%3d", p->xp_pri, p->xp_nice);		/* PRI NICE */
	printf("                         ");			/* ADDR SZ WCH*/
	tm = (p->xp_utime + p->xp_stime + HZ / 2) / HZ;
	printf("       %2ld:%.2ld", tm / 60, tm % 60);		/* TTY TIME */
	printf(" <defunct>");
}

/*
 * follow a linked list within kernel space
 */

k_link(arg_cnt)
int	arg_cnt;
{
	register uint	start_addr, offset, show_cnt;
	uint		kaddr;

	kaddr = Atox(comm_args[1]);
	start_addr = kaddr;
	offset = Atox(comm_args[2]);
	show_cnt = 0;
	if (arg_cnt == 3)
		show_cnt = (Atox(comm_args[3]) + 3) / 4;
	else
		show_cnt = 1;
	line_limit_set(20);
	while (line_limit_use((show_cnt + 3) / 4)) {
		if (arg_cnt != 3)
			printf("%08x\n", kaddr);
		else
			show_kern_mem(kaddr, show_cnt, 1);

		kaddr = CPU_get_long(kaddr + offset);

		if ((kaddr == start_addr) || (kaddr == 0))
			break;
	}
}

show_kern_mem(kaddr, cnt, remote)
register uint	kaddr;
register uint	cnt;
uint		remote;	/* SPM or other cpu */
{
	register uint	*dbp;
	register int	i, num;
	register uchar	*cp;
	uint		buf[4];

	printf("%08x:   ", kaddr);

	for (; cnt != 0; cnt -= num) {
		num = (cnt < 4) ? cnt : 4;
		for (i = num, dbp = buf; --i >= 0; dbp++) {
			if ( !remote )
				copy_from_km(kaddr, dbp, sizeof(*dbp));
			else
				*dbp = CPU_get_long(kaddr);
			kaddr += sizeof(*dbp);

			printf("%08x ", *dbp);
		}
		printf("| ");
		cp = (uchar *)buf;
		for (i = num * sizeof(*dbp); --i >= 0; cp++)
			put_char(isprint((int)*cp) ? *cp : '.');
		printf("\n%s", (cnt > num) ? "            " : "");
	}
}

/*
 * inkey -- get a character from the console and check it for use by
 *	a paging display routine
 *
 *	Returns:  0 if a \n or \r, 1 if a space, else -1
 */

inkey()
{
	for (;;)
		switch (get_char()) {
		case '\r': 
		case '\n':
			return (0);		/* hit return or newline */
		case ' ':
			return (1);		/* hit space bar	*/
		default:
			return (-1);		/* something else	*/
		}
}

/*
 * spm_display_kernel -- display spm's view of kernel memory
 */

spm_display_kernel(arg_cnt)
int	arg_cnt;
{
	register uint	kaddr, show_cnt, num;
	register int	line_cnt, limit;

	kaddr = Atox(comm_args[1]);

	if ( kaddr < ADDR_MEM_SEGS ) {
		printf("address must be above %x\n", ADDR_MEM_SEGS - 1);
		return;
	}

	if (arg_cnt == 2)
		show_cnt = (Atox(comm_args[2]) + sizeof(long)-1) / sizeof(long);
	else
		show_cnt = 0x7ffffffff;
	limit = 20;				/* show a page of data */

	while (show_cnt) {
		for (line_cnt = limit; --line_cnt >= 0; ) {
			num = (show_cnt < 4) ? show_cnt : 4;
			show_kern_mem(kaddr, num, 0);
			kaddr += num * sizeof(long);
			if ((show_cnt -= num) == 0)
				return;
		}

		switch (inkey()) {
		case 0: 
			limit = 20;	/* show another page */
			break;
		case 1:
			limit = 1;	/* show one more line */
			break;
		default:
			return;
		}
	}
}

solo_pm()
{
	if (!cpu_set_slot(comm_args[1], 0))
		return;
	CPU_solo();
	init_disp();
	show_css_config();
}

deconfig_board()
{
	register uint	slot, sbus_slot;
	uint		found_pm = 0;
	extern uint	scan_for_mem_board();

	if (pm_loaded())
		return;
	/*
	if (pm_booted())
		return;
	*/

	slot = atoi(comm_args[1]);

	if (slot >= SBUS_NUM_SLOT) {
		printf("Bad CSS slot number!  Use 0 to 15.\n");
		return;
	}
	switch (sbus_config.slot_id[slot]) {
	case SBUS_NO_BOARD:
		printf("Nothing configured in slot %u\n", slot);
		return;
	case SBUS_PM20:
	case SBUS_DPM40_SGL:
	case SBUS_DPM40_DBL:
	case SBUS_IOPM:
		if (!cpu_set_slot(comm_args[1], 0))
			return;
		CPU_deconfigure();
		break;
	case SBUS_MM:
		if (scan_for_mem_board() == slot) {
			printf("Can't deconfigure the first memory board!\n");
			return;
		}
		BOARD_DECONFIG(slot);
		break;
	default:
		printf("Command not supported for board type %x\n",
		  sbus_config.slot_id[slot]);
		return;
	}
	init_disp();
	show_css_config();
}

config_board()
{
	register uint	slot, sbus_slot;
	uint		found_pm = 0;

	if (pm_loaded())
		return;
	/*
	if (pm_booted())
		return;
	*/

	slot = atoi(comm_args[1]);

	if (slot >= SBUS_NUM_SLOT) {
		printf("Bad CSS slot number!  Use 0 to 15.\n");
		return;
	}
	switch (NOVRAM->css_slot[slot]) {
	case SBUS_NO_BOARD:
		printf("Nothing in slot %u\n", slot);
		return;
	case SBUS_DPM40_SGL:
	case SBUS_DPM40_DBL:
	case SBUS_IOPM:
	case SBUS_PM20:
		if (!cpu_set_slot(comm_args[1], 0))
			return;
		CPU_configure();
		break;
	case SBUS_MM:
		get_slot_config(slot);
		break;
	default:
		printf("Command not supported for board type %x\n",
		  NOVRAM->css_slot[slot]);
		return;
	}
	init_disp();
	show_css_config();
}

unix_console()
{
	if ( kernel_not_booted() )
		return;

	/* check if stopped or at breakpoint */
	if (!tdb_check_state) {
		if (getyn("Sorry, PM(s) stopped. Go (y/n) ? "))
			go();
		else {
			printf("\n");
			return;
		}
	}

	unix_console_mode = 1;
	while (unix_console_mode)
		poll();
}

getyn(string)
char	*string;
{
	char	line[16];

	for (;;) {
		printf("%s", string);
		line[0] = '\0';
		if (getstr(line, sizeof(line)) == NULL)
			return(0);
		switch (toupper(line[0])) {
		case 'Y':
			return(1);
		case 'N':
			return(0);
		}
	}
}

pm_dis(arg_cnt)
int	arg_cnt;
{
	register uint	show_cnt;
	register uint	addr;

	addr = Atox(comm_args[1]);

	if (arg_cnt == 2)
		show_cnt = Atox(comm_args[2]);
	else
		show_cnt = 0x7ffffffff;

	line_limit_set(20);
	for (; show_cnt && line_limit_use(1); show_cnt--)
		addr += CPU_display_dis(addr) * sizeof(inst_t);
}

/*
 * getnum:
 *
 *	get a line of input from the user.
 *	convert it ascii to hex.
 *	place hex value at location pointed at.
 *
 *  Returns:
 *
 *	0 if user only entered <CR>, or <ESCAPE> at any point.
 *	-1 if user entered non-hex.
 *	1 if successful conversion.
 */

getnum(str, val)
register char	*str;
uint		*val;
{
	*str = '\0';
	if (!getstr(str, 10) || *str == '\0')
		return (0);

	*val = Atox(str);

	return(1);
}

/*
 * on_off -- check a string for "on" and "off"
 *	returns ON_ARG, OFF_ARG, BAD_ARG, or NO_ARG
 *	if str is not comm_args[1], for NO_ARG to work, use argc - (index - 1)
 *	Prints an error message for BAD_ARG.
 */

on_off(argc, str)
int	argc;
char	*str;
{
	if (argc > 0) {
		if (!strcmp(str, off_on_str[1]) )
			return (ON_ARG);
		else if (!strcmp(str, off_on_str[0]))
			return (OFF_ARG);
		else {
			printf("Invalid argument '%s'.  ", str);
			printf("Use only 'on', 'off', or nothing.\n");
			return (BAD_ARG);
		}
	}
	return (NO_ARG);
}

/* set_clock - turn clock interrupts on and off.
 *	if the PMs are booted, we modify the value of kern_clock_enable,
 *	and if not, we set the enable_clock_on_start flag appropriately.
 */

set_clock(arg_cnt)
int	arg_cnt;
{
	int	new_value = pm_booting_done ? 
		  kern_clock_enable : enable_clock_on_start;

	switch (on_off(arg_cnt, comm_args[1])) {
	case ON_ARG:
		new_value = 1;
		break;
	case OFF_ARG:
		new_value = 0;
		break;
	case NO_ARG:
		break;
	case BAD_ARG:
	default:
		return;
	}

	if (pm_booting_done) {
		kern_clock_enable = new_value;
		printf("Clock interrupts %s\n", dis_en_abled[new_value]);
	}
	else {
		enable_clock_on_start = new_value;
		printf("Clock interrupts will be %s when kernel is started\n",
		  dis_en_abled[new_value]);
	}
}

cache_control(arg_cnt)
int	arg_cnt;
{
	if (arg_cnt && pm_booted())
		return;

	switch (on_off(arg_cnt, comm_args[1])) {
	case ON_ARG:
		sbus_config.cache_off = 0;
		break;
	case OFF_ARG:
		sbus_config.cache_off = 1;
		break;
	case NO_ARG:
		break;
	case BAD_ARG:
	default:
		return;
	}

	printf("Cache %s", dis_en_abled[!sbus_config.cache_off]);
}

/*
 * vtop
 *
 *	break down virtual address into translation components
 *	print root pointer, page table pointer, page descriptor.
 */

vtop(arg_cnt)
int	arg_cnt;
{
	register uint	addr, proc;

	if (kernel_not_booted())
		return;

	proc = 0;
	switch (arg_cnt) {
	case 3:
		if (!cpu_set_slot(comm_args[3], 0))
			return;
		/* fall through! */
	case 2:
		proc = Atox(comm_args[2]);
		/* fall through! */
	default:
		addr = Atox(comm_args[1]);
	}

	CPU_print_vtop(addr, proc);
}

pm_booted()
{
	if (pm_booting_done) {
		printf("Command not allowed after kernel has been booted\n");
		return(1);
	}
	return(0);
}

/*
 * ex_echo -- echo all the expressions
 */

ex_echo(arg_cnt)
register int	arg_cnt;
{
	register int	i;
	register uint	val;

	for (i = 1; i <= arg_cnt; i++) {
		val = Atox(comm_args[i]);
		printf("%10d (0x%08x)%s", val, val,
		  (i == arg_cnt ? "\n" : (i % 3 == 0 ? ",\n" : ", ")));
	}
} 

/*
 * proc_print -- print a proc table entry
 */

proc_print(arg_cnt)
int	arg_cnt;
{
	register uint	num;
	proc_t		p;
	struct var	v;

	if ( kernel_not_booted() )
		return;

	/* load up v struct */
	copy_from_km(Spm_Mem->ksym_v, (caddr_t)&v, sizeof(v));

	num = Atox(comm_args[1]);
	if (num < Spm_Mem->ksym_proc || num >= (uint)v.ve_proc ||
	  (num - Spm_Mem->ksym_proc) % sizeof(proc_t)) {
		printf("Bad proc address = 0x%x  Use 0x%x to 0x%x, size=0x%x\n",
		  Spm_Mem->ksym_proc, v.ve_proc, sizeof(proc_t));
		return;
	}

	/* Locate proc table */
	copy_from_km((caddr_t)num, (caddr_t)&p, sizeof(p));

	printf("link   %08x pid %11u pgrp %10u userp  %08x urde  %08x\n",
	  p.f_link, p.p_pid, p.p_pgrp, p.p_userp, p.p_urde);
	printf("flag   %08x pri %11d time %10d stat %10d nice %9d\n",
	  p.p_flag, p.p_pri, p.p_time, p.p_stat, p.p_nice);
	printf("cpu %11d cursig %8u clktim %8d wchan  %08x region %08x\n",
	  p.p_cpu, p.p_cursig, p.p_clktim, p.p_wchan, p.p_region);
	printf("whystop%8u whatstp%8u sig    %08x hold   %08x chold  %08x\n",
	  p.p_whystop, p.p_whatstop, p.p_sig, p.p_hold, p.p_chold);
	printf("ppid   %8d parent %08x child  %08x sibling%08x mlink  %08x\n",
	  p.p_ppid, p.p_parent, p.p_child, p.p_sibling, p.p_mlink);
	printf("running%8u swapout%8u upkerncnt%6u dests      %04x last_ranon %04x\n",
	  p.p_running, p.p_swapout, p.p_upkern_cnt, p.p_dests, p.p_last_ran_on);
	printf("cpudests   %04x fpudests   %04x uid%12u suid%11u\n",
	  p.p_cpu_dests, p.p_fpu_dests, p.p_uid, p.p_suid);
	printf("sgid%11u xstat%10d ubptbl %08x size%11u utime%10x\n",
	  p.p_sgid, p.p_xstat, p.p_ubptbl[0], p.p_size, p.p_utime);
	printf("stime%10x minwd  %08x rlink  %08x epid%11d sysid%10x\n",
	  p.p_stime, p.p_minwd, p.p_rlink, p.p_epid, p.p_sysid);
	printf("mpgneed%8u pflags %08x possig %08x savedsuid%6u savedsgid%6u\n",
	  p.p_mpgneed, p.p_posix_flags, p.p_posix_sig, p.p_saved_set_uid,
	  p.p_saved_set_gid);
	printf("sessionid%6u mytty %08x auth  %08x\n",
	  p.p_session_id, p.p_my_tty, p.p_auth);
}

/*
 * set_base -- set the default expr base
 */

static
set_base(arg_cnt)
int	arg_cnt;
{
	register int	b;
	char		*p;
	extern int	ex_base;
	extern long	strtol();

	printf("Current base = %d (0x%x)\n", ex_base, ex_base);
	if (arg_cnt == 0)
		return;

	switch (b = strtol(comm_args[1], &p, 10)) {
	case 0:
	case 2:
	case 8:
	case 10:
	case 16:
		break;		/* ok */
	default:
		b = -1;		/* bad */
	}

	if (b < 0 || (b == 0 && p == comm_args[1])) {
		printf("Invalid base '%s'.  Use only 0, 2, 8, 10, or 16.\n",
		  comm_args[1]);
		return;
	}

	ex_base = b;
	printf("New base     = %d (0x%x)\n", b, b);
}

extern int	load_it(), boot_k(), u_page_trace(), disp_save_buf();
extern int	pm_tag_check(), stop(), set_var(), unset_var(), symdsp();

struct init_menu i_kernel_debugger[] = {
 { "b(oot)",	" <pathname>- Boot from disk",
   MF_EXPERT | MF_PREBOOT, 0, 1, boot_k },
 { "load",	" <pathname>- Load from disk",
   MF_EXPERT | MF_PREBOOT, 0, 1, load_it },
 { "con",	"- switch to unix console",
   MF_EXPERT | MF_POSTBOOT, 0, 0, unix_console },
 { "clock",	"<on|off>- show/enable/disable clock interrupts",
   MF_EXPERT, 0, 1, set_clock },
 { "own",	"<slot>- Show own structure", MF_EXPERT, 0, 1, show_own },
 { "cache",	"<on|off>- show/enable/disable PM cache",
   MF_EXPERT, 0, 1, cache_control },
 { "u",		"<slot>- Show u structure",
   MF_EXPERT | MF_POSTBOOT, 0, 1, show_u },
 { "utrace",	"kern_addr- u_rsav regs & upage stack trace",
   MF_EXPERT | MF_POSTBOOT, 1, 1, u_page_trace },
 { "ps",	"- ps -el", MF_POSTBOOT, 0, 2, ps },
 { "solo",	"slot- deconfig all PMs except slot",
    MF_EXPERT | MF_PREBOOT, 1, 1, solo_pm },
 { "deconfig",	"slot- deconfig board",
    MF_EXPERT | MF_PREBOOT, 1, 1, deconfig_board },
 { "config",	"slot- configure board",
    MF_EXPERT | MF_PREBOOT, 1, 1, config_board },
 { "review",	"- display the printf buffer",
   0, 0, 0, disp_save_buf },
 { "tags",	"<slot>- ask PM in slot to check cache tags",
   MF_EXPERT | MF_POSTBOOT, 0, 1, pm_tag_check },
 { "link",	"kern_addr offset(bytes) <count>- follow a linked list",
   MF_EXPERT, 2, 3, k_link },
 { "sdk",	"kern_addr <count>- spm display kernel memory",
   MF_EXPERT, 1, 2, spm_display_kernel },
 { "stop",	"- stop all PMs", MF_EXPERT | MF_POSTBOOT, 0, 0, stop },
 { "go",	"- (re)start all PMs", MF_EXPERT, 0, 0, go },
 { "set",	"name value- declare and initialize a variable",
   MF_EXPERT, 0, 2, set_var },
 { "unset",	"name- unset a variable", MF_EXPERT, 1, 8, unset_var },
 { "echo",	"<expr(s)>- print the expressions(s)",
   MF_EXPERT, 0, 15, ex_echo },
 { "vtop",	"addr <proc_addr_or_zero <slot>>- virtual to physical",
   MF_EXPERT, 1, 3, vtop },
 { "sy(mbol)",	"<symbol|value> - look up symbol or value",
   MF_EXPERT, 0, 1, symdsp },
 { "proc",	"<proc_addr>- print a proc table entry",
   MF_EXPERT | MF_POSTBOOT, 1, 1, proc_print },
 { "base",	"<new_base>- set the default numeric base",
   MF_EXPERT, 0, 1, set_base },
 { 0 }
};
