/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) debug.c: version 25.1 created on 11/27/91 at 15:30:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)debug.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "menu.h"
#include "iomap.h"

typedef union poly_u {		/* N-way union for dumping memory */
	ulong	*l;
	ushort	*w;
	uchar	*b;
	ulong	i;
} poly_t;

int		mref_siz;	/* Memory reference size, defaults to long */
int		pagsize;

static poly_t	lastmem;
static char	linbuf[20];
static int	nline;
static uint	count;

extern int	throw_away_int;
extern short	throw_away_short;
extern char	throw_away_char;
extern char	*off_on_str[];
extern char	*comm_args[];

extern uchar	*iomap();
extern uint	Atox();


display_iom_err_info()
{
	break_out_iom_err_info(atoi(comm_args[1]));
}

display_iosba_err_info()
{
	break_out_iosba_err_info(atoi(comm_args[1]));
}

/*
 * mref_str -- return a string coresponding to mref_siz, rtn_to_monitor on err
 */

char *
mref_str()
{
	switch (mref_siz) {
	case 'l':
		return ("long");
	case 'w':
		return ("word");
	case 'b':
		return ("byte");
	default:
		printf("Unknown memory size '%c'.  Use 'l', 'w', or 'b'.\n",
		  mref_siz);
		rtn_to_monitor();
	}
	/*NOTREACHED*/
}

/*
 * set_nline -- common routine to set number of items per line
 *		returns non-zero on error
 */

set_nline()
{
	switch (mref_siz) {
	case 'l':
		nline = 4;
		break;
	case 'w':
		nline = 8;
		break;
	case 'b':
		nline = 16;
		break;
	default:
		printf("Illegal output type %c\n", mref_siz);
		mref_siz = 'l';
		return (1);
	}
	return (0);
}

/*
 *	Memory related commands
 *
 *	dmem(arg_cnt)
 *	int arg_cnt;
 *
 *	dm(emory)<.[bwl]> <addr <count>> - Display memory
 *		This is the ubiquitous display memory command. The minimum
 *		required to operate this command is 'dm xxxx', where xxxx is
 *		the desired address. The result is that the memory is dumped
 *		to the screen with the applicable ascii equivalents in the
 *		right hand margin for a page, waiting for a <RET> for another
 *		page, <SP> for another line, or any other key to quit back to
 *		the prompt.
 *		When the count is specified, just that amount is displayed
 *		with no paging.
 */

dmem(arg_cnt)
int	arg_cnt;
{
	register int j;

	linbuf[16] = '\0';

	if (arg_cnt < 2)
		count = 0xffffffff;	/* max size */
	else
		count = Atox(comm_args[2]);
	if (arg_cnt > 0)
		lastmem.i = Atox(comm_args[1]);
	else
		lastmem.i = 0;

	if (set_nline())
		return;

	for (;;) {
		for (j = 0; j < pagsize; j++) {
			one_line();  /* show one page from current pointers.. */
			if(!count) 
				return;
		}
		for (;;) {
			switch (inkey()) { 
			case 0:		/* \r or \n */
				break;
			case 1:		/* space */
				one_line(); /* show one more line */
				continue;
			default:	/* anything else */
				return;
			}
			break;
		}
	}
}

sdmem(arg_cnt)
int	arg_cnt;
{
	register int 	j, sbus_slot;
	uint		saved_map = iomap_save();

	linbuf[16] = '\0';

	sbus_slot = atoi(comm_args[1]);

	if (sbus_slot < 0 || sbus_slot >= SBUS_NUM_SLOT) {
		printf("Illegal slot %s\n", comm_args[1]);
		return;
	}

	if (arg_cnt < 3)   		/* no size specified */
		count = 0xffffffff; 	/* max size */
	else
		count = Atox(comm_args[3]);

	if (set_nline())
		return;

	lastmem.b = iomap(sbus_slot, Atox(comm_args[2]));

	for (;;) {
		for (j = 0; j < pagsize; j++) {
			one_line();  /* show one page from current pointers.. */
			if (count == 0) {
				iomap_restore(saved_map);
				return;
			}
		}
		for (;;) {
			switch (inkey()) { 
			case 0:		/* \r or \n */
				break;
			case 1:		/* space */
				one_line(); /* show one more line */
				continue;
			default:	/* anything else */
				iomap_restore(saved_map);
				return;
			}
			break;
		}
	}
}

/*
 * one_line -- do one line of memory output
 */

one_line()
{
	register int	i;
	int		c;

	printf("%08x  ", lastmem.i);	/* Beginning addr of line */
	for (i = 0; i < nline; i++) {
		switch (mref_siz) {		
		case 'l':
			printf("%08x ", *lastmem.l++);
			break;
		case 'w':
			printf("%04x ", *lastmem.w++);
			break;
		case 'b':
			printf("%02x ", c = *lastmem.b++);
			if ((c >= ' ') && (c <= '~'))
				linbuf[i] = c;
			else
				linbuf[i] = '.';
			break;
		default:
			break;
		} 
		if (--count == 0)
			break;			/* done */
	}
	if (mref_siz == 'b') {			/* if byte mode */
		for (linbuf[++i] = '\0'; i < nline; i++)
			printf("   ");		/* pad short output */

		printf(" %s", linbuf);
	}
	put_char('\n');
}


/*
 *	mmem(comm_str, arg_cnt)
 *	char *comm_str;
 *	int arg_cnt;
 *
 *	mm(emory)<.[bwl]> <addr <data>>  -  Modify memory
 */

mmem(arg_cnt)
int	arg_cnt;
{
	register uint	data;
	register int	val;
	char		inline[64];

	/* Arg cnt will be either 0, 1 or 2 */
	if (arg_cnt == 2)
		data = Atox(comm_args[2]);
	else
		printf("Press <ESC> to stop.\n");

	switch (mref_siz) {
	case 'l':
		break;
	case 'w':
		data &= 0xffff;
		break;
	case 'b':
		data &= 0xff;
		break;
	default:
		printf("Illegal output type %c\n", mref_siz);
		mref_siz = 'l';
		return;
	}

	if (arg_cnt >= 1)
		lastmem.i = Atox(comm_args[1]);

	do {
		printf("%08x  ", lastmem.i);
		switch (mref_siz) {
		case 'l':
			printf("%08x ", *lastmem.l);
			break;
		case 'w':
			printf("%04x ", *lastmem.w);
			break;
		case 'b':
			printf("%02x ", *lastmem.b);
			break;
		default:
			printf("Illegal output type\n");
			return;
		}
		if (arg_cnt == 2) {
			switch (mref_siz) {
			case 'l':
				printf("< %08x\n", data);
				break;
			case 'w':
				printf("< %04x\n", data);
				break;
			case 'b':
				printf("< %02x\n", data);
				break;
			}
		}
		else {
			if (getstr(inline, sizeof(inline)) == NULL)
				return;
			if (*inline == '\0')
				goto nextspot;
			if (*inline == '-') {
				switch (mref_siz) {
				case 'l':
					lastmem.l--;
					break;
				case 'w':
					lastmem.w--;
					break;
				case 'b':
					lastmem.b--;
					break;
				}
				continue;
			} 
			data = Atox(inline);
		}
		switch (mref_siz) {
		case 'l':
			*lastmem.l = data;
			break;
		case 'w':
			*lastmem.w = data;
			break;
		case 'b':
			*lastmem.b = data;
			break;
		}
		if (arg_cnt != 2) {
nextspot:		switch (mref_siz) {
			case 'l':
				lastmem.l++;
				break;
			case 'w':
				lastmem.w++;
				break;
			case 'b':
				lastmem.b++;
				break;
			}
		}
	} while (arg_cnt <= 1);
}

/*
 *	move_mem()
 *
 *	mov<.[bwl]> src dest count  -  Move memory
 */

move_mem()
{
	register int	count;
	uchar		*dest, *src;

	dest = (uchar *)Atox(comm_args[1]);
	src = (uchar *)Atox(comm_args[2]);
	count = (int) Atox(comm_args[3]);

	if (set_nline())
		return;

	printf("Move 0x%x %s(s) from 0x%08x to 0x%08x\n",
	  count, mref_str(), src, dest);

	switch (mref_siz) {
	case 'l': {
		register ulong	*from = (ulong *)src, *to = (ulong *)dest;

		while (--count >= 0)
			*to++ = *from++;
		break;
		}
	case 'w': {
		register ushort	*from = (ushort *)src, *to = (ushort *)dest;

		while (--count >= 0)
			*to++ = *from++;
		break;
		}
	case 'b': {
		register uchar	*from = src, *to = dest;

		while (--count >= 0)
			*to++ = *from++;
		break;
		}
	}
	printf("Done\n");
}

/*
 *	compare_mem()
 *
 *	cmp<.[bwl]> dest src count  -  Compare memory
 */

compare_mem()
{
	register int	count;
	uchar		*dest, *src;

	dest = (uchar *)Atox(comm_args[1]);
	src = (uchar *)Atox(comm_args[2]);
	count = Atox(comm_args[3]);

	if (set_nline())
		return;

	printf("Compare 0x%x %s(s) between 0x%08x and 0x%08x\n",
	  count, mref_str(), dest, src);

	switch (mref_siz) {
	case 'l':
	default: {
		register ulong	*from = (ulong *)src, *to = (ulong *)dest;

		while (--count >= 0) {
			if (*to != *from) {
				printf("compare error - ");
				printf("addr 0x%08x=0x%08x, 0x%08x=0x%08x\n",
				  to, *to, from, *from);
			}
			++to;
			++from;
		}
		break;
		}
	case 'w': {
		register ushort	*from = (ushort *)src, *to = (ushort *)dest;

		while (--count >= 0) {
			if (*to != *from) {
				printf("compare error - ");
				printf("addr 0x%08x=0x%04x, 0x%08x=0x%04x\n",
				  to, *to, from, *from);
			}
			++to;
			++from;
		}
		break;
		}
	case 'b': {
		register uchar	*from = src, *to = dest;

		while (--count >= 0) {
			if (*to != *from) {
				printf("compare error - ");
				printf("addr 0x%08x=0x%02x, 0x%08x=0x%02x\n",
				  to, *to, from, *from);
			}
			++to;
			++from;
		}
		break;
		}
	}
}


/*
 * fmem - fill memory block
 */

fmem()
{
	register int	count;
	register uint	data;
	unchar		*dest;

	dest = (uchar *)Atox(comm_args[1]);
	data = Atox(comm_args[2]);
	count = (int)Atox(comm_args[3]);

	if (set_nline())
		return;

	printf("Fill %#x %s(s) at 0x%08x with 0x%08x\n",
	  count, mref_str(), dest, data);

	switch (mref_siz) {
	case 'l': {
		register ulong	*to = (ulong *)dest;

		while (--count >= 0)
			*to++ = data;
		break;
		}
	case 'w': {
		register ushort	*to = (ushort *)dest;

		while (--count >= 0)
			*to++ = data;
		break;
		}
	case 'b': {
		register uchar	*to = dest;

		while (--count >= 0)
			*to++ = data;
		break;
		}
	}
}

/*
 * sfmem - fill system memory block
 */

sfmem(arg_cnt)
int	arg_cnt;
{
	register int	count, sbus_slot;
	register uint	data;
	register uchar	*dest;
	uint		saved_map = iomap_save();
	
	sbus_slot = atoi(comm_args[1]);

	if (sbus_slot < 0 || sbus_slot >= SBUS_NUM_SLOT) {
		printf("Illegal slot %d\n", sbus_slot);
		return;
	}

	if (set_nline())
		return;

	dest = iomap(sbus_slot, Atox(comm_args[2]));
	data = Atox(comm_args[3]);
	count = Atox(comm_args[4]);

	printf("Fill %#x %s(s) at %d:%08x with 0x%08x\n",
	  count, mref_str(), sbus_slot, dest, data);

	switch (mref_siz) {
	case 'l': {
		register ulong	*to = (ulong *)dest;

		while (--count >= 0)
			*to++ = data;
		break;
		}
	case 'w': {
		register ushort	*to = (ushort *)dest;

		while (--count >= 0)
			*to++ = data;
		break;
		}
	case 'b': {
		register uchar	*to = dest;

		while (--count >= 0)
			*to++ = data;
		break;
		}
	}
	iomap_restore(saved_map);
}

/*
 * mslot -- display or set SPM I/O maps
 */
mslot(arg_cnt)
int	arg_cnt;
{
	register uint	mapnum, slotnum, slotadd;
 
	if (arg_cnt <= 0) {	/* display all io maps */	
		for (mapnum = 0; mapnum < SPM_IOMAP_MANY; mapnum++) {
			if (mapnum == (SPM_IOMAP_MANY / 2))
				printf("\n");
			printf("map %1x = 0x%02x  ", mapnum,
			  *(IO_MAPPER + (mapnum << UnmappedBits)));
		}
		printf("\n");
		return;
	}
	else if (arg_cnt < 3) {
		printf("usage:  map <map_num css_slot addr_high_nibble>\n");
		return;
	}

	if ((mapnum = Atox(comm_args[1])) > 7) {
		printf("Invalid map number: 0x%x (use 0-7)\n", mapnum);
		return;
	}
	if ((slotnum = Atox(comm_args[2])) >= SBUS_NUM_SLOT) {
		printf("Invalid CSS slot number: 0x%x (use 0-%x)\n",
		  slotnum, SBUS_NUM_SLOT - 1);
		return;
	}
	if ((slotadd = Atox(comm_args[3])) > 0xf) {
		printf("Invalid high addr nibble: 0x%x (use 0-f)\n", slotnum);
		return;
	}
	SPM_IOMAP_BASE[mapnum << 28] = (slotnum << 4) | slotadd;
}

jsr(arg_cnt)
int	arg_cnt;
{
	register int	(*mem)();
	uint		a[8];
 
	mem = (int (*)())(Atox(comm_args[1]));
	bzero((caddr_t)a, sizeof(a));

	switch (arg_cnt) {
	case 7:
		a[7] = Atox(comm_args[7]);
	case 6:
		a[6] = Atox(comm_args[6]);
	case 5:
		a[5] = Atox(comm_args[5]);
	case 4:
		a[4] = Atox(comm_args[4]);
	case 3:
		a[3] = Atox(comm_args[3]);
	case 2:
		a[2] = Atox(comm_args[2]);
	case 1:
		(void)(*mem)(a[2], a[3], a[4], a[5], a[6], a[7]);
	}
}

/*
 * rdblock - read block loop
 */

rdblock(arg_cnt)
int	arg_cnt;
{
	register int	size;
	uchar		*start, *end;

	size = 0;
	lastmem.b = start = (uchar *)Atox(comm_args[1]);
	if (arg_cnt == 2)
		size = (int)Atox(comm_args[2]);
	if (set_nline())
		return;
	if (size > 0) {
		printf("Read loop %#x %s(s) starting at 0x%08x\n",
		  size, mref_str(), start);
		printf("Press any key to stop.\n");

		end = start + size;
		while (con_in() < 0) {
			switch (mref_siz) {
			case 'l': {
				register ulong	*from = (ulong *)start,
						*to = (ulong *)end;

				while (from < to)
					throw_away_int = *from++;
				break;
				}
			case 'w': {
				register ushort	*from = (ushort *)start,
						*to = (ushort *)end;

				while (from < to)
					throw_away_short = *from++;
				break;
				}
			case 'b': {
				register uchar	*from = (uchar *)start,
						*to = (uchar *)end;

				while (from < to)
					throw_away_char = *from++;
				break;
				}
			}
		}
	}
	else {
		printf("Read a %s at 0x%08x.  Press any key to stop.\n",
		  mref_str(), start);

		switch (mref_siz) {
		case 'l': {
			register ulong	*from = (ulong *)start;

			while (con_in() < 0)
				for (size = 0x10000; --size >= 0; )
					throw_away_int = *from;
			break;
			}
		case 'w': {
			register ushort	*from = (ushort *)start;

			while (con_in() < 0)
				for (size = 0x10000; --size >= 0; )
					throw_away_short = *from;
			break;
			}
		case 'b': {
			register uchar	*from = (uchar *)start;

			while (con_in() < 0)
				for (size = 0x10000; --size >= 0; )
					throw_away_char = *from;
			break;
			}
		}
	}
}



/*
 * wrblock - write block loop
 */

wrblock(arg_cnt)
int	arg_cnt;
{
	register int	size;
	uint		val;
	uchar		*start, *end;

	size = 0;
	lastmem.b = start = (uchar *)Atox(comm_args[1]);
	val = Atox(comm_args[2]);
	if (arg_cnt == 3)
		size = (int)Atox(comm_args[3]);
	if (size > 0) {
		printf("Write loop %#x %s(s) to %#x starting at 0x%08x\n",
		  size, mref_str(), val, start);
		printf("Press any key to stop.\n");

		end = start + size;
		while (con_in() < 0) {
			switch (mref_siz) {
			case 'l': {
				register ulong	*from = (ulong *)start,
						*to = (ulong *)end,
						value = (ulong)val;

				while (from < to)
					*from++ = value;
				break;
				}
			case 'w': {
				register ushort	*from = (ushort *)start,
						*to = (ushort *)end,
						value = (ushort)val;

				while (from < to)
					*from++ = value;
				break;
				}
			case 'b': {
				register uchar	*from = (uchar *)start,
						*to = (uchar *)end,
						value = (uchar)val;

				while (from < to)
					*from++ = value;
				break;
				}
			}
		}
	}
	else {
		printf("Write %#x as a %s at 0x%08x.  Press any key to stop.\n",
		  val, mref_str(), start);

		switch (mref_siz) {
		case 'l': {
			register ulong	*from = (ulong *)start,
					value = (ulong)val;

			while (con_in() < 0)
				for (size = 0x10000; --size >= 0; )
					*from = value;
			break;
			}
		case 'w': {
			register ushort	*from = (ushort *)start,
					value = (ushort)val;

			while (con_in() < 0)
				for (size = 0x10000; --size >= 0; )
					*from = value;
			break;
			}
		case 'b': {
			register uchar	*from = (uchar *)start,
					value = (uchar)val;

			while (con_in() < 0)
				for (size = 0x10000; --size >= 0; )
					*from = value;
			break;
			}
		}
	}
}

/*
 * 	iready() increase ready count in the arbiter for the SPM
 *	toggle ready bit
 */

iready()
{
	*WRCNTL1 = *WRCNTL1 | WR1_IRDY;
	*WRCNTL1 = *WRCNTL1 & ~WR1_IRDY;	
	*WRCNTL1 = *WRCNTL1 | WR1_IRDY;
}


/*
 * 	rready() reset ready count in the arbiter for the SPM
 *	toggle reset bit
 */

rready()
{
	*WRCNTL1 = *WRCNTL1 | WR1_RRDY;
	*WRCNTL1 = *WRCNTL1 & ~WR1_RRDY;	
	*WRCNTL1 = *WRCNTL1 | WR1_RRDY;
}

/*
 * exec_sa -- load and execute a named standalone program
 */

exec_sa(arg_cnt)
int	arg_cnt;
{
	comm_args[0] = comm_args[1];
	comm_args[1] = comm_args[2];
	sa_load(arg_cnt - 1);
}

open_call()
{
	int	ret;

	if ((ret = Open(comm_args[1], Atox(comm_args[2]))) < 0)
		printf("open failed\n");
	else
		printf("file descriptor = 0x%x\n", ret);
}

close_call()
{
	int	ret;

	if ((ret = Close(Atox(comm_args[1]))) < 0)
		printf("close failed\n");
	else
		printf("return value = 0x%x\n", ret);
}

read_call()
{
	int	ret;

	if ((ret = Read(Atox(comm_args[1]), (char *)Atox(comm_args[2]),
			Atox(comm_args[3]))) < 0)
		printf("read failed\n");
	else
		printf("return value = 0x%x\n", ret);
}

write_call()
{
	int	ret;

	if ((ret = Write(Atox(comm_args[1]), (char *)Atox(comm_args[2]),
			 Atox(comm_args[3]))) < 0)
		printf("write failed\n");
	else
		printf("return value = 0x%x\n", ret);
}

lseek_call()
{
	int	ret;

	if ((ret= Lseek(Atox(comm_args[1]), Atox(comm_args[2]),
			Atox(comm_args[3]))) < 0)
		printf("lseek failed\n");
	else
		printf("return value = 0x%x\n", ret);
}

show_dbug(arg_cnt)
int	arg_cnt;
{
	switch (on_off(arg_cnt, comm_args[1])) {
	case ON_ARG:
		dbug = 1;
		break;
	case OFF_ARG:
		dbug = 0;
		break;
	case NO_ARG:
		break;
	case BAD_ARG:
	default:
		return;
	}

	printf("\ndebug %s\n", off_on_str[dbug]);
}

extern int	xfdl();
extern int	fdl();

struct init_menu i_debugger [] = {
 { "dm(emory)<.[bwl]>",	"<addr <count>>- Display local memory",
   MF_EXPERT, 0, 2, dmem },
 { "ds(memory)<.[bwl]>", "slot addr <count>- Display system memory",
   MF_EXPERT, 2, 3, sdmem },
 { "map",		"<map# slot# addr>- Display/set SPM Map slot and addr",
   MF_EXPERT, 0, 3, mslot },
 { "fm(emory)<.[bwl]>",	"addr data size- Fill memory block",
   MF_EXPERT, 3, 3, fmem },
 { "fs(memory)<.[bwl]>", "slot addr data size- Fill system memory block",
   MF_EXPERT, 4, 4, sfmem },
 { "mov<.[bwl]>",	"dest source count- Move memory",
   MF_EXPERT, 3, 3, move_mem },
 { "cmp<.[bwl]>",	"dest source count- Compare memory",
   MF_EXPERT, 3, 3, compare_mem },
 { "rdb(lock)<.[bwl]>",	"addr <size>- Read block loop",
   MF_EXPERT, 1, 2, rdblock },
 { "wrb(lock)<.[bwl]>",	"addr data <size>- Write block loop",
   MF_EXPERT, 2, 3, wrblock },
 { "jsr",		"addr <arg1><arg2> ... <arg6>- Jump to subroutine",
   MF_EXPERT, 1, 7, jsr },
 { "mm(emory)<.[bwl]>",	"<addr <data>>- Modify memory",
   MF_EXPERT, 0, 2, mmem },
 { "fdl",		"- Download to main memory",
   MF_EXPERT | MF_PREBOOT, 0, 0, fdl },
 { "xfdl",		"<bootimage_device>- Download and execute",
   MF_EXPERT | MF_PREBOOT, 0, 1, xfdl },
 { "iom",		"iom_slot- Display IO Module error info",
   MF_EXPERT, 1, 1, display_iom_err_info },
 { "iosba",		"iom_slot- Display IOSB Adapter error info",
   MF_EXPERT, 1, 1, display_iosba_err_info },
 { "exec_sa",	"program <bootimage_device>- Execute standalone program",
   MF_EXPERT | MF_PREBOOT, 1, 2, exec_sa },
 { "open",		"path mode- open a file, return a fildes",
   MF_EXPERT | MF_PREBOOT, 1, 2, open_call },
 { "close",		"fildes- close a filedes",
   MF_EXPERT | MF_PREBOOT, 1, 1, close_call },
 { "read",		"fildes buf nbyte- read from a file",
   MF_EXPERT | MF_PREBOOT, 3, 3, read_call },
 { "write",		"fildes buf nbyte- write to a file",
   MF_EXPERT | MF_PREBOOT, 3, 3, write_call },
 { "lseek",		"fildes offset whence- move file pointer",
   MF_EXPERT | MF_PREBOOT, 3, 3, lseek_call },
 { "dbug",		"- debug flag <on|off>",
   MF_EXPERT | MF_PREBOOT, 0, 1, show_dbug },
 { 0 }
};
