/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ddebug.c: version 25.1 created on 11/27/91 at 15:30:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ddebug.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* ddebug.c */

#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "menu.h"
#include "rtc.h"
#include "iomap.h"
#include "dispatch.h"


static
immem(arg_cnt)
int arg_cnt;
{
	/* request the dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ;

	wait_for_dispatcher_rams();
	mmem(arg_cnt);

	if(!dispatcher_error)
		*WRCNTL1 |= WR1_DREQ;
}

static
idmem(arg_cnt)
int arg_cnt;
{
	/* request the dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ;

	wait_for_dispatcher_rams();
	dmem(arg_cnt);

	if(!dispatcher_error)
		*WRCNTL1 |= WR1_DREQ;
}


/*
 * dispatcher queue status
 */

static
dir_int(arg_cnt)
int arg_cnt;
{
	register int	cpu_num, level, l;

	cpu_num = strcmp(comm_args[1], "all") ? atoi(comm_args[1]) : -1;
	if (cpu_num >= SBUS_NUM_SLOT) {
		printf("Bad slot! Use 0 to 15, or 'all' only!\n");
		return;
	}

	level = (arg_cnt < 2 || strcmp(comm_args[2], "all")) ? -1 :
	  atoi(comm_args[2]);
	switch (level) {
	case -1:
	case 4:
	case 5:
		break;		/* ok */
	default:
		printf("Directed interrupt levels 4 and 5, or 'all' only!\n");
		return;
	}

/* hanna FIX: leave as is -- ints should go only to cpu A  for 040*/
	if (cpu_num < 0) {
		/* display directed int at "level" for all cpus */
		for (cpu_num = 0; cpu_num < SBUS_NUM_SLOT; cpu_num++)
			if (level < 0)
				for (l = 4; l < 6; l++)
					display_dir_int(cpu_num, l);
			else
				display_dir_int(cpu_num, level);
	}
	else {
		if (level < 0)
			for (l = 4; l < 6; l++)
				display_dir_int(cpu_num, l);
		else
			display_dir_int(cpu_num, level);
	}
}

/* DPM40 NOTE: The dispatcher stuff for the dpm40 is per board, not cpu.
 * therefore, no changes are needed here. */

static
display_dir_int(cpu_num, level)
register uint cpu_num;
register uint level;
{
	register    uint *pntr_addr, in_pntr,out_pntr;
	register    struct int_data *queue_addr, *addr;
	register    uint offset;
	unchar      vector,dest_slot,src_slot,io_src_slot;
	uint 	    *misc_addr;

	/* request rams */
	*WRCNTL1 &= ~WR1_DREQ;
	wait_for_dispatcher_rams();
	if (level == 4) {
		pntr_addr = POINTER_RAM + cpu_num;
		queue_addr = DIR_L4(cpu_num);
	}
	else {
		pntr_addr = POINTER_RAM + (cpu_num + 0x10);
		queue_addr = DIR_L5(cpu_num);
	}

	/* incoming pointer value */
	in_pntr = GET_IN_POINTER(*pntr_addr);

	/* outgoing pointer value */
	out_pntr = GET_OUT_POINTER(*pntr_addr);

	if (in_pntr != out_pntr) {
	    misc_addr = MISC_RAM + (cpu_num + (level * 0x10));
	    if(*misc_addr & MISC_SERVICE_PENDING)
		printf("\ncpu %x: interrupt pending, ", cpu_num);
	    else
		printf("\ncpu %x: no interrupt pending, ", cpu_num);
	    printf("counter = %x\n", (*misc_addr & MISC_COUNTER_MASK));
	    for( ; out_pntr != in_pntr; ) {
		offset = out_pntr - 0x40; 
		addr = queue_addr + offset;
		vector = addr->vector;
		dest_slot = addr->dest_slot;
		src_slot = addr->src_slot;
		io_src_slot = addr->io_slot;
		if(addr->io_int)
			printf("cpu %x: level %x vector %x dest %x src %x i/o src %x \n",
		       	cpu_num,level,vector,dest_slot,src_slot,io_src_slot);
		else
			printf("cpu %x: level %x vector %x dest %x src %x \n",
		       	cpu_num,level,vector,dest_slot,src_slot);

		if(out_pntr == 0x40)
			out_pntr = POINTER_INIT_VAL;
		else
			out_pntr--;
	    }
	}

	if(!dispatcher_error)
		*WRCNTL1 |= WR1_DREQ;
}

#if 0	/* pending complete rewrite */
static
ndir_int()
{
	register uint level;

	if(!strcmp (comm_args[1], "all")) {
		/* display all non-directed interrupts */
		for(level=0; level < 4; level++)
			display_ndir_queue(level);
	}
	else {
		/* get cpu level */
		level = (uint)Atox(comm_args[1]);
		if(level > 3) {
			printf("\nvalid levels are 0-3\n");
			return;
		}
		display_ndir_queue(level);
	}
}

/* DPM40 NOTE: The dispatcher stuff for the dpm40 is per board, not cpu.
 * therefore, no changes are needed here. */

static
display_ndir_queue(level)
register uint level;
{
	register uint *pntr_addr, in_pntr,out_pntr;
	register struct int_data *queue_addr, *addr;
	unchar sbus_slot,vector,dest_slot,src_slot,io_src_slot;
	uint *misc_addr;

	/* request rams */
	*WRCNTL1 &= ~WR1_DREQ;
	wait_for_dispatcher_rams();

	/* find first empty slot or one with a memory board */
	for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; sbus_slot++) {
		if (sbus_config.slot_id[sbus_slot] == SBUS_MM ||
		    sbus_config.slot_id[sbus_slot] == SBUS_NO_BOARD)
			break;
	}
/* ASK mark, james or david. */
	if (sbus_slot >= SBUS_NUM_SLOT) {
		printf("need a memory or empty slot for non-directed pointers\n");
		return;
	}

	pntr_addr = POINTER_RAM + (sbus_slot + (level * 0x10));

	/* calculate the queue address */

	switch(level) {
	case 0:
		queue_addr = (struct int_data *)(0x0c000000);
		break;
	case 1:
		queue_addr = (struct int_data *)(0x0c001000);
		break;
	case 2:	
		queue_addr = (struct int_data *)(0x0c000800);
		break;
	case 3:
		queue_addr = (struct int_data *)(0x0c001800);
		break;
	default:
		printf("\ninvalid level %x, valid levels are 0-3\n", level);
		return;
	}

	/* incoming pointer value */
	in_pntr = GET_IN_POINTER(*pntr_addr);

	/* outgoing pointer value */
	out_pntr = GET_OUT_POINTER(*pntr_addr);

	if(in_pntr == out_pntr) {
/*
		printf("\nlevel %x: no non-directed interrupts in queue\n",level);
*/
			;
	}
	else {
	    misc_addr = MISC_RAM + level;
	    printf("level %x: counter = %x\n", level, (*misc_addr & MISC_COUNTER_MASK));
	    for( ; out_pntr != in_pntr; ) {
		addr = queue_addr + out_pntr;
		vector = addr->vector;
		dest_slot = addr->dest_slot;
		src_slot = addr->src_slot;
		io_src_slot = addr->io_slot;
		if(addr->io_int)
			printf("level %x: vector %x dest %x src %x i/o src %x \n",
		       	level,vector,dest_slot,src_slot,io_src_slot);
		else
			printf("level %x: vector %x dest %x src %x \n",
		       	level,vector,dest_slot,src_slot);
		if(out_pntr == 0x00)
			out_pntr = POINTER_INIT_VAL;
		else
			out_pntr--;
	    }
	}

	if(!dispatcher_error)
		*WRCNTL1 |= WR1_DREQ;
}
#endif /* 0 */

struct init_menu i_ddebugger [] = {
 { "ddm(emory)<.[bwl]>", "<addr <count>>- Display Dispatcher memory",
   MF_EXPERT, 0, 2, idmem },
 { "imm(emory)<.[bwl]>", "<addr <data>>- Modify Dispatcher memory",
   MF_EXPERT, 0, 2, immem },
 { "dint",	"<cpu/all> <level/all>- Display Directed Queue Interrupts",
   MF_EXPERT, 1, 2, dir_int },
/* FIX THIS, HH - nint not working, so don't use it! - per DS request 
 * "nint", "<level/all>- Display Non-Directed Queue Interrupts", 
 * MF_EXPERT, 1, 1, ndir_int
 */
 { 0 }
};
