/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) spm_tdb.c: version 25.1 created on 11/27/91 at 15:30:11	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)spm_tdb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * spm_tdb.c -- spm driver
 */

#include "sys/types.h"
#include "sys/sbus.h"
#include "sys/proc.h"

#include "spm_debug.h"
#include "cpu_method.h"
#include "sbus_conf.h"
/* #include "global.h" */
#include "sa_dir.h"
#include "filehdr.h"

extern uint	m68k_display_dis(), bcopy(), bzero();

typedef struct {
	cpu_data_t	cpu_data;
} spm_info_t;

spm_info_t	spm_info;

extern uint	spm_slot;

extern uint	u_not_implemented();
extern void	not_implemented();

/******** SPM METHODS ********/

static void
spm_display_slot()
{
	printf("SPM in slot %u.\n", spm_slot);
}

/**************** LOW LEVEL DEBUGGER OPERATIONS *****************/

static uint
spm_get_byte(addr)
uint	addr;
{
	uchar	ch;

	if (!probe_rd_byte(addr, &ch)) {
		printf("bus error reading from local memory at 0x%08x\n", addr);
		rtn_to_monitor();
	}
	return(ch);
}

static void
spm_put_byte(addr, value)
uint	addr;
uint	value;
{
	if (!probe_wr_byte(addr, value)) {
		printf("bus error writing to local memory at 0x%08x\n", addr);
		rtn_to_monitor();
	}
}

static uint
spm_get_short(addr)
uint	addr;
{
	ushort	sh;

	if (!probe_rd_short(addr, &sh)) {
		printf("bus error reading from local memory at 0x%08x\n", addr);
		rtn_to_monitor();
	}	
	return(sh);
}

static void
spm_put_short(addr, value)
uint	addr;
uint	value;
{
	if (!probe_wr_short(addr, value)) {
		printf("bus error writing to local memory at 0x%08x\n", addr);
		rtn_to_monitor();
	}
}

static uint
spm_get_long(addr)
uint	addr;
{
	uint	long_word;

	if (!probe_rd_long(addr, &long_word)) {
		printf("bus error reading from local memory at 0x%08x\n", addr);
		rtn_to_monitor();
	}	
	return(long_word);
}

static void
spm_put_long(addr, value)
uint	addr;
uint	value;
{
	if (!probe_wr_long(addr, value)) {
		printf("bus error writing to local memory at 0x%08x\n", addr);
		rtn_to_monitor();
	}
}

/*****************************************/

static void *
spm_rtn_null()
{
	return(NULL);
}

static uint
spm_rtn_zero()
{
	return(0);
}

static uint
spm_rtn_one()
{
	return(1);
}

static void
spm_rtn_void()
{
}

static uchar *
spm_symbolic_version(addr)
uint	addr;
{
	static char	str[12];

	sprintf(str, "%08x", addr);
	return ((uchar *)str);
}

static uint
spm_valid_fp(addr)
uint	addr;
{
	extern uint	end[], stack_end[];

	return (addr > (uint)end && addr < (uint)stack_end);
}

static uint
spm_check_coffdata(addr)
uint	addr;
{
	if (addr < sa_load_point ||
	    addr >= sa_load_point + sa_mem_requirement) {
		printf("0x%08x is a bad address for a standalone!\n", addr);
		printf("Indicates wrong slot or wrong program!\n");
		return(0);
	}
	return(1);
}

static uint
spm_check_magic(number)
short	number;
{
	if (number == A68020MAGIC)
		return(1);
	printf("file is not an 020 binary\n");
	return(0);
}

/************** END OF METHODS ***************/


static void
spm_setup_methods(mp)
register method_t	*mp;
{
	extern void 	spm_backtrace();

	mp->check_printf = spm_rtn_void;
	mp->send_clock = spm_rtn_zero;
	mp->stop = spm_rtn_void;

	mp->display_slot = spm_display_slot;

	mp->load = spm_rtn_zero;
	mp->set_pm_id = spm_rtn_void;
	mp->check_coffdata = spm_check_coffdata;
	mp->check_magic = spm_check_magic;
	mp->prep_for_syms = spm_rtn_zero;
	mp->load_syms = spm_rtn_one;
	mp->prep_boot = spm_rtn_zero;
	mp->start = spm_rtn_void;
	mp->check_tdb = spm_rtn_zero;
	mp->prepare_to_go = spm_rtn_one;
	mp->go = spm_rtn_void;
	mp->show_trap = not_implemented;

	mp->pm_first = u_not_implemented;
	mp->print_vtop = not_implemented;	/* generic vtop?? */
	mp->mem_stripe_init = u_not_implemented;
	mp->build_page_table = spm_rtn_void;
	mp->get_u_addr = u_not_implemented;

	mp->get_byte = spm_get_byte;
	mp->put_byte = spm_put_byte;
	mp->get_short = spm_get_short;
	mp->put_short = spm_put_short;
	mp->get_long = spm_get_long;
	mp->put_long = spm_put_long;
	mp->get_named_reg = u_not_implemented;
	mp->put_named_reg = not_implemented;

	mp->step = not_implemented;
	mp->jump = not_implemented;
	mp->brkpt_check = not_implemented;
	mp->display_own = not_implemented;
	mp->display_dis = m68k_display_dis;
	mp->symbolic_version = spm_symbolic_version;
	mp->find_bp = (BRK_TAB *(*)())spm_rtn_null;
	mp->backtrace = spm_backtrace;
	mp->valid_fp = spm_valid_fp;
	mp->set_brkpt = not_implemented;
	mp->clear_one_brkpt = not_implemented;
	mp->clear_brkpts = spm_rtn_void;
	mp->display_brkpts = spm_rtn_void;

	mp->check_tags = not_implemented;
	mp->solo = not_implemented;
	mp->deconfigure = not_implemented;
	mp->configure = not_implemented;
	mp->cpu_copyout = bcopy;
	mp->cpu_copyin = bcopy;
	mp->cpu_malloc = spm_rtn_zero;
	mp->cpu_zero = bzero;
}

static method_t	spm_methods;

void
spm_setup(slot)
uint	slot;
{
	spm_setup_methods(&spm_methods);
	spm_info.cu_unit.i = IUNIT_NO_DEV;
	spm_info.cu_unit.s.slot = slot;
	spm_info.cu_methods = &spm_methods;

	cpu_enroll(&spm_info.cpu_data);
}
