/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iopm.c: version 25.1 created on 11/27/91 at 15:29:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iopm.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* iopm.c  */

#include "misc.h"
#include "global.h"
#include "spm.h"
#include "scc.h"
#include "iomap.h"
#include "sys/types.h"
#include "rwi.h"
#include "sa_dir.h"
#include "spm_debug.h"
#include "sys/sbus.h"
#include "sys/iopmcomm.h"
#include "sys/iopmsltbl.h"
#include "sys/iopmioctl.h"
#include "sys/sbus_iopm.h"
#include "sys/css_bd_dat.h"

#include "novram.h"
#include "cpu_method.h"
#include "iopm_data.h"
#include "slotdefs.h"
#include "iom_config.h"
#include "saio.h"
#include "dev.h"

extern uint		iom_count;

extern iom_config_t	*find_iom();
extern iopm_data_t	*iopm_slot_to_desc();
extern unchar		*iopm_map();
extern char		*s_str(), *strcpy();
extern void		iopm_comm_init();


/*
 * extract_iopm_dev -- converts source_dev into an IOPM/DSDB download path
 *			Returns zero on errors.
 */
extract_iopm_dev(source_dev)
char	source_dev[DEV_NAMLEN];
{
	iunit_t	unit;
	char	*p;
	devsw_t	*dsp, *get_dev();

	if ((dsp = get_dev(source_dev, &unit, &p)) == NULL || p == NULL) {
		printf("%s : No user specified or default boot path found!\n",
		  source_dev);
		return (0);
	}
	if (dsp->dv_id != DV_IOPM_DK) {
		printf("%s is not an IOPM/DSDB disk device!\n", source_dev);
		return (0);
	}
	strncpy(p, "iopm/iopm.dsdb", DEV_NAMLEN - (p - source_dev));
	return(1);
}

/* iopm_size_mem(desc) - Size iopm RAM.  Works for memory sizes that are
 *	a power of two (1 meg, 2 meg, and 4 meg).
 */
#define	LAST_WORD(size)	(IOPM_RAM_START + (size) - sizeof(uint))
uint
iopm_size_mem(desc)
iopm_data_t	*desc;
{
	register uint	saved_map = iomap_save();
	register uint	iopm_ram_size;

	/* 1. Put value representing mem size to last long at 1,2 and 4 megs. */
	*(uint *)iopm_map(desc, LAST_WORD(0x400000)) = 0x400000;
	*(uint *)iopm_map(desc, LAST_WORD(0x200000)) = 0x200000;
	*(uint *)iopm_map(desc, LAST_WORD(0x100000)) = 0x100000;
	
	/* 2. Read back last word at 4 meg. */
	iopm_ram_size = *(uint *)iopm_map(desc, LAST_WORD(0x400000));

	/* 3. Taking advantage of not decodeing all addr lines, the last long
	 *    read back from '4 megs' is a value written above (2.) that
	 *    represents size of memory on the IOPM.
	 */
	if (iopm_ram_size != 0x100000)
		printf("IOPM %s has a non-standard 4-meg RAM configuration\n",
			s_str(desc));

	iomap_restore(saved_map);
	return(iopm_ram_size);
}

/*
 * get_db_id -- find out an IOPM's device board ID
 */

static uint
get_db_id(desc)
iopm_data_t	*desc;
{
	uint	saved_map = iomap_save();
	uchar	id_byte;

	/* 1. Negate reset on device board (required for ACDB) */
	if (!probe_wr_short(iopm_map(desc, CONFIG_REG), (ushort)DEV_RST_OUT)) {
		printf("slot %s: Bad write of IOPM config control register!\n",
			s_str(desc));
		iomap_restore(saved_map);
		return (IOPM_NO_DB);
	}

	/* 2. Read device board id, if no device board, probe read will fail */
	if (!probe_rd_byte(iopm_map(desc, IOPM_DB_ID_REG), &id_byte)) {
		id_byte = IOPM_NO_DB;
		disable_any_module(desc->cu_unit.w.sns);
	}

	iomap_restore(saved_map);
	return(id_byte);
}

void
iopm_hw_mem_init(i_desc)
iopm_data_t	*i_desc;
{
	uint	savmap = iomap_save();
	uchar	*iopm_ram;
	uint	cur_write;

	iopm_ram = iopm_map(i_desc, IOPM_RAM_START);

	/* 1. Stabilize IOPM's memory controller.  8 long writes to iopm local
	 *    mem will stablize mem controller.
	 */
	for (cur_write = 0; cur_write < 8; cur_write++)
		if (!probe_wr_long((uint *)iopm_ram, 0)) {
			printf("slot %s: Bad stabilizing write of IOPM ram!\n",
				s_str(i_desc));
			iomap_restore(savmap);
			return;
		}

	/* 2. Size and zero IOPM's memory. */
	i_desc->memsize = iopm_size_mem(i_desc); /* Size memory! */
	bzero(iopm_ram, i_desc->memsize);	 /* Zero (init) memory! */

	/* 3. Identify the device board atttached to the IOPM. */
	i_desc->db_id = get_db_id(i_desc);	 /* Get device board id! */

	iomap_restore(savmap);
}

void
iopm_init(i_desc)
iopm_data_t	*i_desc;
{
	uint	savmap = iomap_save();

	/* 1. Disable CSS module (in this case the IOPM). */
	disable_any_module(i_desc->cu_unit.w.sns);

	/* 2. Initialize the IOPM specific stuff. */
	iopm_hw_mem_init(i_desc);

	/* 3. Disable IOPM proms, enable map registers */
	if (!probe_wr_short(iopm_map(i_desc, CONFIG_REG),
			    CLR_ERR | DEV_RST_OUT | DIS_PROM)) {
		printf("slot %s: Bad write of IOPM config control register!\n",
			s_str(i_desc));
		iomap_restore(savmap);
		return;
	}

	iomap_restore(savmap);
}

/*
 *  iopm_init_maps() - Initialize the IOPM mapping registers.
 */
void
iopm_init_maps(desc)
iopm_data_t	*desc;
{
	uint            saved_map = iomap_save();
	extern uchar 	mem_slots[];

	/* set IOPM's first map register to first stripped mem card */
	*(unchar *)iopm_map(desc, MAP_BASE_REG) = mem_slots[0] << 4;

	iomap_restore(saved_map);
}

void
iopm_start_hardware(desc)
iopm_data_t	*desc;
{
	uint            saved_map = iomap_save();

#if 1	/* FIX joe, BACKBURNER 2 */
	/* disable IOPM proms, enable map registers */
	*(ushort *)iopm_map(desc, CONFIG_REG) =
		CLR_ERR | DEV_RST_OUT | DIS_PROM;
#endif

	iopm_init_maps(desc);

	/* FIX joe, IOPM_sp = memsize ???, also should be 100000 -- not ffffc */
	/* IOPM will see this at IOPM addr 0 thru the first map reg */
	Spm_Mem->IOPM_sp = 0xffffc;	/* init IOPM sp, not used */
	Spm_Mem->IOPM_pc = desc->entry;

	enable_any_module(desc->cu_unit.w.sns);
	desc->state = STATE_ENABLED;
	delay(HZ/2 + 1);	/* FIX joe, Create a define for delay factor. */
	iomap_restore(saved_map);
}

/* FIX joe, needs restructuring. */
/* also get rid of iopm_check_print and its extern declaration. */
extern void	iopm_check_printf();
void
iopm_uptime_start(desc)
iopm_data_t	*desc;
{
	register uint           saved_map = iomap_save();
	register iopm_comm_t 	*iopcommp;
	uint			b_response;
	register uint		loopcnt;

	/* Spm_Mem must be previously set up by spm_mem_copy in PM_start */
	ASSERT(spm_mem_copy_called);

	iomap_restore(desc->iopm_comm_map);	/* now iopm_comm_ptr is valid */
	iopcommp = desc->iopm_comm_ptr;
	iopcommp->o_tdb.cmd = TDB_CMD_GO;
	iopcommp->o_boot_response = 0;

	iopm_start_hardware(desc);

	/* wait for IOPM boot response flag */
	loopcnt = HZ * 2;
	do {
		delay_check_iomap(1);
		if (--loopcnt == 0) {
			printf("slot %s: IOPM to SPM boot response timeout\n",
				s_str(desc));
			return;
		}
		if (!probe_rd_long(&iopcommp->o_boot_response, &b_response)) {
			printf("slot %s: Bad read of IOPM boot response\n",
				s_str(desc));
			return;
		}
	} while (!b_response);

	if ( iopcommp->iopm_version != IOPM_VERSION )
		printf("Mismatched iopm_os version numbers: iopm:%x, spm:%x\n",
		       iopcommp->iopm_version, IOPM_VERSION );
	else {
		printf("IOPM in slot %s booted.\n", s_str(desc));
		desc->state = STATE_RUNNING;
	}
	iomap_restore(saved_map);
}

/* FIX joe, upon cleaning up the prom-to-spm interface, this routine will
 * go away because device board info will be in the local config DS.
 *** Meanwhile, returns the IOPM device board for a give slot/subslot. ***
 */
static uint
get_iopm_dev_bd_id(slot, subslot)
uint	slot;
uint	subslot;
{
	iom_config_t	*iomp;

	if (subslot == SBUS_NO_BOARD)
		return (sbus_config.dev_board_id[slot]);

	ASSERT(sbus_config.slot_id[slot] == SBUS_NIOM);
	if (iomp = find_iom(slot))
		return (iomp->ex_card_cage.css_bd_dat[subslot].dev_board_id);

	return (IOPM_NO_DB);
}

char *
iopm_id_str(slot, subslot)
uint	slot;
uint	subslot;
{
	switch (get_iopm_dev_bd_id(slot, subslot)) {
	case IOPM_DB_ID_DSDB:
/***	case IOPM_DB_ID_DSDB_FIX:	* FIX JPC: no longer needed?? ***/
		return ("IOPM/DSDB   ");
	case IOPM_DB_ID_ACDB:
		return ("IOPM/ACDB   ");
	case IOPM_DB_ID_ACDB_38K:
		return ("IOPM/ACDB 38");
	case IOPM_DB_ID_LAN_WAN:
		return ("IOPM/LAN-WAN");
	case IOPM_DB_ID_IOPM_TEST1:
	case IOPM_DB_ID_IOPM_TEST2:
		return ("IOPM/TEST BD");
	case IOPM_NO_DB:
		return ("IOPM/NOBOARD");
	}
	return ("IOPM/UNKNOWN");
}

/*
 * Pm has decided we want to unset the IOPM
 * (it is still loaded) so we take the appropriate actions.
 * Return 0 for fail, !0 for succeed
 */
uint
iopm_cmd_unreset(ioslot, pm_spm_data)
uint	ioslot;
uint	pm_spm_data;
{
	register iopm_data_t	*desc;
	iunit_t			iunit;

	iunit.i = 0;
	iunit.s.slot = ioslot >> 4;	/* FIX JPC: why isn't there a .h file?*/
	if ((iunit.s.subslot = ioslot & 0xf) == 0xf)
		iunit.s.subslot = SBUS_NO_BOARD;

	if ((desc = iopm_slot_to_desc(iunit)) == NULL)
		return(0);

	desc->state = STATE_LOADED;
	desc->entry = pm_spm_data;
	iopm_uptime_start(desc);
	return(desc->state == STATE_RUNNING);
}

uint
iopm_cmd_reset(ioslot)
uint	ioslot;
{
	register iopm_data_t	*desc;
	iunit_t			iunit;

	iunit.i = 0;
	iunit.s.slot = ioslot >> 4; /* FIX JPC: why isn't there a .h file?*/
	if ((iunit.s.subslot = ioslot & 0xf) == 0xf)
		iunit.s.subslot = SBUS_NO_BOARD;
        K_ASSERT(sbus_config.slot_id[iunit.s.slot] == SBUS_IOPM ||
	         sbus_config.slot_id[iunit.s.slot] == SBUS_NIOM);

	/* reset the IOPM */
	desc = iopm_slot_to_desc(iunit);
	desc->state = STATE_INIT;
	disable_any_module(desc->cu_unit.w.sns);
	iopm_init(desc);
	iopm_comm_init(desc);
	return(0);
}

/*
 * show_controllers -- print the names of valid disk controllers
 */

show_controllers()
{
	register uint		slot, n;
	register iom_config_t	*iomp;
	register css_bd_dat_t	*csbp;

	for (slot = 0; slot < SBUS_NUM_SLOT; slot++)
		if (sbus_config.slot_id[slot] == SBUS_IOPM &&
		    sbus_config.dev_board_id[slot] == IOPM_DB_ID_DSDB)
			printf(" IOPM/DSDB %d\n", slot);

	for (iomp = iom_config, n = 0; n < iom_count; n++, iomp++) {
		csbp = iomp->ex_card_cage.css_bd_dat;
		for (slot = 0; slot < SBUS_NUM_SLOT; slot++, csbp++)
			if (csbp->css_slot_id == SBUS_IOPM &&
			    csbp->dev_board_id == IOPM_DB_ID_DSDB)
				printf(" IOPM/DSDB %d/%d\n",
				  iomp->iom_slot, slot);
	}
}
