/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tool.c: version 25.1 created on 11/27/91 at 15:29:09	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tool.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* tools.c */
#include "local.h"			/* this directory temp. XXX*/

char *ascldtype[] = {
	"NULL", "FSYS", "SWAP", "PWRF",
	"HOLE", "SPARE", "SKIP", "SPLIT"
};


extern char	*strrchr();
extern 		free_buf();
extern 		bzero();

/* 
 *	device_ldname: insert a null after the ld specifier in a filename.
 *	e.g. 15/10d2s9arix will be changed to 15/10d2s9
 */

/*#define FsMAGIC	0xfd187e20	/* s_magic */

rd_sup_blk(fnamebuf)
char *fnamebuf;
{
	if ((disk_fd = open(fnamebuf,0)) < 0) {
	    printf("cannot open file system %s\n",fnamebuf);
	    return(-1);
	}

	read_blk(0, superblk);	/* read sector zero(superblock) in*/

	if(verbose)
		printf("magic = (0x%x)  fstate %x  \n",
	     	  superb_ptr->s_magic,superb_ptr->s_state);

	isize = (daddr_t)superb_ptr->s_isize;	/* total inode blocks/slice */
	fsize = (daddr_t)superb_ptr->s_fsize;	/* total blocks on slice */
	imax = isize * (BSIZE/sizeof(DINODE));/* total inodes/slice */

	close(disk_fd);
	return(superb_ptr->s_type);
}



read_blk(bno, buf )
daddr_t bno; char *buf; 
{
	register int n;

	if(lseekck(disk_fd, bno*BSIZE, 0) <0)
		return(-1);

	if((n = read(disk_fd, buf, BSIZE)) != BSIZE) {
		printf("read error: %ld\r\n", bno);
		return(-1);
	}
	return(n);
	
}

lseekck( p, h)
{
	register int rc;

	if ((rc = lseek(disk_fd, p, h)) < 0)
		printf("lseek(0x%x, 0x%x, 0x%x) error 0x%x\n",disk_fd,p, h, rc);
	return(rc);
}


void
device_ldname(str)
register char	*str;
{
	while (isdigit(*str))			/* skip leading number */
		++str;
	if (*str++ != '/')
		return;				/* not a ld specifier */
	while (isdigit(*str))
		++str;
	if (*str++ != 'd')
		return;
	while (isdigit(*str))
		++str;
	if (*str++ != 's')
		return;
	while (isdigit(*str))
		++str;
	*str = '\0';				/* terminate the string */
}

print_blk(buf,count)
register char *buf;
{

	int i, *ptr;
	

	for(i=0,ptr =  (int  *)buf;i<(count + 3) / 4;i++){
		if(!(i%16)) printf("\n");
		printf("%x ",*ptr);
		ptr++;
	}
	if(count == sizeof(DINODE))
		printf(" SIZE (%d) CTIME (%d) ",((DINODE *)(buf))->di_size,
			((DINODE *)(buf))->di_ctime);
}

/* allocate a data buffer */

struct blk_list *
get_buf()			/* get a buffer structure */
{
	register i;
	
	for(i=0;i<BUFF_NUM;i++)
		if(blk_list[i].used == 0)
			return(&blk_list[i]);
	printf("get_buf out  of buffer :: exit:");
	return((struct blk_list *)-1);		/* no free buffers */
}
/* return the buffer to availability */

free_buf(buf_ptr)			/* get a buffer structure */
register struct blk_list *buf_ptr;
{
	if( buf_ptr->used == 0){
		printf("\n:free_buf returning buffer to free list exit: ");
		exit(1);
	}				/* should not happen */
	buf_ptr->used = 0;		/* recycle buffer */
}


reply()
{
	char line[80];

	line[0] = '\0';

	while (line[0] == '\0') {
		gets(line);
		if(line[0] == 'y' || line[0] == 'Y')
			return(YES);
		if(line[0] == 'n' || line[0] == 'N')
			return(NO);
		printf("\nAnswer 'y' or 'n'  ");
		line[0] = '\0';
		printf("\n");
	}
return(NO);
}


/*
 * ls_flags -- build a ls -l style mode bit string
 */

ls_flags(sp, buf)
register struct stat	*sp;
char			*buf;
{
	register int	mode, i;
	register char	*p;
	static char	ls_types[] = "?pc?d?b?-???????";

	p = buf;
	p[0] = ls_types[(sp->st_mode >> 12) & (S_IFMT >> 12)];
	p[10] = '\0';
	p += 7;
	for (mode = sp->st_mode, i = 3; --i >= 0; mode >>= 3, p -= 3) {
		p[0] = (mode & S_IROTH) ? 'r' : '-';
		p[1] = (mode & S_IWOTH) ? 'w' : '-';
		p[2] = (mode & S_IXOTH) ? 'x' : '-';
	}
	p = buf;
	if ((mode = sp->st_mode) & S_ISUID)
		p[3] = (mode & S_IXUSR) ? 's' : 'S';
	if ((mode = sp->st_mode) & S_ISGID)
		p[6] = (mode & S_IXGRP) ? 's' : 'l';
	if ((mode = sp->st_mode) & S_ISVTX)
		p[9] = (mode & S_IXGRP) ? 't' : 'T';
}


/*
 * pathend -- return a pointer to the last component of a pathname
 *		Now recognizes device descriptors
 */

char *
pathend(path)
register char	*path;
{
	register char	*p;
	char		tmp[4*DEV_NAMLEN];

	strcpy(tmp, path);
	device_ldname(tmp);

	if (strcmp(path, tmp) != 0) {
		path += strlen(tmp);

		if (p = strrchr(path, '/'))
			return (p + 1);
	}

	return (path);
}

/*
 * ls_str -- replace all non-printable characters with '?'s
 */

ls_str(str)
register char	*str;
{
	register int	c;

	while (c = *str)
		if (!isascii(c) || !isprint(c))
			*str++ = '?';
		else
			++str;
}
