#	START NEW ARIX SCCS HEADER
#
#	@(#) secure.mk: version 25.1 created on 11/27/91 at 15:29:06
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)secure.mk	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	@(#)secure.mk	1.3

include $(IROOT)/macdefs

NAME = secure
VERS = 1
HDR = ../../lib/standhead.o
LIBFLAG = -L../../lib -lsc
LDF = ../../lib/ld.util
SINC = ../../head
VERFLAG = -VS 3200
SPMINC=../spm/head

CFILES =   global.c	main.c    tool.c	report.c     	check.c\
		secure.c	

OFILES =  global.o	main.o    tool.o	report.o	check.o	\
	        secure.o    misc.o

SFILES = misc.s

CFLAG =  -DSTANDALONE $(CFLAGS)

.SUFFIXES: .c .o

.c.o:
	$(CC) -c $(CFLAG) -I$(INCRT) -I. -I$(SINC) -I$(SPMINC) $<
.c.s:
	$(CC) -S $(CFLAG) -I$(SPMINC) -I$(SINC) $<

all install:	$(NAME)

$(NAME):	$(OFILES)
	$(LD) -o $(NAME) $(LDF) $(HDR) $(OFILES) $(LIBFLAG) $(VERFLAG)
	nm -xv $(NAME) | grep -v '| file |' | sort -t'|' +1 -2 +0 > $(NAME).map
	strip $(NAME)

unixstandalone:
	$(MAKE) -ef secure.mk "CFLAG=$(CFLAG) -DUNIXSTANDALONE" \
			     "NAME=$(NAME).unix"

clean:
	-rm -f $(OFILES)

clobber: clean
	-rm -f $(NAME) $(NAME).map

global.o:	local.h
tools.o:	local.h
check.o:	local.h
main.o:		local.h
mkfs.o:		local.h
report.o:	local.h
secure.o:	local.h
