/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) secure.c: version 25.1 created on 11/27/91 at 15:29:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)secure.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <sys/stat.h>
#include "sys/fcntl.h"
#include "local.h"

extern uint get_device_name();
extern reply();

read_data(fd)
int fd;				/* file descriptor passed in */
{
	int bytes ,loop ,ret ,i;
	int totbytes = 0 ,totcount = 0;
	char *bp  = (char *)&fill; 	/* room for 150 records */
	int max = sizeof(struct fill);
	char dummy[NSIZE];
	uint dev_type;
	FIL *fptr = (FIL *)(bp+4) ;


        printf("Is the secure data the first record on this tape? :");
	if (!reply()) {
		printf("How many records should be skipped? : ");
		gets(dummy);
		loop = atoi(dummy);
		for( i=1;loop--;i++)
		    if((ret = ioctl(fd,REOF,dummy)) < 0) {
			printf("cannot seek to record (%d) on tape (%s)\n",
			    i,input_buf);
			close(fd);
			return(0);
		    }
	}


	while(totbytes <=(max - BSIZE) &&
		((bytes = read(fd,bp,BSIZE)) > 0)){
		totbytes += bytes;
		bp += BSIZE;
	}
	close(fd);
	totcount = totbytes/sizeof(FIL);
	return(totcount);
}


check_secure(stat_buf,err_buf,f_ptr)
struct stat *stat_buf;
struct fil_err *err_buf;
FIL *f_ptr;
{
	int err;
	register struct stat *g_ptr, *b_ptr;

	err = 0;
	g_ptr = &err_buf->good_stat;
	b_ptr = &err_buf->bad_stat;
	if(f_ptr->f_stat.st_ino != stat_buf->st_ino){
		if(verbose)
		printf("(%s) inode (%x) ",f_ptr->fname,stat_buf->st_ino);
		b_ptr->st_ino = stat_buf->st_ino ;
		err++;
	}
	if(f_ptr->f_stat.st_mode != stat_buf->st_mode){
		if(verbose)
		printf("(%s) mode (%x) ",f_ptr->fname,stat_buf->st_mode);
		b_ptr->st_mode = stat_buf->st_mode ;
		err++;
	}
	if(f_ptr->f_stat.st_nlink != stat_buf->st_nlink){
		b_ptr->st_nlink = stat_buf->st_nlink ;
	    if(verbose)
		printf("(%s) nlink (%d) ",f_ptr->fname,b_ptr->st_nlink);
		err++;
	}
	if(f_ptr->f_stat.st_uid != stat_buf->st_uid){
		b_ptr->st_uid = stat_buf->st_uid ;
		if(verbose)
		printf("(%s) uid (%d) ",f_ptr->fname,b_ptr->st_uid);
		err++;
	}
	if(f_ptr->f_stat.st_gid != stat_buf->st_gid){
		if(verbose)
		    printf("(%s) gid (%d) ",f_ptr->fname,stat_buf->st_gid);
		b_ptr->st_gid = stat_buf->st_gid ;
		err++;
	}
	if(f_ptr->f_stat.st_size != stat_buf->st_size){
		if(verbose)
		    printf("(%s) size (%d) ",f_ptr->fname,stat_buf->st_size);
		b_ptr->st_size = stat_buf->st_size ;
		err++;
	}
	if(f_ptr->f_stat.st_mtime != stat_buf->st_mtime){
		if(verbose)
		    printf("(%s) mtime (%d) ",f_ptr->fname,stat_buf->st_mtime);
		b_ptr->st_mtime = stat_buf->st_mtime ;
		err++;
	}
	if(f_ptr->f_stat.st_ctime != stat_buf->st_ctime){
		if(verbose)
		    printf("(%s) ctime (%d) ",f_ptr->fname,stat_buf->st_ctime);
		b_ptr->st_ctime = stat_buf->st_ctime ;
		err++;
	}

	return(err);
}



/*  SECURE calls routines to read the disk status of secure files.
 *  Compare the status with the stored records.
 *  Report the files that differ and how they differ.
 */
char full_name[NSIZE+20];

secure(num,p_dev)
int *num;
char *p_dev;
{
	struct	fil_err	*err_buf_ptr = error_buf; /* first error record */
	struct	fil	*fil_ptr = fill.un.fil;   /* stored stats */
	struct stat 	st_buf;
	struct stat 	*sp = &st_buf;
	int sum ,err ,name_fail = 0;
	char fname[NSIZE];			  /* store the name tested */
	int i ,count = 0,dot = 0;

	files=0;				/* reinitialize global counter*/
	fil_ptr = (FIL *)((char *)fil_ptr + 4); /* strip magic */
	for(i=0; i< *num, i<FILL_SZ, fil_ptr->fname[0] != '\0';i++ ,fil_ptr++){
		strcpy(fname,fil_ptr->fname);
		strcpy(full_name,fname);
		pre_leader(full_name, p_dev); 	/* this is now in fstat format*/
		err = 0;			/* keep track of each file */
		files++;			/* total files on tape */
		if(sec_read(full_name, sp) == -1){
			strcpy(err_buf_ptr->fname,full_name,NSIZE+20);
			err_buf_ptr->bad_stat.st_dev = -1;
			err_buf_ptr++;		/* get the next error buffer */
			count++;
			if(!(++name_fail% 3)){ /* allow second thoughts */
				printf("\n(%s) is number (%d) file missing from"
					,name_fail -1);
				printf(" the system, continue? ");
				if(!reply)
					return(0);
			}
			continue;/* if can't open file nothing else to check */
		}
	/* sec_read has left the file open and file desc. is global */ 
		if(err = check_secure(&st_buf,err_buf_ptr,fil_ptr))
			strcpy(err_buf_ptr->fname,fname,NSIZE);
		sum = check_sum(full_name);
		if(sum != fil_ptr->sum){ /* check sum match  ??  */
			err_buf_ptr->good_sum = fil_ptr->sum;
			err_buf_ptr->bad_sum = sum;
			err++;	
		}
		if(err){
			err_buf_ptr++;		/* get the next error buffer */
			count += err;
		}
		if(!err && verbose)		/* print each file name */
			printf("(%s) : ok\n",fil_ptr->fname);
	}
	return(count);
}


/*
 *  fstat each entry and check for scurity affirmation
 */

sec_read(name, sp)
char		*name; /* should be the whole name X/YdNs0./filename */
struct stat	*sp;
{
	char	lsflags[16];


	if ((disk_fd = open(name, 0)) < 0) {
		if(verbose)
			printf("open on %s failed\n", name);
		return (-1);
	}
	if (fstat(disk_fd, sp)) {
		if(verbose)
			printf("sec_read: fstat of %s failed!\n", name);
		close(disk_fd);
		return (-1);
	}
	
	return (0);
}

union {
	unsigned u_sum;
	unsigned char u_csum[4];
}sum;
check_sum(name)
char *name;
{
	char c_s_buf[BSIZE]; /* local read buffer for check_sum */
	register char *ptr;
	int bytes;
	unsigned total,nbytes;
	register int ca ;
	total = 0;
	nbytes = 0;

	while((bytes = read(disk_fd,c_s_buf,BSIZE)) > 0){
		ptr = c_s_buf;		/* point to start again */
		while( bytes--) {
			ca = *ptr++;
			nbytes++;
			sum.u_csum[nbytes&3] = ca;
			if((nbytes & 3) == 0)
				total += sum.u_sum;	
		}
	}
	/* This is just to make sure that we get the bytes that may have
	 partially been stored in the integer storage just before we
	 jumped out of the loop.  It doesn't matter that we may have some
	 bytes left over from before or that we may add these in a second
	 time.  It only matters that the functions which store the 
	 information and the one that retrieves it use the same checksum
	 routine.
	*/
	total += sum.u_sum;
	close(disk_fd);
	return(total);
}

show_stat(f_ptr)
FIL *f_ptr;
{

struct stat *st_ptr = (struct stat *)&(f_ptr->f_stat);
printf("_(%s) ",f_ptr->fname);
printf("fptr %x mode %o inum %d  link %d  Uid %d  Gid %d  \n",f_ptr ,
st_ptr->st_mode,st_ptr->st_ino,st_ptr->st_nlink,st_ptr->st_uid,st_ptr->st_gid);

/*printf("         size %d  atime %d  mti %d  ctm %d",st_ptr->st_size,
	st_ptr->st_atime,st_ptr->st_mtime, st_ptr->st_ctime);
*/
}
/********************* *****************/
