/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) report.c: version 25.1 created on 11/27/91 at 15:28:58	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)report.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* report.c */
#include "local.h"			/* this directory temp. XXX*/

/*	Record trolls through the error_buf strcuture and reports 	*
 *	the errors in long or short format . The fields tested are	*
 *	a one to one representation of the stat stuctures except for	*
 *	the fields: st_dev -> used to verify name present		*
 *		    sum    -> which is not part of the stat structure	*/

report(number)
{

	ERR *err_ptr = error_buf;		/* stored errors for session */
	int errors = 0;				/* for report count */
	int file_errors = number;		/* for file report count */
	int names = 0;


	if((!err_ptr->fname) && !number && !err_record ){	/* no errors hoorah */
		printf("\n           ");
		printf(" (%s) passed security (%d) files were checked",
			secure_buf,files);
		printf("\n\n           ");
		printf(" The system may be booted to level one \n");
		return(0);
	}
	printf("\n\n");
	while(err_ptr->fname && number--){
		printf("(%d) %s  : ",names,err_ptr->fname);
		names++;
		if(err_ptr->bad_stat.st_dev){
			printf("not found at expected location\n");  
			errors++;
			err_ptr++;
			continue;
		}
		if(err_print(err_ptr)){
			printf("\n");
			err_ptr++;
			continue;
		}
		
		printf(": ok \n");
	}			/* out of names to report */
	    printf("\n           ");
	    printf("The system (%s) failed the security check\n",secure_buf);
	    printf("           ");
	    printf("(%d) files were checked (%d) files are missing", 
			files ,errors);
	    printf("\nYour options are :\n");
	    printf("           boot to single user and correct errors\n");
	    printf("           make a new file system from tape with mkfs\n");
	    return(0);
}
		
/*	Print error fields */

err_print(err_ptr)
ERR *err_ptr ;		/*print stored errors for session */
{
	int error = 0;

	if(err_ptr->bad_stat.st_mode){
		printf(" modes");
		error++;
	}
	if(err_ptr->bad_stat.st_nlink){
		printf(" links");
		error++;
	}
	if(err_ptr->bad_stat.st_uid){
		printf(" uids");
		error++;
	}
	if(err_ptr->bad_stat.st_gid){
		printf(" gids");
		error++;
	}
	if(err_ptr->bad_stat.st_size){
		printf(" sizes");
		error++;
	}
	if(err_ptr->bad_stat.st_mtime){
		printf(" modification times");
		error++;
	}
	if(err_ptr->bad_stat.st_ctime){
		printf(" creation times");
		error++;
	}
	if(err_ptr->bad_sum){
		printf(" check sums");
		error++;
	}
	if(error) printf(" differ");
	return(error);
}
