#	START NEW ARIX SCCS HEADER
#
#	@(#) misc.s: version 25.1 created on 11/27/91 at 15:28:54
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)misc.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)misc.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#	@(#)misc.s	2.1
#-----------------------------------------------------------------------------
#
#	M I S C
#
#-----------------------------------------------------------------------------

	global	bcopy, bzero, bset_long, Chgint
	global	spl0,spl1,spl2,spl3,spl4,spl5,spl6,spl7,get_spl,splx
	global	spl_console, splhi
	global	strrchr, strncpy, strncmp, strncat, strlen
	global	strcpy, strcmp, strchr, strcat

	set	NS,2	# shift to get nbr of long moves/clears

	text


#------------------------------------------------------------------
#
#	B C O P Y
#
#	bcopy(source, destination, count)
#
#------------------------------------------------------------------

# bcopy(from, to, bytes)
#	"to" and "from" are both system physical addresses

	global	bcopy
bcopy:	mov.l	4(%sp),%a0	# from
	mov.l	8(%sp),%a1	# to
	mov.l	12(%sp),%d1	# number of bytes
	ble.b	L%done
	mov.w	%a0,%d0		# long align (at least) one address
	and.w	&3,%d0
	beq.b	L%cl1		# already aligned
	neg.w	%d0		# compute (4-addr%4)-1 (i.e. loop count)
	add.w	&3,%d0
L%cl7:	mov.b	(%a0)+,(%a1)+	# move one byte
	sub.l	&1,%d1		# decrement count by one byte
	dbeq	%d0,L%cl7	# loop while not aligned & more bytes
L%cl1:	mov.l	%d1,%d0		# save count
	lsr.l	&NS,%d1		# adjust count for long loop
	bra.b	L%cl5

L%cl2:	swap	%d1		# outer dbra loop
L%cl3:	mov.l	(%a0)+,(%a1)+	# inner dbra loop: move longs
L%cl5:	dbra	%d1,L%cl3
	swap	%d1
	dbra	%d1,L%cl2

	and.w	&3,%d0
	bra.b	L%cl6
L%cl9:	mov.b	(%a0)+,(%a1)+
L%cl6:	dbra	%d0,L%cl9

L%done:	mov.l	&0,%d0		# return (0)
	rts


#------------------------------------------------------------------
#
#	B Z E R O
#
#	bzero(address, count)
#
#------------------------------------------------------------------

# bzero(addr, size)
#	addr is a physical address
#	size is in bytes

	global	bzero
bzero:	mov.l	4(%sp),%a0	# address
	mov.l	8(%sp),%d1	# number of bytes
	ble.b	L%done
	sub.l	%a1,%a1		# constant zero
	mov.w	%a0,%d0		# long align address
	and.w	&3,%d0
	beq.b	L%zl1		# already aligned
	neg.w	%d0		# compute (4-addr%4)-1 (i.e. loop count)
	add.w	&3,%d0
L%zl6:	clr.b	(%a0)+		# clear one byte
	sub.l	&1,%d1		# decrement count by one byte
	dbeq	%d0,L%zl6	# loop while not aligned & more bytes
L%zl1:	mov.l	%d1,%d0		# save count
	lsr.l	&NS,%d1		# adjust count for long loop
	bra.b	L%zl5

L%zl2:	swap	%d1		# outer dbra loop
L%zl3:	mov.l	%a1,(%a0)+	# inner dbra loop: clear longs
L%zl5:	dbra	%d1,L%zl3
	swap	%d1
	dbra	%d1,L%zl2

	and.w	&3,%d0
	bra.b	L%zb1
L%zb2:	clr.b	(%a0)+
L%zb1:	dbra	%d0,L%zb2
	bra.b	L%done


# bset_long(addr, value, long_cnt)
#
#	set long_cnt locations starting at addr to value
#	addr must be long aligned to avoid massive performance loss
#
bset_long:
	mov.l	4(%sp),%a0	# addr
	mov.l	8(%sp),%d1	# pattern to set
	mov.l	12(%sp),%d0	# number of longs
	bra.b	L%bs_3		# go start the loop
#
L%bs_1:	swap	%d0		# outer dbra loop
L%bs_2:	mov.l	%d1,(%a0)+	# inner dbra loop: set 4 bytes
L%bs_3:	dbra	%d0,L%bs_2
	swap	%d0
	dbra	%d0,L%bs_1
#
	mov.l	%a0,%d0		# return pointer in both registers
	rts


#change interrupt level to value passed on stack and return old level
global Chgint
Chgint:
	mov.l	4(%sp),%d0	#get desired level (from stack)
	lsl.l	&8,%d0		#get level info into position
	mov.w	%sr,%d1		#get present level
	and.w	&0xf8ff,%d1	#strip out int level
	or.l	%d0,%d1		#fill in desired level
	mov.w	%sr,%d0		#get present level again (for return)
	lsr.l	&8,%d0		# shift level
	and.l	&0x7,%d0	#save interrupt level info only
	mov.w	%d1,%sr		#update status register with desired level
	rts			#with original level in d0

#-----------------------------------------------------------------------------
#
#	S Y S T E M    P R I V I L E G E    L E V E L S
#
#-----------------------------------------------------------------------------

spl0:
	mov.w	%sr,%d0		# previous level
	and.w	&0xf8ff,%sr
	rts

spl1:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0100,%d1
	mov.w    %d1,%sr
	rts

spl2:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0200,%d1
	mov.w    %d1,%sr
	rts

spl3:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0300,%d1
	mov.w    %d1,%sr
	rts

spl4:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0400,%d1
	mov.w    %d1,%sr
	rts

spl_console:
spl5:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0500,%d1
	mov.w    %d1,%sr
	rts

spl6:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0600,%d1
	mov.w    %d1,%sr
	rts

splhi:
spl7:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	or.w	&0x0700,%d1
	mov.w    %d1,%sr
	rts

splx:
	mov.w	6(%sp),%sr
	rts

# returns current priority level
get_spl:
	mov.w	%sr,%d0
	lsr.w	&8,%d0
	and.l	&0x00000007,%d0
	rts





#	MOTOROLA:strcat.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strcat - appends a copy of string s2 onto s1
#
# Input:	the address of strings s1 and s2
#
# Output:	the address of s1
#
# Registers:	%a0 points to string s1
#		%a1 points to string s2

				# char *
				# strcat(s1, s2)
				# register char *s1, *s2;
	text
strcat:
	mov.l	4(%sp),%a0	# addr(s1)
	mov.l	8(%sp),%a1	# addr(s2)
	link	%fp,&0
				# while(*s1++); - find the end of s1
L%a1:
	tst.b	(%a0)+
	bne.b	L%a1
				# --s1; - point to end of s1
	sub.l	&1,%a0
				# while(*s1++ = *s2++) - append s2 onto s1
L%a2:
	mov.b	(%a1)+,(%a0)+
	bne.b	L%a2
				# return(s1);
	unlk	%fp
	mov.l	4(%sp),%a0
	mov.l	%a0,%d0
	rts

#	MOTOROLA:strchr.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strchr - returns a pointer to the first occurrence of character "c"
#	   in string s1
#
# Input:	s1 - string to be searched
#		c  - character being sought
#
# Output:	pointer to location of c in s1 or NULL if it is not present
#
# Registers:	%a0 - pointer to s1
#		%d0 - character c

					# char *
					# strchr(s1, c)
					# register char *s1, c;
					# {
	text
strchr:
	mov.l	4(%sp),%a0		# addr(s1)
	mov.b	11(%sp),%d0		# character
	link	%fp,&0
					# do {
L%b1:
					#    if(*s1 == c)
	cmp.b	%d0,(%a0)
					# 	return(s1);
	beq.b	L%b2
					# } while(*s1++);
	tst.b	(%a0)+
	bne.b	L%b1
					# return(0);
        sub.l	%a0,%a0
L%b2:
	mov.l	%a0,%d0
	unlk	%fp
	rts

#	MOTOROLA:strcmp.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strcmp - compares its argument and returns an integer less than, equal to,
#	   or greater than 0, according as s1 is lexicographically less than, 
#	   equal to, or greater than s2.
#
# Input:	strings s1 and s2
#
# Output:	returns an integer according to the following
#		if s1 > s2  then int > 0 returned
#		if s1 = s2  then 0 returned
#		if s1 < s2  then int < 0 returned
#
# Registers:	%a0 - points to s1
#		%a1 - points to s2
#		%d0 - scratch register AND holds return value
#		%d1 - scratch register

					# int
					# strcmp(s1, s2)
					# register char *s1, *s2;
					# {
	text
strcmp:
	mov.l	4(%sp),%a0		# addr(s1)
	mov.l	8(%sp),%a1		# addr(s2)
	link	%fp,&0
					# if(s1 == s2)
	cmp.l	%a0,%a1
	beq.b	L%c1
					# while(*s1 == *s2++)
L%c0:
	mov.b	(%a0),%d0
	cmp.b	%d0,(%a1)+
	bne.b	L%c2
					#    if(*s1++ == '\0')
	tst.b	(%a0)+
	bne.b	L%c0
L%c1:
					# 	return(0);
	clr.l	%d0
	br.b	L%c3
L%c2:
					# return(*s1 - *--s2);
	clr.l	%d0
	mov.b	(%a0),%d0
	clr.l	%d1
	mov.b	-(%a1),%d1
	sub.l	%d1,%d0
L%c3:
	unlk	%fp
	rts

#	MOTOROLA:strcpy.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strcpy - copies string s2 to s1, stopping after the null character has 
#	   been copied
#
# Input:	pointer to strings s1 and s2
#
# Output:	pointer to s1
#
# Registers:	%a0 - points at s1
#		%a1 - points at s2

					# char *
					# strcpy(s1, s2)
					# register char *s1, *s2;
					# {
	text
strcpy:
	mov.l	4(%sp),%a0		# addr(s1)
	mov.l	8(%sp),%a1		# addr(s2)
	link	%fp,&0
					# while(*s1++ = *s2++)
L%d1:
	mov.b	(%a1)+,(%a0)+
	bne.b	L%d1
					# return(s1);
	unlk	%fp
	mov.l	4(%sp),%a0
	mov.l	%a0,%d0
	rts

#	MOTOROLA:strlen.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strlen - returns the number of characters in s, not including the
#	   terminating null character
#
# Input:	s - the string in question
#
# Output:	the length of string "s" 
#
# Registers:	%a0 - points into s
#		%a1 - points at s + 1 for subtraction
#		%d0 - scratch

					# int
					# strlen(s)
					# register char *s;
					# {
	text
strlen:
	mov.l	4(%sp),%a0		# addr(s)
	link	%fp,&0
	lea.l	1(%a0),%a1		# s0 = s + 1
					# while (*s++ != '\0')
L%e1:
	tst.b	(%a0)+
	bne.b	L%e1
					# return (s - s0);
	mov.l	%a0,%d0
	sub.l	%a1,%d0
	unlk	%fp
	rts

#	MOTOROLA:strncat.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strncat - appends at most n characters from string s2 onto string s1
#
# Input:	s1 - string to append to
#		s2 - appending string
#		n  - maximum number of characters to copy from s2 to s1
#
# Output:	pointer to s1
#
# Registers:	%a0 - points into s1
#		%a1 - points into s2
#		%d0 - n
					# char *
					# strncat(s1, s2, n)
					# register char *s1, *s2;
					# register n;
					# {
	text
strncat:
	mov.l	4(%sp),%a0		# addr(s1)
	mov.l	8(%sp),%a1		# addr(s2)
	mov.l	12(%sp),%d0		# maximum length to copy
	link	%fp,&0
	ble.b	L%f5
					# while(*s1++)
L%f1:					# find end of s1
	tst.b	(%a0)+
	bne.b	L%f1
					# --s1;
	sub.l	&1,%a0
					# for (d = n-1; n > 0; --n)
	or.l	%d0,%d0			# set condition code != 0
	bra.b	L%f4
L%f2:
	swap	%d0			# lower half = 2**16-1 = 0xffff
L%f3:
					# if (*s1++ = *s2++) break;
	mov.b	(%a1)+,(%a0)+
L%f4:
	dbeq	%d0,L%f3
	beq.b	L%f5
	swap	%d0			# decrement top half
	dbra	%d0,L%f2

					# *s1 = '\0';
	clr.b	(%a0)
					# return(os1);
L%f5:
	unlk	%fp
	mov.l	4(%sp),%a0
	mov.l	%a0,%d0
	rts

#	MOTOROLA:strncmp.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strncmp - Compares at most n bytes of strings s1 and s2 and
#	    returns: >0 if s1>s2 
#		     0  if s1=s2
#		     <0 if s1< s2
#
# Input:	s1, s2 - strings to compare
#		n - maximum number of characters to compare
#
# Output:	described above
#
# Registers:	%a0 - points into s1
#		%a1 - points into s2
#		%d0 - scratch register AND return value
#		%d1 - scratch register
#
	text
strncmp:
	mov.l	4(%sp),%a0		# addr(s1)
	mov.l	8(%sp),%a1		# addr(s2)
	link	%fp,&0
					# if(s1 == s2)
	cmp.l	%a0,%a1
	beq.b	L%g4
					# while(--n > -1 && *s1++ == *s2++)
	mov.l	16(%sp),%d0		# get n  modified (+4) for link
	ble.b	L%g4
	sub.l	&1,%d0			# enter at top of loop for dbne
	bra.b	L%g1
L%g0:
	swap	%d0			# lower half = 2**16-1 = 0xffff
L%g1:
	mov.b	(%a0)+,%d1
	beq.b	L%g2a			# if *s1 == '\0'
	cmp.b	%d1,(%a1)+
L%g2:
	dbne	%d0,L%g1
	bne.b	L%g3
	swap	%d0
	dbra	%d0,L%g0
	bra.b	L%g4
L%g2a:	
	add.l	&1,%a1			# resync s2 for following subtract
L%g3:
					# return((*--s1 - *--s2));
	clr.l	%d0
	mov.b	-(%a0),%d0
	clr.l	%d1
	mov.b	-(%a1),%d1
	sub.l	%d1,%d0
	bra.b	L%g5
L%g4:
	clr.l	%d0			# return(0)
L%g5:
	unlk	%fp
	rts

#	MOTOROLA:strncpy.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strncpy - Copy s2 to s1, truncating or null-padding to always copy n bytes
#
# Input:	s1 - destination string
#		s2 - source string
#		 n - number of characters to fill in s1
#
# Output:	s1 - pointer to destination string
#
# Registers:	%a0 - points into s1
#		%a1 - points into s2
#		%d0 - loop counter
#		%d1 - scratch register
					# char *
					# strncpy(s1, s2, n)
					# register char *s1, *s2;
					# register int n;
					# {
	text
strncpy:
	mov.l	4(%sp),%a0		# addr(s1)
	mov.l	8(%sp),%a1		# addr(s2)
	mov.l	12(%sp),%d0		# n
	link	%fp,&0
	ble.b	L%h6
	bra.b	L%h2
L%h0:
	swap	%d0			# lower half = 2**16 - 1 = 0xffff
L%h1:
	mov.b	(%a1)+,(%a0)+		# copy characters until n runs out
					# OR end of string copied
L%h2:
	dbeq	%d0,L%h1
	beq.b	L%h5			# end of string copied
	swap	%d0
	dbra	%d0,L%h0		# decrement upper half 
	bra.b	L%h6
L%h3:
	swap	%d0
L%h4:
	clr.b	(%a0)+			# fill rest of string with 0
L%h5:
	dbra	%d0,L%h4
	swap	%d0
	dbra	%d0,L%h3
L%h6:
	unlk	%fp
	mov.l	4(%sp),%a0		# return s1
	mov.l	%a0,%d0
	rts

#	MOTOROLA:strrchr.s	2.2	
#
#	M68000 String(3C) Routine
#
#	(C) Copyright 1983 by Motorola Inc.
#
#	Written by: Steve Sheahan
#
# strrchr - Returns a pointer to the LAST occurrence of character c in string s1
#
# Input:	s1 - string to search
#		 c - character being sought
#
# Output:	pointer to LAST occurence of c or NULL
#
# Registers:	%a0 - current location of c
#		%a1 - pointer into s1
#		%d0 - character c
#
					# char *
					# strrchr(s1, c)
					# register char *s1, c;
					# {
	text
strrchr:
	mov.l	4(%sp),%a1		# addr(s1)
	mov.b	11(%sp),%d0		# character c
					# register char *r;
					# r = NULL;
	link	%fp,&0
	sub.l	%a0,%a0
					# do {
L%i1:
					# if(*s1 == c)
	cmp.b	%d0,(%a1)
	bne.b	L%i2
					# r = s1;
	mov.l	%a1,%a0
					# } while(*s1++);
L%i2:
	tst.b	(%a1)+
	bne.b	L%i1
					# return(r);
	mov.l	%a0,%d0
	unlk	%fp
	rts
