/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) main.c: version 25.1 created on 11/27/91 at 15:28:51	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)main.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*       SECURE CHECK Program 11/1/1989 */


#include "local.h"			/* this directory temp. XXX*/

#define MAGIC		0x7777654
extern void 		device_ldname();
extern int 		rd_sup_blk();

char version;
char release;
char *pathend();

main ()
{
	int i ,fd;
	int errors  = 0 ,count = 0;
	char fnamebuf[DEV_NAMLEN];
	char dummy[DEV_NAMLEN];
	uint dev_type,  sys_type;

	for(i=0;i<BUFF_NUM;i++) 	/* initialize buffer structures */
		blk_list[i].buf =  &read_buf[BSIZE*i];

	
	while(1){
		errors = 0;

		printf("Load the secure system data tape. \n");
		do {
			printf("Enter the tape device (X/YmtZ or '?') : ");
			dev_type = get_device_name(input_buf);
			if (dev_type == DV_HELP_REQUEST) {
				dev_help_message();
				dev_type = DV_NO_DEV;
			}
			else if (dev_type != DV_MT) {
				printf("device is not a tape drive\n");
				dev_type = DV_NO_DEV;
			}
		} while (dev_type == DV_NO_DEV);


		if((fd = open(input_buf, 0)) < 0){
			printf("failed to open %s \n",input_buf);
			close(fd);
			continue;
		}

	   	if((count = read_data(fd)) <=0 ){ /* stored security data */
			printf("READ not successfull! check device \n");
			continue;
		}
		if(check_magic())		/* make sure about tape */
			continue;
		printf("Verbose mode ? :"); 
		if(reply())
			verbose = 1;
	
		printf("Enter secure file system (X/YdZsN ): ");
		if(!gets(secure_buf))
			continue;
		if((sys_type = (uint)rd_sup_blk(secure_buf)) != 6){
			printf("File system %s is not",secure_buf);
			printf(" a secure file system type = (%x)\n",sys_type);
			printf("continue? : ");
			if(!reply())
				continue;
		}
	
		if((errors = secure(&count,secure_buf)) == -1){
			printf("error in secure start again\n");
			continue;
		}
			
		report(errors);
		printf("exit ?? : ");
		if(reply())
			break;	
		verbose = 0;
	}

}
check_magic()
{

	int *bp  = (int *)&fill; 	
	if(*bp  != MAGIC){
	    printf("\nThe tape read has the wrong magic number (%x)",*bp);
	    printf("\nInstall the correct tape or skip to the right record");
	    printf("\nWould you like to continue? :");
	    if(!reply())
	    	return(-1);
	}
	return(0);
}
