/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mkfs.h: version 25.1 created on 11/27/91 at 15:28:30	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mkfs.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * mkfs.h -- includes, defines, and typedefs for standalone mkfs
 */

#include "sys/types.h"
#include "misc.h"
#include "sainode.h"
#include "dev.h"	/* init.c, mkfs.c */
#include "sys/stat.h"
#include "sys/ino.h"
#include "sys/fs/s5param.h"
#include "sys/fs/s5dir.h"

#if 0
#define DEBUG				/* turn on debug stuff */
#endif

#ifdef DEBUG
/*
 * 4 levels of debug:  low, medium, high, and debug
 */
#define NO_DEBUG	0
#define LOW_DEBUG	3
#define MED_DEBUG	2
#define HIGH_DEBUG	1
#define DBUG(fmt)	if (debug) printf(fmt)
#define DBUG1(f,a)	if (debug) printf(f, a)
#define DBUG2(f,a,b)	if (debug) printf(f, a, b)
#define DBUG3(f,a,b,c)	if (debug) printf(f, a, b, c)
#define DBUG4(f,a,b,c,d) if(debug) printf(f, a, b, c, d)
#define DBUGl(fmt)	if (debug >= LOW_DEBUG) printf(fmt)
#define DBUGl1(f,a)	if (debug >= LOW_DEBUG) printf(f, a)
#define DBUGl2(f,a,b)	if (debug >= LOW_DEBUG) printf(f, a, b)
#define DBUGl3(f,a,b,c)	if (debug >= LOW_DEBUG) printf(f, a, b, c)
#define DBUGl4(f,a,b,c,d) if(debug >= LOW_DEBUG) printf(f, a, b, c, d)
#define DBUGm(fmt)	if (debug >= MED_DEBUG) printf(fmt)
#define DBUGm1(f,a)	if (debug >= MED_DEBUG) printf(f, a)
#define DBUGm2(f,a,b)	if (debug >= MED_DEBUG) printf(f, a, b)
#define DBUGm3(f,a,b,c)	if (debug >= MED_DEBUG) printf(f, a, b, c)
#define DBUGm4(f,a,b,c,d) if(debug >= MED_DEBUG) printf(f, a, b, c, d)
#define DBUGh(fmt)	if (debug >= HIGH_DEBUG) printf(fmt)
#define DBUGh1(f,a)	if (debug >= HIGH_DEBUG) printf(f, a)
#define DBUGh2(f,a,b)	if (debug >= HIGH_DEBUG) printf(f, a, b)
#define DBUGh3(f,a,b,c)	if (debug >= HIGH_DEBUG) printf(f, a, b, c)
#define DBUGh4(f,a,b,c,d) if(debug >= HIGH_DEBUG) printf(f, a, b, c, d)
extern int		debug;
#else /* DEBUG */
#define DBUG(fmt)
#define DBUG1(f,a)
#define DBUG2(f,a,b)
#define DBUG3(f,a,b,c)
#define DBUG4(f,a,b,c,d)
#define DBUGl(fmt)
#define DBUGl1(f,a)
#define DBUGl2(f,a,b)
#define DBUGl3(f,a,b,c)
#define DBUGl4(f,a,b,c,d)
#define DBUGm(fmt)
#define DBUGm1(f,a)
#define DBUGm2(f,a,b)
#define DBUGm3(f,a,b,c)
#define DBUGm4(f,a,b,c,d)
#define DBUGh(fmt)
#define DBUGh1(f,a)
#define DBUGh2(f,a,b)
#define DBUGh3(f,a,b,c)
#define DBUGh4(f,a,b,c,d)
#endif /* DEBUG */

#define FLUSH_SOME	0		/* flush flags */
#define FLUSH_ALL	1

#define BLKSIZ		512		/* official block size */
#define NINE_TRK_SZ	5120		/* 9 track tape input buffer size */
#define BNUM		0x40000		/* cartridge tape input buffer size */

#define STANDALONE	1
#define PGSIZE		4096		/* system page size */

#define DEVREQ_BUF_SIZ	(66 * PGSIZE)

#define FS_MIN_BLKS	16		/* minimum size for a file system */

#define NUM_HASH	64		/* must be a power of 2 */
#define HASH(hp, num)	(&(hp)->hash[(num) & (NUM_HASH - 1)])

typedef struct _mlink {
	struct _mlink	*next;	/* hashed on number		*/
	struct _mlink	*prev;
	long		number;	/* item's number		*/
} MLINK;

#define m_left		next	/* for convenience		*/
#define m_right		prev

typedef struct _hlink {
	MLINK		*next;
	MLINK		*prev;
} HLINK;

typedef struct _mhash {
	HLINK		hash[NUM_HASH];
	MLINK		*freelist;
} MHASH;

typedef struct _mino {
	MLINK		i;		/* hashed on i_number		*/
	ushort		i_mode;		/* mode and type of file	*/
	short		i_nlink;	/* number of directory entries	*/
	ushort		i_uid;		/* owner ID			*/
	ushort		i_gid;		/* group ID			*/
	time_t		i_mtime;   	/* time last modified		*/
	off_t		i_size;		/* file size			*/
	daddr_t		i_baddr[NADDR];	/* disk block addresses		*/
} MINO;

typedef struct _mblk {
	MLINK		b;		/* hashed on b_number		*/
	union _mb_un {
		caddr_t	bu_baddr;	/* block memory			*/
		daddr_t	*bu_daddr;
	} mb_un;
} MBLK;

#define b_baddr		mb_un.bu_baddr	/* for convenience		*/
#define b_daddr		mb_un.bu_daddr

extern char	string[4 * DEV_NAMLEN];
extern int	Input;
extern int	maxblksz;

extern char	*strncpy();
extern int	gets();
extern void	bcopy(), bzero(), die(), err();

extern MBLK	*new_mblk(), *get_mblk(), *find_mblk(), *seeki();
extern MBLK	*mblk_binary(), *mblk_smallest();
extern MINO	*get_mino(), *find_mino(), *namei(), *openi();
extern MINO	*mino_binary(), *mino_smallest();
extern void	free_mblk(), free_mino(), iput(), mkentry(), wrfs();
extern void	finish(), mkfs(), flush_mblk(), flush_mino();
