/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) main.c: version 25.1 created on 11/27/91 at 15:28:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)main.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * main.c -- main routines for standalone mkfs
 */

#include "mkfs.h"
#include "sys/ioctl.h"
#include "sa_dir.h"

int		Input;
int		fsd;
char		string[4 * DEV_NAMLEN];

#ifdef DEBUG
int		debug;			/* debug level */
#endif

static int	num_mino, num_mblk;	/* for debugging */
static MINO	*mino;
static MBLK	*mblk;
static caddr_t	b_addr;

extern char	*databuff;		/* cpio input buffer */

extern int	edata, end;

extern MHASH	bhash, ihash;

extern void	exit();

/*
 * err -- error printer
 */

/*VARARGS1*/
void
err(fmt, a, b, c, d, e, f)
char	*fmt;
{
	printf("mkfs: ");
	printf(fmt, a, b, c, d, e, f);
	printf("\n");
}

/*
 * die -- close and exit
 */

void
die()
{
	if (fsd > 0)
		close(fsd);
	if (Input > 0)
		close(Input);
	exit(0);
}

/*
 * init -- initialize stuff
 */

init()
{
	register uint 	dev_type;
	register int	n, spare_mem;
	register HLINK	*hp;
	register MINO	*ip;
	register MBLK	*bp;
	register caddr_t cp;
	register ulong	addr;
	uint		i_unit;
	char		fsbuf[DEV_NAMLEN];

#ifdef DEBUG
	printf("\nDebug level (0-4)? ");
	gets(string);
	debug = atoi(string);
#endif

	printf("\nLoad the file system tape.\n");
	do {
		printf("Enter the tape device (X/YmtZ, XmtY, or '?') : ");
		dev_type = get_device_name(string);
		if (dev_type == DV_HELP_REQUEST) {
			dev_help_message();
			dev_type = DV_NO_DEV;
		}
		else if (dev_type != DV_MT && dev_type != DV_9T) {
			err("device '%s' is not a tape drive", string);
			dev_type = DV_NO_DEV;
		}
		else if ((Input = open(string, 0)) < 0)
			err("cannot open tape device: %s", string);
	} while (dev_type == DV_NO_DEV || Input < 0);

	if (dev_type == DV_9T) {
		maxblksz = NINE_TRK_SZ;
		if (ioctl(Input, TAPESTAT, string) < 0) {
			err("cannot stat tape device");
			die();
		}
	}

        printf("\nDoes this tape contain both ");
        printf("a Bootimage and a Root File System? ");
	gets(string);
	if (string[0] == 'y' || string[0] == 'Y' || string[0] == 0) {
		if (ioctl(Input, REOF, string) < 0) {
			err("cannot seek to file on tape");
			die();
		}
	}
	else if (ioctl(Input, REWIND, string) < 0) {
		err("cannot rewind tape");
		die();
	}

	printf("\n");
	do {
		printf("File system disk device (X/YdZsN, XdYsZ, or '?'): ");
		dev_type = get_device_name(fsbuf);
		if (dev_type == DV_HELP_REQUEST)
			dev_help_message();
		else if (dev_type != DV_DK)
			err("'%s' is not a valid disk device", fsbuf);
		else if ((fsd = open(fsbuf, 2)) < 0)
			err("can't open disk device: %s", fsbuf);
	} while (dev_type != DV_DK || fsd < 0);

	/* init internal inode and buffer caches */

	for (hp = ihash.hash, n = NUM_HASH; --n >= 0; hp++)
		hp->next = hp->prev = (MLINK *)hp;

	for (hp = bhash.hash, n = NUM_HASH; --n >= 0; hp++)
		hp->next = hp->prev = (MLINK *)hp;

	addr = ALIGN(&end, sizeof(long));
	n = spare_mem = ((ulong)dir_load_point + sa_mem_requirement) - addr -
	  sizeof(int) - BNUM;
	/* divide memory between MINOs and (MBLKs + BSIZE), same no. of each */
	n /= sizeof(MINO) + (sizeof(MBLK) + BSIZE);
	if (n < 0) {
		err("no memory for inodes and buffers (%d).", n);
		die();
	}
	spare_mem -= n * (sizeof(MINO) + (sizeof(MBLK) + BSIZE));
	/* allocate remainder for MINOs */
	num_mino = n + spare_mem / sizeof(MINO);
	num_mblk = n;
	mino = ip = (MINO *)(addr + 1);
	mblk = bp = (MBLK *)&ip[num_mino];
	b_addr = cp = (caddr_t)ALIGN(&bp[num_mblk], BSIZE);

	ihash.freelist = NULL;
	for (n = num_mino; --n >= 0; ip++) {
		ip->i.next = ihash.freelist;
		ihash.freelist = &ip->i;
	}

	bhash.freelist = NULL;
	for (n = num_mblk; --n >= 0; bp++, cp += BSIZE) {
		bp->b.next = bhash.freelist;
		bhash.freelist = &bp->b;
		bp->b_baddr = cp;
	}
	databuff = cp;
}


main()
{
	bzero((caddr_t)&edata, (uint)&end - (uint)&edata);
	init();
	mkfs();
	cpio();
	finish();
	die();
	exit(0);
}
