/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) hash.c: version 25.1 created on 11/27/91 at 15:28:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)hash.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * hash.c -- various hash, unhash, find, alloc, and dealloc functions
 */

#include "mkfs.h"

MHASH	ihash, bhash;


/*
 * m_hash -- enter lp into hash list hp
 */

static void
m_hash(lp, hp)
MLINK	*lp;
HLINK	*hp;
{
	lp->next = hp->next;
	lp->prev = (MLINK *)hp;
	hp->next->prev = lp;
	hp->next = lp;
}

/*
 * m_unhash -- remove lp from hash list
 */

static void
m_unhash(lp)
MLINK	*lp;
{
	(lp->next->prev = lp->prev)->next = lp->next;
	lp->next = lp->prev = NULL;
}

/*
 * m_find -- return lp with number == num on hash list hp, or NULL
 */

static MLINK *
m_find(hp, num)
HLINK		*hp;
register long	num;
{
	MLINK	*lp;

	for (lp = hp->next; lp != (MLINK *)hp; lp = lp->next)
		if (lp->number == num) {
			m_unhash(lp);		/* move to hash bucket head */
			m_hash(lp, hp);
			return (lp);
		}

	return (NULL);
}

#if 0
/*
 * m_insert -- insert lp into a binary tree rooted at rootp
 */

static MLINK *
m_insert(rootp, lp)
MLINK	*rootp;
MLINK	*lp;
{
	register long	num = lp->number;
	MLINK		*hp = rootp;

	if (hp) {
		for (;;) {
			if (num < hp->number) {
				if (hp->m_left)
					hp = hp->m_left;
				else {
					hp->m_left = lp;
					break;
				}
			}
			else {
				if (hp->m_right)
					hp = hp->m_right;
				else {
					hp->m_right = lp;
					break;
				}
			}
		}
	}
	else
		rootp = lp;

	return (rootp);
}

/*
 * m_smallest -- unlink and return the smallest valued MLINK in the binary tree
 */

static MLINK *
m_smallest(rootp)
MLINK	*rootp;
{
	register MLINK	*lp = rootp, *pp = NULL;
	MLINK		*np;

	while (lp) {
		if (np = lp->m_left)
			;
		else if (np = lp->m_right)
			;
		else
			break;
		pp = lp;
		lp = np;
	}

	if (pp) {
		if (pp->m_left == lp)
			pp->m_left = NULL;
		else if (pp->m_right == lp)
			pp->m_right = NULL;
		else {
			err("m_smallest: can't unlink %x from %x!", lp, pp);
			die();
		}
	}

	if (lp)
		lp->next = lp->prev = NULL;

	return (lp);
}
#endif /* 0 */

/*
 * new_mblk -- returns a new MBLK
 */

MBLK *
new_mblk(num)
long	num;
{
	MBLK	*bp;

	DBUGl1("new_mblk(%d) ", num);
	if ((bp = (MBLK *)bhash.freelist) == NULL) {
		flush_mblk(FLUSH_SOME);
		if ((bp = (MBLK *)bhash.freelist) == NULL) {
			err("out of free MBLKs!");
			die();
		}
	}

	bhash.freelist = bp->b.next;
	bp->b.next = NULL;
	bp->b.number = num;
	return (bp);
}

/*
 * free_mblk -- free up bp
 */

void
free_mblk(bp)
MBLK	*bp;
{
	DBUGl1("free_mblk(%d) ", bp->b.number);
	if (bp->b.next)
		m_unhash(&bp->b);

	bp->b.next = bhash.freelist;
	bhash.freelist = &bp->b;
}

/*
 * get_mblk -- find or alloc a MBLK with num
 */

MBLK *
get_mblk(num)
long	num;
{
	MBLK	*bp;
	HLINK	*hp = HASH(&bhash, num);

	DBUGl1("get_mblk(%d) ", num);
	if ((bp = (MBLK *)m_find(hp, num)) == NULL) {
		bp = new_mblk(num);
		m_hash(&bp->b, HASH(&bhash, num));
	}

	return (bp);
}

/*
 * find_mblk -- find a MBLK with num, or return NULL
 */

MBLK *
find_mblk(num)
long	num;
{
	DBUGl1("find_mblk(%d) ", num);
	return ((MBLK *)m_find(HASH(&bhash, num), num));
}

#if 0
/*
 * mblk_binary -- convert the hash list to a binary tree and return each MBLK
 *		ignore blocks greater than blk_limit
 */

MBLK *
mblk_binary(blk_limit)
register long	blk_limit;
{
	register HLINK	*hp;
	register MLINK	*lp, *np;
	register int	n;
	MLINK		*rootp = NULL;

	DBUGl1("mblk_binary(%ld) ", blk_limit);
	for (hp = bhash.hash, n = NUM_HASH; --n >= 0; hp++)
		for (lp = hp->next; lp != (MLINK *)hp; lp = np) {
			np = lp->next;
			if (lp->number <= blk_limit) {
				m_unhash(lp);
				rootp = m_insert(rootp, lp);
			}
		}

	return ((MBLK *)rootp);
}

/*
 * mblk_smallest -- unlink and return the smallest MBLK in a binary tree
 */

MBLK *
mblk_smallest(rootpp)
register MBLK	**rootpp;
{
	MBLK	*bp;

	DBUGl1("mblk_smallest(%x) ", rootpp);
	if ((bp = (MBLK *)m_smallest(&(*rootpp)->b)) == *rootpp)
		*rootpp = NULL;

	return (bp);
}
#endif /* 0 */

/*
 * free_mino -- free up ip
 */

void
free_mino(ip)
MINO	*ip;
{
	DBUGl1("free_mino(%d) ", ip->i.number);
	if (ip->i.next)
		m_unhash(&ip->i);

	ip->i.next = ihash.freelist;
	ihash.freelist = &ip->i;
}

/*
 * get_mino -- find or alloc a MINO with num
 */

MINO *
get_mino(num)
long	num;
{
	MINO	*ip;
	HLINK	*hp = HASH(&ihash, num);

	DBUGl1("get_mino(%d) ", num);
	if ((ip = (MINO *)m_find(hp, num)) == NULL) {
		if ((ip = (MINO *)ihash.freelist) == NULL) {
			flush_mino(FLUSH_SOME);
			if ((ip = (MINO *)ihash.freelist) == NULL) {
				err("out of free MINOs!");
				die();
			}
		}
		ihash.freelist = ip->i.next;
		bzero((caddr_t)ip, sizeof(*ip));
		ip->i.number = num;
		m_hash(&ip->i, hp);
	}

	return (ip);
}

/*
 * find_mino -- find a MINO with num, or return NULL
 */

MINO *
find_mino(num)
long	num;
{
	DBUGl1("find_mino(%d) ", num);
	return ((MINO *)m_find(HASH(&ihash, num), num));
}

#if 0
/*
 * mino_binary -- convert the hash list to a binary tree and return each MINO
 *		ignore inodes that match type
 */

MINO *
mino_binary(type)
register uint	type;
{
	register HLINK	*hp;
	register MLINK	*lp, *np;
	register int	n;
	MLINK		*rootp = NULL;

	DBUGl1("mino_binary(%d) ", type);
	for (hp = ihash.hash, n = NUM_HASH; --n >= 0; hp++)
		for (lp = hp->next; lp != (MLINK *)hp; lp = np) {
			np = lp->next;
			if ((((MINO *)lp)->i_mode & IFMT) != type) {
				m_unhash(lp);
				rootp = m_insert(rootp, lp);
			}
		}

	return ((MINO *)rootp);
}

/*
 * mino_smallest -- unlink and return the smallest MINO in a binary tree
 */

MINO *
mino_smallest(rootpp)
register MINO	**rootpp;
{
	MINO	*ip;

	DBUGl1("mino_smallest(%x) ", rootpp);
	if ((ip = (MINO *)m_smallest(&(*rootpp)->i)) == *rootpp)
		*rootpp = NULL;

	return (ip);
}
#endif /* 0 */
