/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) cpio.c: version 25.1 created on 11/27/91 at 15:28:13	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)cpio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * cpio.c -- do standalone cpio
 */

#include "mkfs.h"

#define MAGIC	070707		/* cpio magic number */
#define C_MAGIC "070707"	/* cpio character header magic number */

#define BINARY 0
#define CHARACTER 1
static int 	Cflag = BINARY;		/* character or binary header */

#define HDRSIZE	(Hdr.h_name - (char *)&Hdr)	/* header size minus filename field */
#define LINKS	1000		/* max no. of links allowed */

#define MAXBLOCKS (LADDR + NINDIR + NINDIR*NINDIR)
	/*	  10 direct blks + indirect + double indirect */ 


char		*databuff;			/* cpio input buffer */

int		maxblksz = BNUM;
int		Input;				/* cpio file descriptor */
static int	verbose;			/* cpio verbose mode */

static struct ml {
	dev_t	m_tdev;			/* tape device	*/
	ino_t	m_tino;			/* tape inode	*/
	ino_t   m_fsino;		/* inode in this file system */
} mlbuf[LINKS];

static int	mlinks;

	/* Cpio header format */
static struct header {
	short	h_magic,
		h_dev;
	ushort	h_ino,
		h_mode,
		h_uid,
		h_gid;
	short	h_nlink,
		h_rdev,
		h_mtime[2],
		h_namesize,
		h_filesize[2];
	char	h_name[256];
} Hdr;

/*
 * Character header
 */
static	struct c_header {
	char	h_magic[6],
		h_dev[6],
		h_ino[6],
		h_mode[6],
		h_uid[6],
		h_gid[6],
		h_nlink[6],
		h_rdev[6],
		Longtime[11],
		h_namesize[6],
		Longfile[11]
};

static ushort	A_directory,
		A_special;

static union _u_ {
	long	l;
	short	s[sizeof(long) / sizeof(short)];
	char	c[sizeof(long)];
} U;

#if 0
/* for VAX, Interdata, ... */
long mklong(v)
short v[];
{
	U.l = 1;
	if(U.c[0])
		U.s[0] = v[1], U.s[1] = v[0];
	else
		U.s[0] = v[0], U.s[1] = v[1];
	return U.l;
}
#else
/*
 * we always take the second path, so it may as well be a define
 */
#define mklong(v)	(U.s[0] = v[0], U.s[1] = v[1], U.l)
#endif

/*
 * readck -- error trapped read with blocking by maxblksz
 */

static int
readck(fd, b, s) 
int	fd, s;
char	*b;
{
	register int	n, total, bsize, count;

	DBUGl3("readck(%d, %x, %d) ", fd, b, s);
	for (total = 0, count = s; count > 0; count -= n, total += n, b += n) {
		bsize = MIN(count, maxblksz);
		if ((n = read(fd, b, bsize)) < 0) {
			err("readck: read(%d, 0x%x, %d) error=%d",
			  fd, b, bsize, n);
			return (n);
		}
		if (n == 0)
			break;
	}
	return (total);
}

static
bcmp(a, b, n)
char	*a, *b;
uint	n;
{
	uint	i;

	for (i = 0; i != n; i++, a++, b++)
		if (*a != *b)
			return(*b - *a);
	return(0);
}

static
strncp(from, to, n)
char	*from, *to;
uint	n;
{
	uint	i;

	for (i = 0; i != n; i++)
		*to++ = *from++;
}

/*
 * bread -- buffered read
 */
static void
bread(b, c)
register char	*b;
register int	c;
{
	register int	rv;
	static char	*ip;
	register char	*p = ip;
	static int	nleft;

	/* all reads of binary headers are of even length */
	if (Cflag == BINARY)
		c += c % 2; /* round up to even number */
	DBUGh2("bread(%x, %d) ", b, c);
	while (--c >= 0) {
		if (nleft <= 0) {
			if ((rv = readck(Input, databuff, BNUM)) <= 0) {
				if (rv < 0)
					err("bread: read error!");
				else
					err("bread: unexpected EOF!");
				die();
			}
			nleft += rv;
			p = databuff;
		}
		*b++ = *p++;
		--nleft;
	}
	ip = p;
}

/*
 * gethdr -- get file headers
 */
static int
gethdr()
{
	register uint	ftype;
	static char	buff[sizeof(struct c_header)];

	DBUGm("\ngethdr() ");
	/* read magic number */
	bread((char *)&Hdr.h_magic, sizeof(Hdr.h_magic));

	if (Hdr.h_magic != MAGIC) {
		strncp((char *)&Hdr.h_magic, buff, sizeof(Hdr.h_magic));
		/* read rest of character header */
		bread((char *)(buff + sizeof(Hdr.h_magic)),
			sizeof(struct c_header) - sizeof(Hdr.h_magic));
		if (bcmp(C_MAGIC, buff, strlen(C_MAGIC))) {
			err("Out of phase--get help");
			die();
		}
		Cflag = CHARACTER;
		chartobinhdr(buff, &Hdr);
	}
	else {
		/* read rest of binary header */
		Cflag = BINARY;
		bread((char *)&Hdr.h_dev, HDRSIZE - sizeof(Hdr.h_magic));
	}
	bread((char *)Hdr.h_name, Hdr.h_namesize);
	Hdr.h_name[Hdr.h_namesize] = '\0';
	disphead();
	DBUGm4("uid=%d, mode=0%05o fsize=%d name='%s' ",
	  Hdr.h_uid, Hdr.h_mode, mklong(Hdr.h_filesize), Hdr.h_name);

	if (strcmp(Hdr.h_name, "TRAILER!!!") == 0)
		return (0);
	ftype = Hdr.h_mode & S_IFMT;
	A_directory = (ftype == S_IFDIR);
	A_special = (ftype == S_IFBLK) ||
		    (ftype == S_IFCHR) ||
		    (ftype == S_IFIFO);
	return (1);
}

disphead()
{
	DBUGh1("Hdr.h_magic = %o\n", Hdr.h_magic);
	DBUGh1("Hdr.h_dev = %o\n", Hdr.h_dev);
	DBUGh1("Hdr.h_ino = %o\n", Hdr.h_ino);
	DBUGh1("Hdr.h_mode = %o\n", Hdr.h_mode);
	DBUGh1("Hdr.h_uid = %o\n", Hdr.h_uid);
	DBUGh1("Hdr.h_gid = %o\n", Hdr.h_gid);
	DBUGh1("Hdr.h_nlink = %o\n", Hdr.h_nlink);
	DBUGh1("Hdr.h_rdev = %o\n", Hdr.h_rdev);
	DBUGh1("Hdr.h_mtime[0] = %o\n", Hdr.h_mtime[0]);
	DBUGh1("Hdr.h_mtime[1] = %o\n", Hdr.h_mtime[1]);
	DBUGh1("Hdr.h_namesize = %o\n", Hdr.h_namesize);
	DBUGh1("Hdr.h_filesize[0] = %o\n", Hdr.h_filesize[0]);
	DBUGh1("Hdr.h_filesize[1] = %o\n", Hdr.h_filesize[1]);
	DBUGh1("Hdr.h_name = %s\n", Hdr.h_name);
}

/*
 * atoo() - ascii octal to number. 
 * Necessary, since we don't (yet) support stdio in standalone.
 */
#define	o_val(x)	(((x) - '0') & 07)
uint
atoo(str, len)
char	*str;
uint	len;
{
	register uint	i;
	register uint	retval = 0;

	/* each element of the string contains 3 bits of the number */
	for (i = 0; i != len; i++, str++)
		retval = (retval << 3) | o_val(*str);
	return(retval);
}

#define h_long_to_short(X)	(short)((uint)((X) >> 16) & 0x0000ffff)
#define l_long_to_short(X)	(short)(((uint)X) & 0xffff)

static int
chartobinhdr(str, hdr)
char	*str;
struct	header	*hdr;
{
	struct	c_header *c_hdr;
	uint	longword;

	c_hdr = (struct c_header *)str;

	hdr->h_magic =  (short)atoo(c_hdr->h_magic, sizeof(c_hdr->h_magic));
	hdr->h_dev   =  (short)atoo(c_hdr->h_dev,   sizeof(c_hdr->h_dev));
	hdr->h_ino   = (ushort)atoo(c_hdr->h_ino,   sizeof(c_hdr->h_ino));
	hdr->h_mode  = (ushort)atoo(c_hdr->h_mode,  sizeof(c_hdr->h_mode));
	hdr->h_uid   = (ushort)atoo(c_hdr->h_uid,   sizeof(c_hdr->h_uid));
	hdr->h_gid   = (ushort)atoo(c_hdr->h_gid,   sizeof(c_hdr->h_gid));
	hdr->h_nlink =  (short)atoo(c_hdr->h_nlink, sizeof(c_hdr->h_nlink));
	hdr->h_rdev  =  (short)atoo(c_hdr->h_rdev,  sizeof(c_hdr->h_rdev));

	longword     =   (uint)atoo(c_hdr->Longtime, sizeof(c_hdr->Longtime));
	hdr->h_mtime[0] = h_long_to_short(longword);
	hdr->h_mtime[1] = l_long_to_short(longword);
	hdr->h_namesize = (short)atoo(c_hdr->h_namesize,
		sizeof(c_hdr->h_namesize));
	longword = (uint)atoo(c_hdr->Longfile, sizeof(c_hdr->Longfile));
	hdr->h_filesize[0] = (short)((short *)(&longword))[0];
	hdr->h_filesize[1] = (short)((short *)(&longword))[1];
}

static ino_t
cklink(mlpp)		/* linking funtion */
struct ml	**mlpp;
{
	register int	i;
	struct ml	*mlptr;

	DBUGm("cklink() ");
	*mlpp = NULL;
	if (Hdr.h_nlink == 1)
		return ((ino_t)0);
	if (mlinks >= LINKS) {
		err("Too many links");
		return ((ino_t)0);
	}

	for (mlptr = mlbuf, i = mlinks; --i >= 0; ++mlptr) {
		if (mlptr->m_tino == Hdr.h_ino && mlptr->m_tdev == Hdr.h_dev) {
			if (verbose)
			  	printf("file %s is linked\n", Hdr.h_name);
			return (mlptr->m_fsino);
		}

	}

	mlptr = &mlbuf[mlinks++];
	mlptr->m_tdev = Hdr.h_dev;
	mlptr->m_tino = Hdr.h_ino;
	*mlpp = mlptr;
	return ((ino_t)0);
}

/*
 * c1file -- cpio 1 file
 */

static void
c1file()
{
	register MINO	*ip;
	register MBLK	*bp;
	register long	filesz, link;
	register int	count;
	MINO		*par;
	struct ml	*mlp;
	char		part[DIRSIZ];

	DBUG("\nc1file() ");
	if (link = cklink(&mlp)) {
		/*
		 * make an entry for a linked file
		 */
		/* find dups, get the parent dir, and last part of pathname */
		if (ip = namei(Hdr.h_name, &par, part)) {
			err("link already exists! link=%d ino=%d '%s'", 
			  link, ip->i.number, Hdr.h_name);
			die();
		}
		/* look up the real inode */
		if ((ip = get_mino(link)) == NULL) {
			err("c1file: can't find linked inode %d for '%s'", 
			  link, Hdr.h_name);
			die();
		}
		if ((ip->i_mode & IFMT) != (Hdr.h_mode & IFMT)) {
			err("link mode=%05o different from inode %d mode=%05o",
			  Hdr.h_mode, ip->i.number, ip->i_mode);
			die();
		}
		mkentry(par, ip, part);
		ip->i_mode = Hdr.h_mode;
	}
	else if ((ip = openi(Hdr.h_name, Hdr.h_mode)) == NULL) {
		err("c1file: openi(%s, %o) failed!", Hdr.h_name, Hdr.h_mode);
		die();
	}
	else if (mlp)
		mlp->m_fsino = ip->i.number;		/* now have inode num */

	/*
	 * get mode, uid and gid
	 */

	ip->i_uid = Hdr.h_uid;
	ip->i_gid = Hdr.h_gid;
	ip->i_mtime = mklong(Hdr.h_mtime);

	switch (ip->i_mode & IFMT) {

	case IFREG:	/* regular file */
	case IFLNK:	/* symbolic link */

		DBUGm((ip->i_mode & IFMT) == IFREG ? "REG " : "LNK ");
		filesz = mklong(Hdr.h_filesize);
		if (link) {
			/* throw away file contents */
			bp = new_mblk(-1L);
			for ( ; filesz > 0; filesz -= count) {
				count = MIN(filesz, BSIZE);
				bread((char *)bp->b_baddr, count);
			}
			free_mblk(bp);
		}
		else {
			for ( ; filesz > 0; filesz -= count) {
				bp = seeki(ip, ip->i_size);
				count = MIN(filesz, BSIZE);
				bread((char *)bp->b_baddr, count);
				wrfs(bp);
				free_mblk(bp);
				ip->i_size += count;
			}
		}

		if (verbose)
			printf("%s %s (%d bytes)\n",
			  ((ip->i_mode & IFMT) == IFREG ? "file" : "link"),
			  Hdr.h_name, ip->i_size);
		break;

	case IFBLK:	/* special file */
	case IFCHR:

		DBUGm("BLK/CHR ");
		ip->i_baddr[0] = Hdr.h_rdev;
		if (verbose)
			printf("dev  %s\n", Hdr.h_name);
		break;

	case IFDIR:	/* directory */

		DBUGm("DIR ");
		if (verbose)
			printf("dir  %s\n", Hdr.h_name);
		break;		/* done in openi */

	case IFIFO:	/* named pipe */

		DBUGm("FIFO ");
		if (verbose)
			printf("fifo %s\n", Hdr.h_name);
		break;

	default:
		err("c1file: unknown file mode = %05o for '%s'",
		  ip->i_mode, Hdr.h_name);
		die();
	}

	if (!A_directory && Hdr.h_nlink <= 1)
		iput(ip);
}

cpio()
{
	printf("Verbose mode?  ");
	gets(string);
	if (string[0] == 'Y' || string[0] == 'y')
		verbose++;

#ifdef DEBUG
	printf("\nDebug level (0-4)? ");
	gets(string);
	debug = atoi(string);
#endif

	while (gethdr())
		c1file();
}
